/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.symmetry;

import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Point4f;
import javax.vecmath.Tuple4f;
import org.jmol.util.Logger;

public class SymmetryOperation
extends Matrix4f {
    String xyzOriginal;
    String xyz;
    boolean doNormalize = true;
    private static final String[] twelfths = new String[]{"0", "1/12", "1/6", "1/4", "1/3", "5/12", "1/2", "7/12", "2/3", "3/4", "5/6", "11/12"};
    Point3f atomTest = new Point3f();

    public SymmetryOperation() {
    }

    public SymmetryOperation(boolean doNormalize) {
        this.doNormalize = doNormalize;
    }

    public SymmetryOperation(SymmetryOperation op, Point3f[] atoms, int atomIndex, int count, boolean doNormalize) {
        this.doNormalize = doNormalize;
        this.xyzOriginal = op.xyzOriginal;
        this.xyz = op.xyz;
        this.set(op);
        this.m03 /= 12.0f;
        this.m13 /= 12.0f;
        this.m23 /= 12.0f;
        if (doNormalize) {
            this.setOffset(atoms, atomIndex, count);
        }
    }

    public String getXyz() {
        return this.xyz;
    }

    public String getXyzOriginal() {
        return this.xyzOriginal;
    }

    public void newPoint(Point3f atom1, Point3f atom2, int transX, int transY, int transZ) {
        Point4f temp = new Point4f(atom1.x, atom1.y, atom1.z, 1.0f);
        this.transform((Tuple4f)temp, (Tuple4f)temp);
        atom2.x = temp.x + (float)transX;
        atom2.y = temp.y + (float)transY;
        atom2.z = temp.z + (float)transZ;
    }

    String dumpInfo() {
        return "\n" + this.xyz + "\ninternal matrix representation:\n" + this.toString();
    }

    static final String dumpSeitz(Matrix4f s) {
        return "{\t" + (int)s.m00 + "\t" + (int)s.m01 + "\t" + (int)s.m02 + "\t" + SymmetryOperation.twelfthsOf(s.m03) + "\t}\n" + "{\t" + (int)s.m10 + "\t" + (int)s.m11 + "\t" + (int)s.m12 + "\t" + SymmetryOperation.twelfthsOf(s.m13) + "\t}\n" + "{\t" + (int)s.m20 + "\t" + (int)s.m21 + "\t" + (int)s.m22 + "\t" + SymmetryOperation.twelfthsOf(s.m23) + "\t}\n" + "{\t0\t0\t0\t1\t}\n";
    }

    boolean setMatrixFromXYZ(String xyz) {
        if (xyz == null) {
            return false;
        }
        this.xyzOriginal = xyz;
        xyz = xyz.toLowerCase();
        float[] temp = new float[16];
        boolean isDenominator = false;
        boolean isDecimal = false;
        boolean isNegative = false;
        int x = 0;
        int y = 0;
        int z = 0;
        float iValue = 0.0f;
        String strOut = "";
        int rowPt = -1;
        temp[15] = 1.0f;
        float decimalMultiplier = 1.0f;
        xyz = xyz + ",";
        block12: for (int i = 0; i < xyz.length(); ++i) {
            char ch = xyz.charAt(i);
            switch (ch) {
                case ' ': 
                case '\'': {
                    continue block12;
                }
                case '-': {
                    isNegative = true;
                    continue block12;
                }
                case '+': {
                    isNegative = false;
                    continue block12;
                }
                case '/': {
                    isDenominator = true;
                    continue block12;
                }
                case 'X': 
                case 'x': {
                    x = isNegative ? -1 : 1;
                    break;
                }
                case 'Y': 
                case 'y': {
                    y = isNegative ? -1 : 1;
                    break;
                }
                case 'Z': 
                case 'z': {
                    z = isNegative ? -1 : 1;
                    break;
                }
                case ',': {
                    if (++rowPt > 2) {
                        Logger.warn((String)("Symmetry Operation? " + xyz));
                        return false;
                    }
                    int tpt = rowPt * 4;
                    iValue *= 12.0f;
                    if (this.doNormalize) {
                        while (iValue > 6.0f) {
                            iValue -= 12.0f;
                        }
                        while (iValue <= -6.0f) {
                            iValue += 12.0f;
                        }
                    }
                    temp[tpt++] = x;
                    temp[tpt++] = y;
                    temp[tpt++] = z;
                    temp[tpt] = iValue;
                    String strT = "";
                    strT = strT + (x == 0 ? "" : (x < 0 ? "-x" : (strT.length() == 0 ? "x" : "+x")));
                    strT = strT + (y == 0 ? "" : (y < 0 ? "-y" : (strT.length() == 0 ? "y" : "+y")));
                    strT = strT + (z == 0 ? "" : (z < 0 ? "-z" : (strT.length() == 0 ? "z" : "+z")));
                    strT = strT + SymmetryOperation.xyzFraction(iValue, false);
                    strOut = strOut + (strOut == "" ? "" : ",") + strT;
                    if (rowPt == 2) {
                        this.set(temp);
                        this.xyz = strOut;
                        rowPt = 0;
                        return true;
                    }
                    z = 0;
                    y = 0;
                    x = 0;
                    iValue = 0.0f;
                    break;
                }
                case '.': {
                    isDecimal = true;
                    decimalMultiplier = 1.0f;
                    continue block12;
                }
                case '0': {
                    if (!isDecimal) continue block12;
                }
                default: {
                    int ich = ch - 48;
                    if (isDecimal && ich >= 0 && ich <= 9) {
                        decimalMultiplier /= 10.0f;
                        if (iValue < 0.0f) {
                            isNegative = true;
                        }
                        iValue += decimalMultiplier * (float)ich * (float)(isNegative ? -1 : 1);
                        continue block12;
                    }
                    if (ich >= 1 && ich <= 9) {
                        if (isDenominator) {
                            iValue /= (float)ich;
                            break;
                        }
                        iValue = (isNegative ? -1.0f : 1.0f) * (float)ich;
                        break;
                    }
                    Logger.warn((String)("symmetry character?" + ch));
                }
            }
            isNegative = false;
            isDenominator = false;
            isDecimal = false;
        }
        return false;
    }

    static final String getXYZFromMatrix(Matrix4f mat, boolean allPositive) {
        String str = "";
        float[] row = new float[4];
        for (int i = 0; i < 3; ++i) {
            mat.getRow(i, row);
            String term = "";
            if (row[0] != 0.0f) {
                term = term + (row[0] < 0.0f ? "-" : "+") + "x";
            }
            if (row[1] != 0.0f) {
                term = term + (row[1] < 0.0f ? "-" : "+") + "y";
            }
            if (row[2] != 0.0f) {
                term = term + (row[2] < 0.0f ? "-" : "+") + "z";
            }
            if ((term = term + SymmetryOperation.xyzFraction(row[3], allPositive)).length() > 0 && term.charAt(0) == '+') {
                term = term.substring(1);
            }
            str = str + "," + term;
        }
        return str.substring(1);
    }

    private static final String twelfthsOf(float n12ths) {
        String str = "";
        if (n12ths < 0.0f) {
            str = "-";
            n12ths = -n12ths;
        }
        return str + twelfths[(int)n12ths % 12];
    }

    private static final String xyzFraction(float n12ths, boolean allPositive) {
        String s;
        if (allPositive) {
            while (n12ths < 0.0f) {
                n12ths += 12.0f;
            }
        } else if (n12ths > 6.0f) {
            n12ths -= 12.0f;
        }
        return (s = SymmetryOperation.twelfthsOf(n12ths)).charAt(0) == '0' ? "" : (n12ths > 0.0f ? "+" + s : s);
    }

    private void setOffset(Point3f[] atoms, int atomIndex, int count) {
        int i1 = atomIndex;
        int i2 = i1 + count;
        float x = 0.0f;
        float y = 0.0f;
        float z = 0.0f;
        for (int i = i1; i < i2; ++i) {
            this.newPoint(atoms[i], this.atomTest, 0, 0, 0);
            x += this.atomTest.x;
            y += this.atomTest.y;
            z += this.atomTest.z;
        }
        while ((double)x < -0.001 || (double)x >= (double)count + 0.001) {
            this.m03 += (float)(x < 0.0f ? 1 : -1);
            x += (float)(x < 0.0f ? count : -count);
        }
        while ((double)y < -0.001 || (double)y >= (double)count + 0.001) {
            this.m13 += (float)(y < 0.0f ? 1 : -1);
            y += (float)(y < 0.0f ? count : -count);
        }
        while ((double)z < -0.001 || (double)z >= (double)count + 0.001) {
            this.m23 += (float)(z < 0.0f ? 1 : -1);
            z += (float)(z < 0.0f ? count : -count);
        }
    }
}

