/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import java.util.Hashtable;
import org.jmol.g3d.Graphics3D;
import org.jmol.viewer.Atom;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.Shape;

class AtomShape
extends Shape {
    short[] mads;
    short[] colixes;
    short[] paletteIDs;
    BitSet bsSizeSet;
    BitSet bsColixSet;

    AtomShape() {
    }

    void setSize(int size, BitSet bsSelected) {
        if (this.bsSizeSet == null) {
            this.bsSizeSet = new BitSet();
        }
        Atom[] atoms = this.frame.atoms;
        boolean isVisible = size != 0;
        int i = this.frame.atomCount;
        while (--i >= 0) {
            if (!bsSelected.get(i)) continue;
            if (this.mads == null) {
                this.mads = new short[this.frame.atomCount];
            }
            Atom atom = atoms[i];
            atom.setShapeVisibility(this.myVisibilityFlag, isVisible);
            this.mads[i] = atom.convertEncodedMad(size);
            this.bsSizeSet.set(i);
        }
    }

    void setProperty(String propertyName, Object value, BitSet bs) {
        int atomCount = this.frame.atomCount;
        Atom[] atoms = this.frame.atoms;
        if ("color" == propertyName) {
            short colix = Graphics3D.getColix(value);
            if (this.bsColixSet == null) {
                this.bsColixSet = new BitSet();
            }
            int pid = value instanceof Byte ? ((Byte)value).intValue() : -1;
            int i = atomCount;
            while (--i >= 0) {
                if (!bs.get(i)) continue;
                if (this.colixes == null) {
                    this.colixes = new short[atomCount];
                    this.paletteIDs = new short[atomCount];
                }
                this.colixes[i] = colix != 3 ? colix : this.viewer.getColixAtomPalette(atoms[i], pid);
                this.paletteIDs[i] = (short)pid;
                this.bsColixSet.set(i, this.colixes[i] != 0 || atoms[i].isTranslucent());
            }
            return;
        }
        if ("translucency" == propertyName) {
            boolean isTranslucent = "translucent" == value;
            int i = atomCount;
            while (--i >= 0) {
                if (!bs.get(i)) continue;
                if (this.colixes == null) {
                    this.colixes = new short[atomCount];
                }
                this.colixes[i] = Graphics3D.setTranslucent(this.colixes[i], isTranslucent);
                if (!isTranslucent) continue;
                this.bsColixSet.set(i);
            }
            return;
        }
    }

    void setModelClickability() {
        if (this.mads == null) {
            return;
        }
        int i = this.frame.atomCount;
        while (--i >= 0) {
            Atom atom = this.frame.atoms[i];
            if ((atom.shapeVisibilityFlags & this.myVisibilityFlag) != 0) continue;
            atom.clickabilityFlags |= this.myVisibilityFlag;
        }
    }

    String getShapeState() {
        if (this.bsSizeSet == null) {
            return "";
        }
        Hashtable temp = new Hashtable();
        Hashtable temp2 = new Hashtable();
        String type = JmolConstants.shapeClassBases[this.shapeID];
        int i = this.frame.atomCount;
        while (--i >= 0) {
            if (this.bsSizeSet != null && this.bsSizeSet.get(i)) {
                AtomShape.setStateInfo(temp, i, type + " " + (float)this.mads[i] / 2000.0f);
            }
            if (this.bsColixSet == null || !this.bsColixSet.get(i)) continue;
            AtomShape.setStateInfo(temp2, i, this.getColorCommand(type, this.paletteIDs[i], this.colixes[i]));
        }
        return AtomShape.getShapeCommands(temp, temp2, this.frame.atomCount);
    }
}

