/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import java.util.Hashtable;
import java.util.Vector;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Vector3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.util.Logger;
import org.jmol.viewer.Mesh;
import org.jmol.viewer.MeshCollection;
import org.jmol.viewer.StateManager;

class Draw
extends MeshCollection {
    static final int MAX_POINTS = 256;
    Point3f[] ptList = new Point3f[256];
    int[] ptIdentifiers = new int[256];
    boolean[] reversePoints = new boolean[256];
    boolean[] useVertices = new boolean[256];
    BitSet[] ptBitSets = new BitSet[256];
    BitSet bsAllAtoms = new BitSet();
    int nUnnamed;
    Vector3f offset = new Vector3f();
    Point3f xyz = new Point3f();
    int nPoints;
    int nbitsets;
    int ncoord;
    int nidentifiers;
    float newScale;
    float length;
    boolean isCurve;
    boolean isArrow;
    boolean isCircle;
    boolean isFixed;
    boolean isVisible;
    boolean isPerpendicular;
    boolean isVertices;
    boolean isPlane;
    boolean isReversed;
    boolean isRotated45;
    boolean isCrossed;
    boolean isValid;
    final Vector3f vAB = new Vector3f();
    final Vector3f vAC = new Vector3f();
    static final int MAX_OBJECT_CLICK_DISTANCE_SQUARED = 100;
    Mesh pickedMesh = null;
    int pickedModel;
    int pickedVertex;
    final Point3i ptXY = new Point3i();

    Draw() {
    }

    void initShape() {
        this.myType = "draw";
    }

    void setProperty(String propertyName, Object value, BitSet bs) {
        Logger.debug("draw " + propertyName + " " + value);
        if ("init" == propertyName) {
            this.nPoints = -1;
            this.nidentifiers = 0;
            this.nbitsets = 0;
            this.ncoord = 0;
            this.isCrossed = false;
            this.isRotated45 = false;
            this.isReversed = false;
            this.isFixed = false;
            this.isPerpendicular = false;
            this.isVertices = false;
            this.isPlane = false;
            this.isArrow = false;
            this.isCurve = false;
            this.isValid = true;
            this.isVisible = true;
            this.length = Float.MAX_VALUE;
            this.bsAllAtoms.clear();
            this.offset = new Vector3f();
            if (this.colix == 0) {
                this.colix = (short)23;
            }
            super.setProperty("thisID", null, null);
            return;
        }
        if ("length" == propertyName) {
            this.length = ((Float)value).floatValue();
            return;
        }
        if ("fixed" == propertyName) {
            this.isFixed = (Boolean)value;
            return;
        }
        if ("perp" == propertyName) {
            this.isPerpendicular = true;
            return;
        }
        if ("plane" == propertyName) {
            this.isPlane = true;
            return;
        }
        if ("curve" == propertyName) {
            this.isCurve = true;
            return;
        }
        if ("arrow" == propertyName) {
            this.isArrow = true;
            return;
        }
        if ("vertices" == propertyName) {
            this.isVertices = true;
            return;
        }
        if ("reverse" == propertyName) {
            this.isReversed = true;
            return;
        }
        if ("rotate45" == propertyName) {
            this.isRotated45 = true;
            return;
        }
        if ("crossed" == propertyName) {
            this.isCrossed = true;
            return;
        }
        if ("points" == propertyName) {
            this.nPoints = 0;
            this.newScale = ((Integer)value).floatValue() / 100.0f;
            if (this.newScale == 0.0f) {
                this.newScale = 1.0f;
            }
            return;
        }
        if ("scale" == propertyName) {
            this.newScale = ((Integer)value).floatValue() / 100.0f;
            if (this.newScale == 0.0f) {
                this.newScale = 0.01f;
            }
            if (this.currentMesh != null) {
                this.scaleDrawing(this.currentMesh, this.newScale);
                this.currentMesh.initialize();
            }
            return;
        }
        if ("identifier" == propertyName) {
            String thisID = (String)value;
            int meshIndex = this.getIndexFromName(thisID);
            if (meshIndex >= 0) {
                this.reversePoints[this.nidentifiers] = this.isReversed;
                this.useVertices[this.nidentifiers] = this.isVertices;
                this.ptIdentifiers[this.nidentifiers] = meshIndex;
                ++this.nidentifiers;
                ++this.nPoints;
                this.isVertices = false;
                this.isReversed = false;
            } else {
                Logger.error("draw identifier " + value + " not found");
                this.isValid = false;
            }
            return;
        }
        if ("coord" == propertyName) {
            if (this.ncoord == 256) {
                return;
            }
            this.ptList[this.ncoord++] = new Point3f((Point3f)value);
            ++this.nPoints;
            return;
        }
        if ("offset" == propertyName) {
            this.offset = new Vector3f((Point3f)value);
            if (this.currentMesh != null) {
                this.currentMesh.offset(this.offset);
            }
            return;
        }
        if ("atomSet" == propertyName) {
            if (this.viewer.cardinalityOf((BitSet)value) == 0) {
                return;
            }
            this.ptBitSets[this.nbitsets++] = (BitSet)value;
            this.bsAllAtoms.or((BitSet)value);
            ++this.nPoints;
            return;
        }
        if ("set" == propertyName) {
            if (this.currentMesh == null) {
                this.allocMesh(null);
                this.currentMesh.colix = this.colix;
            }
            boolean bl = this.currentMesh.isValid = this.isValid ? this.setDrawing() : false;
            if (this.currentMesh.isValid) {
                this.scaleDrawing(this.currentMesh, this.newScale);
                this.currentMesh.initialize();
                this.setAxes(this.currentMesh);
                this.currentMesh.visible = this.isVisible;
            }
            this.nPoints = -1;
            return;
        }
        if ("off" == propertyName) {
            this.isVisible = false;
        }
        super.setProperty(propertyName, value, bs);
    }

    Object getProperty(String property, int index) {
        if (property == "command") {
            return this.getDrawCommand(this.currentMesh);
        }
        return super.getProperty(property, index);
    }

    boolean setDrawing() {
        if (this.currentMesh == null) {
            this.allocMesh(null);
        }
        this.currentMesh.clear("draw");
        if (this.nPoints == 0) {
            return false;
        }
        int nPoly = 0;
        int modelCount = this.viewer.getModelCount();
        if (this.isFixed || this.isArrow || this.isCurve || modelCount == 1) {
            this.currentMesh.modelIndex = this.viewer.getDisplayModelIndex();
            if (this.currentMesh.modelIndex < 0) {
                this.currentMesh.modelIndex = 0;
            }
            this.currentMesh.setPolygonCount(1);
            this.currentMesh.ptCenters = null;
            this.currentMesh.modelFlags = null;
            this.currentMesh.drawTypes = null;
            this.currentMesh.drawVertexCounts = null;
            this.addModelPoints(-1);
            nPoly = this.setPolygons(nPoly);
        } else {
            BitSet bsAllModels = new BitSet();
            if (this.nbitsets > 0) {
                bsAllModels = this.viewer.getModelBitSet(this.bsAllAtoms);
            } else if (this.nidentifiers > 0) {
                for (int i = 0; i < this.nidentifiers; ++i) {
                    int j = this.meshes[this.ptIdentifiers[i]].polygonCount;
                    while (--j >= 0) {
                        bsAllModels.set(j);
                    }
                }
            } else {
                bsAllModels = this.viewer.getVisibleFramesBitSet();
            }
            this.currentMesh.setPolygonCount(modelCount);
            this.currentMesh.ptCenters = new Point3f[modelCount];
            this.currentMesh.modelFlags = new int[modelCount];
            this.currentMesh.drawTypes = new int[modelCount];
            this.currentMesh.drawVertexCounts = new int[modelCount];
            for (int iModel = 0; iModel < modelCount; ++iModel) {
                if (bsAllModels.get(iModel)) {
                    this.addModelPoints(iModel);
                    this.setPolygons(nPoly);
                    this.currentMesh.setCenter(iModel);
                    this.currentMesh.drawTypes[iModel] = this.currentMesh.drawType;
                    this.currentMesh.drawVertexCounts[iModel] = this.currentMesh.drawVertexCount;
                    this.currentMesh.drawType = -1;
                    this.currentMesh.drawVertexCount = -1;
                } else {
                    this.currentMesh.drawTypes[iModel] = 0;
                    this.currentMesh.polygonIndexes[iModel] = new int[0];
                }
                ++nPoly;
            }
        }
        this.currentMesh.setCenter(-1);
        if (this.currentMesh.thisID == null) {
            this.currentMesh.thisID = this.currentMesh.getDrawType() + ++this.nUnnamed;
        }
        return true;
    }

    void addPoint(Point3f newPt) {
        this.ptList[this.nPoints] = new Point3f(newPt);
        if (this.offset != null) {
            this.ptList[this.nPoints].add(this.offset);
        }
        if (++this.nPoints > 256) {
            this.nPoints = 256;
        }
    }

    private void addModelPoints(int iModel) {
        this.nPoints = this.ncoord;
        for (int i = 0; i < this.nidentifiers; ++i) {
            Mesh m = this.meshes[this.ptIdentifiers[i]];
            if (this.isPlane || this.isPerpendicular || this.useVertices[i]) {
                int ipt;
                if (this.reversePoints[i]) {
                    if (iModel < 0 || iModel >= m.polygonCount) {
                        ipt = m.drawVertexCount;
                        while (--ipt >= 0) {
                            this.addPoint(m.vertices[ipt]);
                        }
                        continue;
                    }
                    ipt = m.drawVertexCounts[iModel];
                    while (--ipt >= 0) {
                        this.addPoint(m.vertices[m.polygonIndexes[iModel][ipt]]);
                    }
                    continue;
                }
                if (iModel < 0 || iModel >= m.polygonCount) {
                    for (ipt = 0; ipt < m.drawVertexCount; ++ipt) {
                        this.addPoint(m.vertices[ipt]);
                    }
                    continue;
                }
                ipt = m.drawVertexCounts[iModel];
                while (--ipt >= 0) {
                    this.addPoint(m.vertices[m.polygonIndexes[iModel][ipt]]);
                }
                continue;
            }
            if (iModel < 0 || m.ptCenters == null || m.ptCenters[iModel] == null) {
                this.addPoint(m.ptCenter);
                continue;
            }
            this.addPoint(m.ptCenters[iModel]);
        }
        if (this.nbitsets == 0) {
            return;
        }
        BitSet bsModel = iModel < 0 ? null : this.viewer.getModelAtomBitSet(iModel);
        for (int i = 0; i < this.nbitsets; ++i) {
            BitSet bs = (BitSet)this.ptBitSets[i].clone();
            if (bsModel != null) {
                bs.and(bsModel);
            }
            if (this.viewer.cardinalityOf(bs) <= 0) continue;
            this.addPoint(this.viewer.getAtomSetCenter(bs));
        }
    }

    private int setPolygons(int nPoly) {
        if (this.nPoints == 4 && this.isCrossed) {
            Point3f pt = new Point3f(this.ptList[1]);
            this.ptList[1].set(this.ptList[2]);
            this.ptList[2].set(pt);
        }
        return this.setPolygon(this.currentMesh, this.nPoints, nPoly);
    }

    private int setPolygon(Mesh mesh, int nVertices, int nPoly) {
        int drawType = 6;
        if ((this.isCurve || this.isArrow || this.isCircle) && nVertices >= 2) {
            int n = this.isCurve ? 3 : (drawType = this.isArrow ? 1 : 2);
        }
        if (drawType == 6) {
            float dist;
            Point3f pt;
            Point3f center = new Point3f();
            Vector3f normal = new Vector3f();
            if (nVertices == 3 && this.isPlane && !this.isPerpendicular) {
                pt = new Point3f(this.ptList[1]);
                pt.sub(this.ptList[0]);
                pt.scale(0.5f);
                this.ptList[3] = new Point3f(this.ptList[2]);
                this.ptList[2].add(pt);
                this.ptList[3].sub(pt);
                nVertices = 4;
            } else if (nVertices >= 3 && !this.isPlane && this.isPerpendicular) {
                Graphics3D.calcNormalizedNormal(this.ptList[0], this.ptList[1], this.ptList[2], normal, this.vAB, this.vAC);
                center = new Point3f(this.ptList[0]);
                for (int i = 1; i < nVertices; ++i) {
                    center.add(this.ptList[i]);
                }
                center.scale(1.0f / (float)nVertices);
                dist = this.length == Float.MAX_VALUE ? this.ptList[0].distance(center) : this.length;
                normal.scale(dist);
                this.ptList[0].set(center);
                this.ptList[1].set(center);
                this.ptList[1].add(normal);
                nVertices = 2;
            } else if (nVertices == 2 && this.isPerpendicular) {
                this.g3d.calcAveragePoint(this.ptList[0], this.ptList[1], center);
                float f = dist = this.length == Float.MAX_VALUE ? this.ptList[0].distance(center) : this.length;
                if (this.isPlane && this.length != Float.MAX_VALUE) {
                    dist /= 2.0f;
                }
                if (this.isPlane && this.isRotated45) {
                    dist *= 1.4142f;
                }
                this.g3d.calcXYNormalToLine(this.ptList[0], this.ptList[1], normal);
                normal.scale(dist);
                if (this.isPlane) {
                    this.ptList[2] = new Point3f(center);
                    this.ptList[2].sub(normal);
                    pt = new Point3f(center);
                    pt.add(normal);
                    Graphics3D.calcNormalizedNormal(this.ptList[0], this.ptList[1], this.ptList[2], normal, this.vAB, this.vAC);
                    normal.scale(dist);
                    this.ptList[3] = new Point3f(center);
                    this.ptList[3].add(normal);
                    this.ptList[1].set(center);
                    this.ptList[1].sub(normal);
                    this.ptList[0].set(pt);
                    if (this.isRotated45) {
                        this.g3d.calcAveragePoint(this.ptList[0], this.ptList[1], this.ptList[0]);
                        this.g3d.calcAveragePoint(this.ptList[1], this.ptList[2], this.ptList[1]);
                        this.g3d.calcAveragePoint(this.ptList[2], this.ptList[3], this.ptList[2]);
                        this.g3d.calcAveragePoint(this.ptList[3], pt, this.ptList[3]);
                    }
                    nVertices = 4;
                } else {
                    this.ptList[0].set(center);
                    this.ptList[1].set(center);
                    this.ptList[0].sub(normal);
                    this.ptList[1].add(normal);
                }
            } else if (nVertices == 2 && this.length != Float.MAX_VALUE) {
                this.g3d.calcAveragePoint(this.ptList[0], this.ptList[1], center);
                normal.set(this.ptList[1]);
                normal.sub(center);
                normal.scale(0.5f / normal.length() * this.length);
                this.ptList[0].set(center);
                this.ptList[1].set(center);
                this.ptList[0].sub(normal);
                this.ptList[1].add(normal);
            }
            if (nVertices > 4) {
                nVertices = 4;
            }
            switch (nVertices) {
                case 1: {
                    break;
                }
                case 2: {
                    drawType = 4;
                    break;
                }
                default: {
                    drawType = 5;
                }
            }
        }
        mesh.drawType = drawType;
        mesh.drawVertexCount = nVertices;
        if (nVertices == 0) {
            return nPoly;
        }
        int nVertices0 = mesh.vertexCount;
        for (int i = 0; i < nVertices; ++i) {
            mesh.addVertexCopy(this.ptList[i]);
        }
        int npoints = nVertices < 3 ? 3 : nVertices;
        mesh.setPolygonCount(nPoly + 1);
        mesh.polygonIndexes[nPoly] = new int[npoints];
        for (int i = 0; i < npoints; ++i) {
            mesh.polygonIndexes[nPoly][i] = nVertices0 + (i < nVertices ? i : nVertices - 1);
        }
        return nPoly + 1;
    }

    private void scaleDrawing(Mesh mesh, float newScale) {
        if (newScale == 0.0f || mesh.vertexCount == 0 || mesh.scale == newScale) {
            return;
        }
        Vector3f diff = new Vector3f();
        float f = newScale / mesh.scale;
        mesh.scale = newScale;
        int iptlast = -1;
        int ipt = 0;
        int i = mesh.polygonCount;
        while (--i >= 0) {
            Point3f center;
            Point3f point3f = center = mesh.ptCenters == null ? mesh.ptCenter : mesh.ptCenters[i];
            if (center == null) {
                return;
            }
            iptlast = -1;
            int iV = mesh.polygonIndexes[i].length;
            while (--iV >= 0) {
                ipt = mesh.polygonIndexes[i][iV];
                if (ipt == iptlast) continue;
                iptlast = ipt;
                diff.sub(mesh.vertices[ipt], center);
                diff.scale(f);
                diff.add(center);
                mesh.vertices[ipt].set(diff);
            }
        }
    }

    final Point3f getSpinCenter(int meshIndex, int modelIndex) {
        Mesh m = this.meshes[meshIndex];
        if (m.vertices == null) {
            return null;
        }
        return m.ptCenters == null || modelIndex < 0 ? m.ptCenter : m.ptCenters[modelIndex];
    }

    final Vector3f getSpinAxis(int meshIndex, int modelIndex) {
        Mesh m = this.meshes[meshIndex];
        if (m.vertices == null) {
            return null;
        }
        return m.ptCenters == null || modelIndex < 0 ? m.axis : m.axes[modelIndex];
    }

    final void setAxes(Mesh m) {
        m.axis = new Vector3f(0.0f, 0.0f, 0.0f);
        m.axes = new Vector3f[m.polygonCount > 0 ? m.polygonCount : 1];
        if (m.vertices == null) {
            return;
        }
        int n = 0;
        int i = m.polygonCount;
        while (--i >= 0) {
            int[] p = m.polygonIndexes[i];
            m.axes[i] = new Vector3f();
            if (p.length != 0) {
                if (m.drawVertexCount == 2 || m.drawVertexCount < 0 && m.drawVertexCounts[i] == 2) {
                    m.axes[i].sub(m.vertices[p[0]], m.vertices[p[1]]);
                    ++n;
                } else {
                    Graphics3D.calcNormalizedNormal(m.vertices[p[0]], m.vertices[p[1]], m.vertices[p[2]], m.axes[i], m.vAB, m.vAC);
                    ++n;
                }
            }
            m.axis.add(m.axes[i]);
        }
        if (n == 0) {
            return;
        }
        m.axis.scale(1.0f / (float)n);
    }

    void setVisibilityFlags(BitSet bs) {
        int modelCount = this.viewer.getModelCount();
        for (int i = 0; i < this.meshCount; ++i) {
            Mesh m = this.meshes[i];
            int n = m.visibilityFlags = m.isValid && m.visible ? this.myVisibilityFlag : 0;
            if (m.modelIndex >= 0 && !bs.get(m.modelIndex)) {
                m.visibilityFlags = 0;
                continue;
            }
            if (m.modelFlags == null) continue;
            int iModel = modelCount;
            while (--iModel >= 0) {
                m.modelFlags[iModel] = bs.get(iModel) ? 1 : 0;
            }
        }
    }

    synchronized void checkObjectDragged(int prevX, int prevY, int deltaX, int deltaY, int modifiers) {
        boolean isPicking;
        boolean bl = isPicking = this.viewer.getPickingMode() == 4;
        if (!isPicking) {
            return;
        }
        if (!this.findPickedObject(prevX, prevY, true)) {
            return;
        }
        boolean moveAll = false;
        switch (modifiers & 0x1F) {
            case 17: {
                moveAll = true;
            }
            case 24: {
                this.move2D(this.pickedMesh, this.pickedMesh.polygonIndexes[this.pickedModel], this.pickedVertex, prevX + deltaX, prevY + deltaY, moveAll);
                this.currentMesh = this.pickedMesh;
                break;
            }
        }
    }

    void move2D(Mesh mesh, int[] vertexes, int iVertex, int x, int y, boolean moveAll) {
        int i;
        if (vertexes == null || vertexes.length == 0) {
            return;
        }
        Point3i pt = new Point3i();
        Point3f coord = new Point3f();
        Point3f newcoord = new Point3f();
        Vector3f move = new Vector3f();
        coord.set(mesh.vertices[vertexes[iVertex]]);
        this.viewer.transformPoint(coord, pt);
        pt.x = x;
        pt.y = y;
        this.viewer.unTransformPoint(pt, newcoord);
        move.set(newcoord);
        move.sub(coord);
        int klast = -1;
        int n = i = moveAll ? 0 : iVertex;
        while (i < vertexes.length) {
            if (moveAll || i == iVertex) {
                int k = vertexes[i];
                if (k == klast) break;
                mesh.vertices[k].add(move);
                if (!moveAll) break;
                klast = k;
            }
            ++i;
        }
        if (Logger.isActiveLevel(0)) {
            Logger.debug(this.getDrawCommand(mesh));
        }
        this.viewer.refresh();
    }

    void checkObjectClicked(int x, int y, int modifiers) {
        boolean isPicking;
        boolean bl = isPicking = this.viewer.getPickingMode() == 4;
        if (isPicking) {
            return;
        }
        if (!this.findPickedObject(x, y, false)) {
            return;
        }
        if (this.pickedVertex == 0) {
            this.viewer.startSpinningAxis(this.pickedMesh.vertices[this.pickedMesh.polygonIndexes[this.pickedModel][0]], this.pickedMesh.vertices[this.pickedMesh.polygonIndexes[this.pickedModel][1]], (modifiers & 1) != 0);
            return;
        }
        this.viewer.startSpinningAxis(this.pickedMesh.vertices[this.pickedMesh.polygonIndexes[this.pickedModel][1]], this.pickedMesh.vertices[this.pickedMesh.polygonIndexes[this.pickedModel][0]], (modifiers & 1) != 0);
    }

    boolean findPickedObject(int x, int y, boolean isPicking) {
        int modelCount = this.viewer.getModelCount();
        int dmin2 = 100;
        this.pickedModel = 0;
        this.pickedVertex = 0;
        this.pickedMesh = null;
        for (int i = 0; i < this.meshCount; ++i) {
            int mCount;
            Mesh m = this.meshes[i];
            if (!isPicking && m.drawType != 4 && m.drawType != -1 || m.visibilityFlags == 0) continue;
            int iModel = mCount = m.modelFlags == null ? 1 : modelCount;
            while (--iModel >= 0) {
                if (m.modelFlags != null && m.modelFlags[iModel] == 0) continue;
                int iVertex = m.polygonIndexes[iModel].length;
                while (--iVertex >= 0) {
                    Point3f v = new Point3f();
                    v.set(m.vertices[m.polygonIndexes[iModel][iVertex]]);
                    int d2 = this.coordinateInRange(x, y, v, dmin2);
                    if (d2 < 0) continue;
                    this.pickedMesh = m;
                    dmin2 = d2;
                    this.pickedModel = iModel;
                    this.pickedVertex = iVertex;
                }
            }
        }
        return this.pickedMesh != null;
    }

    int coordinateInRange(int x, int y, Point3f vertex, int dmin2) {
        int d2 = dmin2;
        this.viewer.transformPoint(vertex, this.ptXY);
        d2 = (x - this.ptXY.x) * (x - this.ptXY.x) + (y - this.ptXY.y) * (y - this.ptXY.y);
        return d2 < dmin2 ? d2 : -1;
    }

    private String getDrawCommand(Mesh mesh) {
        int nVertices = 0;
        if (mesh == null) {
            return "no current draw object";
        }
        StringBuffer str = new StringBuffer("draw " + mesh.thisID);
        switch (mesh.drawType) {
            case -1: {
                return this.getDrawCommand(mesh, -1);
            }
            case 1: {
                str.append(" ARROW");
                break;
            }
            case 2: {
                str.append(" CIRCLE");
                break;
            }
            case 3: {
                str.append(" CURVE");
                break;
            }
            case 4: {
                ++nVertices;
            }
            case 6: {
                ++nVertices;
                break;
            }
        }
        int modelIndex = this.viewer.getDisplayModelIndex();
        if (modelIndex < 0) {
            return str.toString();
        }
        int modelCount = this.viewer.getModelCount();
        int mCount = mesh.modelFlags == null ? 1 : modelCount;
        for (int iModel = 0; iModel < mCount; ++iModel) {
            if (mesh.modelFlags != null && mesh.modelFlags[iModel] == 0) continue;
            str.append(this.getVertexList(mesh, iModel, nVertices));
        }
        str.append(";\n" + this.getColorCommand("draw", mesh.colix) + ";");
        return str.toString();
    }

    String getVertexList(Mesh mesh, int iModel, int nVertices) {
        String str = "";
        if (nVertices == 0) {
            nVertices = mesh.polygonIndexes[iModel].length;
        }
        for (int i = 0; i < nVertices; ++i) {
            Point3f v = new Point3f();
            v.set(mesh.vertices[mesh.polygonIndexes[iModel][i]]);
            str = str + " " + StateManager.encloseCoord(v);
        }
        return str;
    }

    String getDrawCommand(Mesh mesh, int iModel) {
        StringBuffer str = new StringBuffer();
        int modelCount = this.viewer.getModelCount();
        if (iModel < 0) {
            for (int i = 0; i < modelCount; ++i) {
                str.append(this.getDrawCommand(mesh, i));
            }
            return str.toString();
        }
        int nVertices = 0;
        int n = this.viewer.getModelNumber(iModel);
        if (modelCount > 1) {
            str.append("frame " + n + ";");
        }
        str.append("draw " + mesh.thisID + (mesh.drawType == -1 ? "_" + n : ""));
        switch (mesh.drawTypes == null ? mesh.drawType : mesh.drawTypes[iModel]) {
            case 0: {
                return "";
            }
            case 1: {
                str.append(" ARROW");
                break;
            }
            case 2: {
                str.append(" CIRCLE");
                break;
            }
            case 3: {
                str.append(" CURVE");
                break;
            }
            case 4: {
                ++nVertices;
            }
            case 6: {
                ++nVertices;
                break;
            }
        }
        str.append(this.getVertexList(mesh, iModel, nVertices));
        str.append(";\n" + this.getColorCommand("draw", mesh.colix));
        return str.toString();
    }

    Vector getShapeDetail() {
        Vector V = new Vector();
        if (this.nPoints == 0) {
            return V;
        }
        for (int i = 0; i < this.meshCount; ++i) {
            Mesh mesh = this.meshes[i];
            if (mesh.vertexCount == 0) continue;
            Hashtable<String, Object> info = new Hashtable<String, Object>();
            info.put("fixed", mesh.ptCenters == null ? Boolean.TRUE : Boolean.FALSE);
            info.put("ID", mesh.thisID == null ? "<noid>" : mesh.thisID);
            info.put("drawType", mesh.getDrawType());
            info.put("scale", new Float(mesh.scale));
            if (mesh.drawType == -1) {
                int modelCount = this.viewer.getModelCount();
                Vector m = new Vector();
                for (int k = 0; k < modelCount; ++k) {
                    if (mesh.ptCenters[k] == null) continue;
                    Hashtable<String, Object> mInfo = new Hashtable<String, Object>();
                    mInfo.put("modelIndex", new Integer(k));
                    mInfo.put("command", this.getDrawCommand(mesh, k));
                    mInfo.put("center", mesh.ptCenters[k]);
                    int nPoints = mesh.drawVertexCounts[k];
                    mInfo.put("vertexCount", new Integer(nPoints));
                    if (nPoints > 1) {
                        mInfo.put("axis", mesh.axes[k]);
                    }
                    Vector<Point3f> v = new Vector<Point3f>();
                    for (int ipt = 0; ipt < nPoints; ++ipt) {
                        v.add(mesh.vertices[mesh.polygonIndexes[k][ipt]]);
                    }
                    mInfo.put("vertices", v);
                    if (mesh.drawTypes[k] == 4) {
                        float d = mesh.vertices[mesh.polygonIndexes[k][0]].distance(mesh.vertices[mesh.polygonIndexes[k][1]]);
                        mInfo.put("length_Ang", new Float(d));
                    }
                    m.add(mInfo);
                }
                info.put("models", m);
            } else {
                info.put("command", this.getDrawCommand(mesh));
                info.put("center", mesh.ptCenter);
                if (mesh.drawVertexCount > 1) {
                    info.put("axis", mesh.axis);
                }
                Vector<Point3f> v = new Vector<Point3f>();
                for (int j = 0; j < mesh.vertexCount; ++j) {
                    v.add(mesh.vertices[j]);
                }
                info.put("vertices", v);
                if (mesh.drawType == 4) {
                    info.put("length_Ang", new Float(mesh.vertices[0].distance(mesh.vertices[1])));
                }
            }
            V.add(info);
        }
        return V;
    }

    String getShapeState() {
        StringBuffer s = new StringBuffer();
        if (this.nPoints == 0) {
            return "";
        }
        for (int i = 0; i < this.meshCount; ++i) {
            Mesh mesh = this.meshes[i];
            if (mesh.vertexCount == 0) continue;
            s.append(this.getDrawCommand(mesh, mesh.modelIndex) + "\n");
        }
        return s.toString();
    }
}

