/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix3f;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Vector3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.viewer.AlphaMonomer;
import org.jmol.viewer.Atom;
import org.jmol.viewer.CarbohydratePolymer;
import org.jmol.viewer.Mesh;
import org.jmol.viewer.MeshRenderer;
import org.jmol.viewer.Monomer;
import org.jmol.viewer.Mps;
import org.jmol.viewer.NucleicPolymer;
import org.jmol.viewer.ProteinStructure;

abstract class MpsRenderer
extends MeshRenderer {
    Mps.Mpspolymer thisChain;
    int aspectRatio;
    int hermiteLevel;
    float sheetSmoothing;
    boolean isHighRes;
    boolean isTraceAlpha;
    boolean isNucleic;
    boolean isCarbohydrate;
    boolean ribbonBorder = false;
    BitSet bsVisible = new BitSet();
    Point3i[] ribbonTopScreens;
    Point3i[] ribbonBottomScreens;
    Mesh[] meshes;
    boolean[] meshReady;
    int monomerCount;
    Monomer[] monomers;
    Point3f[] controlPoints;
    Point3i[] controlPointScreens;
    boolean haveControlPointScreens;
    Vector3f[] wingVectors;
    short[] mads;
    short[] colixes;
    int[] leadAtomIndices;
    byte[] structureTypes;
    Point3f[] tempPoints;
    final Point3f pointT = new Point3f();
    int iPrev;
    int iNext;
    int iNext2;
    int iNext3;
    int madMid;
    int madBeg;
    int madEnd;
    int diameterBeg;
    int diameterMid;
    int diameterEnd;
    boolean doCap0;
    boolean doCap1;
    final Point3i screenArrowTop = new Point3i();
    final Point3i screenArrowTopPrev = new Point3i();
    final Point3i screenArrowBot = new Point3i();
    final Point3i screenArrowBotPrev = new Point3i();
    static final int ABSOLUTE_MIN_MESH_SIZE = 3;
    static final int MIN_MESH_RENDER_SIZE = 8;
    Point3f[] controlHermites;
    Vector3f[] wingHermites;
    Point3f[] radiusHermites;
    final Vector3f Z = new Vector3f(0.1345f, 0.5426f, 0.3675f);
    Vector3f norm = new Vector3f();
    final Vector3f wing = new Vector3f();
    final Vector3f wing0 = new Vector3f();
    final Vector3f wing1 = new Vector3f();
    final Vector3f wingT = new Vector3f();
    final AxisAngle4f aa = new AxisAngle4f();
    final Point3f pt = new Point3f();
    final Point3f pt1 = new Point3f();
    final Point3f ptPrev = new Point3f();
    final Point3f ptNext = new Point3f();
    final Matrix3f mat = new Matrix3f();

    MpsRenderer() {
    }

    void render() {
        if (this.shape == null) {
            return;
        }
        this.frontOnly = this.viewer.getTestFlag2();
        Mps mcps = (Mps)this.shape;
        int m = mcps.getMpsmodelCount();
        while (--m >= 0) {
            Mps.Mpsmodel mcpsmodel = mcps.getMpsmodel(m);
            if ((mcpsmodel.modelVisibilityFlags & this.myVisibilityFlag) == 0) continue;
            int c = mcpsmodel.getMpspolymerCount();
            while (--c >= 0) {
                Mps.Mpspolymer mpspolymer = mcpsmodel.getMpspolymer(c);
                if (mpspolymer.monomerCount < 2 || !this.initializePolymer(mpspolymer)) continue;
                this.renderMpspolymer(mpspolymer);
                this.freeTempArrays();
            }
        }
    }

    private void freeTempArrays() {
        if (this.haveControlPointScreens) {
            this.viewer.freeTempScreens(this.controlPointScreens);
        }
        this.viewer.freeTempBytes(this.structureTypes);
    }

    abstract void renderMpspolymer(Mps.Mpspolymer var1);

    private boolean initializePolymer(Mps.Mpspolymer schain) {
        float fval;
        boolean invalidate = false;
        boolean TF = this.viewer.getHighResolution();
        if (TF != this.isHighRes) {
            invalidate = true;
        }
        this.isHighRes = TF;
        TF = this.viewer.getTraceAlpha();
        if (TF != this.isTraceAlpha) {
            invalidate = true;
        }
        this.isTraceAlpha = TF;
        int val = this.viewer.getRibbonAspectRatio();
        if ((val = Math.min(Math.max(0, val), 20)) != this.aspectRatio && val != 0) {
            invalidate = true;
        }
        this.aspectRatio = val;
        val = this.viewer.getHermiteLevel();
        int n = val <= 0 ? -val : (val = this.viewer.getInMotion() ? 0 : val);
        if (val != this.hermiteLevel && val != 0) {
            invalidate = true;
        }
        this.hermiteLevel = Math.min(val, 8);
        if (this.hermiteLevel == 0) {
            this.aspectRatio = 0;
        }
        if ((fval = this.viewer.getSheetSmoothing()) != this.sheetSmoothing && this.isTraceAlpha) {
            this.sheetSmoothing = fval;
            invalidate = true;
        }
        this.controlPoints = !this.isTraceAlpha ? schain.leadMidpoints : (this.sheetSmoothing == 0.0f ? schain.leadPoints : schain.polymer.getTempPoints(this.sheetSmoothing));
        this.monomerCount = schain.monomerCount;
        this.monomers = schain.monomers;
        this.leadAtomIndices = schain.polymer.getLeadAtomIndices();
        this.bsVisible.clear();
        boolean haveVisible = false;
        int i = this.monomerCount;
        while (--i >= 0) {
            if (invalidate) {
                schain.falsifyMesh(i, false);
            }
            if ((this.monomers[i].shapeVisibilityFlags & this.myVisibilityFlag) == 0 || this.frame.bsHidden.get(this.leadAtomIndices[i])) continue;
            Atom lead = this.frame.atoms[this.leadAtomIndices[i]];
            if (!this.g3d.isInDisplayRange(lead.screenX, lead.screenY)) continue;
            this.bsVisible.set(i);
            haveVisible = true;
        }
        if (!haveVisible) {
            return false;
        }
        this.ribbonBorder = this.viewer.getRibbonBorder();
        this.thisChain = schain;
        this.isNucleic = schain.polymer instanceof NucleicPolymer;
        this.isCarbohydrate = schain.polymer instanceof CarbohydratePolymer;
        this.haveControlPointScreens = false;
        this.wingVectors = schain.wingVectors;
        this.meshReady = schain.meshReady;
        this.meshes = schain.meshes;
        this.mads = schain.mads;
        this.colixes = schain.colixes;
        this.setStructureTypes();
        return true;
    }

    private void setStructureTypes() {
        this.structureTypes = this.viewer.allocTempBytes(this.monomerCount + 1);
        int i = this.monomerCount;
        while (--i >= 0) {
            this.structureTypes[i] = this.monomers[i].getProteinStructureType();
            if (this.structureTypes[i] != 1) continue;
            this.structureTypes[i] = 0;
        }
        this.structureTypes[this.monomerCount] = this.structureTypes[this.monomerCount - 1];
    }

    boolean isHelix(int i) {
        return this.structureTypes[i] == 3;
    }

    boolean isSheet(int i) {
        return this.structureTypes[i] == 2;
    }

    void calcScreenControlPoints() {
        this.calcScreenControlPoints(this.controlPoints);
    }

    void calcScreenControlPoints(Point3f[] points) {
        int count = this.monomerCount + 1;
        this.controlPointScreens = this.viewer.allocTempScreens(count);
        int i = count;
        while (--i >= 0) {
            this.viewer.transformPoint(points[i], this.controlPointScreens[i]);
        }
        this.haveControlPointScreens = true;
    }

    Point3i[] calcScreens(float offsetFraction) {
        int count = this.controlPoints.length;
        Point3i[] screens = this.viewer.allocTempScreens(count);
        if (offsetFraction == 0.0f) {
            int i = count;
            while (--i >= 0) {
                this.viewer.transformPoint(this.controlPoints[i], screens[i]);
            }
        } else {
            float offset_1000 = offsetFraction / 1000.0f;
            int i = count;
            while (--i >= 0) {
                this.calc1Screen(this.controlPoints[i], this.wingVectors[i], this.mads[i], offset_1000, screens[i]);
            }
        }
        return screens;
    }

    private void calc1Screen(Point3f center, Vector3f vector, short mad, float offset_1000, Point3i screen) {
        this.pointT.set(vector);
        float scale = (float)mad * offset_1000;
        this.pointT.scaleAdd(scale, center);
        this.viewer.transformPoint(this.pointT, screen);
    }

    short getLeadColix(int i) {
        return Graphics3D.inheritColix(this.colixes[i], this.monomers[i].getLeadAtom().colixAtom);
    }

    private void setNeighbors(int i) {
        this.iPrev = Math.max(i - 1, 0);
        this.iNext = Math.min(i + 1, this.monomerCount);
        this.iNext2 = Math.min(i + 2, this.monomerCount);
        this.iNext3 = Math.min(i + 3, this.monomerCount);
    }

    final void renderHermiteCylinder(Point3i[] screens, int i) {
        this.setNeighbors(i);
        this.g3d.drawHermite(this.getLeadColix(i), this.isNucleic ? 4 : 7, screens[this.iPrev], screens[i], screens[this.iNext], screens[this.iNext2]);
    }

    private boolean setMads(int i, boolean thisTypeOnly) {
        this.madBeg = this.madEnd = this.mads[i];
        this.madMid = this.madEnd;
        if (this.isTraceAlpha) {
            if (!thisTypeOnly || this.structureTypes[i] == this.structureTypes[this.iNext]) {
                this.madEnd = this.mads[this.iNext];
                this.madMid = this.madBeg + this.madEnd >> 1;
            }
        } else {
            if (!thisTypeOnly || this.structureTypes[i] == this.structureTypes[this.iPrev]) {
                this.madBeg = this.mads[this.iPrev] + this.madMid >> 1;
            }
            if (!thisTypeOnly || this.structureTypes[i] == this.structureTypes[this.iNext]) {
                this.madEnd = this.mads[this.iNext] + this.madMid >> 1;
            }
        }
        this.doCap0 = i == this.iPrev || thisTypeOnly && this.structureTypes[i] != this.structureTypes[this.iPrev];
        this.doCap1 = this.iNext == this.iNext2 || thisTypeOnly && this.structureTypes[i] != this.structureTypes[this.iNext];
        this.diameterBeg = this.viewer.scaleToScreen(this.controlPointScreens[i].z, this.madBeg);
        this.diameterMid = this.viewer.scaleToScreen(this.monomers[i].getLeadAtom().getScreenZ(), this.madMid);
        this.diameterEnd = this.viewer.scaleToScreen(this.controlPointScreens[this.iNext].z, this.madEnd);
        return this.aspectRatio > 0 && (this.checkDiameter(this.diameterBeg) || this.checkDiameter(this.diameterMid) || this.checkDiameter(this.diameterEnd));
    }

    private boolean checkDiameter(int d) {
        return this.isHighRes & d > 3 || d >= 8;
    }

    final void renderHermiteConic(int i, boolean thisTypeOnly) {
        this.setNeighbors(i);
        short colix = this.getLeadColix(i);
        if (this.setMads(i, thisTypeOnly)) {
            try {
                if (this.meshes[i] == null || !this.meshReady[i]) {
                    this.createMeshCylinder(i, this.madBeg, this.madMid, this.madEnd, 1);
                }
                this.meshes[i].colix = colix;
                this.render1(this.meshes[i]);
                return;
            }
            catch (Exception e) {
                System.out.println("render mesh error: " + e.toString());
            }
        }
        this.g3d.fillHermite(colix, this.isNucleic ? 4 : 7, this.diameterBeg, this.diameterMid, this.diameterEnd, this.controlPointScreens[this.iPrev], this.controlPointScreens[i], this.controlPointScreens[this.iNext], this.controlPointScreens[this.iNext2]);
    }

    final void renderHermiteRibbon(boolean doFill, int i, boolean thisTypeOnly) {
        this.setNeighbors(i);
        short colix = this.getLeadColix(i);
        if (doFill && this.aspectRatio != 0 && this.setMads(i, thisTypeOnly)) {
            try {
                if (this.meshes[i] == null || !this.meshReady[i]) {
                    this.createMeshCylinder(i, this.madBeg, this.madMid, this.madEnd, this.aspectRatio);
                }
                this.meshes[i].colix = colix;
                this.render1(this.meshes[i]);
                return;
            }
            catch (Exception e) {
                System.out.println("render mesh error: " + e.toString());
            }
        }
        this.g3d.drawHermite(doFill, this.ribbonBorder, colix, this.isNucleic ? 4 : 7, this.ribbonTopScreens[this.iPrev], this.ribbonTopScreens[i], this.ribbonTopScreens[this.iNext], this.ribbonTopScreens[this.iNext2], this.ribbonBottomScreens[this.iPrev], this.ribbonBottomScreens[i], this.ribbonBottomScreens[this.iNext], this.ribbonBottomScreens[this.iNext2], this.aspectRatio);
    }

    final void renderHermiteArrowHead(int i) {
        short colix = this.getLeadColix(i);
        this.setNeighbors(i);
        if (this.setMads(i, false)) {
            try {
                this.doCap0 = true;
                this.doCap1 = false;
                if (this.meshes[i] == null || !this.meshReady[i]) {
                    this.createMeshCylinder(i, (int)((double)this.madBeg * 1.2), (int)((double)this.madBeg * 0.6), 0, this.aspectRatio >> 1);
                }
                this.meshes[i].colix = colix;
                this.render1(this.meshes[i]);
                return;
            }
            catch (Exception e) {
                System.out.println("render mesh error: " + e.toString());
            }
        }
        this.calc1Screen(this.controlPoints[i], this.wingVectors[i], (short)this.madBeg, 7.0E-4f, this.screenArrowTop);
        this.calc1Screen(this.controlPoints[i], this.wingVectors[i], (short)this.madBeg, -7.0E-4f, this.screenArrowBot);
        this.calc1Screen(this.controlPoints[i], this.wingVectors[i], (short)this.madBeg, 0.001f, this.screenArrowTopPrev);
        this.calc1Screen(this.controlPoints[i], this.wingVectors[i], (short)this.madBeg, -0.001f, this.screenArrowBotPrev);
        if (this.ribbonBorder && this.aspectRatio == 0) {
            this.g3d.fillCylinder(colix, colix, (byte)3, 3, this.screenArrowTop.x, this.screenArrowTop.y, this.screenArrowTop.z, this.screenArrowBot.x, this.screenArrowBot.y, this.screenArrowBot.z);
        }
        this.g3d.drawHermite(true, this.ribbonBorder, colix, this.isNucleic ? 4 : 7, this.screenArrowTopPrev, this.screenArrowTop, this.controlPointScreens[this.iNext], this.controlPointScreens[this.iNext2], this.screenArrowBotPrev, this.screenArrowBot, this.controlPointScreens[this.iNext], this.controlPointScreens[this.iNext2], this.aspectRatio);
    }

    void renderCone(int i, Point3f pointBegin, Point3f pointEnd, Point3f screenPtBegin, Point3f screenPtEnd, short colix, int mad) {
        short coneDiameter = this.viewer.scaleToScreen((int)Math.floor(screenPtBegin.z), mad + (mad >> 2));
        this.g3d.fillCone(colix, (byte)2, (int)coneDiameter, screenPtBegin, screenPtEnd);
    }

    private void createMeshCylinder(int i, int madBeg, int madMid, int madEnd, int aspectRatio) {
        int k;
        boolean variableRadius;
        this.setNeighbors(i);
        if (this.controlPoints[i].distance(this.controlPoints[this.iNext]) == 0.0f) {
            return;
        }
        if (this.isHelix(i)) {
            ProteinStructure p = ((AlphaMonomer)this.monomers[i]).proteinStructure;
            p.calcAxis();
        }
        boolean isEccentric = aspectRatio != 1 && this.wingVectors != null;
        int nHermites = (this.hermiteLevel + 1) * 2 + 1;
        int nPer = (nHermites - 1) * 2 - 2;
        Mesh mesh = this.meshes[i] = new Mesh(this.viewer, "mesh_" + this.shapeID + "_" + i, this.g3d, 0);
        boolean bl = variableRadius = madBeg != madMid || madMid != madEnd;
        if (this.controlHermites == null || this.controlHermites.length < nHermites + 1) {
            this.controlHermites = new Point3f[nHermites + 1];
        }
        Graphics3D.getHermiteList(this.isNucleic ? 4 : 7, this.controlPoints[this.iPrev], this.controlPoints[i], this.controlPoints[this.iNext], this.controlPoints[this.iNext2], this.controlPoints[this.iNext3], this.controlHermites, nHermites);
        if (isEccentric) {
            if (this.wingHermites == null || this.wingHermites.length < nHermites + 1) {
                this.wingHermites = new Vector3f[nHermites + 1];
            }
            this.wing.set(this.wingVectors[this.iPrev]);
            if (madEnd == 0) {
                this.wing.scale(2.0f);
            }
            Graphics3D.getHermiteList(this.isNucleic ? 4 : 7, this.wing, this.wingVectors[i], this.wingVectors[this.iNext], this.wingVectors[this.iNext2], this.wingVectors[this.iNext3], this.wingHermites, nHermites);
        }
        float radius1 = (float)madBeg / 2000.0f;
        float radius2 = (float)madMid / 2000.0f;
        float radius3 = (float)madEnd / 2000.0f;
        if (variableRadius) {
            if (this.radiusHermites == null || this.radiusHermites.length < (nHermites + 1 >> 1) + 1) {
                this.radiusHermites = new Point3f[(nHermites + 1 >> 1) + 1];
            }
            this.ptPrev.set(radius1, radius1, 0.0f);
            this.pt.set(radius1, radius2, 0.0f);
            this.pt1.set(radius2, radius3, 0.0f);
            this.ptNext.set(radius3, radius3, 0.0f);
            Graphics3D.getHermiteList(4, this.ptPrev, this.pt, this.pt1, this.ptNext, this.ptNext, this.radiusHermites, nHermites + 1 >> 1);
        }
        if (!isEccentric) {
            this.norm.sub(this.controlHermites[1], this.controlHermites[0]);
            this.wing0.cross(this.norm, this.Z);
            this.wing0.cross(this.norm, this.wing0);
        }
        int nPoints = 0;
        int iMid = nHermites >> 1;
        for (int p = 0; p < nHermites; ++p) {
            int k2;
            this.norm.sub(this.controlHermites[p + 1], this.controlHermites[p]);
            if (isEccentric) {
                this.wing.set(this.wingHermites[p]);
                this.wing1.set(this.wing);
                this.wing.scale(2.0f / (float)aspectRatio);
            } else {
                this.wing.cross(this.norm, this.wing0);
                this.wing.normalize();
            }
            float scale = !variableRadius ? radius1 : (p < iMid ? this.radiusHermites[p].x : this.radiusHermites[p - iMid].y);
            this.wing.scale(scale);
            this.wing1.scale(scale);
            this.aa.set(this.norm, (float)(Math.PI * 2 / (double)nPer));
            this.mat.set(this.aa);
            this.pt1.set(this.controlHermites[p]);
            for (k2 = 0; k2 < nPer; ++k2) {
                this.mat.transform(this.wing);
                this.wingT.set(this.wing);
                if (isEccentric) {
                    if (k2 == (nPer + 2) / 4 || k2 == (3 * nPer + 2) / 4) {
                        this.wing1.scale(-1.0f);
                    }
                    this.wingT.add(this.wing1);
                }
                this.pt.add(this.pt1, this.wingT);
                if (isEccentric) {
                    // empty if block
                }
                mesh.addVertexCopy(this.pt);
            }
            if (p > 0) {
                for (k2 = 0; k2 < nPer; ++k2) {
                    mesh.addQuad(nPoints - nPer + k2, nPoints - nPer + (k2 + 1) % nPer, nPoints + (k2 + 1) % nPer, nPoints + k2);
                }
            }
            nPoints += nPer;
        }
        if (this.doCap0) {
            k = this.hermiteLevel * 2;
            while (--k >= 0) {
                mesh.addQuad(k + 2, k + 1, (nPer - k) % nPer, nPer - k - 1);
            }
        }
        if (this.doCap1) {
            k = this.hermiteLevel * 2;
            while (--k >= 0) {
                mesh.addQuad(nPoints - k - 1, nPoints - nPer + (nPer - k) % nPer, nPoints - nPer + k + 1, nPoints - nPer + k + 2);
            }
        }
        mesh.initialize(false);
        this.meshReady[i] = true;
        mesh.visibilityFlags = 1;
    }

    void createMeshCone(int i, Point3f pointBegin, Point3f pointEnd, int mad) {
        int k;
        int level = 5;
        int nHermites = (level + 1) * 2 + 1;
        int nPer = (nHermites - 1) * 2 - 2;
        this.norm.sub(pointEnd, pointBegin);
        this.norm.normalize();
        this.norm.scale(0.19f);
        this.wing.cross(this.Z, this.norm);
        this.wing.normalize();
        this.wing.scale((float)mad * 1.2f / 2000.0f);
        Mesh mesh = this.meshes[i] = new Mesh(this.viewer, "mesh_" + this.shapeID + "_" + i, this.g3d, 0);
        this.aa.set(this.norm, (float)(Math.PI * 2 / (double)nPer));
        this.mat.set(this.aa);
        this.pt1.set(pointBegin);
        this.pt1.sub(this.norm);
        for (k = 0; k < nPer; ++k) {
            this.mat.transform(this.wing);
            this.pt.add(this.pt1, this.wing);
            mesh.addVertexCopy(this.pt);
        }
        mesh.addVertexCopy(pointEnd);
        for (k = 0; k < nPer; ++k) {
            mesh.addTriangle((k + 1) % nPer, nPer, k);
        }
        k = level * 2;
        while (--k >= 0) {
            mesh.addQuad(k + 2, k + 1, (nPer - k) % nPer, nPer - k - 1);
        }
        mesh.initialize(false);
        this.meshReady[i] = true;
        mesh.visibilityFlags = 1;
    }
}

