/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.jmol.viewer.AminoPolymer;
import org.jmol.viewer.Helix;
import org.jmol.viewer.Monomer;
import org.jmol.viewer.Mps;
import org.jmol.viewer.MpsRenderer;
import org.jmol.viewer.ProteinStructure;
import org.jmol.viewer.Rockets;
import org.jmol.viewer.Sheet;

class RocketsRenderer
extends MpsRenderer {
    static final float MIN_CONE_HEIGHT = 0.05f;
    Point3f[] cordMidPoints;
    boolean tPending;
    ProteinStructure proteinstructurePending;
    int startIndexPending;
    int endIndexPending;
    short madPending;
    short colixPending;
    int[] shadesPending;
    Point3f screenA = new Point3f();
    Point3f screenB = new Point3f();
    Point3f screenC = new Point3f();
    static final byte[] boxFaces = new byte[]{0, 1, 3, 2, 0, 2, 6, 4, 0, 4, 5, 1, 7, 5, 4, 6, 7, 6, 2, 3, 7, 3, 1, 5};
    final Point3f[] corners = new Point3f[8];
    final Point3f[] screenCorners = new Point3f[8];
    final Point3f pointTipOffset;
    final Point3f pointArrow2;
    final Vector3f vectorNormal;
    final Vector3f scaledWidthVector;
    final Vector3f scaledHeightVector;
    static final byte[] arrowHeadFaces = new byte[]{0, 1, 3, 2, 0, 4, 5, 2, 1, 4, 5, 3};
    final Vector3f lengthVector;
    final Point3f pointCorner;

    RocketsRenderer() {
        int i = 8;
        while (--i >= 0) {
            this.screenCorners[i] = new Point3f();
            this.corners[i] = new Point3f();
        }
        this.pointTipOffset = new Point3f();
        this.pointArrow2 = new Point3f();
        this.vectorNormal = new Vector3f();
        this.scaledWidthVector = new Vector3f();
        this.scaledHeightVector = new Vector3f();
        this.lengthVector = new Vector3f();
        this.pointCorner = new Point3f();
    }

    void renderMpspolymer(Mps.Mpspolymer mpspolymer) {
        Rockets.Cchain cchain = (Rockets.Cchain)mpspolymer;
        if (!(cchain.polymer instanceof AminoPolymer)) {
            return;
        }
        this.calcRopeMidPoints(false);
        this.calcScreenControlPoints(this.cordMidPoints);
        this.controlPoints = this.cordMidPoints;
        this.render1();
        this.viewer.freeTempPoints(this.cordMidPoints);
    }

    void calcRopeMidPoints(boolean isNewStyle) {
        Point3f point;
        int midPointCount = this.monomerCount + 1;
        this.cordMidPoints = this.viewer.allocTempPoints(midPointCount);
        ProteinStructure proteinstructurePrev = null;
        for (int i = 0; i < this.monomerCount; ++i) {
            point = this.cordMidPoints[i];
            Monomer residue = this.monomers[i];
            if (isNewStyle) {
                point.set(this.controlPoints[i]);
                continue;
            }
            if (this.isHelix(i) || this.isSheet(i)) {
                ProteinStructure proteinstructure = residue.getProteinStructure();
                point.set(i - 1 != proteinstructure.getMonomerIndex() ? proteinstructure.getAxisStartPoint() : proteinstructure.getAxisEndPoint());
                proteinstructurePrev = proteinstructure;
                continue;
            }
            if (proteinstructurePrev != null) {
                point.set(proteinstructurePrev.getAxisEndPoint());
            } else {
                point.set(this.controlPoints[i]);
            }
            proteinstructurePrev = null;
        }
        point = this.cordMidPoints[this.monomerCount];
        if (proteinstructurePrev != null) {
            point.set(proteinstructurePrev.getAxisEndPoint());
        } else {
            point.set(this.controlPoints[this.monomerCount]);
        }
    }

    void render1() {
        this.tPending = false;
        for (int i = 0; i < this.monomerCount; ++i) {
            if (!this.bsVisible.get(i)) continue;
            Monomer monomer = this.monomers[i];
            if (this.isHelix(i) || this.isSheet(i)) {
                this.renderSpecialSegment(monomer, this.getLeadColix(i), this.mads[i]);
                continue;
            }
            this.renderHermiteConic(i, true);
        }
        this.renderPending();
    }

    void renderSpecialSegment(Monomer monomer, short colix, short mad) {
        ProteinStructure proteinstructure = monomer.getProteinStructure();
        if (this.tPending) {
            if (proteinstructure == this.proteinstructurePending && mad == this.madPending && colix == this.colixPending && proteinstructure.getIndex(monomer) == this.endIndexPending + 1) {
                ++this.endIndexPending;
                return;
            }
            this.renderPending();
        }
        this.proteinstructurePending = proteinstructure;
        this.startIndexPending = this.endIndexPending = proteinstructure.getIndex(monomer);
        this.colixPending = colix;
        this.madPending = mad;
        this.tPending = true;
    }

    void renderPending() {
        boolean tEnd;
        if (!this.tPending) {
            return;
        }
        Point3f[] segments = this.proteinstructurePending.getSegments();
        boolean bl = tEnd = this.endIndexPending == this.proteinstructurePending.getMonomerCount() - 1;
        if (this.proteinstructurePending instanceof Helix) {
            this.renderPendingRocketSegment(this.endIndexPending, segments[this.startIndexPending], segments[this.endIndexPending], segments[this.endIndexPending + 1], tEnd);
        } else if (this.proteinstructurePending instanceof Sheet) {
            this.renderPendingSheet(segments[this.startIndexPending], segments[this.endIndexPending], segments[this.endIndexPending + 1], tEnd);
        }
        this.tPending = false;
    }

    void renderPendingRocketSegment(int i, Point3f pointStart, Point3f pointBeforeEnd, Point3f pointEnd, boolean tEnd) {
        this.viewer.transformPoint(pointStart, this.screenA);
        this.viewer.transformPoint(pointEnd, this.screenB);
        int zMid = (int)Math.floor((this.screenA.z + this.screenB.z) / 2.0f);
        short diameter = this.viewer.scaleToScreen(zMid, this.madPending);
        if (tEnd) {
            this.viewer.transformPoint(pointBeforeEnd, this.screenC);
            if (pointBeforeEnd.distance(pointEnd) > 0.05f) {
                this.renderCone(i, pointBeforeEnd, pointEnd, this.screenC, this.screenB, this.colixPending, this.madPending);
            } else {
                this.g3d.fillCylinderBits(this.colixPending, (byte)2, (int)diameter, this.screenB, this.screenC);
            }
            if (this.startIndexPending == this.endIndexPending) {
                return;
            }
            Point3f t = this.screenB;
            this.screenB = this.screenC;
            this.screenC = t;
        }
        this.g3d.fillCylinderBits(this.colixPending, (byte)2, (int)diameter, this.screenA, this.screenB);
    }

    void renderPendingSheet(Point3f pointStart, Point3f pointBeforeEnd, Point3f pointEnd, boolean tEnd) {
        this.shadesPending = this.g3d.getShades(this.colixPending);
        if (tEnd) {
            this.drawArrowHeadBox(pointBeforeEnd, pointEnd);
            this.drawBox(pointStart, pointBeforeEnd);
        } else {
            this.drawBox(pointStart, pointEnd);
        }
    }

    void buildBox(Point3f pointCorner, Vector3f scaledWidthVector, Vector3f scaledHeightVector, Vector3f lengthVector) {
        int i = 8;
        while (--i >= 0) {
            Point3f corner = this.corners[i];
            corner.set(pointCorner);
            if ((i & 1) != 0) {
                corner.add(scaledWidthVector);
            }
            if ((i & 2) != 0) {
                corner.add(scaledHeightVector);
            }
            if ((i & 4) != 0) {
                corner.add(lengthVector);
            }
            this.viewer.transformPoint(corner, this.screenCorners[i]);
        }
    }

    void buildArrowHeadBox(Point3f pointCorner, Vector3f scaledWidthVector, Vector3f scaledHeightVector, Point3f pointTip) {
        int i = 4;
        while (--i >= 0) {
            Point3f corner = this.corners[i];
            corner.set(pointCorner);
            if ((i & 1) != 0) {
                corner.add(scaledWidthVector);
            }
            if ((i & 2) != 0) {
                corner.add(scaledHeightVector);
            }
            this.viewer.transformPoint(corner, this.screenCorners[i]);
        }
        this.corners[4].set(pointTip);
        this.viewer.transformPoint(pointTip, this.screenCorners[4]);
        this.corners[5].add(pointTip, scaledHeightVector);
        this.viewer.transformPoint(this.corners[5], this.screenCorners[5]);
    }

    void drawBox(Point3f pointA, Point3f pointB) {
        Sheet sheet = (Sheet)this.proteinstructurePending;
        float scale = (float)this.madPending / 1000.0f;
        this.scaledWidthVector.set(sheet.getWidthUnitVector());
        this.scaledWidthVector.scale(scale);
        this.scaledHeightVector.set(sheet.getHeightUnitVector());
        this.scaledHeightVector.scale(scale / 4.0f);
        this.pointCorner.add(this.scaledWidthVector, this.scaledHeightVector);
        this.pointCorner.scaleAdd(-0.5f, pointA);
        this.lengthVector.sub(pointB, pointA);
        this.buildBox(this.pointCorner, this.scaledWidthVector, this.scaledHeightVector, this.lengthVector);
        for (int i = 0; i < 6; ++i) {
            byte i0 = boxFaces[i * 4];
            byte i1 = boxFaces[i * 4 + 1];
            byte i2 = boxFaces[i * 4 + 2];
            byte i3 = boxFaces[i * 4 + 3];
            this.g3d.fillQuadrilateral(this.colixPending, this.screenCorners[i0], this.screenCorners[i1], this.screenCorners[i2], this.screenCorners[i3]);
        }
    }

    void drawArrowHeadBox(Point3f base, Point3f tip) {
        Sheet sheet = (Sheet)this.proteinstructurePending;
        float scale = (float)this.madPending / 1000.0f;
        this.scaledWidthVector.set(sheet.getWidthUnitVector());
        this.scaledWidthVector.scale(scale * 1.25f);
        this.scaledHeightVector.set(sheet.getHeightUnitVector());
        this.scaledHeightVector.scale(scale / 3.0f);
        this.pointCorner.add(this.scaledWidthVector, this.scaledHeightVector);
        this.pointCorner.scaleAdd(-0.5f, base);
        this.pointTipOffset.set(this.scaledHeightVector);
        this.pointTipOffset.scaleAdd(-0.5f, tip);
        this.buildArrowHeadBox(this.pointCorner, this.scaledWidthVector, this.scaledHeightVector, this.pointTipOffset);
        this.g3d.fillTriangle(this.colixPending, this.screenCorners[0], this.screenCorners[1], this.screenCorners[4]);
        this.g3d.fillTriangle(this.colixPending, this.screenCorners[2], this.screenCorners[3], this.screenCorners[5]);
        for (int i = 0; i < 12; i += 4) {
            byte i0 = arrowHeadFaces[i];
            byte i1 = arrowHeadFaces[i + 1];
            byte i2 = arrowHeadFaces[i + 2];
            byte i3 = arrowHeadFaces[i + 3];
            this.g3d.fillQuadrilateral(this.colixPending, this.screenCorners[i0], this.screenCorners[i1], this.screenCorners[i2], this.screenCorners[i3]);
        }
    }
}

