/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.text.DecimalFormat;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.vecmath.Matrix3f;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.viewer.Bond;
import org.jmol.viewer.Frame;
import org.jmol.viewer.Viewer;

class StateManager {
    Viewer viewer;
    Hashtable saved = new Hashtable();
    String lastOrientation = "";
    String lastConnections = "";
    String lastSelected = "";
    String lastState = "";
    private DecimalFormat[] formatters;
    private static String[] formattingStrings = new String[]{"0", "0.0", "0.00", "0.000", "0.0000", "0.00000", "0.000000", "0.0000000", "0.00000000", "0.000000000"};

    StateManager(Viewer viewer) {
        this.viewer = viewer;
    }

    GlobalSettings getGlobalSettings() {
        return new GlobalSettings();
    }

    void clear(GlobalSettings global) {
        global.clear();
    }

    void setCrystallographicDefaults() {
        this.viewer.setShapeSize(17, 200);
        this.viewer.setShapeSize(19, -1);
        this.viewer.setAxesModeUnitCell(true);
        this.viewer.setBooleanProperty("perspectiveDepth", false);
    }

    void setCommonDefaults() {
        this.viewer.setBooleanProperty("perspectiveDepth", true);
        this.viewer.setIntProperty("percentVdwAtom", 20);
        this.viewer.setFloatProperty("bondTolerance", 0.45f);
        this.viewer.setFloatProperty("minBondDistance", 0.4f);
        this.viewer.setIntProperty("bondRadiusMilliAngstroms", 150);
    }

    void setJmolDefaults() {
        this.setCommonDefaults();
        this.viewer.setStringProperty("defaultColorScheme", "Jmol");
        this.viewer.setBooleanProperty("axesOrientationRasmol", false);
        this.viewer.setBooleanProperty("zeroBasedXyzRasmol", false);
    }

    void setRasMolDefaults() {
        this.setCommonDefaults();
        this.viewer.setStringProperty("defaultColorScheme", "RasMol");
        this.viewer.setBooleanProperty("axesOrientationRasmol", true);
        this.viewer.setBooleanProperty("zeroBasedXyzRasmol", true);
        this.viewer.setIntProperty("percentVdwAtom", 0);
        this.viewer.setIntProperty("bondRadiusMilliAngstroms", 1);
    }

    String formatDecimal(float value, int decimalDigits) {
        DecimalFormat formatter;
        if (decimalDigits < 0) {
            return "" + value;
        }
        if (this.formatters == null) {
            this.formatters = new DecimalFormat[formattingStrings.length];
        }
        if (decimalDigits >= formattingStrings.length) {
            decimalDigits = formattingStrings.length - 1;
        }
        if ((formatter = this.formatters[decimalDigits]) == null) {
            formatter = this.formatters[decimalDigits] = new DecimalFormat(formattingStrings[decimalDigits]);
        }
        return formatter.format(value);
    }

    String getStandardLabelFormat() {
        int modelCount = this.viewer.getModelCount();
        String strLabel = this.viewer.getChainCount() > modelCount ? "[%n]%r:%c.%a" : (this.viewer.getGroupCount() <= modelCount ? "%e%i" : "[%n]%r.%a");
        if (this.viewer.getModelCount() > 1) {
            strLabel = strLabel + "/%M";
        }
        return strLabel;
    }

    String listSavedStates() {
        String names = "";
        Enumeration e = this.saved.keys();
        while (e.hasMoreElements()) {
            names = names + "\n" + e.nextElement();
        }
        return names;
    }

    void saveSelection(String saveName, BitSet bsSelected) {
        saveName = this.lastSelected = "Selected_" + saveName;
        BitSet bs = (BitSet)bsSelected.clone();
        this.saved.put(saveName, bs);
    }

    boolean restoreSelection(String saveName) {
        String name = saveName.length() > 0 ? "Selected_" + saveName : this.lastSelected;
        BitSet bsSelected = (BitSet)this.saved.get(name);
        if (bsSelected == null) {
            this.viewer.select(new BitSet(), false);
            return false;
        }
        this.viewer.select(bsSelected, false);
        return true;
    }

    void saveState(String saveName) {
        saveName = this.lastState = "State_" + saveName;
        this.saved.put(saveName, this.viewer.getStateInfo());
    }

    String getSavedState(String saveName) {
        String name = saveName.length() > 0 ? "State_" + saveName : this.lastState;
        String script = (String)this.saved.get(name);
        return script == null ? "" : script;
    }

    boolean restoreState(String saveName) {
        String name = saveName.length() > 0 ? "State_" + saveName : this.lastState;
        String script = (String)this.saved.get(name);
        if (script == null) {
            return false;
        }
        this.viewer.script(script + "#----");
        return true;
    }

    void saveOrientation(String saveName) {
        Orientation o = new Orientation();
        o.saveName = this.lastOrientation = "Orientation_" + saveName;
        this.saved.put(o.saveName, o);
    }

    boolean restoreOrientation(String saveName, float timeSeconds) {
        String name = saveName.length() > 0 ? "Orientation_" + saveName : this.lastOrientation;
        Orientation o = (Orientation)this.saved.get(name);
        if (o == null) {
            return false;
        }
        o.restore(timeSeconds);
        return true;
    }

    void saveBonds(String saveName) {
        Connections b = new Connections();
        b.saveName = this.lastConnections = "Bonds_" + saveName;
        this.saved.put(b.saveName, b);
    }

    boolean restoreBonds(String saveName) {
        String name = saveName.length() > 0 ? "Bonds_" + saveName : this.lastConnections;
        Connections c = (Connections)this.saved.get(name);
        if (c == null) {
            return false;
        }
        c.restore();
        return true;
    }

    static String encodeBitset(BitSet bs) {
        if (bs == null) {
            return "({})";
        }
        StringBuffer s = new StringBuffer("({");
        int imax = bs.size();
        int iLast = -1;
        int iFirst = -2;
        int i = -1;
        while (++i <= imax) {
            boolean isSet = bs.get(i);
            if (i == imax || iLast >= 0 && !isSet) {
                if (iLast >= 0 && iFirst != iLast) {
                    s.append((iFirst == iLast - 1 ? " " : ":") + iLast);
                }
                if (i == imax) {
                    s.append("})");
                    return s.toString();
                }
                iLast = -1;
            }
            if (!bs.get(i)) continue;
            if (iLast < 0) {
                s.append((iFirst == -2 ? "" : " ") + i);
                iFirst = i;
            }
            iLast = i;
        }
        return "({})";
    }

    static BitSet decodeBitset(String strBitset) {
        BitSet bs = new BitSet();
        int len = strBitset.length();
        int iPrev = -1;
        int iThis = -2;
        if (len < 3) {
            return bs;
        }
        block4: for (int i = 0; i < len; ++i) {
            char ch = strBitset.charAt(i);
            switch (ch) {
                case ' ': 
                case '{': 
                case '}': {
                    if (iThis < 0) continue block4;
                    if (iPrev < 0) {
                        iPrev = iThis;
                    }
                    for (int j = iPrev; j <= iThis; ++j) {
                        bs.set(j);
                    }
                    iPrev = -1;
                    iThis = -2;
                    continue block4;
                }
                case ':': {
                    iPrev = iThis;
                    iThis = -2;
                    continue block4;
                }
                default: {
                    if (!Character.isDigit(ch)) continue block4;
                    if (iThis < 0) {
                        iThis = 0;
                    }
                    iThis = (iThis << 3) + (iThis << 1) + (ch - 48);
                }
            }
        }
        return bs;
    }

    static String escape(String str) {
        if (str == null) {
            return "\"\"";
        }
        int pt = -2;
        while ((pt = str.indexOf("\"", pt + 2)) >= 0) {
            str = str.substring(0, pt) + '\\' + str.substring(pt);
        }
        return "\"" + str + "\"";
    }

    static String encloseCoord(Tuple3f xyz) {
        return "{" + xyz.x + " " + xyz.y + " " + xyz.z + "}";
    }

    static String encodeColor(int argb) {
        return "[x" + Graphics3D.getHexColorFromRGB(argb) + "]";
    }

    static void setStateInfo(Hashtable ht, int i1, int i2, String key) {
        BitSet bs;
        if (ht.containsKey(key)) {
            bs = (BitSet)ht.get(key);
        } else {
            bs = new BitSet();
            ht.put(key, bs);
        }
        for (int i = i1; i <= i2; ++i) {
            bs.set(i);
        }
    }

    static String getCommands(Hashtable ht) {
        return StateManager.getCommands(ht, null, -1, "select");
    }

    static String getCommands(Hashtable htDefine, Hashtable htMore, int nAll) {
        return StateManager.getCommands(htDefine, htMore, nAll, "select");
    }

    static String getCommands(Hashtable htDefine, Hashtable htMore, int nAll, String selectCmd) {
        StringBuffer s = new StringBuffer();
        String setPrev = StateManager.getCommands(htDefine, s, null, nAll, selectCmd);
        if (htMore != null) {
            StateManager.getCommands(htMore, s, setPrev, nAll, selectCmd);
        }
        return s.toString();
    }

    static String getCommands(Hashtable ht, StringBuffer s, String setPrev, int nAll, String selectCmd) {
        if (ht == null) {
            return "";
        }
        String strAll = "({0:" + (nAll - 1) + "})";
        Enumeration e = ht.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String set = StateManager.encodeBitset((BitSet)ht.get(key));
            if (set.length() == 4) continue;
            if (!set.equals(setPrev)) {
                if (set.equals(strAll)) {
                    s.append(selectCmd);
                    s.append(" *;");
                } else {
                    s.append(selectCmd);
                    s.append(" ");
                    s.append(set);
                    s.append(";\n");
                }
            }
            setPrev = set;
            if (key.indexOf("-") < 0) {
                s.append(key + ";");
            }
            s.append("\n");
        }
        return setPrev;
    }

    class GlobalSettings {
        char inlineNewlineChar = (char)124;
        boolean zeroBasedXyzRasmol = false;
        boolean forceAutoBond = false;
        boolean autoBond = true;
        int percentVdwAtom = 20;
        short marBond = (short)150;
        float bondTolerance = 0.45f;
        float minBondDistance = 0.4f;
        String defaultLoadScript = "";
        String defaultDirectory = null;
        private final Point3f ptDefaultLattice = new Point3f();
        boolean allowCameraMoveFlag = true;
        boolean adjustCameraFlag = true;
        boolean solventOn = false;
        float solventProbeRadius = 1.2f;
        boolean measureAllModels;
        boolean enableFullSceneAntialiasing = false;
        boolean greyscaleRendering = false;
        boolean zoomLarge = true;
        boolean dotsSelectedOnlyFlag = false;
        boolean dotSurfaceFlag = true;
        boolean displayCellParameters = true;
        boolean showHiddenSelectionHalos = false;
        boolean showMeasurements = true;
        boolean frankOn = false;
        boolean bondSelectionModeOr = false;
        boolean showMultipleBonds = true;
        boolean showHydrogens = true;
        boolean ssbondsBackbone = false;
        boolean hbondsBackbone = false;
        boolean hbondsSolid = false;
        byte modeMultipleBond = (byte)2;
        int defaultVectorMad = 0;
        boolean rasmolHydrogenSetting = true;
        boolean rasmolHeteroSetting = true;
        boolean cartoonRocketFlag = false;
        boolean ribbonBorder = false;
        boolean chainCaseSensitive = false;
        boolean rangeSelected = false;
        boolean traceAlpha = true;
        boolean highResolutionFlag = false;
        int ribbonAspectRatio = 16;
        int hermiteLevel = 0;
        float sheetSmoothing = 1.0f;
        boolean hideNameInPopup = false;
        boolean disablePopupMenu = false;
        int argbBackground = -16777216;
        String stereoState = null;
        int axesMode = 0;
        int pickingSpinRate = 10;
        String helpPath = null;
        String defaultHelpPath = "http://www.stolaf.edu/academics/chemapps/jmol/docs/index.htm?search=";
        String propertyStyleString = "";
        boolean debugScript = false;
        boolean testFlag1 = false;
        boolean testFlag2 = false;
        boolean testFlag3 = false;
        boolean testFlag4 = false;
        private String measureDistanceUnits = "nanometers";
        Hashtable htParameterValues = new Hashtable();
        Hashtable htPropertyFlags = new Hashtable();
        static final String volatileProperties = ";selectionhalos;";
        static final String unnecessaryProperties = ";refreshing;defaults;backgroundmodel;backgroundcolor;;stereo;defaultdirectory;percentvdwatom;zerobasedxyzrasmol;;bondradiusmilliangstroms;bondtolerance;minbonddistance;autobond;;debugscript;frank;showaxes;showunitcell;showboundbox;;axeswindow;axesunitcell;axesmolecular;windowcentered;";

        GlobalSettings() {
        }

        String getLoadState() {
            String str = "";
            if (this.defaultDirectory != null) {
                str = str + "set defaultDirectory " + StateManager.escape(this.defaultDirectory) + ";\n";
            }
            str = str + "set autoBond " + this.autoBond + ";\n" + "set forceAutoBond " + this.forceAutoBond + ";\n" + "set zeroBasedXyzRasmol " + this.zeroBasedXyzRasmol + ";\n" + "set percentVdwAtom " + this.percentVdwAtom + ";\n" + "set bondRadiusMilliAngstroms " + this.marBond + ";\n" + "set minBondDistance " + this.minBondDistance + ";\n" + "set bondTolerance " + this.bondTolerance + ";\n";
            if (this.defaultLoadScript.length() > 0) {
                str = str + "set defaultLoadScript " + StateManager.escape(this.defaultLoadScript) + ";\n";
            }
            return str;
        }

        void setDefaultLattice(Point3f ptLattice) {
            this.ptDefaultLattice.set(ptLattice);
        }

        Point3f getDefaultLatticePoint() {
            return this.ptDefaultLattice;
        }

        int[] getDefaultLatticeArray() {
            int[] A = new int[4];
            A[1] = (int)this.ptDefaultLattice.x;
            A[2] = (int)this.ptDefaultLattice.y;
            A[3] = (int)this.ptDefaultLattice.z;
            return A;
        }

        void clear() {
            this.clearVolatileProperties();
        }

        String getWindowState() {
            String str = "# window state (height=" + StateManager.this.viewer.getScreenHeight() + " width=" + StateManager.this.viewer.getScreenWidth() + ")\n";
            str = str + "initialize;\nset refreshing false;\nbackground " + StateManager.encodeColor(this.argbBackground) + ";\n";
            if (this.stereoState != null) {
                str = str + "stereo " + this.stereoState + ";\n";
            }
            return str + "\n";
        }

        boolean setMeasureDistanceUnits(String units) {
            if (units.equalsIgnoreCase("angstroms")) {
                this.measureDistanceUnits = "angstroms";
            } else if (units.equalsIgnoreCase("nanometers") || units.equalsIgnoreCase("nm")) {
                this.measureDistanceUnits = "nanometers";
            } else if (units.equalsIgnoreCase("picometers") || units.equalsIgnoreCase("pm")) {
                this.measureDistanceUnits = "picometers";
            } else {
                return false;
            }
            return true;
        }

        String getMeasureDistanceUnits() {
            return this.measureDistanceUnits;
        }

        void clearVolatileProperties() {
            String key;
            Enumeration e = this.htPropertyFlags.keys();
            while (e.hasMoreElements()) {
                key = (String)e.nextElement();
                if (volatileProperties.indexOf(";" + key + ";") < 0 && key.charAt(0) != '@') continue;
                this.htPropertyFlags.remove(key);
            }
            e = this.htParameterValues.keys();
            while (e.hasMoreElements()) {
                key = (String)e.nextElement();
                if (volatileProperties.indexOf(";" + key + ";") < 0 && key.charAt(0) != '@') continue;
                this.htParameterValues.remove(key);
            }
        }

        void setPropertyFlag(String key, boolean value) {
            key = key.toLowerCase();
            this.htPropertyFlags.put(key, value ? Boolean.TRUE : Boolean.FALSE);
        }

        void setParameterValue(String name, int value) {
            name = name.toLowerCase();
            this.htParameterValues.put(name, new Integer(value));
        }

        void setParameterValue(String name, float value) {
            name = name.toLowerCase();
            this.htParameterValues.put(name, new Float(value));
        }

        void setParameterValue(String name, String value) {
            name = name.toLowerCase();
            this.htParameterValues.put(name, value);
        }

        boolean doRegister(String name) {
            return unnecessaryProperties.indexOf(";" + name + ";") < 0;
        }

        String getState() {
            String key;
            StringBuffer commands = new StringBuffer("# settings:\nset refreshing false;\n");
            Enumeration e = this.htParameterValues.keys();
            while (e.hasMoreElements()) {
                key = (String)e.nextElement();
                if (key.indexOf("default") < 0 || key.charAt(0) == '@' || !this.doRegister(key)) continue;
                commands.append("set " + key + " " + this.htParameterValues.get(key) + ";\n");
            }
            e = this.htPropertyFlags.keys();
            while (e.hasMoreElements()) {
                key = (String)e.nextElement();
                if (!this.doRegister(key)) continue;
                commands.append("set " + key + " " + this.htPropertyFlags.get(key) + ";\n");
            }
            e = this.htParameterValues.keys();
            while (e.hasMoreElements()) {
                key = (String)e.nextElement();
                if (key.indexOf("default") >= 0 || key.charAt(0) == '@' || !this.doRegister(key)) continue;
                Object value = this.htParameterValues.get(key);
                if (key.charAt(0) == '_') {
                    key = key.substring(1);
                } else {
                    key = "set " + key;
                    if (value instanceof String) {
                        value = StateManager.escape((String)value);
                    }
                }
                commands.append(key + " " + value + ";\n");
            }
            switch (this.axesMode) {
                case 2: {
                    commands.append("set axesUnitcell;\n");
                    break;
                }
                case 0: {
                    commands.append("set axesWindow;\n");
                    break;
                }
                default: {
                    commands.append("set axesMolecular;\n");
                }
            }
            e = this.htParameterValues.keys();
            while (e.hasMoreElements()) {
                key = (String)e.nextElement();
                if (key.charAt(0) != '@') continue;
                commands.append(key + " " + this.htParameterValues.get(key) + ";\n");
            }
            commands.append("\n");
            return commands.toString();
        }
    }

    class Connections {
        String saveName;
        int bondCount;
        Connection[] connections;

        Connections() {
            Frame frame = StateManager.this.viewer.getFrame();
            if (frame == null) {
                return;
            }
            this.bondCount = frame.bondCount;
            this.connections = new Connection[this.bondCount + 1];
            Bond[] bonds = frame.bonds;
            int i = this.bondCount;
            while (--i >= 0) {
                Bond b = bonds[i];
                this.connections[i] = new Connection(b.atom1.atomIndex, b.atom2.atomIndex, b.mad, b.colix, b.order, b.shapeVisibilityFlags);
            }
        }

        void restore() {
            Frame frame = StateManager.this.viewer.getFrame();
            if (frame == null) {
                return;
            }
            frame.deleteAllBonds();
            int i = this.bondCount;
            while (--i >= 0) {
                Connection c = this.connections[i];
                if (c.atomIndex1 >= frame.atomCount || c.atomIndex2 >= frame.atomCount) continue;
                Bond b = frame.bondAtoms(frame.atoms[c.atomIndex1], frame.atoms[c.atomIndex2], c.order, c.mad);
                b.shapeVisibilityFlags = c.shapeVisibilityFlags;
            }
            StateManager.this.viewer.setShapeProperty(1, "reportAll", null);
        }

        class Connection {
            int atomIndex1;
            int atomIndex2;
            short mad;
            short colix;
            short order;
            int shapeVisibilityFlags;

            Connection(int atom1, int atom2, short mad, short colix, short order, int shapeVisibilityFlags) {
                this.atomIndex1 = atom1;
                this.atomIndex2 = atom2;
                this.mad = mad;
                this.colix = colix;
                this.order = order;
                this.shapeVisibilityFlags = shapeVisibilityFlags;
            }
        }
    }

    class Orientation {
        String saveName;
        Matrix3f rotationMatrix = new Matrix3f();
        float xTrans;
        float yTrans;
        float zoom;
        float rotationRadius;
        Point3f center = new Point3f();
        boolean windowCenteredFlag;

        Orientation() {
            StateManager.this.viewer.getRotation(this.rotationMatrix);
            this.xTrans = StateManager.this.viewer.getTranslationXPercent();
            this.yTrans = StateManager.this.viewer.getTranslationYPercent();
            this.zoom = StateManager.this.viewer.getZoomPercentFloat();
            this.center.set(StateManager.this.viewer.getRotationCenter());
            this.windowCenteredFlag = StateManager.this.viewer.isWindowCentered();
            this.rotationRadius = StateManager.this.viewer.getRotationRadius();
        }

        void restore(float timeSeconds) {
            StateManager.this.viewer.setBooleanProperty("windowCentered", this.windowCenteredFlag);
            StateManager.this.viewer.moveTo(timeSeconds, this.rotationMatrix, this.center, this.zoom, this.xTrans, this.yTrans, this.rotationRadius);
        }
    }
}

