/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.jmol.adapter.smarter.SmarterJmolAdapter;
import org.jmol.api.JmolStatusListener;
import org.jmol.api.JmolViewer;
import org.jmol.i18n.GT;
import org.jmol.popup.JmolPopup;
import org.openscience.jmol.app.AboutDialog;
import org.openscience.jmol.app.AtomSetChooser;
import org.openscience.jmol.app.ConsoleTextArea;
import org.openscience.jmol.app.DisplayPanel;
import org.openscience.jmol.app.FileChooser;
import org.openscience.jmol.app.FileDropper;
import org.openscience.jmol.app.FilePreview;
import org.openscience.jmol.app.FileTyper;
import org.openscience.jmol.app.GuiMap;
import org.openscience.jmol.app.HelpDialog;
import org.openscience.jmol.app.HistoryFile;
import org.openscience.jmol.app.ImageCreator;
import org.openscience.jmol.app.ImageSelection;
import org.openscience.jmol.app.ImageTyper;
import org.openscience.jmol.app.JmolResourceHandler;
import org.openscience.jmol.app.MeasurementTable;
import org.openscience.jmol.app.PovrayDialog;
import org.openscience.jmol.app.PreferencesDialog;
import org.openscience.jmol.app.RecentFilesDialog;
import org.openscience.jmol.app.ScriptWindow;
import org.openscience.jmol.app.Splash;
import org.openscience.jmol.app.StatusBar;
import org.openscience.jmol.app.WhatsNewDialog;

public class Jmol
extends JPanel {
    public JmolViewer viewer;
    DisplayPanel display;
    StatusBar status;
    private PreferencesDialog preferencesDialog;
    MeasurementTable measurementTable;
    RecentFilesDialog recentFiles;
    public ScriptWindow scriptWindow;
    public AtomSetChooser atomSetChooser;
    private ExecuteScriptAction executeScriptAction;
    protected JFrame frame;
    protected static File currentDir;
    FileChooser openChooser;
    private JFileChooser saveChooser;
    private FileTyper fileTyper;
    JFileChooser exportChooser;
    JmolPopup jmolpopup;
    private GuiMap guimap = new GuiMap();
    private static int numWindows;
    private static Dimension screenSize;
    int startupWidth;
    int startupHeight;
    PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private static final String JMOL_WINDOW_NAME = "Jmol";
    private static final String CONSOLE_WINDOW_NAME = "Console";
    private static final String SCRIPT_WINDOW_NAME = "Script";
    private static final String FILE_OPEN_WINDOW_NAME = "FileOpen";
    File currentFile;
    static AbstractButton buttonRotate;
    static ButtonGroup toolbarButtonGroup;
    static File UserPropsFile;
    static HistoryFile historyFile;
    Splash splash;
    static JFrame consoleframe;
    static Boolean isSilent;
    static Boolean haveConsole;
    static Boolean haveDisplay;
    private Hashtable commands;
    private Hashtable menuItems;
    private JMenuBar menubar;
    private JToolBar toolbar;
    private static final String newwinAction = "newwin";
    private static final String openAction = "open";
    private static final String openurlAction = "openurl";
    private static final String newAction = "new";
    private static final String exportActionProperty = "export";
    private static final String closeAction = "close";
    private static final String exitAction = "exit";
    private static final String aboutAction = "about";
    private static final String whatsnewAction = "whatsnew";
    private static final String uguideAction = "uguide";
    private static final String printActionProperty = "print";
    private static final String recentFilesAction = "recentFiles";
    private static final String povrayActionProperty = "povray";
    private static final String pdfActionProperty = "pdf";
    private static final String scriptAction = "script";
    private static final String atomsetchooserAction = "atomsetchooser";
    private static final String copyImageActionProperty = "copyImage";
    private static final String pasteClipboardActionProperty = "pasteClipboard";
    private ExportAction exportAction = new ExportAction();
    private PovrayAction povrayAction = new PovrayAction();
    private PdfAction pdfAction = new PdfAction();
    private PrintAction printAction = new PrintAction();
    private CopyImageAction copyImageAction = new CopyImageAction();
    private PasteClipboardAction pasteClipboardAction = new PasteClipboardAction();
    private ViewMeasurementTableAction viewMeasurementTableAction = new ViewMeasurementTableAction();
    private Action[] defaultActions = new Action[]{new NewAction(), new NewwinAction(), new OpenAction(), new OpenUrlAction(), this.printAction, this.exportAction, new CloseAction(), new ExitAction(), this.copyImageAction, this.pasteClipboardAction, new AboutAction(), new WhatsNewAction(), new UguideAction(), new ConsoleAction(), new RecentFilesAction(), this.povrayAction, this.pdfAction, new ScriptWindowAction(), new AtomSetChooserAction(), this.viewMeasurementTableAction};
    public static final String chemFileProperty = "chemFile";

    public static HistoryFile getHistoryFile() {
        return historyFile;
    }

    Jmol(Splash splash, JFrame frame, Jmol parent, int startupWidth, int startupHeight, String commandOptions) {
        super(true);
        SmarterJmolAdapter modelAdapter;
        this.frame = frame;
        this.startupWidth = startupWidth;
        this.startupHeight = startupHeight;
        ++numWindows;
        frame.setTitle(JMOL_WINDOW_NAME);
        frame.setBackground(Color.lightGray);
        frame.getContentPane().setLayout(new BorderLayout());
        this.splash = splash;
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setLayout(new BorderLayout());
        this.status = (StatusBar)this.createStatusBar();
        this.say(GT._("Initializing 3D display..."));
        this.display = new DisplayPanel(this.status, this.guimap, haveDisplay, startupWidth, startupHeight);
        String adapter = System.getProperty("model");
        if (adapter == null || adapter.length() == 0) {
            adapter = "smarter";
        }
        if (adapter.equals("smarter")) {
            Jmol.report("using Smarter Model Adapter");
            modelAdapter = new SmarterJmolAdapter(null);
        } else if (adapter.equals("cdk")) {
            Jmol.report("the CDK Model Adapter is currently no longer supported. Check out http://bioclipse.net/. -- using Smarter");
            modelAdapter = new SmarterJmolAdapter(null);
        } else {
            Jmol.report("unrecognized model adapter:" + adapter + " -- using Smarter");
            modelAdapter = new SmarterJmolAdapter(null);
        }
        this.viewer = JmolViewer.allocateViewer(this.display, modelAdapter);
        this.viewer.setAppletContext("", null, null, commandOptions);
        this.display.setViewer(this.viewer);
        this.say(GT._("Initializing Preferences..."));
        this.preferencesDialog = new PreferencesDialog(frame, this.guimap, this.viewer);
        this.say(GT._("Initializing Recent Files..."));
        this.recentFiles = new RecentFilesDialog(frame);
        this.say(GT._("Initializing Script Window..."));
        this.scriptWindow = new ScriptWindow(this.viewer, frame);
        this.say(GT._("Initializing AtomSetChooser Window..."));
        if (haveDisplay.booleanValue()) {
            this.atomSetChooser = new AtomSetChooser(this.viewer, frame);
        }
        MyStatusListener myStatusListener = new MyStatusListener();
        this.viewer.setJmolStatusListener(myStatusListener);
        this.say(GT._("Initializing Measurements..."));
        this.measurementTable = new MeasurementTable(this.viewer, frame);
        this.say(GT._("Building Command Hooks..."));
        this.commands = new Hashtable();
        Action[] actions = this.getActions();
        for (int i = 0; i < actions.length; ++i) {
            Action a = actions[i];
            this.commands.put(a.getValue("Name"), a);
        }
        this.menuItems = new Hashtable();
        this.say(GT._("Building Menubar..."));
        this.executeScriptAction = new ExecuteScriptAction();
        this.menubar = this.createMenubar();
        this.add("North", this.menubar);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add("North", this.createToolbar());
        JPanel ip = new JPanel();
        ip.setLayout(new BorderLayout());
        ip.add("Center", this.display);
        panel.add("Center", ip);
        this.add("Center", panel);
        this.add("South", this.status);
        this.say(GT._("Starting display..."));
        this.display.start();
        if (haveDisplay.booleanValue()) {
            this.say(GT._("Setting up File Choosers..."));
            this.openChooser = new FileChooser();
            this.openChooser.setCurrentDirectory(currentDir);
            String previewProperty = System.getProperty("openFilePreview", "true");
            if (Boolean.valueOf(previewProperty).booleanValue()) {
                new FilePreview(this.openChooser, modelAdapter);
            }
            this.saveChooser = new JFileChooser();
            this.fileTyper = new FileTyper();
            this.saveChooser.addPropertyChangeListener(this.fileTyper);
            this.saveChooser.setAccessory(this.fileTyper);
            this.saveChooser.setCurrentDirectory(currentDir);
            this.exportChooser = new JFileChooser();
            this.exportChooser.setCurrentDirectory(currentDir);
            this.pcs.addPropertyChangeListener(chemFileProperty, this.exportAction);
            this.pcs.addPropertyChangeListener(chemFileProperty, this.povrayAction);
            this.pcs.addPropertyChangeListener(chemFileProperty, this.pdfAction);
            this.pcs.addPropertyChangeListener(chemFileProperty, this.printAction);
            this.pcs.addPropertyChangeListener(chemFileProperty, this.viewMeasurementTableAction);
            this.pcs.addPropertyChangeListener(chemFileProperty, this.atomSetChooser);
            this.jmolpopup = JmolPopup.newJmolPopup(this.viewer);
        }
        if (parent != null) {
            Point location = parent.frame.getLocationOnScreen();
            int maxX = Jmol.screenSize.width - 50;
            int maxY = Jmol.screenSize.height - 50;
            location.x += 40;
            location.y += 40;
            if (location.x > maxX || location.y > maxY) {
                location.setLocation(0, 0);
            }
            frame.setLocation(location);
        }
        frame.getContentPane().add("Center", this);
        frame.addWindowListener(new AppCloser());
        frame.pack();
        frame.setSize(startupWidth, startupHeight);
        ImageIcon jmolIcon = JmolResourceHandler.getIconX("icon");
        Image iconImage = jmolIcon.getImage();
        frame.setIconImage(iconImage);
        if (haveDisplay.booleanValue()) {
            historyFile.repositionWindow(SCRIPT_WINDOW_NAME, this.scriptWindow);
        }
        this.say(GT._("Setting up Drag-and-Drop..."));
        FileDropper dropper = new FileDropper();
        final JFrame f = frame;
        dropper.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                f.setCursor(Cursor.getPredefinedCursor(3));
                if (evt.getPropertyName().equals("filename")) {
                    String filename = evt.getNewValue().toString();
                    Jmol.this.viewer.openFile(filename);
                    Jmol.this.viewer.getOpenFileError();
                } else if (evt.getPropertyName().equals("inline")) {
                    String inline = evt.getNewValue().toString();
                    Jmol.this.viewer.openStringInline(inline);
                }
                f.setCursor(Cursor.getDefaultCursor());
            }
        });
        this.setDropTarget(new DropTarget(this, dropper));
        this.setEnabled(true);
        this.say(GT._("Launching main frame..."));
    }

    static void report(String str) {
        if (isSilent.booleanValue()) {
            return;
        }
        System.out.println(str);
    }

    public static Jmol getJmol(JFrame frame, int startupWidth, int startupHeight, String commandOptions) {
        Splash splash = null;
        if (haveDisplay.booleanValue()) {
            ImageIcon splash_image = JmolResourceHandler.getIconX("splash");
            Jmol.report("splash_image=" + splash_image);
            splash = new Splash(frame, splash_image);
            splash.setCursor(new Cursor(3));
            splash.showStatus(GT._("Creating main window..."));
            splash.showStatus(GT._("Initializing Swing..."));
        }
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        }
        catch (Exception exc) {
            System.err.println("Error loading L&F: " + exc);
        }
        screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        if (splash != null) {
            splash.showStatus(GT._("Initializing Jmol..."));
        }
        currentDir = Jmol.getUserDirectory();
        Jmol window = new Jmol(splash, frame, null, startupWidth, startupHeight, commandOptions);
        if (haveDisplay.booleanValue()) {
            frame.show();
        }
        return window;
    }

    public static void main(String[] args) {
        Dimension size;
        Jmol jmol = null;
        String modelFilename = null;
        String scriptFilename = null;
        Options options = new Options();
        options.addOption("h", "help", false, GT._("give this help page"));
        options.addOption("n", "nodisplay", false, GT._("no display (and also exit when done)"));
        options.addOption("i", "silent", false, GT._("silent startup operation"));
        options.addOption("o", "noconsole", false, GT._("no console -- all output to sysout"));
        options.addOption("x", exitAction, false, GT._("exit after script (implicit with -n)"));
        OptionBuilder.withLongOpt(scriptAction);
        OptionBuilder.withDescription("script file to execute");
        OptionBuilder.withValueSeparator('=');
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create("s"));
        OptionBuilder.withArgName(GT._("property=value"));
        OptionBuilder.hasArg();
        OptionBuilder.withValueSeparator();
        OptionBuilder.withDescription(GT._("supported options are given below"));
        options.addOption(OptionBuilder.create("D"));
        OptionBuilder.withLongOpt("geometry");
        OptionBuilder.withDescription(GT._("window size, e.g. {0}", "-g500x500"));
        OptionBuilder.withValueSeparator();
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create("g"));
        OptionBuilder.withLongOpt("write");
        OptionBuilder.withDescription(GT._("{0} or {1}:filename", new Object[]{"CLIP", "JPG|JPG64|PNG|PPM"}));
        OptionBuilder.withValueSeparator();
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create("w"));
        int startupWidth = 0;
        int startupHeight = 0;
        CommandLine line = null;
        try {
            PosixParser parser = new PosixParser();
            line = parser.parse(options, args);
        }
        catch (ParseException exception) {
            System.err.println("Unexpected exception: " + exception.toString());
        }
        if (line.hasOption("h")) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp(JMOL_WINDOW_NAME, options);
            System.out.println();
            System.out.println(GT._("For example:"));
            System.out.println();
            System.out.println("Jmol -ions myscript.spt -w JPEG:myfile.jpg > output.txt");
            System.out.println();
            System.out.println(GT._("The -D options are as follows (defaults in parathesis):"));
            System.out.println();
            System.out.println("  cdk.debugging=[true|false] (false)");
            System.out.println("  cdk.debug.stdout=[true|false] (false)");
            System.out.println("  display.speed=[fps|ms] (ms)");
            System.out.println("  JmolConsole=[true|false] (true)");
            System.out.println("  jmol.logger.debug=[true|false] (false)");
            System.out.println("  jmol.logger.error=[true|false] (true)");
            System.out.println("  jmol.logger.fatal=[true|false] (true)");
            System.out.println("  jmol.logger.info=[true|false] (true)");
            System.out.println("  jmol.logger.logLevel=[true|false] (false)");
            System.out.println("  jmol.logger.warn=[true|false] (true)");
            System.out.println("  plugin.dir (unset)");
            System.out.println("  user.language=[DE|EN|ES|FR|NL|PL|TR] (EN)");
            System.exit(0);
        }
        if ((args = line.getArgs()).length > 0) {
            modelFilename = args[0];
        }
        String commandOptions = "";
        if (line.hasOption("i")) {
            commandOptions = commandOptions + "-i";
            isSilent = Boolean.TRUE;
        }
        if (line.hasOption("o")) {
            commandOptions = commandOptions + "-o";
            haveConsole = Boolean.FALSE;
        }
        if (line.hasOption("n")) {
            commandOptions = commandOptions + "-n-x";
            haveDisplay = Boolean.FALSE;
        }
        if (line.hasOption("s")) {
            commandOptions = commandOptions + "-s";
            scriptFilename = line.getOptionValue("s");
        } else if (line.hasOption("n")) {
            System.out.println("?Que? ?-n pero no -s?");
            System.exit(1);
        }
        if (line.hasOption("x")) {
            commandOptions = commandOptions + "-x";
        }
        if (line.hasOption("w")) {
            String type_name = line.getOptionValue("w");
            commandOptions = commandOptions + "-w\u0001" + type_name + "\u0001";
        }
        try {
            String geometry;
            int indexX;
            String vers = System.getProperty("java.version");
            if (vers.compareTo("1.1.2") < 0) {
                System.out.println("!!!WARNING: Swing components require a 1.1.2 or higher version VM!!!");
            }
            if ((size = historyFile.getWindowSize(JMOL_WINDOW_NAME)) != null && haveDisplay.booleanValue()) {
                startupWidth = size.width;
                startupHeight = size.height;
            }
            if (line.hasOption("g") && haveDisplay.booleanValue() && (indexX = (geometry = line.getOptionValue("g")).indexOf(120)) > 0) {
                startupWidth = Jmol.parseInt(geometry.substring(0, indexX));
                startupHeight = Jmol.parseInt(geometry.substring(indexX + 1));
            }
            if (startupWidth <= 0 || startupHeight <= 0) {
                startupWidth = 500;
                startupHeight = 550;
            }
            JFrame jmolFrame = new JFrame();
            Point jmolPosition = historyFile.getWindowPosition(JMOL_WINDOW_NAME);
            if (jmolPosition != null) {
                jmolFrame.setLocation(jmolPosition);
            }
            jmol = Jmol.getJmol(jmolFrame, startupWidth, startupHeight, commandOptions);
            if (modelFilename != null) {
                jmol.viewer.openFile(modelFilename);
                jmol.viewer.getOpenFileError();
            }
            if (scriptFilename != null) {
                Jmol.report("Executing script: " + scriptFilename);
                if (haveDisplay.booleanValue()) {
                    jmol.splash.showStatus(GT._("Executing script..."));
                }
                jmol.viewer.evalFile(scriptFilename);
            }
        }
        catch (Throwable t) {
            System.out.println("uncaught exception: " + t);
            t.printStackTrace();
        }
        if (haveConsole.booleanValue()) {
            Point location = jmol.frame.getLocation();
            size = jmol.frame.getSize();
            consoleframe = new JFrame(GT._("Jmol Java Console"));
            consoleframe.setIconImage(jmol.frame.getIconImage());
            try {
                final ConsoleTextArea consoleTextArea = new ConsoleTextArea();
                consoleTextArea.setFont(Font.decode("monospaced"));
                consoleframe.getContentPane().add((Component)new JScrollPane(consoleTextArea), "Center");
                if (Boolean.getBoolean("clearConsoleButton")) {
                    JButton buttonClear = new JButton(GT._("Clear"));
                    buttonClear.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            consoleTextArea.setText("");
                        }
                    });
                    consoleframe.getContentPane().add((Component)buttonClear, "South");
                }
            }
            catch (IOException e) {
                JTextArea errorTextArea = new JTextArea();
                errorTextArea.setFont(Font.decode("monospaced"));
                consoleframe.getContentPane().add((Component)new JScrollPane(errorTextArea), "Center");
                errorTextArea.append(GT._("Could not create ConsoleTextArea: ") + e);
            }
            Dimension consoleSize = historyFile.getWindowSize(CONSOLE_WINDOW_NAME);
            Point consolePosition = historyFile.getWindowPosition(CONSOLE_WINDOW_NAME);
            if (consoleSize != null && consolePosition != null) {
                consoleframe.setBounds(consolePosition.x, consolePosition.y, consoleSize.width, consoleSize.height);
            } else {
                consoleframe.setBounds(location.x, location.y + size.height, size.width, 200);
            }
            Boolean consoleVisible = historyFile.getWindowVisibility(CONSOLE_WINDOW_NAME);
            if (consoleVisible != null && consoleVisible.equals(Boolean.TRUE)) {
                consoleframe.show();
            }
        }
    }

    static int parseInt(String str) {
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException nfe) {
            return Integer.MIN_VALUE;
        }
    }

    private void say(String message) {
        if (haveDisplay.booleanValue()) {
            if (this.splash == null) {
                Jmol.report(message);
            } else {
                this.splash.showStatus(message);
            }
        }
    }

    public Action[] getActions() {
        ArrayList<Action> actions = new ArrayList<Action>();
        actions.addAll(Arrays.asList(this.defaultActions));
        actions.addAll(Arrays.asList(this.display.getActions()));
        actions.addAll(Arrays.asList(this.preferencesDialog.getActions()));
        return actions.toArray(new Action[0]);
    }

    void doClose() {
        if (historyFile != null) {
            historyFile.addWindowInfo(JMOL_WINDOW_NAME, this.frame);
            historyFile.addWindowInfo(SCRIPT_WINDOW_NAME, this.scriptWindow);
        }
        if (--numWindows <= 1) {
            Jmol.report(GT._("Closing Jmol..."));
            System.exit(0);
        } else {
            this.frame.dispose();
        }
    }

    protected Frame getFrame() {
        for (Container p = this.getParent(); p != null; p = p.getParent()) {
            if (!(p instanceof Frame)) continue;
            return (Frame)p;
        }
        return null;
    }

    protected JMenuItem createMenuItem(String cmd) {
        JMenuItem mi = cmd.endsWith("Check") ? this.guimap.newJCheckBoxMenuItem(cmd, false) : this.guimap.newJMenuItem(cmd);
        ImageIcon f = JmolResourceHandler.getIconX(cmd + "Image");
        if (f != null) {
            mi.setHorizontalTextPosition(4);
            mi.setIcon(f);
        }
        if (cmd.endsWith(SCRIPT_WINDOW_NAME)) {
            mi.setActionCommand(JmolResourceHandler.getStringX(cmd));
            mi.addActionListener(this.executeScriptAction);
        } else {
            mi.setActionCommand(cmd);
            Action a = this.getAction(cmd);
            if (a != null) {
                mi.addActionListener(a);
                a.addPropertyChangeListener(new ActionChangedListener(mi));
                mi.setEnabled(a.isEnabled());
            } else {
                mi.setEnabled(false);
            }
        }
        this.menuItems.put(cmd, mi);
        return mi;
    }

    protected JMenuItem getMenuItem(String cmd) {
        return (JMenuItem)this.menuItems.get(cmd);
    }

    protected Action getAction(String cmd) {
        return (Action)this.commands.get(cmd);
    }

    private Component createToolbar() {
        this.toolbar = new JToolBar();
        String[] tool1Keys = this.tokenize(JmolResourceHandler.getStringX("toolbar"));
        for (int i = 0; i < tool1Keys.length; ++i) {
            if (tool1Keys[i].equals("-")) {
                this.toolbar.addSeparator();
                continue;
            }
            this.toolbar.add(this.createTool(tool1Keys[i]));
        }
        this.toolbar.add(Box.createHorizontalGlue());
        return this.toolbar;
    }

    protected Component createTool(String key) {
        return this.createToolbarButton(key);
    }

    protected AbstractButton createToolbarButton(String key) {
        boolean isToggle;
        ImageIcon ii = JmolResourceHandler.getIconX(key + "Image");
        AbstractButton b = new JButton(ii);
        String isToggleString = JmolResourceHandler.getStringX(key + "Toggle");
        if (isToggleString != null && (isToggle = Boolean.valueOf(isToggleString).booleanValue())) {
            b = new JToggleButton(ii);
            if (key.equals("rotate")) {
                buttonRotate = b;
            }
            toolbarButtonGroup.add(b);
            String isSelectedString = JmolResourceHandler.getStringX(key + "ToggleSelected");
            if (isSelectedString != null) {
                boolean isSelected = Boolean.valueOf(isSelectedString);
                b.setSelected(isSelected);
            }
        }
        b.setRequestFocusEnabled(false);
        b.setMargin(new Insets(1, 1, 1, 1));
        Action a = null;
        String actionCommand = null;
        if (key.endsWith(SCRIPT_WINDOW_NAME)) {
            actionCommand = JmolResourceHandler.getStringX(key);
            a = this.executeScriptAction;
        } else {
            actionCommand = key;
            a = this.getAction(key);
        }
        if (a != null) {
            b.setActionCommand(actionCommand);
            b.addActionListener(a);
            a.addPropertyChangeListener(new ActionChangedListener(b));
            b.setEnabled(a.isEnabled());
        } else {
            b.setEnabled(false);
        }
        String tip = this.guimap.getLabel(key + "Tip");
        if (tip != null) {
            b.setToolTipText(tip);
        }
        return b;
    }

    public static void setRotateButton() {
        if (buttonRotate != null) {
            buttonRotate.setSelected(true);
        }
    }

    protected String[] tokenize(String input) {
        Vector<String> v = new Vector<String>();
        StringTokenizer t = new StringTokenizer(input);
        while (t.hasMoreTokens()) {
            v.addElement(t.nextToken());
        }
        String[] cmd = new String[v.size()];
        for (int i = 0; i < cmd.length; ++i) {
            cmd[i] = (String)v.elementAt(i);
        }
        return cmd;
    }

    protected Component createStatusBar() {
        return new StatusBar();
    }

    protected JMenuBar createMenubar() {
        JMenuBar mb = new JMenuBar();
        this.addNormalMenuBar(mb);
        this.addMacrosMenuBar(mb);
        mb.add(Box.createHorizontalGlue());
        this.addHelpMenuBar(mb);
        return mb;
    }

    protected void addMacrosMenuBar(JMenuBar menuBar) {
        JMenu macroMenu = new JMenu(GT._("Macros"));
        File macroDir = new File(System.getProperty("user.home") + System.getProperty("file.separator") + ".jmol" + System.getProperty("file.separator") + "macros");
        Jmol.report("User macros dir: " + macroDir);
        Jmol.report("       exists: " + macroDir.exists());
        Jmol.report("  isDirectory: " + macroDir.isDirectory());
        if (macroDir.exists() && macroDir.isDirectory()) {
            File[] macros = macroDir.listFiles();
            for (int i = 0; i < macros.length; ++i) {
                String macroName = macros[i].getName();
                if (!macroName.endsWith(".macro")) continue;
                System.out.println("Possible macro found: " + macroName);
                try {
                    FileInputStream macro = new FileInputStream(macros[i]);
                    Properties macroProps = new Properties();
                    macroProps.load(macro);
                    String macroTitle = macroProps.getProperty("Title");
                    String macroScript = macroProps.getProperty(SCRIPT_WINDOW_NAME);
                    JMenuItem mi = new JMenuItem(macroTitle);
                    mi.setActionCommand(macroScript);
                    mi.addActionListener(this.executeScriptAction);
                    macroMenu.add(mi);
                    continue;
                }
                catch (IOException exception) {
                    System.err.println("Could not load macro file: ");
                    System.err.println(exception);
                }
            }
        }
        menuBar.add(macroMenu);
    }

    protected void addNormalMenuBar(JMenuBar menuBar) {
        String[] menuKeys = this.tokenize(JmolResourceHandler.getStringX("menubar"));
        for (int i = 0; i < menuKeys.length; ++i) {
            if (menuKeys[i].equals("-")) {
                menuBar.add(Box.createHorizontalGlue());
                continue;
            }
            JMenu m = this.createMenu(menuKeys[i]);
            if (m == null) continue;
            menuBar.add(m);
        }
    }

    protected void addHelpMenuBar(JMenuBar menuBar) {
        String menuKey = "help";
        JMenu m = this.createMenu(menuKey);
        if (m != null) {
            menuBar.add(m);
        }
    }

    protected JMenu createMenu(String key) {
        String[] itemKeys = this.tokenize(JmolResourceHandler.getStringX(key));
        JMenu menu = this.guimap.newJMenu(key);
        for (int i = 0; i < itemKeys.length; ++i) {
            String item = itemKeys[i];
            if (item.equals("-")) {
                menu.addSeparator();
                continue;
            }
            if (item.endsWith("Menu")) {
                JMenu pm = "recentFilesMenu".equals(item) ? this.createMenu(item) : this.createMenu(item);
                menu.add(pm);
                continue;
            }
            JMenuItem mi = this.createMenuItem(item);
            menu.add(mi);
        }
        menu.addMenuListener(this.display.getMenuListener());
        return menu;
    }

    public void print() {
        PrinterJob job = PrinterJob.getPrinterJob();
        job.setPrintable(this.display);
        if (job.printDialog()) {
            try {
                job.print();
            }
            catch (PrinterException e) {
                System.out.println("" + e);
            }
        }
    }

    public static File getUserDirectory() {
        if (System.getProperty("user.dir") == null) {
            return null;
        }
        return new File(System.getProperty("user.dir"));
    }

    static {
        numWindows = 0;
        screenSize = null;
        buttonRotate = null;
        toolbarButtonGroup = new ButtonGroup();
        if (System.getProperty("javawebstart.version") != null) {
            System.setSecurityManager(null);
        }
        if (System.getProperty("user.home") == null) {
            System.err.println(GT._("Error starting Jmol: the property 'user.home' is not defined."));
            System.exit(1);
        }
        File ujmoldir = new File(new File(System.getProperty("user.home")), ".jmol");
        ujmoldir.mkdirs();
        UserPropsFile = new File(ujmoldir, "properties");
        historyFile = new HistoryFile(new File(ujmoldir, "history"), "Jmol's persistent values");
        isSilent = Boolean.FALSE;
        haveConsole = Boolean.TRUE;
        haveDisplay = Boolean.TRUE;
    }

    class ExecuteScriptAction
    extends AbstractAction {
        public ExecuteScriptAction() {
            super("executeScriptAction");
        }

        public void actionPerformed(ActionEvent e) {
            Jmol.this.viewer.evalStringQuiet(e.getActionCommand());
        }
    }

    class MyStatusListener
    implements JmolStatusListener {
        MyStatusListener() {
        }

        public void createImage(String file, String type, int quality) {
            ImageCreator c = new ImageCreator(Jmol.this.viewer, Jmol.this.status);
            c.createImage(file, type, quality);
        }

        public void setCallbackFunction(String callbackType, String callbackFunction) {
        }

        public void notifyFileLoaded(String fullPathName, String fileName, String modelName, Object clientFile, String errorMsg) {
            if (errorMsg != null) {
                return;
            }
            if (!haveDisplay.booleanValue()) {
                return;
            }
            if (fullPathName == null) {
                return;
            }
            String title = Jmol.JMOL_WINDOW_NAME;
            if (modelName != null && fileName != null) {
                title = fileName + " - " + modelName;
            } else if (fileName != null) {
                title = fileName;
            } else if (modelName != null) {
                title = modelName;
            }
            Jmol.this.frame.setTitle(title);
            Jmol.this.recentFiles.notifyFileOpen(fullPathName);
            if (haveDisplay.booleanValue()) {
                Jmol.this.pcs.firePropertyChange(Jmol.chemFileProperty, null, clientFile);
            }
        }

        public void notifyFrameChanged(int frameNo) {
            boolean isAnimationRunning;
            boolean bl = isAnimationRunning = frameNo <= -2;
            if (Jmol.this.jmolpopup == null || isAnimationRunning) {
                return;
            }
            Jmol.this.jmolpopup.updateComputedMenus();
        }

        public void notifyScriptStart(String statusMessage, String additionalInfo) {
        }

        public void sendConsoleEcho(String strEcho) {
            if (Jmol.this.scriptWindow != null) {
                Jmol.this.scriptWindow.sendConsoleEcho(strEcho);
            }
        }

        public void sendConsoleMessage(String strStatus) {
            if (Jmol.this.scriptWindow != null) {
                Jmol.this.scriptWindow.sendConsoleMessage(strStatus);
            }
        }

        public void notifyScriptTermination(String strStatus, int msWalltime) {
            if (Jmol.this.scriptWindow != null) {
                Jmol.this.scriptWindow.notifyScriptTermination(strStatus, msWalltime);
            }
        }

        public void handlePopupMenu(int x, int y) {
            Jmol.this.jmolpopup.show(x, y);
        }

        public void notifyNewPickingModeMeasurement(int iatom, String strMeasure) {
            this.notifyAtomPicked(iatom, strMeasure);
        }

        public void notifyNewDefaultModeMeasurement(int count, String strInfo) {
            Jmol.this.measurementTable.updateTables();
        }

        public void notifyAtomPicked(int atomIndex, String strInfo) {
            if (Jmol.this.scriptWindow != null) {
                Jmol.this.scriptWindow.sendConsoleMessage(strInfo);
                Jmol.this.scriptWindow.sendConsoleMessage("\n");
            }
        }

        public void notifyAtomHovered(int atomIndex, String strInfo) {
        }

        public void sendSyncScript(String script, String appletName) {
        }

        public void showUrl(String url) {
        }

        public void showConsole(boolean showConsole) {
            if (showConsole) {
                Jmol.this.scriptWindow.show();
            } else {
                Jmol.this.scriptWindow.hide();
            }
        }

        public float functionXY(String functionName, int x, int y) {
            return 0.0f;
        }
    }

    private abstract class MoleculeDependentAction
    extends AbstractAction
    implements PropertyChangeListener {
        public MoleculeDependentAction(String name) {
            super(name);
            this.setEnabled(false);
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getPropertyName().equals(Jmol.chemFileProperty)) {
                if (event.getNewValue() != null) {
                    this.setEnabled(true);
                } else {
                    this.setEnabled(false);
                }
            }
        }
    }

    class ViewMeasurementTableAction
    extends MoleculeDependentAction {
        public ViewMeasurementTableAction() {
            super("viewMeasurementTable");
        }

        public void actionPerformed(ActionEvent e) {
            Jmol.this.measurementTable.activate();
        }
    }

    class PdfAction
    extends MoleculeDependentAction {
        public PdfAction() {
            super(Jmol.pdfActionProperty);
        }

        public void actionPerformed(ActionEvent e) {
            File file;
            Jmol.this.exportChooser.setAccessory(null);
            int retval = Jmol.this.exportChooser.showSaveDialog(Jmol.this);
            if (retval == 0 && (file = Jmol.this.exportChooser.getSelectedFile()) != null) {
                Document document = new Document();
                try {
                    PdfWriter writer = PdfWriter.getInstance(document, new FileOutputStream(file));
                    document.open();
                    int w = Jmol.this.display.getWidth();
                    int h = Jmol.this.display.getHeight();
                    PdfContentByte cb = writer.getDirectContent();
                    PdfTemplate tp = cb.createTemplate(w, h);
                    Graphics2D g2 = tp.createGraphics(w, h);
                    g2.setStroke(new BasicStroke(0.1f));
                    tp.setWidth(w);
                    tp.setHeight(h);
                    Jmol.this.display.print(g2);
                    g2.dispose();
                    cb.addTemplate(tp, 72.0f, 720 - h);
                }
                catch (DocumentException de) {
                    System.err.println(de.getMessage());
                }
                catch (IOException ioe) {
                    System.err.println(ioe.getMessage());
                }
                document.close();
            }
        }
    }

    class PovrayAction
    extends MoleculeDependentAction {
        public PovrayAction() {
            super(Jmol.povrayActionProperty);
        }

        public void actionPerformed(ActionEvent e) {
            if (Jmol.this.currentFile != null) {
                Jmol.this.currentFile.getName().substring(0, Jmol.this.currentFile.getName().lastIndexOf("."));
            }
            new PovrayDialog(Jmol.this.frame, Jmol.this.viewer);
        }
    }

    class AtomSetChooserAction
    extends AbstractAction {
        public AtomSetChooserAction() {
            super(Jmol.atomsetchooserAction);
        }

        public void actionPerformed(ActionEvent e) {
            Jmol.this.atomSetChooser.show();
        }
    }

    class ScriptWindowAction
    extends AbstractAction {
        public ScriptWindowAction() {
            super(Jmol.scriptAction);
        }

        public void actionPerformed(ActionEvent e) {
            Jmol.this.scriptWindow.show();
        }
    }

    class RecentFilesAction
    extends AbstractAction {
        public RecentFilesAction() {
            super(Jmol.recentFilesAction);
        }

        public void actionPerformed(ActionEvent e) {
            Jmol.this.recentFiles.show();
            String selection = Jmol.this.recentFiles.getFile();
            if (selection != null) {
                Jmol.this.viewer.openFile(selection);
                Jmol.this.viewer.getOpenFileError();
            }
        }
    }

    class ExportAction
    extends MoleculeDependentAction {
        ExportAction() {
            super(Jmol.exportActionProperty);
        }

        public void actionPerformed(ActionEvent e) {
            int retval;
            ImageTyper it = new ImageTyper(Jmol.this.exportChooser);
            Jmol.this.exportChooser.setAccessory(it);
            String fileName = Jmol.this.viewer.getModelSetFileName();
            String pathName = Jmol.this.viewer.getModelSetPathName();
            File file = null;
            if (fileName != null && pathName != null) {
                int extensionStart = fileName.lastIndexOf(46);
                if (extensionStart != -1) {
                    fileName = fileName.substring(0, extensionStart) + "." + it.getExtension();
                }
                file = new File(pathName, fileName);
                Jmol.this.exportChooser.setSelectedFile(file);
            }
            if ((retval = Jmol.this.exportChooser.showSaveDialog(Jmol.this)) == 0 && (file = Jmol.this.exportChooser.getSelectedFile()) != null) {
                ImageCreator c = new ImageCreator(Jmol.this.viewer, Jmol.this.status);
                c.createImage(file.getAbsolutePath(), it.getType(), it.getQuality());
            }
        }
    }

    class ExitAction
    extends AbstractAction {
        ExitAction() {
            super(Jmol.exitAction);
        }

        public void actionPerformed(ActionEvent e) {
            Jmol.this.doClose();
        }
    }

    class NewAction
    extends AbstractAction {
        NewAction() {
            super(Jmol.newAction);
        }

        NewAction(String nm) {
            super(nm);
        }

        public void actionPerformed(ActionEvent e) {
            Jmol.this.revalidate();
        }
    }

    class OpenUrlAction
    extends NewAction {
        String title;
        String prompt;

        OpenUrlAction() {
            super(Jmol.openurlAction);
            this.title = GT._("Open URL");
            this.prompt = GT._("Enter URL of molecular model");
        }

        public void actionPerformed(ActionEvent e) {
            String url = JOptionPane.showInputDialog(Jmol.this.frame, this.prompt, this.title, -1);
            if (url != null) {
                if (url.indexOf("://") == -1) {
                    url = "http://" + url;
                }
                Jmol.this.viewer.openFile(url);
                Jmol.this.viewer.getOpenFileError();
            }
        }
    }

    class OpenAction
    extends NewAction {
        OpenAction() {
            super(Jmol.openAction);
        }

        public void actionPerformed(ActionEvent e) {
            Jmol.this.openChooser.setDialogSize(historyFile.getWindowSize(Jmol.FILE_OPEN_WINDOW_NAME));
            Jmol.this.openChooser.setDialogLocation(historyFile.getWindowPosition(Jmol.FILE_OPEN_WINDOW_NAME));
            int retval = Jmol.this.openChooser.showOpenDialog(Jmol.this);
            if (retval == 0) {
                File file = Jmol.this.openChooser.getSelectedFile();
                Jmol.this.viewer.evalStringQuiet("load \"" + file.getAbsolutePath() + "\"");
                return;
            }
            historyFile.addWindowInfo(Jmol.FILE_OPEN_WINDOW_NAME, Jmol.this.openChooser.getDialog());
        }
    }

    class PrintAction
    extends MoleculeDependentAction {
        public PrintAction() {
            super(Jmol.printActionProperty);
        }

        public void actionPerformed(ActionEvent e) {
            Jmol.this.print();
        }
    }

    class CopyImageAction
    extends AbstractAction {
        public CopyImageAction() {
            super(Jmol.copyImageActionProperty);
        }

        public void actionPerformed(ActionEvent e) {
            ImageCreator c = new ImageCreator(Jmol.this.viewer, Jmol.this.status);
            c.clipImage();
        }
    }

    class PasteClipboardAction
    extends AbstractAction {
        public PasteClipboardAction() {
            super(Jmol.pasteClipboardActionProperty);
        }

        public void actionPerformed(ActionEvent e) {
            String str = ImageSelection.getClipboardText();
            if (str != null && str.length() > 0) {
                Jmol.this.viewer.loadInline(str);
            }
        }
    }

    class UguideAction
    extends AbstractAction {
        public UguideAction() {
            super(Jmol.uguideAction);
        }

        public void actionPerformed(ActionEvent e) {
            HelpDialog hd = new HelpDialog(Jmol.this.frame);
            hd.show();
        }
    }

    class NewwinAction
    extends AbstractAction {
        NewwinAction() {
            super(Jmol.newwinAction);
        }

        public void actionPerformed(ActionEvent e) {
            JFrame newFrame = new JFrame();
            new Jmol(null, newFrame, Jmol.this, Jmol.this.startupWidth, Jmol.this.startupHeight, "");
            newFrame.show();
        }
    }

    class WhatsNewAction
    extends AbstractAction {
        public WhatsNewAction() {
            super(Jmol.whatsnewAction);
        }

        public void actionPerformed(ActionEvent e) {
            WhatsNewDialog wnd = new WhatsNewDialog(Jmol.this.frame);
            wnd.show();
        }
    }

    class AboutAction
    extends AbstractAction {
        public AboutAction() {
            super(Jmol.aboutAction);
        }

        public void actionPerformed(ActionEvent e) {
            AboutDialog ad = new AboutDialog(Jmol.this.frame);
            ad.show();
        }
    }

    class ConsoleAction
    extends AbstractAction {
        public ConsoleAction() {
            super("console");
        }

        public void actionPerformed(ActionEvent e) {
            if (consoleframe != null) {
                consoleframe.show();
            }
        }
    }

    class CloseAction
    extends AbstractAction {
        CloseAction() {
            super(Jmol.closeAction);
        }

        public void actionPerformed(ActionEvent e) {
            Jmol.this.frame.hide();
            Jmol.this.doClose();
        }
    }

    private class ActionChangedListener
    implements PropertyChangeListener {
        AbstractButton button;

        ActionChangedListener(AbstractButton button) {
            this.button = button;
        }

        public void propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            if (e.getPropertyName().equals("Name")) {
                String text = (String)e.getNewValue();
                if (this.button.getText() != null) {
                    this.button.setText(text);
                }
            } else if (propertyName.equals("enabled")) {
                Boolean enabledState = (Boolean)e.getNewValue();
                this.button.setEnabled(enabledState);
            }
        }
    }

    protected final class AppCloser
    extends WindowAdapter {
        protected AppCloser() {
        }

        public void windowClosing(WindowEvent e) {
            Jmol.this.doClose();
        }
    }
}

