/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jmol.api.JmolViewer;
import org.jmol.i18n.GT;
import org.openscience.jmol.app.GuiMap;
import org.openscience.jmol.app.Jmol;

public class PreferencesDialog
extends JDialog
implements ActionListener {
    private boolean autoBond;
    boolean showHydrogens;
    boolean showMeasurements;
    boolean perspectiveDepth;
    boolean showAxes;
    boolean showBoundingBox;
    boolean axesOrientationRasmol;
    boolean openFilePreview;
    boolean clearConsoleButton;
    float minBondDistance;
    float bondTolerance;
    short marBond;
    int percentVdwAtom;
    JButton bButton;
    JButton pButton;
    JButton tButton;
    JButton eButton;
    JButton vButton;
    private JRadioButton abYes;
    private JRadioButton abNo;
    private JSlider vdwPercentSlider;
    private JSlider bdSlider;
    private JSlider bwSlider;
    private JSlider btSlider;
    private JCheckBox cH;
    private JCheckBox cM;
    private JCheckBox cbPerspectiveDepth;
    private JCheckBox cbShowAxes;
    private JCheckBox cbShowBoundingBox;
    private JCheckBox cbAxesOrientationRasmol;
    private JCheckBox cbOpenFilePreview;
    private JCheckBox cbClearConsoleButton;
    private Properties originalSystemProperties;
    private Properties jmolDefaultProperties;
    Properties currentProperties;
    private PrefsAction prefsAction = new PrefsAction();
    private Hashtable commands;
    static final String[] jmolDefaults = new String[]{"jmolDefaults", "true", "showHydrogens", "true", "showMeasurements", "true", "perspectiveDepth", "true", "showAxes", "false", "showBoundingBox", "false", "axesOrientationRasmol", "false", "openFilePreview", "true", "percentVdwAtom", "20", "autoBond", "true", "marBond", "150", "minBondDistance", "0.40", "bondTolerance", "0.45"};
    static final String[] rasmolOverrides = new String[]{"jmolDefaults", "false", "percentVdwAtom", "0", "marBond", "1", "axesOrientationRasmol", "true"};
    JmolViewer viewer;
    GuiMap guimap;
    ItemListener checkBoxListener = new ItemListener(){

        public void itemStateChanged(ItemEvent e) {
            String strSelected;
            JCheckBox cb = (JCheckBox)e.getSource();
            String key = PreferencesDialog.this.guimap.getKey(cb);
            boolean isSelected = cb.isSelected();
            String string = strSelected = isSelected ? "true" : "false";
            if (key.equals("Prefs.showHydrogens")) {
                PreferencesDialog.this.showHydrogens = isSelected;
                PreferencesDialog.this.viewer.setBooleanProperty("showHydrogens", PreferencesDialog.this.showHydrogens);
                PreferencesDialog.this.currentProperties.put("showHydrogens", strSelected);
            } else if (key.equals("Prefs.showMeasurements")) {
                PreferencesDialog.this.showMeasurements = isSelected;
                PreferencesDialog.this.viewer.setBooleanProperty("showMeasurements", PreferencesDialog.this.showMeasurements);
                PreferencesDialog.this.currentProperties.put("showMeasurements", strSelected);
            } else if (key.equals("Prefs.perspectiveDepth")) {
                PreferencesDialog.this.perspectiveDepth = isSelected;
                PreferencesDialog.this.viewer.setBooleanProperty("perspectiveDepth", PreferencesDialog.this.perspectiveDepth);
                PreferencesDialog.this.currentProperties.put("perspectiveDepth", strSelected);
            } else if (key.equals("Prefs.showAxes")) {
                PreferencesDialog.this.showAxes = isSelected;
                PreferencesDialog.this.viewer.setBooleanProperty("showAxes", isSelected);
                PreferencesDialog.this.currentProperties.put("showAxes", strSelected);
            } else if (key.equals("Prefs.showBoundingBox")) {
                PreferencesDialog.this.showBoundingBox = isSelected;
                PreferencesDialog.this.viewer.setBooleanProperty("showBoundBox", isSelected);
                PreferencesDialog.this.currentProperties.put("showBoundingBox", strSelected);
            } else if (key.equals("Prefs.axesOrientationRasmol")) {
                PreferencesDialog.this.axesOrientationRasmol = isSelected;
                PreferencesDialog.this.viewer.setBooleanProperty("axesOrientationRasmol", isSelected);
                PreferencesDialog.this.currentProperties.put("axesOrientationRasmol", strSelected);
            } else if (key.equals("Prefs.openFilePreview")) {
                PreferencesDialog.this.openFilePreview = isSelected;
                PreferencesDialog.this.currentProperties.put("openFilePreview", strSelected);
            } else if (key.equals("Prefs.clearConsoleButton")) {
                PreferencesDialog.this.clearConsoleButton = isSelected;
                PreferencesDialog.this.currentProperties.put("clearConsoleButton", strSelected);
            }
        }
    };
    private JButton applyButton;
    private JButton jmolDefaultsButton;
    private JButton rasmolDefaultsButton;
    private JButton cancelButton;
    private JButton okButton;

    public PreferencesDialog(JFrame f, GuiMap guimap, JmolViewer viewer) {
        super((Frame)f, false);
        this.guimap = guimap;
        this.viewer = viewer;
        this.initializeProperties();
        this.setTitle(GT._("Preferences"));
        this.initVariables();
        this.commands = new Hashtable();
        Action[] actions = this.getActions();
        for (int i = 0; i < actions.length; ++i) {
            Action a = actions[i];
            this.commands.put(a.getValue("Name"), a);
        }
        JPanel container = new JPanel();
        container.setLayout(new BorderLayout());
        JTabbedPane tabs = new JTabbedPane();
        JPanel disp = this.buildDispPanel();
        JPanel atoms = this.buildAtomsPanel();
        JPanel bonds = this.buildBondPanel();
        tabs.addTab(GT._("Display"), null, disp);
        tabs.addTab(GT._("Atoms"), null, atoms);
        tabs.addTab(GT._("Bonds"), null, bonds);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(2));
        this.jmolDefaultsButton = new JButton(GT._("Jmol Defaults"));
        this.jmolDefaultsButton.addActionListener(this);
        buttonPanel.add(this.jmolDefaultsButton);
        this.rasmolDefaultsButton = new JButton(GT._("RasMol Defaults"));
        this.rasmolDefaultsButton.addActionListener(this);
        buttonPanel.add(this.rasmolDefaultsButton);
        this.cancelButton = new JButton(GT._("Cancel"));
        this.cancelButton.addActionListener(this);
        buttonPanel.add(this.cancelButton);
        this.applyButton = new JButton(GT._("Apply"));
        this.applyButton.addActionListener(this);
        buttonPanel.add(this.applyButton);
        this.okButton = new JButton(GT._("OK"));
        this.okButton.addActionListener(this);
        buttonPanel.add(this.okButton);
        this.getRootPane().setDefaultButton(this.okButton);
        container.add((Component)tabs, "Center");
        container.add((Component)buttonPanel, "South");
        this.getContentPane().add(container);
        this.updateComponents();
        this.pack();
        this.centerDialog();
    }

    public JPanel buildDispPanel() {
        JPanel disp = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        disp.setLayout(gridbag);
        JPanel showPanel = new JPanel();
        showPanel.setLayout(new GridLayout(1, 3));
        showPanel.setBorder(new TitledBorder(GT._("Show All")));
        this.cH = this.guimap.newJCheckBox("Prefs.showHydrogens", this.viewer.getShowHydrogens());
        this.cH.addItemListener(this.checkBoxListener);
        this.cM = this.guimap.newJCheckBox("Prefs.showMeasurements", this.viewer.getShowMeasurements());
        this.cM.addItemListener(this.checkBoxListener);
        showPanel.add(this.cH);
        showPanel.add(this.cM);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridwidth = 0;
        constraints.fill = 2;
        constraints.weightx = 1.0;
        disp.add((Component)showPanel, constraints);
        JPanel fooPanel = new JPanel();
        fooPanel.setBorder(new TitledBorder(""));
        fooPanel.setLayout(new GridLayout(2, 1));
        this.cbPerspectiveDepth = this.guimap.newJCheckBox("Prefs.perspectiveDepth", this.viewer.getPerspectiveDepth());
        this.cbPerspectiveDepth.addItemListener(this.checkBoxListener);
        fooPanel.add(this.cbPerspectiveDepth);
        this.cbShowAxes = this.guimap.newJCheckBox("Prefs.showAxes", this.viewer.getShowAxes());
        this.cbShowAxes.addItemListener(this.checkBoxListener);
        fooPanel.add(this.cbShowAxes);
        this.cbShowBoundingBox = this.guimap.newJCheckBox("Prefs.showBoundingBox", this.viewer.getShowBbcage());
        this.cbShowBoundingBox.addItemListener(this.checkBoxListener);
        fooPanel.add(this.cbShowBoundingBox);
        constraints = new GridBagConstraints();
        constraints.gridwidth = 0;
        constraints.fill = 2;
        constraints.weightx = 1.0;
        disp.add((Component)fooPanel, constraints);
        JPanel axesPanel = new JPanel();
        axesPanel.setBorder(new TitledBorder(""));
        axesPanel.setLayout(new GridLayout(1, 1));
        this.cbAxesOrientationRasmol = this.guimap.newJCheckBox("Prefs.axesOrientationRasmol", this.viewer.getAxesOrientationRasmol());
        this.cbAxesOrientationRasmol.addItemListener(this.checkBoxListener);
        axesPanel.add(this.cbAxesOrientationRasmol);
        constraints = new GridBagConstraints();
        constraints.gridwidth = 0;
        constraints.fill = 2;
        constraints.weightx = 1.0;
        disp.add((Component)axesPanel, constraints);
        JPanel otherPanel = new JPanel();
        otherPanel.setBorder(new TitledBorder(""));
        otherPanel.setLayout(new GridLayout(2, 1));
        this.cbOpenFilePreview = this.guimap.newJCheckBox("Prefs.openFilePreview", this.openFilePreview);
        this.cbOpenFilePreview.addItemListener(this.checkBoxListener);
        otherPanel.add(this.cbOpenFilePreview);
        this.cbClearConsoleButton = this.guimap.newJCheckBox("Prefs.clearConsoleButton", this.clearConsoleButton);
        this.cbClearConsoleButton.addItemListener(this.checkBoxListener);
        otherPanel.add(this.cbClearConsoleButton);
        constraints = new GridBagConstraints();
        constraints.gridwidth = 0;
        constraints.fill = 2;
        constraints.weightx = 1.0;
        disp.add((Component)otherPanel, constraints);
        JLabel filler = new JLabel();
        constraints = new GridBagConstraints();
        constraints.gridwidth = 0;
        constraints.gridheight = 0;
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        disp.add((Component)filler, constraints);
        return disp;
    }

    public JPanel buildAtomsPanel() {
        JPanel atomPanel = new JPanel(new GridBagLayout());
        JPanel sfPanel = new JPanel();
        sfPanel.setLayout(new BorderLayout());
        sfPanel.setBorder(new TitledBorder(GT._("Default atom size")));
        JLabel sfLabel = new JLabel(GT._("(percentage of vanDerWaals radius)"), 0);
        sfPanel.add((Component)sfLabel, "North");
        this.vdwPercentSlider = new JSlider(0, 0, 100, this.viewer.getPercentVdwAtom());
        this.vdwPercentSlider.putClientProperty("JSlider.isFilled", Boolean.TRUE);
        this.vdwPercentSlider.setPaintTicks(true);
        this.vdwPercentSlider.setMajorTickSpacing(20);
        this.vdwPercentSlider.setMinorTickSpacing(10);
        this.vdwPercentSlider.setPaintLabels(true);
        this.vdwPercentSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                JSlider source = (JSlider)e.getSource();
                PreferencesDialog.this.percentVdwAtom = source.getValue();
                PreferencesDialog.this.viewer.setIntProperty("PercentVdwAtom", PreferencesDialog.this.percentVdwAtom);
                PreferencesDialog.this.currentProperties.put("percentVdwAtom", "" + PreferencesDialog.this.percentVdwAtom);
            }
        });
        sfPanel.add((Component)this.vdwPercentSlider, "Center");
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridwidth = 0;
        constraints.fill = 2;
        constraints.weightx = 1.0;
        atomPanel.add((Component)sfPanel, constraints);
        JLabel filler = new JLabel();
        constraints = new GridBagConstraints();
        constraints.gridwidth = 0;
        constraints.gridheight = 0;
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        atomPanel.add((Component)filler, constraints);
        return atomPanel;
    }

    public JPanel buildBondPanel() {
        JPanel bondPanel = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        bondPanel.setLayout(gridbag);
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        JPanel autobondPanel = new JPanel();
        autobondPanel.setLayout(new BoxLayout(autobondPanel, 1));
        autobondPanel.setBorder(new TitledBorder(GT._("Compute Bonds")));
        ButtonGroup abGroup = new ButtonGroup();
        this.abYes = new JRadioButton(GT._("Automatically"));
        this.abNo = new JRadioButton(GT._("Don't Compute Bonds"));
        abGroup.add(this.abYes);
        abGroup.add(this.abNo);
        autobondPanel.add(this.abYes);
        autobondPanel.add(this.abNo);
        autobondPanel.add(Box.createVerticalGlue());
        this.abYes.setSelected(this.viewer.getAutoBond());
        this.abYes.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PreferencesDialog.this.viewer.setBooleanProperty("autoBond", true);
            }
        });
        this.abNo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PreferencesDialog.this.viewer.setBooleanProperty("autoBond", false);
            }
        });
        c.gridwidth = 0;
        gridbag.setConstraints(autobondPanel, c);
        bondPanel.add(autobondPanel);
        JPanel bwPanel = new JPanel();
        bwPanel.setLayout(new BorderLayout());
        bwPanel.setBorder(new TitledBorder(GT._("Default Bond Radius")));
        JLabel bwLabel = new JLabel(GT._("(Angstroms)"), 0);
        bwPanel.add((Component)bwLabel, "North");
        this.bwSlider = new JSlider(0, 250, this.viewer.getMadBond() / 2);
        this.bwSlider.putClientProperty("JSlider.isFilled", Boolean.TRUE);
        this.bwSlider.setPaintTicks(true);
        this.bwSlider.setMajorTickSpacing(50);
        this.bwSlider.setMinorTickSpacing(25);
        this.bwSlider.setPaintLabels(true);
        for (int i = 0; i <= 250; i += 50) {
            String label = "" + (1000 + i);
            label = "0." + label.substring(1);
            this.bwSlider.getLabelTable().put(new Integer(i), new JLabel(label, 0));
            this.bwSlider.setLabelTable(this.bwSlider.getLabelTable());
        }
        this.bwSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                JSlider source = (JSlider)e.getSource();
                PreferencesDialog.this.marBond = (short)source.getValue();
                PreferencesDialog.this.viewer.setIntProperty("bondRadiusMilliAngstroms", PreferencesDialog.this.marBond);
                PreferencesDialog.this.currentProperties.put("marBond", "" + PreferencesDialog.this.marBond);
            }
        });
        bwPanel.add((Component)this.bwSlider, "South");
        c.weightx = 0.0;
        gridbag.setConstraints(bwPanel, c);
        bondPanel.add(bwPanel);
        JPanel btPanel = new JPanel();
        btPanel.setLayout(new BorderLayout());
        btPanel.setBorder(new TitledBorder(GT._("Bond Tolerance - sum of two covalent radii + this value")));
        JLabel btLabel = new JLabel(GT._("(Angstroms)"), 0);
        btPanel.add((Component)btLabel, "North");
        this.btSlider = new JSlider(0, 0, 100, (int)(100.0f * this.viewer.getBondTolerance()));
        this.btSlider.putClientProperty("JSlider.isFilled", Boolean.TRUE);
        this.btSlider.setPaintTicks(true);
        this.btSlider.setMajorTickSpacing(20);
        this.btSlider.setMinorTickSpacing(10);
        this.btSlider.setPaintLabels(true);
        this.btSlider.getLabelTable().put(new Integer(0), new JLabel("0.0", 0));
        this.btSlider.setLabelTable(this.btSlider.getLabelTable());
        this.btSlider.getLabelTable().put(new Integer(20), new JLabel("0.2", 0));
        this.btSlider.setLabelTable(this.btSlider.getLabelTable());
        this.btSlider.getLabelTable().put(new Integer(40), new JLabel("0.4", 0));
        this.btSlider.setLabelTable(this.btSlider.getLabelTable());
        this.btSlider.getLabelTable().put(new Integer(60), new JLabel("0.6", 0));
        this.btSlider.setLabelTable(this.btSlider.getLabelTable());
        this.btSlider.getLabelTable().put(new Integer(80), new JLabel("0.8", 0));
        this.btSlider.setLabelTable(this.btSlider.getLabelTable());
        this.btSlider.getLabelTable().put(new Integer(100), new JLabel("1.0", 0));
        this.btSlider.setLabelTable(this.btSlider.getLabelTable());
        this.btSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                JSlider source = (JSlider)e.getSource();
                PreferencesDialog.this.bondTolerance = (float)source.getValue() / 100.0f;
                PreferencesDialog.this.viewer.setFloatProperty("bondTolerance", PreferencesDialog.this.bondTolerance);
                PreferencesDialog.this.currentProperties.put("bondTolerance", "" + PreferencesDialog.this.bondTolerance);
                PreferencesDialog.this.viewer.rebond();
            }
        });
        btPanel.add(this.btSlider);
        c.weightx = 0.0;
        gridbag.setConstraints(btPanel, c);
        bondPanel.add(btPanel);
        JPanel bdPanel = new JPanel();
        bdPanel.setLayout(new BorderLayout());
        bdPanel.setBorder(new TitledBorder(GT._("Minimum Bonding Distance")));
        JLabel bdLabel = new JLabel(GT._("(Angstroms)"), 0);
        bdPanel.add((Component)bdLabel, "North");
        this.bdSlider = new JSlider(0, 0, 100, (int)(100.0f * this.viewer.getMinBondDistance()));
        this.bdSlider.putClientProperty("JSlider.isFilled", Boolean.TRUE);
        this.bdSlider.setPaintTicks(true);
        this.bdSlider.setMajorTickSpacing(20);
        this.bdSlider.setMinorTickSpacing(10);
        this.bdSlider.setPaintLabels(true);
        this.bdSlider.getLabelTable().put(new Integer(0), new JLabel("0.0", 0));
        this.bdSlider.setLabelTable(this.bdSlider.getLabelTable());
        this.bdSlider.getLabelTable().put(new Integer(20), new JLabel("0.2", 0));
        this.bdSlider.setLabelTable(this.bdSlider.getLabelTable());
        this.bdSlider.getLabelTable().put(new Integer(40), new JLabel("0.4", 0));
        this.bdSlider.setLabelTable(this.bdSlider.getLabelTable());
        this.bdSlider.getLabelTable().put(new Integer(60), new JLabel("0.6", 0));
        this.bdSlider.setLabelTable(this.bdSlider.getLabelTable());
        this.bdSlider.getLabelTable().put(new Integer(80), new JLabel("0.8", 0));
        this.bdSlider.setLabelTable(this.bdSlider.getLabelTable());
        this.bdSlider.getLabelTable().put(new Integer(100), new JLabel("1.0", 0));
        this.bdSlider.setLabelTable(this.bdSlider.getLabelTable());
        this.bdSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                JSlider source = (JSlider)e.getSource();
                PreferencesDialog.this.minBondDistance = (float)source.getValue() / 100.0f;
                PreferencesDialog.this.viewer.setFloatProperty("minBondDistance", PreferencesDialog.this.minBondDistance);
                PreferencesDialog.this.currentProperties.put("minBondDistance", "" + PreferencesDialog.this.minBondDistance);
                PreferencesDialog.this.viewer.rebond();
            }
        });
        bdPanel.add(this.bdSlider);
        c.weightx = 0.0;
        gridbag.setConstraints(bdPanel, c);
        bondPanel.add(bdPanel);
        return bondPanel;
    }

    protected void centerDialog() {
        Dimension screenSize = this.getToolkit().getScreenSize();
        Dimension size = this.getSize();
        screenSize.height /= 2;
        screenSize.width /= 2;
        size.height /= 2;
        size.width /= 2;
        int y = screenSize.height - size.height;
        int x = screenSize.width - size.width;
        this.setLocation(x, y);
    }

    public void ok() {
        this.save();
        this.dispose();
    }

    public void cancel() {
        this.updateComponents();
        this.dispose();
    }

    private void updateComponents() {
        this.cH.setSelected(this.viewer.getShowHydrogens());
        this.cM.setSelected(this.viewer.getShowMeasurements());
        this.cbPerspectiveDepth.setSelected(this.viewer.getPerspectiveDepth());
        this.cbShowAxes.setSelected(this.viewer.getShowAxes());
        this.cbShowBoundingBox.setSelected(this.viewer.getShowBbcage());
        this.cbAxesOrientationRasmol.setSelected(this.viewer.getAxesOrientationRasmol());
        this.cbOpenFilePreview.setSelected(this.openFilePreview);
        this.cbClearConsoleButton.setSelected(this.clearConsoleButton);
        this.vdwPercentSlider.setValue(this.viewer.getPercentVdwAtom());
        this.abYes.setSelected(this.viewer.getAutoBond());
        this.bwSlider.setValue(this.viewer.getMadBond() / 2);
        this.bdSlider.setValue((int)(100.0f * this.viewer.getMinBondDistance()));
        this.btSlider.setValue((int)(100.0f * this.viewer.getBondTolerance()));
    }

    private void save() {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(Jmol.UserPropsFile);
            this.currentProperties.store(fileOutputStream, "Jmol");
            fileOutputStream.close();
        }
        catch (Exception e) {
            System.out.println("Error saving preferences" + e);
        }
        this.viewer.refresh(0, "PreferencesDialog:save()");
    }

    void initializeProperties() {
        this.originalSystemProperties = System.getProperties();
        this.jmolDefaultProperties = new Properties(this.originalSystemProperties);
        int i = jmolDefaults.length;
        while ((i -= 2) >= 0) {
            this.jmolDefaultProperties.put(jmolDefaults[i], jmolDefaults[i + 1]);
        }
        this.currentProperties = new Properties(this.jmolDefaultProperties);
        try {
            FileInputStream fis2 = new FileInputStream(Jmol.UserPropsFile);
            this.currentProperties.load(new BufferedInputStream(fis2, 1024));
            fis2.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.setProperties(this.currentProperties);
    }

    void resetDefaults(String[] overrides) {
        this.currentProperties = new Properties(this.jmolDefaultProperties);
        System.setProperties(this.currentProperties);
        if (overrides != null) {
            int i = overrides.length;
            while ((i -= 2) >= 0) {
                this.currentProperties.put(overrides[i], overrides[i + 1]);
            }
        }
        this.initVariables();
        this.viewer.refresh(0, "PreferencesDialog:resetDefaults()");
        this.updateComponents();
    }

    void initVariables() {
        this.autoBond = Boolean.getBoolean("autoBond");
        this.showHydrogens = Boolean.getBoolean("showHydrogens");
        this.showMeasurements = Boolean.getBoolean("showMeasurements");
        this.perspectiveDepth = Boolean.getBoolean("perspectiveDepth");
        this.showAxes = Boolean.getBoolean("showAxes");
        this.showBoundingBox = Boolean.getBoolean("showBoundingBox");
        this.axesOrientationRasmol = Boolean.getBoolean("axesOrientationRasmol");
        this.openFilePreview = Boolean.valueOf(System.getProperty("openFilePreview", "true"));
        this.clearConsoleButton = Boolean.getBoolean("clearConsoleButton");
        this.minBondDistance = new Float(this.currentProperties.getProperty("minBondDistance")).floatValue();
        this.bondTolerance = new Float(this.currentProperties.getProperty("bondTolerance")).floatValue();
        this.marBond = Short.parseShort(this.currentProperties.getProperty("marBond"));
        this.percentVdwAtom = Integer.parseInt(this.currentProperties.getProperty("percentVdwAtom"));
        if (Boolean.getBoolean("jmolDefaults")) {
            this.viewer.setStringProperty("defaults", "Jmol");
        } else {
            this.viewer.setStringProperty("defaults", "RasMol");
        }
        this.viewer.setIntProperty("percentVdwAtom", this.percentVdwAtom);
        this.viewer.setIntProperty("bondRadiusMilliAngstroms", this.marBond);
        this.viewer.setFloatProperty("minBondDistance", this.minBondDistance);
        this.viewer.setFloatProperty("BondTolerance", this.bondTolerance);
        this.viewer.setBooleanProperty("autoBond", this.autoBond);
        this.viewer.setBooleanProperty("showHydrogens", this.showHydrogens);
        this.viewer.setBooleanProperty("showMeasurements", this.showMeasurements);
        this.viewer.setBooleanProperty("perspectiveDepth", this.perspectiveDepth);
        this.viewer.setBooleanProperty("showAxes", this.showAxes);
        this.viewer.setBooleanProperty("showBoundBox", this.showBoundingBox);
        this.viewer.setBooleanProperty("axesOrientationRasmol", this.axesOrientationRasmol);
    }

    public Action[] getActions() {
        Action[] defaultActions = new Action[]{this.prefsAction};
        return defaultActions;
    }

    protected Action getAction(String cmd) {
        return (Action)this.commands.get(cmd);
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.applyButton) {
            this.save();
        } else if (event.getSource() == this.jmolDefaultsButton) {
            this.resetDefaults(null);
        } else if (event.getSource() == this.rasmolDefaultsButton) {
            this.resetDefaults(rasmolOverrides);
        } else if (event.getSource() == this.cancelButton) {
            this.cancel();
        } else if (event.getSource() == this.okButton) {
            this.ok();
        }
    }

    class PrefsAction
    extends AbstractAction {
        public PrefsAction() {
            super("prefs");
            this.setEnabled(true);
        }

        public void actionPerformed(ActionEvent e) {
            PreferencesDialog.this.show();
        }
    }
}

