//  JmolShell - a platform for preparing Jmol presentations
//  
//  This file forms the basis for JmolShell. It is called by a WEB page that need
//  only include presentation-specific code. It uses the Jmol Java unit and the
//  Jmol.js library code that accompanies Jmol. 
//  
//  JmolShell is written by:
//	
//	Craig T. Martin
//	Dept of Chemistry and of Biochem & Mol Biol
//	University of Massachusetts
//	710 N Pleasant St
//	Amherst, MA 01003
//	(413) 545-3299
//	CTMartin@chem.umass.edu
//	http://www.chem.umass.edu/~cmartin
//  
//  
//  Requires Jmol.js  v10.0.39 or greater
//
//  This version works well in most Mac browsers!
//

var JmolShellUpdate = "April 27, 2006; 10:30pm";

//Global variables
var TagLine = "",			authorG = "Bozo";
var CitationG = "J Irreprod Res 00, 123";
var PubMedIDG = "000",		LastUpdatedG = "1/01/1901";
var jHgt = 300, jWid = 300;
var ResetFileG = "Reset.spt";
var RecOn = "false";
var LastMsgSet = "";
var WaitingForO = "false";
var CaptureMsgs = "false";
var MsgStore = "";
var JmolDebugStatus = false;
var OneLineCmdBarG = false;
var Processing = true;
var PDBid = "";
var StDescr = "";
var st_JmolApp = "";
var pdbFileG = "";
var scrptfileG = "";

// Constants for external links
//var JmolMainPage = "http:\/\/www.Jmol.org";
var JmolMainPage = "http:\/\/jmol.sourceforge.net";
var JmolJSPage = "http:\/\/jmol.sourceforge.net\/jslibrary";
var JmolHelp = "http:\/\/www.stolaf.edu\/academics\/chemapps\/jmol\/";
var MouseHelp = "http://wiki.jmol.org/MouseManual";
var CHIMEHelp = "http:\/\/www.umass.edu\/microbio\/chime\/manual\/chimeman.htm#chcomref";
var RasmolHelp = "http:\/\/www.openrasmol.org\/doc\/#chcomref";
var PDB_Search = "http:\/\/pdbbeta.rcsb.org\/pdb\/explore.do?structureId=";

var BigMemory = "";
var NewDebug = false;

// A script to execute at startup
var StartUpScript = "set measurement angstroms";

// Constants for "design"
var FontSzG = 12;
var fntstyl = " style=\"font-size: " + (FontSzG-2)+ "px;\"";
var fntstylTiny = " style=\"font-size: " + (FontSzG-3)+ "px;\"";
var colWid = 38; colRows = 15;

// Constants for HTML formatting
var CrLf = "\n";
var HRSm = "\n\n\<HR size=\"2\" \>";
var HRBg = "\n\n\<HR size=\"4\" \>";
var Spc3 = "&nbsp;&nbsp;&nbsp;";
var Spc2 = "&nbsp;&nbsp;";
var br = "\n\n\<br\>";
var p = "\n\n\<P\>";
var HR = "\n\n\<HR\>";
var endDIV = "<\/DIV\>\n\n";

// Constants for Form Select elements
var ColorOptions = "Color:"
		+ ",cpk,Red,Orange,Yellow,Green,Blue,Cyan,Violet,Brown"
		+ ",Magenta,Pink,LightGreen,LightBlue,LightYellow,Gray,Black,White,Purple";
		
var aaOptions = "aa:"
		+ ",Asn,Gln,Asp,Glu,Arg,Lys,Gly,Ala,Val,Ile,Leu,Thr"
		+ ",Phe,Tyr,Trp,Pro,Met,Ser,Thr,Cys,His,Cystine,-----"
		+ ",Hydrophobic,Neutral,Polar,Charged,Acidic,Basic,Amino,Aromatic"
		+ ",Aliphatic,Hydrogen";
		
var aaWhatOptions = "where:"
		+ ",Bonded,Ligand,Surface,Buried";
		
var typeOptions = "Type:,Protein,Nucleic,Solvent,Water,Hetero,Ions"

var ScndryOptions = "2ndry:,Helix,Sheet,Turn";
var BBOptions = "BB:,Backbone,Sidechain";
var nucleicOptions = "DNA:,AT,CG,A,C,G,T,U,Pyrimidine,Purine";

// Global variables that will change (but don't touch)
 var UserMenuList = [];
 var UserDscr = [];
 var MainMenuList = [];
 var sideBarWid = 290;  // Gets reset later
 var cmdHgt = (navigator.userAgent.indexOf("Safari")!=-1) ? 155 : 100;

 var LastUserDiv = "";

 var DebugDivHTML = 
	"<FORM ID='DebugDivForm' NAME='DebugDivForm'\>" +
	"<TEXTAREA NAME='DebugDivField' ROWS='80' COLS='1000'\><\/TEXTAREA\>" +
	"<\/FORM\>";
	
//=================================

// Function for writing form elements

function FormButtonTag(nam,onClk,clss) {
	return "\<input type=\"button\" value=\"" + nam + "\""
			+ "onclick=\"" + onClk +  "\" CLASS=\"" + clss + "\"\>"
}

//=================================

// Note that this set of scripts uses routines defined in Jmol.js

// ======== Define some static WEB "pages" for later loading =========

// A command line BOX for multiple commands
//  Future: make this of dynamic width & height, turn it into a function call
//  Future: include message box and command history box
var CmdLineHTML = "\<B\>Enter your "
	+ LinkTag(JmolHelp,"CHIMECommands","Jmol","Click here for help with commands") 
		+ " script here\<\/B\>"
	+ br + "\<form name=\"area\"\>"
		+ ClearTag()
		+ FormButtonTag("Execute","run(document.area.scriptBox.value)","formstyl") 
		+ Spc3 + FormButtonTag(";","ToggleCmdBx()","formstyl") 
		+ br
		+ "\<textarea name=\"scriptBox\"  value=\"Enter multiple jmol commands here\""
			+ "  cols=" + colWid + " rows=" + colRows + fntstyl + "\>\<\/textarea\>"
	+ "\<\/form\>"
	
	+ br + "Command record".bold()
	+ br + "\<form name=\"history\"\>"
		+ ClearTag()
		+ "\<input name=\"ScriptRecordOn\" type=\"checkbox\" value=\"true\""
			+ " onClick=\"SetRecStatus()\"\> Record commands"+ Spc3
		+ FormButtonTag(";","ToggleHist()","formstyl") 
		+ br
		+ "\<textarea name=\"historyBox\"  value=\"\""
		+ "  cols=" + colWid + " rows=" + (colRows-5) + fntstyl + "\> \<\/textarea\>"
	+ "\<\/form\>"
		
	+ br + "\<form name=\"Feedback\"\>"
	+ "Feedback".bold() + " (newest at top)"
		+ ClearTag()
		+ br
		+ "\<textarea name=\"Messages\"  value=\"\""
		+ "  cols=" + colWid + " rows=" + (colRows-5) + fntstyl + "\> \<\/textarea\>"
	+ "\<br\>\<\/form\>";

// ---------------------------------------------------------------------

// A help window
var HelpHTML = "This presentation made possible by "
	+ LinkTag(JmolMainPage,"JmolSrc","Jmol","Click here to learn more about Jmol") 
		+ ", an open-source project. "
	+ LinkTag(JmolHelp,"JmolHelp","Scripting commands","Click here for help with Jmol commands")
		+ " follow those of " 
	+ LinkTag(RasmolHelp,"RasmolHelp","Rasmol","Click here for Rasmol help") + "\/" 
	+ LinkTag(CHIMEHelp,"CHIMEHelp","CHIME.","Click here for CHIME help")
	+ HR + "The Jmol "
	+ LinkTag(MouseHelp,"MouseHelp","mouse gestures","Click here to learn more about mouse gestures") 
	+ " are designed to function with single-button mice"
		+ " on the Mac. All references to 'left' get translated to 'only'"

	+ "\<table border=\"1\" cellspacing=\"2\" cellpadding=\"1\"\>"
		+ GetTblRw("rotate X and Y axes","left drag")
		+ GetTblRw("zoom + rotate Z axis","shift left drag\<br\> OR middle button drag")
		+ GetTblRw("rotate Z axis only","shift right drag")
		+ GetTblRw("translate X and Y axes","shift double left drag\<br\> OR double middle drag")
			+ GetTblRw("reset to center","shift double left click\<br\> OR double middle click")
		+ GetTblRw("wheel - zoom","a wheel is also a middle button if clicked/dragged")
		+ GetTblRw("popup menu","right click<br> OR ctrl left click")
	+ "\<\/table\>"

	+ "\n\n\<H3\>To measure distances and angles\<\/H3\>"
	+ "Double click, optionally single click 0, 1, or 2 times, Double click"

	+ "\<p\>After your first double-click the cursor will change and then you can"
		+ "\'hover\' over several different atoms to get different distances."

	+ "\<p\>Move outside the applet to cancel the measurement."

	+ "\<p\>For a distance measurment:"

	+ "\<p\>double click to drop an anchor"
	+ "\<br\>double click on the destination"

	+ "\<p\>For an angle measurement:"

	+ "\<p\>double click to drop an anchor"
	+ "\<br\>single click on an intermediate point"
	+ "\<br\>double click on the final point"

	+ "\<p\>For a torsion measurement:"

	+ "\<p\>double click to drop anchor"
	+ "\<br\>single click"
	+ "\<br\>single click"
	+ "\<br\>double click"
	
	+ "\n\n\<H3\>Selection examples\<\/H3\>"
	+ "Select:"
	+ "\<TABLE BORDER=\"0\" CELLSPACING=\"2\" CELLPADDING=\"1\"\>"
	+ "\<TR\>" + "\<TD width=70\>:G\<\/TD\>" + "\<TD\>Chain G\<\/TD\>" + "\<\/TR\>"
	+ "\<TR\>" + "\<TD\>145:G\<\/TD\>" + "\<TD\>Residue 145 of Chain G\<\/TD\>" + "\<\/TR\>"
	+ "\<TR\>" + "\<TD\>45-50:G\<\/TD\>" + "\<TD\>Residues 45 to 50 of Chain G\<\/TD\>" + "\<\/TR\>"
	+ "\<TR\>" + "\<TD\>*.CA\<\/TD\>" + "\<TD\>all c-alphas\<\/TD\>" + "\<\/TR\>"
	+ "\<TR\>" + "\<TD\>[Cys].CA\<\/TD\>" + "\<TD\>all Cys c-alphas\<\/TD\>" + "\<\/TR\>"
	+ "\<TR\>" + "\<TD\>[Cys]:A.CA\<\/TD\>" + "\<TD\>all Cys c-alphas in Chain A\<\/TD\>" + "\<\/TR\>"
	+ "\<\/TABLE\>"
	
	;

// ---------------------------------------------------------------------

// An "About" window - dynamic!
//	This takes information from the user, combined with info from this shell
//		and presents it all in a uniform format
function jAbout()
{
	return "Literature reference for the structure:\<br\>" +
		LinkTag("http://www.ncbi.nlm.nih.gov:80/entrez/query.fcgi?cmd=Retrieve" +
		"&db=PubMed&list_uids=" + PubMedIDG + "&dopt=Abstract",
		"PubMedW",CitationG,"Click here to go to PubMed entry")  +

	
	HR + "Presentation by " + AuthorG + "<p>Last updated: " + LastUpdatedG +

	HR + "This presentation made possible by " + 
		LinkTag(JmolMainPage,"JmolSrc","Jmol","Click here to go to Jmol main page")
			+ ", an open-source project, " +
		"using a set of JavaScript functions provided in the library " + 
		LinkTag(JmolJSPage,"JmolLib","Jmol.js",
			"Click here to go to Jmol javascript library page") + 

		p + "Developed using " + "JmolShell" + ", by " + 
		LinkTag("http:\/\/www.chem.umass.edu\/people\/cmartin","CTM","Craig Martin",
			"Click here to go to his home page at UMass") + ", " +
		EMailTag("cmartin","chem.umass.edu") + ", " +
		"Department of Chemistry, University of Massachusetts, Amherst, MA" +

 		p + "JmolShell last updated: " + JmolShellUpdate +

	HR + "Description of menu items above: " + 
		p + "\<b\>Main\<\/b\> - The presentation content, including the complete" + 
			" story for the molecule at right" +
		p + "\<b\>About\<\/b\> - This page" + 
		p + "\<b\>Cmd\<\/b\> - provides a larger command line for executing " + 
		"multiple Jmol commands. Also allows recording of commands. Cut and paste " +
			"from and to here during development of your project" +
		p + "\<b\>Presets\<\/b\> - lets you construct Jmol commands using a simple " +
			"form. This is a good way to learn how to write scripts." + 
		p + "\<b\>Help\<\/b\> - Help on using JMol and JmolShell" + 
		p + "\<b\>Reset\<\/b\> - Redraws the molecule to its starting view and rendering" + 


	br + "<FORM ID=\"HelpOut\" NAME=\"HelpOut\"\>" +	
	FormButtonTag("PDB Header","DisplayHeaderInfo()","formstyl") +
	FormButtonTag("Machine Info","DisplayMachineInfo()","formstyl") +	
	br + "\<textarea name=\"HelpOutBox\"  value=\"\"" +
		"  cols=" + (colWid+18) + " rows=" + colRows + fntstylTiny + "\> \<\/textarea\>" +
	"\<\/FORM\>";
}

function DisplayMachineInfo()
{	document.HelpOut.HelpOutBox.value =
		"AppCodeName: " + navigator.appCodeName +
		"\nAppName: " + navigator.appName +
		"\nAppVersion: " + navigator.appVersion +
		"\nUserAgent: " + navigator.userAgent +
		"\nPlatform: " + navigator.platform + 
//		"\nJava version " + java.lang.System.getProperty("java.version") + 
        "\nJava enabled: " + navigator.javaEnabled() + 
		"\nDocPath " + document.location.pathname + 
		"\nHostPath: " + document.location.host;
}

// Collect header info
function DisplayHeaderInfo()
{	document.HelpOut.HelpOutBox.value = "Reading...";
	MsgStore = "";
	CaptureMsgs = "true";
	run("show pdbheader");
}

function DisplayHeaderWrap()
{	CaptureMsgs = "false";
	document.HelpOut.HelpOutBox.value = MsgStore;
}

// ---------------------------------------------------------------------

// To Do: Include support for MoveTo
//   	Note:	show axisangle
//		yields:	axis-angle rotation = -0.37671968 0.7977311 -0.47085804 84.490776

var PresetsHTML = "Use the following to execute Jmol commands:".bold()
	+ p
	
	+ "\<form name=\"SelectForm\" \>" + ClearTag() + br
		+ "\<B\>Select\<\/B\>:" + Spc3
		+ SelectTag("aaList","DoSelectForm",aaOptions)
		+ SelectTag("aaWhatList","DoSelectForm",aaWhatOptions)
		+ SelectTag("Secondary","DoSelectForm",ScndryOptions)
		+ Spc3
		+ SelectTag("BBSide","DoSelectForm",BBOptions)
		+ SelectTag("AClass","DoSelectForm",typeOptions)
		+ SelectTag("Nucleic","DoSelectForm",nucleicOptions)
		+ br + Spc3	
		+ "Chain " + InputTextTag("Chain","DoSelectForm",fntstyl,1,1)
		+ Spc3 + "Res No " + InputTextTag("ResNo","DoSelectForm",fntstyl,4,7)
		+ Spc3 + "Atom No " + InputTextTag("AtomNo","DoSelectForm",fntstyl,5,10)
		+ br
		+ FormButtonTag("Do","DoSelectForm();run(document.SelectForm.selecttxt.value)","formstyl")
		+ InputTextTag("selecttxt","",fntstyl,30,200)
		+ p + Spc2 + "Find within "
		+ InputTextTag("DstAng","DoWithinForm",fntstyl,3,7)
		+ " &#197; of the above selection"
		+ br + Spc2 + FormButtonTag("Do","DoWithinForm();run(document.SelectForm.withintxt.value)","formstyl")
		+ InputTextTag("withintxt","",fntstyl,30,200)
	+ "\<\/form\>"
		
	+ HRSm
	
	+ "\<form name=\"ApplyForm\" action='Do'\>" + ClearTag()
		+ "\<B\>Apply\<\/B\>: " + Spc3 + Spc3
		+"Wireframe " + InputTextTag("wireframe","DoApplyForm",fntstyl,4,8) + br+Spc3
		+"Spacefill " + InputTextTag("spacefill","DoApplyForm",fntstyl,4,8) + Spc3
		
		+"Cartoon " + InputTextTag("cartoon","DoApplyForm",fntstyl,4,8) + Spc3 
		+ InputTextToggle("Transluc","DoApplyForm",fntstyl) + "Transluc" + br+Spc3
		+"Backbone " + InputTextTag("backbone","DoApplyForm",fntstyl,4,8) + Spc3
		+"Ribbon " + InputTextTag("ribbon","DoApplyForm",fntstyl,4,8) + br+Spc3
		+"Dots " + InputTextTag("dots","DoApplyForm",fntstyl,4,8) + Spc3
		+"Mesh " + InputTextTag("mesh","DoApplyForm",fntstyl,4,8) + Spc3 
		+SelectTag("Color","DoApplyForm",ColorOptions)
		+ "\<br\>" + FormButtonTag("Do","DoApplyForm();run(document.ApplyForm.selecttxt.value)","formstyl")
		+ InputTextTag("selecttxt","",fntstyl,30,200)
	+ "\<\/form\>"
	
	+ HRBg
	
	+ "\<form name=\"EnviroForm\" action=\"\"\>" + ClearTag()
		+ "\<B\>Global\<\/B\>:"

		+ br + Spc3 + "\<B\>Stereo\<\/B\>:\<br\>" + Spc3
			+ Spc2 + InputRadio("StereoView","","DoEnviroForm","Checked",fntstyl) + "None"
			+ Spc2 + InputRadio("StereoView","off","DoEnviroForm","",fntstyl) + "Off"
			+ Spc2 + InputRadio("StereoView","-5","DoEnviroForm","",fntstyl) + "cross-eyed"
			+ Spc2 + InputRadio("StereoView","5","DoEnviroForm","",fntstyl) + "wall-eyed"

		+ br + Spc3+"Bkgrnd "
		+ SelectTag("background","DoEnviroForm",ColorOptions)
		+ Spc3+"HBonds " + InputTextTag("hbonds","DoEnviroForm",fntstyl,4,8)
	
		+ br + "\<input name=\"ShowOr\" type=\"checkbox\" "
			+ " onClick=\"SetShowOr()\"\> Rotate to current view"
			//+ " in " + InputTextTag("Rtime","DoEnviroForm",fntstyl,3,4) + "sec"
		
		+ br + InputTextTag("CurrOr","DoEnviroForm",fntstyl,30,200) 

		+ "\<br\>" + FormButtonTag("Do","DoEnviroForm();run(document.EnviroForm.selecttxt.value)","formstyl")
		+ InputTextTag("selecttxt","",fntstyl,30,200)
	+ "\<\/form\>"
	;
	
// ========== Functions for the Cmd side-bar ===========

// Used by DoApplyForm (only)
function AddOpt(val,st,prop)
{ if (val != "") st += (st != "")  ?  ";"+prop+" "+val  :  prop+" "+val;
  return st
}

// Used by DoSelectForm (only)
function AddOptB(val,st,prefx)
{  if ((val.indexOf(":") == -1)&&(val!="")) st += (st != "")  ?  " and "+prefx+val  :  prefx+val;
  return st;
}

// Used by EnviroForm (only)
function SetShowOr()
{  with (document.EnviroForm) {
  if (ShowOr.checked)
	{ SetCurrOr() }
  else
	{ CurrOr.value = "" }
  }
  DoEnviroForm();
}

// Used by EnviroForm (only)
function SetCurrOr()
{  with (document.EnviroForm) {
	// issue a Jmol command and wait for the return
	CurrOr.value = "...thinking";
	WaitingForO = "true";
	run("show orientation");
	
  	//var orientationInfo = jmolGetPropertyAsArray("orientationInfo");
	//alert(orientationInfo);
	//orientationInfo.moveTo="moveto 1.0 -345 -938 -23 64.8;"
	//orientationInfo.rotateZYZ="reset; rotate z -160.7; rotate y 64.8;  
	//rotate z 159.0;"
	//orientationInfo.transYPercent=0
	//orientationInfo.transXPercent=0
	//orientationInfo.zoom=100
	
	
	// This function is completed by the event handler showmsg
  }
}

// Process the Environment part of the form, filling in the text box with Jmol script
function DoEnviroForm()
{ var st = "";
  var i=0;
  with (document.EnviroForm) {
  	with (background) {if (value != "") if (value.indexOf(":") == -1) st += (st != "") ? ";" + "background "+value : "background "+value};
 	with (hbonds) { st = AddOpt(value,st,"hbonds") };
	
	stereosetting = "";
	for (i=0;i<StereoView.length;i++)
		{ if (StereoView[i].checked) {stereosetting = StereoView[i].value } }
 	st = AddOpt(stereosetting,st,"stereo");

	if (ShowOr.checked) {
		if (st != "") st += ";";
		st += CurrOr.value;
		};
	selecttxt.value = st;
  };
}

// Process the Apply part of the form, filling in the text box with Jmol script
function DoApplyForm()
{
  var st = "";
  with (document.ApplyForm) {
  	st = AddOpt(wireframe.value,st,"wireframe");
  	st = AddOpt(spacefill.value,st,"spacefill");
  	st = AddOpt(dots.value,st,"dots");
  	st = AddOpt(backbone.value,st,"backbone");
	st = AddOpt(cartoon.value,st,"cartoon");
	if (Transluc.checked) 
		{ if (cartoon.value=="") { st = AddOpt("on",st,"cartoon") };
		  st = AddOpt("translucent",st,"color cartoons ");
		};
  	st = AddOpt(ribbon.value,st,"ribbon");  	
  	st = AddOpt(mesh.value,st,"mesh");
  	with (Color) {if (value != "") if (value.indexOf(":") == -1)
		st += (st != "") ? ";" + "color "+value : "color "+value};
	selecttxt.value = st;
  };
}

// Process the Select part of the form, filling in the text box with Jmol script
function DoSelectForm()
{
  var st = "";
  with (document.SelectForm) {
	st = AddOptB(aaList.value,st,"");
	st = AddOptB(aaWhatList.value,st,"");
	st = AddOptB(Secondary.value,st,"");
	st = AddOptB(BBSide.value,st,"");
	st = AddOptB(AClass.value,st,"");
	st = AddOptB(Nucleic.value,st,"");
	st = AddOptB(Chain.value,st,"*");
	st = AddOptB(ResNo.value,st,"");
	st = AddOptB(AtomNo.value,st,"atomno=");
  	selecttxt.value = (st != "") ? st = "Select " + st  :  "";
  };
  DoWithinForm();
}

// Process the Select part of the form, filling in the text box with Jmol script
function DoWithinForm()
{
  with (document.SelectForm) {
	if ((selecttxt.value=="") || (DstAng.value=="")) {
		st = ""
	} else {
		SelArg = selecttxt.value.substr(6,selecttxt.value.length-5);
  		st = "Select within(" + DstAng.value + "," + SelArg + ") and not (" + SelArg + ")";
	}
	withintxt.value = st;
  };
}

// In command history box, within Cmd, respond to checkbox
function SetRecStatus()
{ ScriptRecOn = document.history.ScriptRecordOn.checked; }

function ReplaceAll(st,stold,stnew)
{	var indx = st.indexOf(stold);
	while (indx != -1)
		{ st = st.replace(stold,stnew);
		  indx = st.indexOf(stold); };
	return st;
}

function ToggleHist()
{ with (document.history.historyBox) {
if (value.indexOf(";") != -1)
 {	value = ReplaceAll(value,";",CrLf)
   } else {
	value = ReplaceAll(value,CrLf,";");
	value = ReplaceAll(value,"\r",";");
	value = ReplaceAll(value,"\n",";");
}  }	}

function ToggleCmdBx()
{ with (document.area.scriptBox) {
if (value.indexOf(";") != -1)
 {	value = ReplaceAll(value,";",CrLf)
   } else {
	value = ReplaceAll(value,CrLf,";");
	value = ReplaceAll(value,"\r",";");
	value = ReplaceAll(value,"\n",";");
}  }	}

// ========== Functions for the Help side-bar ===========

// Used by HelpHTML definition (only)
function GetTblRw(txt1,txt2)
{
return "\<tr align=\"left\" valign=\"top\"\>"
	+ "\<td\>" + txt1 + "\<\/td\>"
	+ "\<td\>" + txt2 + "\<\/td\>"
	+ "\<\/tr\>";
}

// ========== Functions to toggle the side-bars ===========

function GetObjNew(id)
{
  if (document.getElementById)
  {
  	this.obj = document.getElementById(id);
	this.style = document.getElementById(id).style;
  }
  else if (document.all)
  {
	this.obj = document.all[id];
	this.style = document.all[id].style;
  }
  else if (document.layers)
  {
   	this.obj = document.layers[id];
   	this.style = document.layers[id];
  }
}

// Used to reference dHTML elements browser-specifically 
function GetObjAlt(id) {
  var path = new GetObjNew(id);
  return path
}

// Used to reference dHTML elements browser-specifically 
function GetObj(id) {
  if (document.layers)	{ path = document.layers[id] }
  else if (document.all)	{ path = document.all[id] }
  else	if (document.getElementById)	{ path = document.getElementById(id) }
  else alert("Error getting object - browser not supported!");
  return path
}

// Sets individual DIV visibility (true = visible)
function SetVisibility(velement,vstatus) {
   if (GetObj(velement)) 
	  { GetObj(velement).style.visibility = (vstatus) ? "visible" : "hidden"; }
}

// Sets individual DIV visibility (true = visible)
function SetYScroll(velement,sstatus) {
   if (GetObj(velement)) 
	  { GetObj(velement).style.overflow = (sstatus) ? "auto" : "hidden"; }
}

// Toggle content in the JmolShell side-bar
// The following assumes overlapping DIV's containing content
// on the left side. It allows toggling visibility so that only
// one is showing at a time 
function ShowDiv(id)
{ for (var i=0; i< MainMenuList.length; i++) 
	{ SetVisibility(MainMenuList[i],(MainMenuList[i] == id )); 
	  SetYScroll(MainMenuList[i],(MainMenuList[i] == id )) }

  //SetYScroll("MainDiv",(UserMenuList.length<1));
  //The following Kludge should not be necessary (and isn't, in Safari)
  	if (id=="MainDiv") {
		if (UserMenuList.length>0) {
			SetVisibility(LastUserDiv,true);
			SetVisibility("UserMenuDiv",true);
			SetVisibility("UserParent",true);
		  	for(i=0; i< UserMenuList.length; i++) 
				{ SetYScroll(UserMenuList[i],false) };
			SetYScroll(LastUserDiv,true);
			SetYScroll(id,false);
		}
		else {
			SetYScroll(id,true);
		}
	} else {
		if (UserMenuList.length>0) {
			for(i=0; i< UserMenuList.length; i++) 
				{ SetVisibility(UserMenuList[i],false) };
			SetVisibility("UserMenuDiv",false);
			SetVisibility("UserParent",false);
			SetYScroll(id,true);
		}
		else {
			SetYScroll(id,true);
		}
	}
	ReSetSizes();
}


// ========== Functions that can be called within the HTML page ====

// This function simplifies the generation of toggle boxes with the explicit
//  function of turning monitor lines on/off
function ToggleMonitor(atom1,atom2,InTextLbl)
{
  DocWrite("\<script\>jmolCheckbox(" + 
	"\"select atomno=" + atom1 + " or atomno=" + atom2 + ";spacefill 250;" +
	"monitor " + atom1 + " " + atom2 + "\"," + 
	"\"select atomno=" + atom1 + " or atomno=" + atom2 + ";spacefill off;" +
	"monitor " + atom1 + " " + atom2 + "\"," + 
	"\"" + InTextLbl + "\")\<\/script\>" );
}

// Function to write a series of controls useful for animations
function AnimControls(nframes)
{
	var i=0;
	var RunScriptC = ";animation fps 1;animation on";
	var RunRScript = "frame " + nframes + ";animation direction -1;animation mode once" + RunScriptC;
	var RunFScript = "frame 1;animation direction +1;animation mode once" + RunScriptC;
	var t = "Run: " +
		"\<script\>" +
		"jmolButton(\"" + RunRScript + "\", \"\\<\");" +
		"jmolButton(\"" + RunFScript + "\", \"\\>\");" +

		"\<\/script\>";

	t += p + "Step: " +
		"\<script\>" +
		"jmolButton(\"frame 1\", \"\\<\\<\");" +

		"jmolButton(\"animation frame prev\", \"\\<\");" +

		"jmolButton(\"animation frame next\", \"\\>\");" +

		"jmolButton(\"frame " + nframes  + "\", \"\\>\\>\")" +
		"\<\/script\>" +
		p +
		"\<form\>\<script\>" +
 		"jmolRadioGroup([";

	for (i=1; i<=nframes; i++)
		{ t += "[\"frame " + i + "\",\"\",\"\"],"  }
	
	t += " ], \" \", \"\") " +
		"\<\/script\>\<\/form\>";
		
	DocWrite(t);
}

// ========== General functions ===========

// Called by SetupPage. Draws the menu buttons that control
// visibility of the DIV panels
function NavLink(lnk,txt,Dscr)
{  return "\<a href=\"javascript:ShowDiv(\'" + lnk + "\')\"" 
	+ ((Dscr=="") ? "" : " title=\"" + Dscr + "\"") + "\>" + txt + "\<\/a\>"; }

// ---------------

// replace all occurences of x by y in st
function rplc(st, x, y) {

  if ((x == y) || (parseInt(y.indexOf(x)) > -1)) { return st }
    
  while (st.indexOf(x) != -1) {
    st = st.substring(0, st.indexOf(x)) + y
		+ st.substring(st.indexOf(x) + x.length, st.length);  }
  return st;
}

// ---------------

// Defines a "DIV" start tag, based on a css class, with possibility of override
function DivStartTagC(divid, divclass)
{	if (divclass != "")		divclass = " class=\"" + divclass + "\" ";
	var st = "\n\n\<div id=\"" + divid + "\" name=\"" + divid + "\" " + divclass + "\>";
	//alert(st)
	return st;
}


// ---------------

function SpanWrap(st,spanclass, styl, id) {
  if (spanclass != "")	spanclass = " class=\"" + spanclass + "\" ";
  if (styl != "")		styl = " style=\"" + styl + "\" ";
  if (id != "")			id = " id=\"" + id + "\" ";
  return "\<span " + id + spanclass + styl + "\>" + st + "\<\/span\>"
}

// ---------------

// Places a string right-adjusted (used internally only)
function floatRight(st)
  { return SpanWrap(st,"","position: relative; float:right",""); }
// ---------------

// put Email tags for me and for the user
//  not currently used
function EMailTagName(RealName, User, domain)
{ return "\<a href=\"mailto:" + User + "@" + domain + "\"\>" + RealName + "\<\/a\>" }

// ---------------

function EMailTag(User, domain)
{ return "\<a href=\"mailto:" + User + "@" + domain + "\"\>" + User + "@" + domain + "\<\/a\>" }

// ---------------

function SetTagLine(PDBid, Dscr,Citation) {
  DscrPlus = Dscr + "\<br\>" + SpanWrap(Citation,"TagLine", "", "")
  GetObj("TagLineSpan").innerHTML = (PDBid == "" ) ? 
	DscrPlus :
	LinkTag(PDB_Search + PDBid,
		"ProteinDataBank", PDBid,"Click here to go to entry at the PDB") + " - "+ DscrPlus;
}

// ---------------

// Return an HTML link to go somewhere
function LinkTag(Dest,Targt,Txt,Dscr)
{ return "\<a href=\"" + Dest + "\" target=\"" + Targt + "\"" 
	+ ((Dscr=="") ? "" : " title=\"" + Dscr + "\"") + "\>" + Txt + "\<\/a\>" }

// ======== Routines for generating form elements (used by CmdLine code) =======

// Return a clickable button that executes a script
function FormButtonTag(nam,onClk,clss) {
	return "\<input type=\"button\" value=\"" + nam + "\""
			+ "onclick=\"" + onClk +  "\" CLASS=\"" + clss + "\"\>"
}


// return a complete Select element for a form. Generates a pop-up menu
function SelectTag(nam,onchng,optns)
{	if (onchng != "") onchng += "()";
	optns = "\<option\>" + optns.replace(/,/g,"\<option\>");
	var st = "\<select name=\"" + nam + "\" class=\"SelectTag\" size=\"1\" onchange=\"" + onchng + "\"" 
		+ " WIDTH=\"59\" \>" + optns + "\<\/select\>";
	return st;
}

// Return an "text input" form element
function InputTextTag(nam,onchng,styl,sz,maxsz)
{	if (onchng != "") onchng = " onchange=\"" + onchng + "()\"";
	var st = "\<input name='" + nam + "' type='text' size='" + sz + "' maxlength='" + maxsz + "'"
	+ onchng + "\>";
	return st;
}

// Return a "checkbox" form element
function InputTextToggle(nam,onchng,styl)
{	if (onchng != "") onchng = " onchange=\"" + onchng + "()\"";
	var st = "\<input name=\"" + nam + "\" type=\"checkbox\""
	+ onchng + "\>";
	return st;
}

// Return a "radio button" form element
function InputRadio(grpnam,rtnval,onchng,IsChecked,styl)
{	if (onchng != "") onchng = " onclick=\"" + onchng + "()\"";
	(IsChecked != "") ? IsChecked = " CHECKED" : IsChecked = "";
	var st = "\<input name=\"" + grpnam + "\" type=\"radio\" Value=\"" + rtnval + "\" "
	+ onchng + IsChecked + "\>";
	return st;
}


// Return a "Clear" form element
function ClearTag() {
  return SpanWrap("\<input type=\"reset\" value=\"Clear\"" + fntstyl + "\>",
	"", "position: relative; float:right", "");
}

// =============== jShell specific stuff ==================

// Reset protein to default view, coloring, etc
function Reset()
  { run("script " + ResetFileG); }

// ---------------

// Draws an HTML link to execute script to load new molecule
function LinkToLoadNew(filename,lnktxt,PDB,dscr,citation) {
  var q = "\'";
  var stdsc = "Load coordinates for " + PDB + " - " + dscr;
  var stjsscrpt = "LoadNewPDB("
		+ q + filename + q + ","
		+ q + "" + q + ","
		+ q + PDB + q + ","
		+ q + dscr + q + ","
		+ q + citation + q
		+ ")";
  var st = "\<A HREF=\"javascript:" + stjsscrpt + "\" TITLE=\"" + stdsc + "\"\>" + lnktxt + "\<\/A\>";
  DocWrite(st);
}

// Shows frame i of a model and updates the info header appropriately
function ShowFrame(i,PDB,dscr,citation) {
	var st = "frame " + i;
	jmolScript(st);
	SetTagLine(PDB,dscr,citation);
}

function LoadingWaitMsg(st)
{	jmolScript("set echo top left;echo loading "+st+"...;delay 1");
}

// Executes script to load new molecule and updates the info header appropriately
function LoadNewPDB(filename,scrpt,PDB,dscr,citation) {
	if (scrpt=="")
		{ scrpt = "script " + ResetFileG + ""  };
	var st = "load " + filename;
	LoadingWaitMsg(filename);
	jmolScript(st);
	var iposStar = scrpt.indexOf("_ResetAll_");
	if (iposStar>-1) {
		Reset();
		scrpt = scrpt.replace("_ResetAll_","");
	}
	jmolScript(scrpt);
	SetTagLine(PDB,dscr,citation);
}

// Writes HTML code to generate a button set for loading new molecules
// Call with the following
//  [filename,dscr,script,PDB,citation], [filename,btntxt,PDB,dscr,citation], ...
// Include as many buttons as you like
function ButtonsToLoadNew() {
  var filename="", dscr="", scrp="", PDB="", citation="", chkd="", btntxt="", sti="";
  var btns = ButtonsToLoadNew.arguments;
  var nbtns = btns.length;
  var st = "\<form\>";
  for (var i = 0; i < nbtns; i++) {
	filename = btns[i][0];
	dscr = btns[i][1];
	scrp = btns[i][2];
	PDB = btns[i][3];
	citation = btns[i][4];
	chkd = btns[i][5];
	chkd = (chkd=="CHECKED") ? " CHECKED" : "";
	
	btntxt = dscr + " \<SMALL\>(" + PDB + ")\<\/SMALL\>";
	sti = "\<input type=\"radio\" name=\"Bub\" onClick="
		+ "\"LoadNewPDB(\'" + filename  + "\',"
		+ "\'" +  scrp  + "\',"
		+ "\'" +  PDB  + "\',"
		+ "\'" +  dscr  + "\',"
		+ "\'" +  citation  + "\'"
		+ ")\"" + chkd + "\>" +  btntxt + "\<br\>";
	st += sti;
  }
  st += "\<\/form\>";
  DocWrite(st);
}

// Like that above but using a "Definitions" list
function ButtonsToLoadDef() {
  var filename="", dscr="", scrp="", PDB="", citation="", chkd="", btntxt="", sti="";
  var btns = ButtonsToLoadDef.arguments;
  var nbtns = btns.length;
  var st = "\<form\>" + "<DL>";
  for (var i = 0; i < nbtns; i++) {
	filename = btns[i][0];
	dscr = btns[i][1];
	scrp = btns[i][2];
	PDB = btns[i][3];
	citation = btns[i][4];
	chkd = btns[i][5];
	definit = btns[i][6];
	chkd = (chkd=="CHECKED") ? " CHECKED" : "";
	
	btntxt = dscr + " \<SMALL\>(" + PDB + ")\<\/SMALL\>";
	sti = "\<input type=\"radio\" name=\"Bub\" onClick="
		+ "\"LoadNewPDB(\'" + filename  + "\',"
		+ "\'" +  scrp  + "\',"
		+ "\'" +  PDB  + "\',"
		+ "\'" +  dscr  + "\',"
		+ "\'" +  citation  + "\'"
		+ ")\"" + chkd + "\>" +  btntxt + "\<br\>";

	st += "<DT>" + sti + "<DD>" + definit;
  }
  st += "<\/DL>" + "\<\/form\>";
  DocWrite(st);
}

// Write a routine like that above, but that switches frames only
//  [ for future development ]


// Send command(s) to Jmol, saving in History if Record mode is ON
function run(Jscript)
  { jmolScript(Jscript);
	with (document.history) {
		if (ScriptRecordOn.checked) {
			if (historyBox.value != "") historyBox.value += CrLf;
			historyBox.value += ReplaceAll(Jscript,";",CrLf);
		}
	}
  }

// ---------- Stuff for message call back ------------

// Feedback on the recently picked atom
//  place the result into boxes on main page
function showpick(a,b)
{	b = ""+b;
	if (OneLineCmdBarG) with (document.cline.PickBox) {
		var st = value;
		value = b+"\n"+st;
	}
	with (document.cline) {
		Res.value = b.substring(b.indexOf("[")+1,b.indexOf("]"));
		ResNo.value = b.substring(b.indexOf("]")+1,b.indexOf(":"));
		Chain.value = b.substring(b.indexOf(":")+1,b.indexOf("."));
		Atom.value = b.substring(b.indexOf(".")+1,b.indexOf("#"));
		AtomNo.value = b.substring( b.indexOf("#")+1 );
		if (!OneLineCmdBarG) { FullCall.value = b }
	}
}

// Messages from Jmol (info about number of atoms selected, etc)
//  this is specified in the MessageCallBack argument below
function showmsg(a,b,c)
{	b = ""+b;
	if (OneLineCmdBarG) with (document.cline.MsgBox) {
		var st = value;
		value = b+"\n"+st;
	}
	with (document.Feedback.Messages) {
		var st = value;
		value = b+"\n"+st;
	}
	
	var ScriptCompleted = (b.indexOf("Script completed")==-1);
	
	// The following (optionally) records content to a global variable
	if (CaptureMsgs=="true")
		{ if ((b.indexOf("Jmol executing")==-1) && (ScriptCompleted))
			{ MsgStore += b + "\n"; } }
			
	if (Processing) {
		if (ScriptCompleted) {
			Processing = false;
			jmolScript(StartUpScript);
		}
	}

	// the following responds to a prior request from ShowOr
	if (WaitingForO=="true") {
		var istart = b.indexOf("moveto ");
		if (istart>-1) {
			WaitingForO = "false";
			with (document.EnviroForm) {
				st = b.substring(istart,b.indexOf("OR")-2);
				CurrOr.value = st;
				DoEnviroForm();
			}
	 	 }
  	}

	// If the system was waiting for a completed message to be sent
	//   then do something
	if (b.indexOf("Script completed")>-1)
		{
		if (CaptureMsgs=="true")
			{
			CaptureMsgs="false";
			DisplayHeaderWrap();
			}
		}	
	LastMsgSet = b;
	
	//alert("showmsg: " + a + " !! " + b);
}

// All writing to the HTML document body must go through here
function DocWrite(st) {
  document.writeln(st);
  if (NewDebug) { BigMemory += st };
}

//==================== Special section for User DIVs ============

// Only the first function should be called by the User

// Called by the User. It marks the beginning of a new user-defined DIV.
//  It writes the necessary code to start a new DIV (and finish the previous),
//    but also adds to the global arrays UserMenuList and UserDscr
//  By default, the DIV defined first is visible. The rest are hidden.
function StartNewDiv(DivName,Dscr,LastUpDate) {
  if (LastUserDiv=="") LastUserDiv = DivName;
  if (UserMenuList.length==0) 
		{ DocWrite(DivStartTagC("UserParent","UserParent")); }

  UserMenuList[UserMenuList.length] = DivName;
  UserDscr[UserDscr.length] = Dscr + " (last updated " + LastUpDate + ")";
  var st = (UserMenuList.length>1) ? "</DIV>" : "";

  st += DivStartTagC(DivName,"UserContent");
  DocWrite(st);
}

// ===================================

// This is used when the user clicks on a menu item in the UserMenuList
//  it hides all User Divs, and then enables the one passed
function ShowUserDiv(id)
{ var i=0;
  for(var i=0; i< UserMenuList.length; i++) 
		{ SetVisibility(UserMenuList[i],false);  }
  SetVisibility(id,true);
  LastUserDiv = id;
  ShowDiv("MainDiv");
  ReSetSizes();
}

// =============

// Writes a menu, using the table construct
// Called as a part of WrapUp, so that it knows what to draw
//   Gets information from the passed arrays UserMenuList and UserDscr
function WriteMenu(MenuItems,DescItems)
{
 // Define a DIV for this menu, at the top of the enclosing DIV
 var st = DivStartTagC("UserMenuDiv","UserMenu");
 var n = MenuItems.length;
 var pWid = Math.round(100/n);
 var mWid = Math.round((sideBarWid)/n);
 //var FrntSt = "\<TD width=\"" + mWid + "\"\>\<A HREF=\"javascript:ShowUserDiv(\'";
 var FrntSt = "\<TD width=\"" + pWid + "%\"\>\<A HREF=\"javascript:ShowUserDiv(\'";
  //alert(FrntSt);
 var MidSt1 = "\')\" title=\'";
 var MidSt2 = "\'\>";
 var EndSt = "\<\/A\>\<\/TD\>";

 // Write a table containing the menu elements, then close this DIV
 st += "\<TABLE BORDER=\"0\" CELLSPACING=\"2\" CELLPADDING=\"1\" BGCOLOR=\"#FFFFCC\"\>";
 st += "\<TR ALIGN=\"center\" VALIGN=\"top\"\>";
 for(var i=0; i< n; i++) {
	st += FrntSt + MenuItems[i] + MidSt1 + DescItems[i] + MidSt2 + MenuItems[i] + EndSt;
 }
 st += "\<\/TABLE\>" + endDIV;
 DocWrite(st);
}

// ============

// Used by following function
function SetDivHeight(velement,pxhgt) {
   if (GetObj(velement)) { GetObj(velement).style.height = pxhgt+"px"; }
}

// Called whenever a window is re-sized (added 3-31-06)
//  Note that the "BODY" element must now include a call to this function on resize)
//    within the BODY tag include:   onResize="ReSetSizes()"
function ReSetSizes() {
  jHgt = (window.innerHeight) ? window.innerHeight : document.body.offsetHeight;
	
  //Reset Main Left DIV's
  var menuHeight = GetObj("MenuD").offsetHeight;
  var hgtpx = jHgt-menuHeight;
  for (var i=0; i< MainMenuList.length; i++)
	 { SetDivHeight(MainMenuList[i],hgtpx); }	
  SetDivHeight("LeftPanel",hgtpx);

  // Reset User Div's, if any
  if (UserMenuList.length>0) {
	hgtpx = hgtpx - GetObj("UserMenuDiv").offsetHeight;
	SetDivHeight("UserParent",hgtpx);
    for (var i=0; i< UserMenuList.length; i++) 
		{ SetDivHeight(UserMenuList[i],hgtpx); }
  }
}

// ====================

// This code is called once, below, to create the DIV containing the applet
// Prepare the DIV layer to contain the applet, but don't yet write it
function CreateAppletDiv() {
  //Figure out dimensions of the browser window
  //Safari doesn't return final value, so have to set manually for now
  sideBarWid = (navigator.userAgent.indexOf("Safari")!=-1) ? 290 : GetObj("LeftParent").offsetWidth;
  if (window.innerWidth) {
	jWid = window.innerWidth;
	jHgt = window.innerHeight;
  } else {
	// Apparently, in IE this doesn't work until after the entire <BODY> has loaded
	//   so this doesn't work properly now - Help!
	jWid = document.body.offsetWidth;
	jHgt = document.body.offsetHeight;
  };
  
  jWid = jWid - sideBarWid - ((navigator.userAgent.indexOf("Safari")!=-1) ? 25 : 15);
  jHgt = jHgt - cmdHgt - ((navigator.userAgent.indexOf("Safari")!=-1) ? 30 : 18);

  var st_AppDiv = DivStartTagC("Appd","JmolApp");
						
  jmolSetAppletColor("white", "black", "white", "white");

  var LoadScript = "load " + pdbFileG;
  if (scrptfileG) LoadScript += ";script " + scrptfileG;

  // Write the JMol applet within this DIV
   jmolSetDocument(0);
   var s = jmolApplet([jWid,jHgt], LoadScript);
   var sext = "";
     sext = "\n<param name='MessageCallback' value='" + "showmsg" + "' />";
     s = s.replace(/\<param/, sext + "\n<param");
     sext = "";
     sext = "\n<param name='PickCallback' value='" + "showpick" + "' />";
     s = s.replace(/\<param/, sext + "\n<param");
 
  //Restore direct writing by Jmol.js calls
  jmolSetDocument(document);

  // Write a form containing a box for user-entered commands, then close the DIV
  var cmdWid = Math.round(jWid/7) - 21;
  var st_CB = "\n\n\<form name=\"cline\" onSubmit="
  	+ "\"run(document.cline.jmscript.value);document.cline.jmscript.select();"
  	+ "document.cline.jmscript.value=''; return false\"\>";

  	if (OneLineCmdBarG) st_CB += "\<input name=\"jmscript\" type=\"text\" value=\"Enter single Jmol commands here\" "
  	+ "onfocus=\"if (this.value=='Enter single Jmol commands here') this.value=''\" size=\""+cmdWid+"\" "
	+ "maxlength=\"200\" " + fntstyl + "\>";

  // Write boxes for parsed picking stuff
  st_CB +=  "\<input name=\"Res\" value=\"Res\" size=5 " + fntstyl + " \>"
	+ "\<input name=\"ResNo\" value=\"ResNo\" size=5 " + fntstyl + " \>"
	+ "\<input name=\"Chain\" value=\"Ch\" size=2 " + fntstyl + " \>"
	+ "\<input name=\"Atom\" value=\"Atom\" size=5 " + fntstyl + " \>"
	+ "\<input name=\"AtomNo\" value=\"AtomNo\" size=6 " + fntstyl + " \>";
	
  if (!OneLineCmdBarG) { st_CB += "\<input name=\"FullCall\" value=\"\" size=20 " + fntstyl + " \>"; }


  // Write a box for pickingcallback stuff
  if (OneLineCmdBarG) st_CB += "\<br\>\<textarea name='MsgBox' "
	+ "  cols=\"" + (cmdWid-2) + "\" rows=4" + fntstyl + " \>"
	+ "\<\/textarea\>";

  // Write a box for messsagecallback stuff
  if (OneLineCmdBarG) st_CB += "\<textarea name='PickBox' "
	+ "  cols=\"24\" rows=3" + fntstyl + "\>"
	+ "\<\/textarea\>";
  	
  st_CB += "\<\/form\>";

  st_CB += endDIV;  // Closes up the AppDiv

  return st_AppDiv + s + st_CB;

}

//================================================================
//======== These draw the bulk of the page for the user ==========

// Define and write a Jmol Applet, sized dynamically
//
//	Arguments to the function JmolAppl are:
//
//	       pdbfile:  the name of the pdb coordinate file
//	     scrptfile:  the name of a default script file to run after loading
//          PDBid:  the PDB identifier for this structure
//         StDescr:  a description of the structure (eg, name of the protein)
//        Citation:  journal reference for the structure presented
//        PubMedID:  PubMed ID for the above journal reference
//          Author:  name of the author of this particular presentation
//     LastUpdated:  Date this particular presentation was last updated
//
//			== the following paramters are optional ==
//
//     SupportPath:  the path to the support folder (default: same folder)
//
//   No longer supported:
//      sideBarWid: width, in pixels, of the sidebar (default: 290)

function JmolAppl(pdbfile,scrptfile,PDBidSet,StDescrSet,Citation,PubMedID,
                  Author,LastUpdated,SupportPath,UnUsedParam1,OneLineCmdBar) 
{
  var UseSignedAppl;
  if (OneLineCmdBarG) OneLineCmdBarG = OneLineCmdBar;
  PDBid = PDBidSet;
  StDescr = StDescrSet;
  pdbFileG = pdbfile;
  scrptfileG = scrptfile;

  if (! SupportPath) SupportPath = "./";
  var CSSPath = SupportPath + "JmolShell.css";

  // Load the style sheet
  DocWrite("\<link rel=\"stylesheet\" href=\"" + CSSPath + "\" type=\"text\/css\"\>");

  // vertical height for the single command line entry box
  if (!OneLineCmdBarG) cmdHgt = 0;

  // Figure out if being called locally or via the net
  jmolDebugAlert(JmolDebugStatus);
  if (JmolDebugStatus) alert("JmolDebugStatus on");
  UseSignedAppl = (document.location.host=="");

  // First, call a setup routine in Jmol.js
  jmolInitialize(SupportPath,UseSignedAppl);
  jmolCheckBrowser("alert","This browser does not fully support Jmol. " + 
	"Some functions are limited.");

  // Update the SupportPath and other global variables from calling params
  AuthorG = Author;
  CitationG = Citation;
  PubMedIDG = PubMedID;
  ResetFileG = scrptfile;
  LastUpdatedG = LastUpdated;

  FontSzG = ((navigator.appVersion.indexOf("Mac") != -1)) ? 12 : 10;
  CrLf = ((navigator.appVersion.indexOf("Mac") != -1)) ? "\r" : "\n";

  // change the title of the window to a description of the structure
  document.title = PDBid+" - "+StDescr;

//    Layout of "DIV" elements (Main, About, Cmd, Help overlap each other)
// +----------+-----------------------------------------+
// |			|									|
// |	MenuD	|									|
// |			|									|
// +---------+									|
// |			|			Appd					|
// |	Main	|									|
// |	About	|									|
// |	Cmd	|									|
// |	Help	|									|
// |			|									|
// +----------+-----------------------------------------+


// ------------ Next, draw the 'MenuD' DIV box to the top left --------------

  var stTop = DivStartTagC("LeftParent", "LeftParent");
				
  DocWrite(stTop);

// Draw the menu at the top
  var st_Menu = DivStartTagC("MenuD","MainMenu")
 	+ NavLink("MainDiv","Main","The descriptive content for this molecule")
		+ " | " 		
	+ NavLink("About","About","Information about this molecule and about JmolShell. Literature citation.")
		+ " | "
	+ NavLink("CmdDiv","Cmd","A box to enter multiple Jmol commands. Record and get feedback as well.")
		+ " | "		
	+ NavLink("PreSetsDiv","Presets","Execute Jmol commands by example")
		+ " | "
	+ NavLink("HelpDiv","Help","Help on using Jmol. Links to documentation.");
	
	if (NewDebug) { 
		st_Menu += " | " + NavLink("DebugDiv","D","Debugging info");}
	
	st_Menu += " || "
	+ "\<a href=\"javascript:Reset()\" title=\"Reset structure to starting point\"\>Reset\<\/a\>"
	+ HR + SpanWrap("loading...","","","TagLineSpan")
	+ endDIV;
  DocWrite(st_Menu);

  DocWrite( DivStartTagC("LeftPanel", "LeftPanel") );

// ------- Next, draw the 'MainDiv,About,Help,&Cmd' DIV boxes to the left ----------

// Draw the left-content, multiple times overlapping
// All but the MainDiv panel are set to invisible for now.
// MainDiv must be last and is left open-ended, since user content in the calling page will follow

  MainMenuList = ["MainDiv","About","CmdDiv","PreSetsDiv","HelpDiv","DebugDiv"];
  var st_DIVs = DivStartTagC("About","MainContent") +jAbout() + endDIV;
  	st_DIVs += DivStartTagC("CmdDiv","MainContent") + CmdLineHTML + endDIV;
  	st_DIVs += DivStartTagC("HelpDiv","MainContent") + HelpHTML + endDIV;
  	st_DIVs += DivStartTagC("PreSetsDiv","MainContent") + PresetsHTML + endDIV;
  	st_DIVs += DivStartTagC("DebugDiv","MainContent") + DebugDivHTML + endDIV;
  DocWrite(st_DIVs);

  // Finally, write the MainDiv (User) LeftDiv
  DocWrite( DivStartTagC("MainDiv","MainContent") );

}

// =================================================================

// Call this after the User's HTML
function WrapUpPage()
{ 
  // If the user defined User (sub-) DIV's, wrap that up and write a menu for it
  if (UserMenuList.length>0) {
	DocWrite(endDIV+endDIV);     //Close off the last user DIV and UserParentDiv
	WriteMenu(UserMenuList,UserDscr);
	DocWrite(endDIV);
   }

  // Close off the "LeftParent" and "MainDiv"  and "LeftPanel" DIVs
  DocWrite( endDIV + endDIV + endDIV );

  ShowDiv("MainDiv");
  SetVisibility(UserMenuList[0],true);

  // Write the code that draws the Jmol applet
  DocWrite(CreateAppletDiv());

  if (NewDebug) { document.DebugDivForm.DebugDivField.value = BigMemory; }
	
  // Update the Tag Line
  SetTagLine(PDBid, StDescr,CitationG);

  ReSetSizes();

  run(StartUpScript);
}

