/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.viewer.Atom;
import org.jmol.viewer.AtomIterator;
import org.jmol.viewer.Bond;
import org.jmol.viewer.SelectionIndependentShape;
import org.jmol.viewer.Util;

class Polyhedra
extends SelectionIndependentShape {
    int polyhedronCount;
    Polyhedron[] polyhedrons = new Polyhedron[32];
    float radius;
    int drawEdges;
    static final int EDGES_NONE = 0;
    static final int EDGES_ALL = 1;
    static final int EDGES_FRONT = 2;
    Atom[] otherAtoms = new Atom[6];
    static final boolean CHECK_ELEMENT = false;
    final Vector3f vectorAB = new Vector3f();
    final Vector3f vectorAC = new Vector3f();
    final Vector3f vectorAX = new Vector3f();
    final Vector3f faceNormalABC = new Vector3f();
    static final byte[] tetrahedronFaces = new byte[]{0, 1, 2, 0, 2, 3, 0, 3, 1, 1, 3, 2};
    static final byte[] octahedronFaces = new byte[]{0, 1, 2, 0, 2, 3, 0, 3, 4, 0, 4, 1, 5, 2, 1, 5, 3, 2, 5, 4, 3, 5, 1, 4};
    static final short[] polyhedronNormixes = new short[8];
    final Atom[] otherAtomsT = new Atom[6];

    Polyhedra() {
    }

    void initShape() {
    }

    void setProperty(String propertyName, Object value, BitSet bs) {
        if ("bonds" == propertyName) {
            this.deletePolyhedra(bs);
            this.buildBondsPolyhedra(bs);
            return;
        }
        if ("delete" == propertyName) {
            this.deletePolyhedra(bs);
            return;
        }
        if ("on" == propertyName) {
            this.setVisible(true, bs);
            return;
        }
        if ("off" == propertyName) {
            this.setVisible(false, bs);
            return;
        }
        if ("noedges" == propertyName) {
            this.drawEdges = 0;
            return;
        }
        if ("edges" == propertyName) {
            this.drawEdges = 1;
            return;
        }
        if ("frontedges" == propertyName) {
            this.drawEdges = 2;
            return;
        }
        if ("color" == propertyName) {
            this.colix = Graphics3D.getColix((Object)value);
            this.setColix(this.colix, this.colix != 3 ? null : (String)value, bs);
            return;
        }
        if ("translucency" == propertyName) {
            this.colix = Graphics3D.getColix((Object)value);
            this.setTranslucent("translucent" == value, bs);
            return;
        }
        if ("radius" == propertyName) {
            this.radius = ((Float)value).floatValue();
            return;
        }
        if ("expression" == propertyName) {
            BitSet bsVertices = (BitSet)value;
            this.deletePolyhedra(bs);
            this.buildRadiusPolyhedra(bs, this.radius, bsVertices);
            return;
        }
    }

    void deletePolyhedra(BitSet bs) {
        int i;
        int newCount = 0;
        for (i = 0; i < this.polyhedronCount; ++i) {
            Polyhedron p = this.polyhedrons[i];
            if (bs.get(p.centralAtom.atomIndex)) continue;
            this.polyhedrons[newCount++] = p;
        }
        for (i = newCount; i < this.polyhedronCount; ++i) {
            this.polyhedrons[i] = null;
        }
        this.polyhedronCount = newCount;
    }

    void setVisible(boolean visible, BitSet bs) {
        int i = this.polyhedronCount;
        while (--i >= 0) {
            Polyhedron p = this.polyhedrons[i];
            if (p == null || !bs.get(p.centralAtom.atomIndex)) continue;
            p.visible = visible;
        }
    }

    void setColix(short colix, String palette, BitSet bs) {
        int i = this.polyhedronCount;
        while (--i >= 0) {
            int atomIndex;
            Polyhedron p = this.polyhedrons[i];
            if (p == null || !bs.get(atomIndex = p.centralAtom.atomIndex)) continue;
            p.polyhedronColix = colix != 3 ? colix : this.viewer.getColixAtomPalette(this.frame.getAtomAt(atomIndex), palette);
        }
    }

    void setTranslucent(boolean isTranslucent, BitSet bs) {
        int i = this.polyhedronCount;
        while (--i >= 0) {
            Polyhedron p = this.polyhedrons[i];
            if (p == null || !bs.get(p.centralAtom.atomIndex)) continue;
            p.polyhedronColix = Graphics3D.setTranslucent((short)p.polyhedronColix, (boolean)isTranslucent);
        }
    }

    void savePolyhedron(Polyhedron p) {
        if (this.polyhedronCount == this.polyhedrons.length) {
            this.polyhedrons = (Polyhedron[])Util.doubleLength(this.polyhedrons);
        }
        this.polyhedrons[this.polyhedronCount++] = p;
    }

    void buildBondsPolyhedra(BitSet bs) {
        int i = this.frame.atomCount;
        while (--i >= 0) {
            Polyhedron p;
            if (!bs.get(i) || (p = this.constructBondsPolyhedron(i)) == null) continue;
            this.savePolyhedron(p);
        }
    }

    Polyhedron constructBondsPolyhedron(int atomIndex) {
        Atom atom = this.frame.getAtomAt(atomIndex);
        Bond[] bonds = atom.bonds;
        int bondedElementNumber = -1;
        if (bonds == null) {
            return null;
        }
        int bondCount = bonds.length;
        if (bondCount == 4 || bondCount == 6) {
            int i = bondCount;
            while (--i >= 0) {
                Atom otherAtom;
                Bond bond = bonds[i];
                this.otherAtoms[i] = otherAtom = bond.atom1 == atom ? bond.atom2 : bond.atom1;
            }
            return this.validatePolyhedron(atom, bondCount, this.otherAtoms);
        }
        return null;
    }

    void buildRadiusPolyhedra(BitSet bs, float radius, BitSet bsVertices) {
        int i = this.frame.atomCount;
        while (--i >= 0) {
            Polyhedron p;
            if (!bs.get(i) || (p = this.constructRadiusPolyhedron(i, radius, bsVertices)) == null) continue;
            this.savePolyhedron(p);
        }
    }

    Polyhedron constructRadiusPolyhedron(int atomIndex, float radius, BitSet bsVertices) {
        Atom atom = this.frame.getAtomAt(atomIndex);
        int otherAtomCount = 0;
        AtomIterator withinIterator = this.frame.getWithinModelIterator(atom, radius);
        while (withinIterator.hasNext()) {
            Atom other = withinIterator.next();
            if (other == atom || bsVertices != null && !bsVertices.get(other.atomIndex)) continue;
            if (otherAtomCount < 6) {
                this.otherAtoms[otherAtomCount++] = other;
                continue;
            }
            ++otherAtomCount;
            break;
        }
        Polyhedron p = this.validatePolyhedron(atom, otherAtomCount, this.otherAtoms);
        int i = 6;
        while (--i >= 0) {
            this.otherAtoms[i] = null;
        }
        return p;
    }

    Polyhedron validatePolyhedron(Atom centralAtom, int vertexCount, Atom[] otherAtoms) {
        int faceCount;
        byte[] faces;
        if (vertexCount == 6) {
            this.arrangeOctahedronVertices(centralAtom, otherAtoms);
            faces = octahedronFaces;
            faceCount = 8;
        } else if (vertexCount == 4) {
            this.arrangeTetrahedronVertices(centralAtom, otherAtoms);
            faces = tetrahedronFaces;
            faceCount = 4;
        } else {
            return null;
        }
        Point3f pointCentral = centralAtom.point3f;
        int j = 0;
        for (int i = 0; i < faceCount; ++i) {
            byte indexA = faces[j++];
            Point3f pointA = otherAtoms[indexA].point3f;
            byte indexB = faces[j++];
            Point3f pointB = otherAtoms[indexB].point3f;
            byte indexC = faces[j++];
            Point3f pointC = otherAtoms[indexC].point3f;
            this.vectorAB.sub((Tuple3f)pointB, (Tuple3f)pointA);
            this.vectorAC.sub((Tuple3f)pointC, (Tuple3f)pointA);
            this.faceNormalABC.cross(this.vectorAB, this.vectorAC);
            this.vectorAX.sub((Tuple3f)pointCentral, (Tuple3f)pointA);
            if (this.faceNormalABC.dot(this.vectorAX) >= 0.0f) {
                return null;
            }
            int k = vertexCount;
            while (--k >= 0) {
                if (k == indexA || k == indexB || k == indexC) continue;
                this.vectorAX.sub((Tuple3f)otherAtoms[k].point3f, (Tuple3f)pointA);
                if (!(this.faceNormalABC.dot(this.vectorAX) >= 0.0f)) continue;
                return null;
            }
            Polyhedra.polyhedronNormixes[i] = this.g3d.getNormix(this.faceNormalABC);
        }
        return new Polyhedron(centralAtom, vertexCount, faceCount, otherAtoms, polyhedronNormixes);
    }

    void arrangeTetrahedronVertices(Atom centralAtom, Atom[] otherAtoms) {
        Point3f pointCentral = centralAtom.point3f;
        Point3f point0 = otherAtoms[0].point3f;
        Point3f point1 = otherAtoms[1].point3f;
        this.vectorAB.sub((Tuple3f)point1, (Tuple3f)point0);
        this.vectorAC.sub((Tuple3f)pointCentral, (Tuple3f)point0);
        this.faceNormalABC.cross(this.vectorAB, this.vectorAC);
        Atom atomT = otherAtoms[2];
        this.vectorAX.sub((Tuple3f)atomT.point3f, (Tuple3f)point0);
        if (this.faceNormalABC.dot(this.vectorAX) < 0.0f) {
            otherAtoms[2] = otherAtoms[3];
            otherAtoms[3] = atomT;
        }
    }

    void arrangeOctahedronVertices(Atom centralAtom, Atom[] otherAtoms) {
        Atom atom2;
        Atom atom4;
        int i = 6;
        while (--i >= 0) {
            this.otherAtomsT[i] = otherAtoms[i];
        }
        Atom atom0 = otherAtoms[0] = this.getFarthestAtom(centralAtom, this.otherAtomsT);
        Atom atom5 = otherAtoms[5] = this.getFarthestAtom(atom0, this.otherAtomsT);
        Atom atom1 = otherAtoms[1] = this.getFarthestAtom(centralAtom, this.otherAtomsT);
        otherAtoms[3] = this.getFarthestAtom(atom1, this.otherAtomsT);
        this.vectorAB.sub((Tuple3f)atom5.point3f, (Tuple3f)atom0.point3f);
        this.vectorAC.sub((Tuple3f)atom1.point3f, (Tuple3f)atom0.point3f);
        this.faceNormalABC.cross(this.vectorAB, this.vectorAC);
        Atom atomT = this.getFarthestAtom(centralAtom, this.otherAtomsT);
        this.vectorAX.sub((Tuple3f)atomT.point3f, (Tuple3f)atom0.point3f);
        Atom atomT1 = this.getFarthestAtom(centralAtom, this.otherAtomsT);
        if (this.faceNormalABC.dot(this.vectorAX) > 0.0f) {
            atom4 = atomT;
            atom2 = atomT1;
        } else {
            atom2 = atomT;
            atom4 = atomT1;
        }
        otherAtoms[2] = atom2;
        otherAtoms[4] = atom4;
    }

    Atom getFarthestAtom(Atom atomA, Atom[] atoms) {
        Point3f point3f = atomA.point3f;
        float dist2Max = 0.0f;
        int indexFarthest = -1;
        int i = atoms.length;
        while (--i >= 0) {
            float dist2;
            Atom atom = atoms[i];
            if (atom == null || !((dist2 = point3f.distance(atom.point3f)) > dist2Max)) continue;
            dist2Max = dist2;
            indexFarthest = i;
        }
        Atom atomFarthest = atoms[indexFarthest];
        atoms[indexFarthest] = null;
        return atomFarthest;
    }

    class Polyhedron {
        final Atom centralAtom;
        final Atom[] vertices;
        boolean visible;
        final short[] normixes;
        short polyhedronColix;

        Polyhedron(Atom centralAtom, int vertexCount, int faceCount, Atom[] otherAtoms, short[] normixes) {
            this.centralAtom = centralAtom;
            this.vertices = new Atom[vertexCount];
            this.visible = true;
            this.polyhedronColix = Polyhedra.this.colix;
            this.normixes = new short[faceCount];
            int i = vertexCount;
            while (--i >= 0) {
                this.vertices[i] = otherAtoms[i];
            }
            i = faceCount;
            while (--i >= 0) {
                this.normixes[i] = normixes[i];
            }
        }
    }
}

