/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.io.BufferedReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.CmlReader;
import org.xml.sax.Attributes;

class MolproReader
extends CmlReader {
    MolproReader() {
    }

    AtomSetCollection readAtomSetCollection(BufferedReader reader) throws Exception {
        return this.readAtomSetCollectionXml(reader, new MolproHandler(), "molpro");
    }

    class MolproHandler
    extends CmlReader.CmlHandler {
        private String normalCoordinateTag = "normalCoordinate";
        private String vibrationsTag = "vibrations";
        int frequencyCount;

        MolproHandler() {
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) {
            this.processStartElement(namespaceURI, localName, qName, atts);
            this.molproStartElement(namespaceURI, localName, qName, atts);
        }

        public void molproStartElement(String namespaceURI, String localName, String qName, Attributes atts) {
            if (this.normalCoordinateTag.equals(localName)) {
                String wavenumber = "";
                MolproReader.this.atomSetCollection.cloneLastAtomSet();
                ++this.frequencyCount;
                int i = atts.getLength();
                while (--i >= 0) {
                    String attLocalName = atts.getLocalName(i);
                    String attValue = atts.getValue(i);
                    if ("wavenumber".equals(attLocalName)) {
                        wavenumber = attValue;
                        continue;
                    }
                    if (!"units".equals(attLocalName)) continue;
                }
                MolproReader.this.atomSetCollection.setAtomSetProperty("Frequency", wavenumber + " cm**-1");
                this.keepChars = true;
                return;
            }
            if (this.vibrationsTag.equals(localName)) {
                this.frequencyCount = 0;
                return;
            }
        }

        public void endElement(String uri, String localName, String qName) {
            this.processEndElement(uri, localName, qName);
            this.molproProcessEndElement(uri, localName, qName);
            this.keepChars = false;
            this.title = null;
            this.dictRef = null;
            this.chars = null;
        }

        public void molproProcessEndElement(String uri, String localName, String qName) {
            if (this.normalCoordinateTag.equals(localName)) {
                int atomCount = MolproReader.this.atomSetCollection.getLastAtomSetAtomCount();
                this.tokens = MolproReader.this.getTokens(this.chars);
                int offset = this.tokens.length - atomCount * 3;
                for (int i = 0; i < atomCount; ++i) {
                    Atom atom = MolproReader.this.atomSetCollection.atoms[i + MolproReader.this.atomSetCollection.currentAtomSetIndex * atomCount];
                    atom.vectorX = MolproReader.this.parseFloat(this.tokens[offset++]);
                    atom.vectorY = MolproReader.this.parseFloat(this.tokens[offset++]);
                    atom.vectorZ = MolproReader.this.parseFloat(this.tokens[offset++]);
                }
            }
        }
    }
}

