/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.io.BufferedReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;

class ShelxReader
extends AtomSetCollectionReader {
    boolean endReached;
    String[] sfacElementSymbols;
    static final String[] supportedRecordTypes = new String[]{"TITL", "CELL", "SPGR", "END ", "SFAC"};
    static final String[] unsupportedRecordTypes = new String[]{"ZERR", "LATT", "SYMM", "DISP", "UNIT", "LAUE", "REM ", "MORE", "TIME", "HKLF", "OMIT", "SHEL", "BASF", "TWIN", "EXTI", "SWAT", "HOPE", "MERG", "SPEC", "RESI", "MOVE", "ANIS", "AFIX", "HFIX", "FRAG", "FEND", "EXYZ", "EXTI", "EADP", "EQIV", "CONN", "PART", "BIND", "FREE", "DFIX", "DANG", "BUMP", "SAME", "SADI", "CHIV", "FLAT", "DELU", "SIMU", "DEFS", "ISOR", "NCSY", "SUMP", "L.S.", "CGLS", "BLOC", "DAMP", "STIR", "WGHT", "FVAR", "BOND", "CONF", "MPLA", "RTAB", "HTAB", "LIST", "ACTA", "SIZE", "TEMP", "WPDB", "FMAP", "GRID", "PLAN", "MOLE", "    "};

    ShelxReader() {
    }

    AtomSetCollection readAtomSetCollection(BufferedReader reader) throws Exception {
        String line;
        this.atomSetCollection = new AtomSetCollection("shelx");
        this.atomSetCollection.coordinatesAreFractional = true;
        block0: while ((line = reader.readLine()) != null) {
            int lineLength = line.length();
            while (lineLength > 0 && line.charAt(lineLength - 1) == '=') {
                line = line.substring(0, lineLength - 1) + reader.readLine();
            }
            if (lineLength < 4) {
                if (lineLength != 3 || !"END".equalsIgnoreCase(line)) continue;
                break;
            }
            String command = line.substring(0, 4).toUpperCase();
            int i = unsupportedRecordTypes.length;
            while (--i >= 0) {
                if (!command.equals(unsupportedRecordTypes[i])) continue;
                continue block0;
            }
            i = supportedRecordTypes.length;
            while (--i >= 0) {
                if (!command.equals(supportedRecordTypes[i])) continue;
                this.processSupportedRecord(i, line);
                if (!this.endReached) continue block0;
                break block0;
            }
            this.assumeAtomRecord(line);
        }
        return this.atomSetCollection;
    }

    void processSupportedRecord(int recordIndex, String line) throws Exception {
        switch (recordIndex) {
            case 0: {
                this.atomSetCollection.collectionName = this.parseTrimmed(line, 4);
                break;
            }
            case 1: {
                this.cell(line);
                break;
            }
            case 2: {
                this.atomSetCollection.spaceGroup = this.parseTrimmed(line, 4);
                break;
            }
            case 3: {
                this.endReached = true;
                break;
            }
            case 4: {
                this.parseSfacRecord(line);
            }
        }
    }

    void cell(String line) throws Exception {
        float wavelength = this.parseFloat(line, 4);
        float[] notionalUnitcell = new float[6];
        for (int i = 0; i < 6; ++i) {
            notionalUnitcell[i] = this.parseFloat(line, this.ichNextParse);
        }
        this.atomSetCollection.wavelength = wavelength;
        this.atomSetCollection.notionalUnitcell = notionalUnitcell;
    }

    void parseSfacRecord(String line) {
        String[] sfacTokens = this.getTokens(line, 4);
        boolean allElementSymbols = true;
        int i = sfacTokens.length;
        while (allElementSymbols && --i >= 0) {
            String token = sfacTokens[i];
            allElementSymbols = Atom.isValidElementSymbolNoCaseSecondChar(token);
        }
        if (allElementSymbols) {
            this.parseSfacElementSymbols(sfacTokens);
        } else {
            this.parseSfacCoefficients(sfacTokens);
        }
    }

    void parseSfacElementSymbols(String[] sfacTokens) {
        if (this.sfacElementSymbols == null) {
            this.sfacElementSymbols = sfacTokens;
        } else {
            int oldCount = this.sfacElementSymbols.length;
            int tokenCount = sfacTokens.length;
            this.sfacElementSymbols = AtomSetCollectionReader.setLength(this.sfacElementSymbols, oldCount + tokenCount);
            int i = tokenCount;
            while (--i >= 0) {
                this.sfacElementSymbols[oldCount + tokenCount] = sfacTokens[i];
            }
        }
    }

    void parseSfacCoefficients(String[] sfacTokens) {
        float a1 = this.parseFloat(sfacTokens[1]);
        float a2 = this.parseFloat(sfacTokens[3]);
        float a3 = this.parseFloat(sfacTokens[5]);
        float a4 = this.parseFloat(sfacTokens[7]);
        float c = this.parseFloat(sfacTokens[9]);
        int z = (int)(a1 + a2 + a3 + a4 + c + 0.5f);
        String elementSymbol = AtomSetCollectionReader.getElementSymbol(z);
        int oldCount = 0;
        if (this.sfacElementSymbols == null) {
            this.sfacElementSymbols = new String[1];
        } else {
            oldCount = this.sfacElementSymbols.length;
            this.sfacElementSymbols = AtomSetCollectionReader.setLength(this.sfacElementSymbols, oldCount + 1);
            this.sfacElementSymbols[oldCount] = elementSymbol;
        }
        this.sfacElementSymbols[oldCount] = elementSymbol;
    }

    void assumeAtomRecord(String line) {
        try {
            int elementIndex;
            String atomName = this.parseToken(line);
            int scatterFactor = this.parseInt(line, this.ichNextParse);
            float a = this.parseFloat(line, this.ichNextParse);
            float b = this.parseFloat(line, this.ichNextParse);
            float c = this.parseFloat(line, this.ichNextParse);
            Atom atom = this.atomSetCollection.addNewAtom();
            atom.atomName = atomName;
            if (this.sfacElementSymbols != null && (elementIndex = scatterFactor - 1) >= 0 && elementIndex < this.sfacElementSymbols.length) {
                atom.elementSymbol = this.sfacElementSymbols[elementIndex];
            }
            atom.x = a;
            atom.y = b;
            atom.z = c;
        }
        catch (Exception ex) {
            this.logger.log("Exception", (Object)ex, (Object)line);
        }
    }
}

