/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.io.BufferedReader;
import java.util.StringTokenizer;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.LimitedLineReader;
import org.jmol.api.JmolAdapter;

class Resolver {
    static final String[] pdbRecords = new String[]{"HEADER", "OBSLTE", "TITLE ", "CAVEAT", "COMPND", "SOURCE", "KEYWDS", "EXPDTA", "AUTHOR", "REVDAT", "SPRSDE", "JRNL  ", "REMARK", "DBREF ", "SEQADV", "SEQRES", "MODRES", "HELIX ", "SHEET ", "TURN  ", "CRYST1", "ORIGX1", "ORIGX2", "ORIGX3", "SCALE1", "SCALE2", "SCALE3", "ATOM  ", "HETATM", "MODEL "};
    static final String[] shelxRecords = new String[]{"TITL ", "ZERR ", "LATT ", "SYMM ", "CELL "};
    static final String[] cifRecords = new String[]{"data_", "_publ"};
    static final String[] ghemicalMMRecords = new String[]{"!Header mm1gp", "!Header gpr"};
    static final String[] jaguarRecords = new String[]{"  |  Jaguar version"};
    static final String[] hinRecords = new String[]{"mol "};
    static final String[] mdlRecords = new String[]{"$MDL "};
    static final String[] nwchemRecords = new String[]{" argument  1"};
    static final String[] spartanSmolRecords = new String[]{"INPUT="};
    static final String[][] startsWithRecords = new String[][]{pdbRecords, shelxRecords, cifRecords, ghemicalMMRecords, jaguarRecords, hinRecords, mdlRecords, nwchemRecords, spartanSmolRecords};
    static final String[] startsWithFormats = new String[]{"Pdb", "Shelx", "Cif", "GhemicalMM", "Jaguar", "Hin", "Mol", "NWChem", "SpartanSmol"};
    static final String[] molproRecords = new String[]{"http://www.molpro.net/schema/molpro"};
    static final String[] cmlRecords = new String[]{"<?xml", "<atom", "<molecule", "<reaction", "<cml", "<bond", ".dtd\"", "<list>", "<entry", "<identifier", "http://www.xml-cml.org/schema/cml2/core"};
    static final String[] gaussianRecords = new String[]{"Entering Gaussian System", "Entering Link 1", "1998 Gaussian, Inc."};
    static final String[] mopacRecords = new String[]{"MOPAC 93 (c) Fujitsu", "MOPAC2002 (c) Fujitsu", "MOPAC FOR LINUX (PUBLIC DOMAIN VERSION)"};
    static final String[] qchemRecords = new String[]{"Welcome to Q-Chem", "A Quantum Leap Into The Future Of Chemistry"};
    static final String[] gamessRecords = new String[]{"GAMESS"};
    static final String[] spartanRecords = new String[]{"Spartan"};
    static final String[][] containsRecords = new String[][]{molproRecords, cmlRecords, gaussianRecords, mopacRecords, qchemRecords, gamessRecords, spartanRecords};
    static final String[] containsFormats = new String[]{"Molpro", "Cml", "Gaussian", "Mopac", "Qchem", "Gamess", "Spartan"};

    Resolver() {
    }

    static Object resolve(String name, BufferedReader bufferedReader, JmolAdapter.Logger logger) throws Exception {
        AtomSetCollectionReader atomSetCollectionReader;
        String atomSetCollectionReaderName = Resolver.determineAtomSetCollectionReader(bufferedReader, logger);
        logger.log("The Resolver thinks", atomSetCollectionReaderName);
        String className = "org.jmol.adapter.smarter." + atomSetCollectionReaderName + "Reader";
        if (atomSetCollectionReaderName == null) {
            return "unrecognized file format";
        }
        try {
            Class<?> atomSetCollectionReaderClass = Class.forName(className);
            atomSetCollectionReader = (AtomSetCollectionReader)atomSetCollectionReaderClass.newInstance();
        }
        catch (Exception e) {
            String err = "Could not instantiate:" + className;
            logger.log(err);
            return err;
        }
        atomSetCollectionReader.setLogger(logger);
        atomSetCollectionReader.initialize();
        AtomSetCollection atomSetCollection = atomSetCollectionReader.readAtomSetCollection(bufferedReader);
        atomSetCollection.freeze();
        if (atomSetCollection.errorMessage != null) {
            return atomSetCollection.errorMessage;
        }
        if (atomSetCollection.atomCount == 0) {
            return "No atoms in file";
        }
        return atomSetCollection;
    }

    static String determineAtomSetCollectionReader(BufferedReader bufferedReader, JmolAdapter.Logger logger) throws Exception {
        int k;
        String recordTag;
        int j;
        String[] recordTags;
        int i;
        String[] lines = new String[4];
        LimitedLineReader llr = new LimitedLineReader(bufferedReader, 16384);
        for (i = 0; i < lines.length; ++i) {
            lines[i] = llr.readLineWithNewline();
        }
        if (Resolver.checkMol(lines)) {
            return "Mol";
        }
        if (Resolver.checkXyz(lines)) {
            return "Xyz";
        }
        if (Resolver.checkFoldingXyz(lines)) {
            return "FoldingXyz";
        }
        if (Resolver.checkCube(lines)) {
            return "Cube";
        }
        for (i = 0; i < startsWithRecords.length; ++i) {
            recordTags = startsWithRecords[i];
            for (j = 0; j < recordTags.length; ++j) {
                recordTag = recordTags[j];
                for (k = 0; k < lines.length; ++k) {
                    if (!lines[k].startsWith(recordTag)) continue;
                    return startsWithFormats[i];
                }
            }
        }
        for (i = 0; i < containsRecords.length; ++i) {
            recordTags = containsRecords[i];
            for (j = 0; j < recordTags.length; ++j) {
                recordTag = recordTags[j];
                for (k = 0; k < lines.length; ++k) {
                    if (lines[k].indexOf(recordTag) == -1) continue;
                    return containsFormats[i];
                }
            }
        }
        if (lines[1] == null || lines[1].trim().length() == 0) {
            return "Jme";
        }
        return null;
    }

    static boolean checkMol(String[] lines) {
        if (lines[3].length() >= 6) {
            String line4trimmed = lines[3].trim();
            if (line4trimmed.endsWith("V2000") || line4trimmed.endsWith("v2000") || line4trimmed.endsWith("V3000")) {
                return true;
            }
            try {
                Integer.parseInt(lines[3].substring(0, 3).trim());
                Integer.parseInt(lines[3].substring(3, 6).trim());
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    static boolean checkXyz(String[] lines) {
        try {
            Integer.parseInt(lines[0].trim());
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    static boolean checkFoldingXyz(String[] lines) {
        try {
            StringTokenizer tokens = new StringTokenizer(lines[0].trim(), " \t");
            if (tokens != null && tokens.countTokens() >= 2) {
                Integer.parseInt(tokens.nextToken().trim());
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return false;
    }

    static boolean checkCube(String[] lines) {
        try {
            StringTokenizer tokens2 = new StringTokenizer(lines[2]);
            if (tokens2 == null || tokens2.countTokens() != 4) {
                return false;
            }
            Integer.parseInt(tokens2.nextToken());
            int i = 3;
            while (--i >= 0) {
                new Float(tokens2.nextToken());
            }
            StringTokenizer tokens3 = new StringTokenizer(lines[3]);
            if (tokens3 == null || tokens3.countTokens() != 4) {
                return false;
            }
            Integer.parseInt(tokens3.nextToken());
            int i2 = 3;
            while (--i2 >= 0) {
                Float f = new Float(tokens3.nextToken());
                if (!(f.floatValue() < 0.0f)) continue;
                return false;
            }
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }
}

