/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.g3d;

import java.awt.Color;
import org.jmol.g3d.Graphics3D;
import org.jmol.g3d.Shade3D;

final class Colix {
    private static int colixMax = 1;
    private static int[] argbs = new int[128];
    private static int[] argbsGreyscale;
    private static Color[] colors;
    private static int[][] ashades;
    private static int[][] ashadesGreyscale;
    static int mixCacheCount;
    static int[] mixCacheMixIds;
    static short[] mixCacheColixes;

    Colix() {
    }

    static final short getColix(int argb) {
        if (argb == 0) {
            return 0;
        }
        int translucent = 0;
        if ((argb & 0xFF000000) != -16777216) {
            if ((argb & 0xFF000000) == 0) {
                System.out.println("zero alpha channel + non-zero rgb not supported");
                throw new IndexOutOfBoundsException();
            }
            argb |= 0xFF000000;
            translucent = 16384;
        }
        int i = colixMax;
        while (--i >= 4) {
            if (argb != argbs[i]) continue;
            return (short)(i | translucent);
        }
        return (short)(Colix.allocateColix(argb, null) | translucent);
    }

    static final short getColix(Color color) {
        if (color == null) {
            return 0;
        }
        int argb = color.getRGB();
        if (argb == 0) {
            return 0;
        }
        int translucent = 0;
        if ((argb & 0xFF000000) != -16777216) {
            argb |= 0xFF000000;
            translucent = 16384;
        }
        int i = colixMax;
        while (--i >= 4) {
            if (argb != argbs[i]) continue;
            return (short)(i | translucent);
        }
        return (short)(Colix.allocateColix(argb, translucent == 0 ? color : null) | translucent);
    }

    private static synchronized int allocateColix(int argb, Color opaqueColor) {
        if ((argb & 0xFF000000) != -16777216) {
            throw new IndexOutOfBoundsException();
        }
        int i = colixMax;
        while (--i >= 4) {
            if (argb != argbs[i]) continue;
            return (short)i;
        }
        if (colixMax == argbs.length) {
            int oldSize = argbs.length;
            int newSize = oldSize * 2;
            int[] t0 = new int[newSize];
            System.arraycopy(argbs, 0, t0, 0, oldSize);
            argbs = t0;
            if (argbsGreyscale != null) {
                t0 = new int[newSize];
                System.arraycopy(argbsGreyscale, 0, t0, 0, oldSize);
                argbsGreyscale = t0;
            }
            Color[] t1 = new Color[newSize];
            System.arraycopy(colors, 0, t1, 0, oldSize);
            colors = t1;
            int[][] t2 = new int[newSize][];
            System.arraycopy(ashades, 0, t2, 0, oldSize);
            ashades = t2;
            if (ashadesGreyscale != null) {
                t2 = new int[newSize][];
                System.arraycopy(ashadesGreyscale, 0, t2, 0, oldSize);
                ashadesGreyscale = t2;
            }
        }
        Colix.argbs[Colix.colixMax] = argb;
        if (argbsGreyscale != null) {
            Colix.argbsGreyscale[Colix.colixMax] = Graphics3D.calcGreyscaleRgbFromRgb(argb);
        }
        Colix.colors[Colix.colixMax] = opaqueColor != null ? opaqueColor : new Color(argb);
        return colixMax++;
    }

    private static synchronized void calcArgbsGreyscale() {
        if (argbsGreyscale == null) {
            argbsGreyscale = new int[argbs.length];
            int i = argbsGreyscale.length;
            while (--i >= 0) {
                Colix.argbsGreyscale[i] = Graphics3D.calcGreyscaleRgbFromRgb(argbs[i]);
            }
        }
    }

    static final Color getColor(short colix) {
        if (colix == 0) {
            return null;
        }
        return colors[colix & 0xFFFFBFFF];
    }

    static final int getRgb(short colix) {
        return argbs[colix & 0xFFFFBFFF];
    }

    static final int getRgbGreyscale(short colix) {
        if (argbsGreyscale == null) {
            Colix.calcArgbsGreyscale();
        }
        return argbsGreyscale[colix & 0xFFFFBFFF];
    }

    static final boolean isTranslucent(short colix) {
        return (colix & 0x4000) != 0;
    }

    static final int[] getShades(short colix) {
        int[] shades = ashades[colix = (short)(colix & 0xFFFFBFFF)];
        if (shades == null) {
            Colix.ashades[colix] = Shade3D.getShades(argbs[colix], false);
            shades = Colix.ashades[colix];
        }
        return shades;
    }

    static final int[] getShadesGreyscale(short colix) {
        int[] shadesGreyscale;
        colix = (short)(colix & 0xFFFFBFFF);
        if (ashadesGreyscale == null) {
            ashadesGreyscale = new int[ashades.length][];
        }
        if ((shadesGreyscale = ashadesGreyscale[colix]) == null) {
            Colix.ashadesGreyscale[colix] = Shade3D.getShades(argbs[colix], true);
            shadesGreyscale = Colix.ashadesGreyscale[colix];
        }
        return shadesGreyscale;
    }

    static final void flushShades() {
        int i = colixMax;
        while (--i >= 0) {
            Colix.ashades[i] = null;
        }
    }

    static final short getColixMix(short colixA, short colixB) {
        if (colixA == colixB) {
            return colixA;
        }
        if (colixA <= 0) {
            return colixB;
        }
        if (colixB <= 0) {
            return colixA;
        }
        int mixId = colixA < colixB ? colixA << 16 | colixB : colixB << 16 | colixA;
        for (int i = 0; i < mixCacheCount; ++i) {
            if (mixId != mixCacheMixIds[i]) continue;
            return mixCacheColixes[i];
        }
        int argbA = argbs[colixA];
        int argbB = argbs[colixB];
        int r = (argbA & 0xFF0000) + (argbB & 0xFF0000) >> 1 & 0xFF0000;
        int g = (argbA & 0xFF00) + (argbB & 0xFF00) >> 1 & 0xFF00;
        int b = (argbA & 0xFF) + (argbB & 0xFF) >> 1;
        int argbMixed = 0xFF000000 | r | g | b;
        short mixedColix = Colix.getColix(argbMixed);
        return Colix.addMixed(mixId, mixedColix);
    }

    private static synchronized short addMixed(int mixId, short mixedColix) {
        if (mixCacheCount == mixCacheMixIds.length) {
            int[] t1 = new int[2 * mixCacheCount];
            short[] t2 = new short[2 * mixCacheCount];
            int i = mixCacheCount;
            while (--i >= 0) {
                t1[i] = mixCacheMixIds[i];
                t2[i] = mixCacheColixes[i];
            }
            mixCacheMixIds = t1;
            mixCacheColixes = t2;
        }
        Colix.mixCacheMixIds[Colix.mixCacheCount] = mixId;
        Colix.mixCacheColixes[Colix.mixCacheCount] = mixedColix;
        ++mixCacheCount;
        return mixedColix;
    }

    static {
        colors = new Color[128];
        ashades = new int[128][];
        mixCacheCount = 0;
        mixCacheMixIds = new int[32];
        mixCacheColixes = new short[32];
    }
}

