/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.Hashtable;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix3f;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Vector3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.viewer.Atom;
import org.jmol.viewer.Dots;
import org.jmol.viewer.ShapeRenderer;

class DotsRenderer
extends ShapeRenderer {
    boolean perspectiveDepth;
    int scalePixelsPerAngstrom;
    boolean bondSelectionModeOr;
    Geodesic geodesic;
    static final int[] mapNull = Dots.mapNull;
    Point3f pointT = new Point3f();
    Point3f pointT1 = new Point3f();
    Matrix3f matrixT = new Matrix3f();
    Matrix3f matrixT1 = new Matrix3f();
    Matrix3f matrixRot = new Matrix3f();
    AxisAngle4f aaT = new AxisAngle4f();
    AxisAngle4f aaT1 = new AxisAngle4f();
    static final float torusStepAngle = 0.09817477f;
    static final byte nearI = 1;
    static final byte nearJ = 2;
    static final byte nearK = 4;
    static final byte[] nearAssociations = new byte[]{7, 1, 2, 4, 3, 6, 5, 1, 2, 2, 4, 4, 1, 1, 2, 4, 3, 6, 5, 1, 2, 2, 4, 4, 1};
    static final float halfRoot5 = (float)(0.5 * Math.sqrt(5.0));
    static final float oneFifth = 1.2566371f;
    static final float oneTenth = 0.62831855f;
    static final short[] faceIndicesInitial = new short[]{0, 1, 2, 0, 2, 3, 0, 3, 4, 0, 4, 5, 0, 5, 1, 1, 6, 2, 2, 7, 3, 3, 8, 4, 4, 9, 5, 5, 10, 1, 6, 1, 10, 7, 2, 6, 8, 3, 7, 9, 4, 8, 10, 5, 9, 11, 6, 10, 11, 7, 6, 11, 8, 7, 11, 9, 8, 11, 10, 9};

    DotsRenderer() {
    }

    void initRenderer() {
        this.geodesic = new Geodesic();
        this.geodesic.quadruple();
        this.geodesic.quadruple();
        this.geodesic.quadruple();
    }

    void render() {
        this.perspectiveDepth = this.viewer.getPerspectiveDepth();
        this.scalePixelsPerAngstrom = (int)this.viewer.getScalePixelsPerAngstrom();
        this.bondSelectionModeOr = this.viewer.getBondSelectionModeOr();
        this.geodesic.transform();
        Dots dots = (Dots)this.shape;
        if (dots == null) {
            return;
        }
        Atom[] atoms = this.frame.atoms;
        int[][] dotsConvexMaps = dots.dotsConvexMaps;
        short[] colixesConvex = dots.colixesConvex;
        int displayModelIndex = this.displayModelIndex;
        int i = dots.dotsConvexMax;
        while (--i >= 0) {
            int[] map = dotsConvexMaps[i];
            if (map == null || map == mapNull) continue;
            Atom atom = atoms[i];
            if (displayModelIndex >= 0 && displayModelIndex != atom.modelIndex) continue;
            this.renderConvex(atom, colixesConvex[i], map);
        }
        Dots.Torus[] tori = dots.tori;
        int i2 = dots.torusCount;
        while (--i2 >= 0) {
            Dots.Torus torus = tori[i2];
            if (displayModelIndex >= 0 && displayModelIndex != atoms[torus.ixI].modelIndex) continue;
            this.renderTorus(torus, atoms, colixesConvex, dotsConvexMaps);
        }
        Dots.Cavity[] cavities = dots.cavities;
        int i3 = dots.cavityCount;
        while (--i3 >= 0) {
            Dots.Cavity cavity = cavities[i3];
            if (displayModelIndex >= 0 && displayModelIndex != atoms[cavity.ixI].modelIndex) continue;
            this.renderCavity(cavities[i3], atoms, colixesConvex, dotsConvexMaps);
        }
    }

    void renderConvex(Atom atom, short colix, int[] visibilityMap) {
        this.geodesic.calcScreenPoints(visibilityMap, atom.getVanderwaalsRadiusFloat(), atom.getScreenX(), atom.getScreenY(), atom.getScreenZ());
        if (this.geodesic.screenCoordinateCount > 0) {
            this.g3d.plotPoints(Graphics3D.inheritColix(colix, atom.colixAtom), this.geodesic.screenCoordinateCount, this.geodesic.screenCoordinates);
        }
    }

    void renderTorus(Dots.Torus torus, Atom[] atoms, short[] colixes, int[][] dotsConvexMaps) {
        if (dotsConvexMaps[torus.ixI] != null) {
            this.renderTorusHalf(torus, this.getColix(torus.colixI, colixes, atoms, torus.ixI), false);
        }
        if (dotsConvexMaps[torus.ixJ] != null) {
            this.renderTorusHalf(torus, this.getColix(torus.colixJ, colixes, atoms, torus.ixJ), true);
        }
    }

    short getColix(short colix, short[] colixes, Atom[] atoms, int index) {
        return Graphics3D.inheritColix(colix, atoms[index].colixAtom);
    }

    void renderTorusHalf(Dots.Torus torus, short colix, boolean renderJHalf) {
        this.g3d.setColix(colix);
        long probeMap = torus.probeMap;
        int torusDotCount1 = (int)((double)((float)this.getTorusOuterDotCount() * torus.outerAngle) / (Math.PI * 2));
        float stepAngle1 = torus.outerAngle / (float)torusDotCount1;
        if (renderJHalf) {
            stepAngle1 = -stepAngle1;
        }
        this.aaT1.set(torus.tangentVector, 0.0f);
        this.aaT.set(torus.axisVector, 0.0f);
        int step = this.getTorusIncrement();
        int i = 0;
        while (probeMap != 0L) {
            if (probeMap < 0L) {
                this.aaT.angle = (float)i * 0.09817477f;
                this.matrixT.set(this.aaT);
                this.matrixT.transform(torus.radialVector, this.pointT);
                this.pointT.add(torus.center);
                int j = torusDotCount1;
                while (--j >= 0) {
                    this.aaT1.angle = (float)j * stepAngle1;
                    this.matrixT1.set(this.aaT1);
                    this.matrixT1.transform(torus.outerRadial, this.pointT1);
                    this.matrixT.transform(this.pointT1);
                    this.pointT1.add(this.pointT);
                    this.g3d.drawPixel(this.viewer.transformPoint(this.pointT1));
                }
            }
            i += step;
            probeMap <<= step;
        }
    }

    int getTorusIncrement() {
        if (this.scalePixelsPerAngstrom <= 5) {
            return 16;
        }
        if (this.scalePixelsPerAngstrom <= 10) {
            return 8;
        }
        if (this.scalePixelsPerAngstrom <= 20) {
            return 4;
        }
        if (this.scalePixelsPerAngstrom <= 40) {
            return 2;
        }
        return 1;
    }

    int getTorusOuterDotCount() {
        int dotCount = 8;
        if (this.scalePixelsPerAngstrom > 5) {
            dotCount = 16;
            if (this.scalePixelsPerAngstrom > 10) {
                dotCount = 32;
                if (this.scalePixelsPerAngstrom > 20) {
                    dotCount = 64;
                }
            }
        }
        return dotCount;
    }

    void renderCavity(Dots.Cavity cavity, Atom[] atoms, short[] colixes, int[][] dotsConvexMaps) {
        Point3f[] points = cavity.points;
        if (dotsConvexMaps[cavity.ixI] != null) {
            this.g3d.setColix(this.getColix(cavity.colixI, colixes, atoms, cavity.ixI));
            this.renderCavityThird(points, 0);
        }
        if (dotsConvexMaps[cavity.ixJ] != null) {
            this.g3d.setColix(this.getColix(cavity.colixJ, colixes, atoms, cavity.ixJ));
            this.renderCavityThird(points, 1);
        }
        if (dotsConvexMaps[cavity.ixK] != null) {
            this.g3d.setColix(this.getColix(cavity.colixK, colixes, atoms, cavity.ixK));
            this.renderCavityThird(points, 2);
        }
    }

    void renderCavityThird(Point3f[] points, int which) {
        int i = points.length;
        while (--i >= 0) {
            if ((nearAssociations[i] & 1 << which) == 0) continue;
            Point3i screen = this.viewer.transformPoint(points[i]);
            this.g3d.drawPixel(screen);
        }
    }

    static final boolean getBit(int[] bitmap, int i) {
        return bitmap[i >> 5] << (i & 0x1F) < 0;
    }

    class Geodesic {
        Vector3f[] vertices = new Vector3f[12];
        Vector3f[] verticesTransformed;
        int screenCoordinateCount;
        int[] screenCoordinates;
        short[] faceIndices;
        short iVertexNew;
        Hashtable htVertex;

        Geodesic() {
            int i;
            this.vertices[0] = new Vector3f(0.0f, 0.0f, halfRoot5);
            for (i = 0; i < 5; ++i) {
                this.vertices[i + 1] = new Vector3f((float)Math.cos((float)i * 1.2566371f), (float)Math.sin((float)i * 1.2566371f), 0.5f);
                this.vertices[i + 6] = new Vector3f((float)Math.cos((float)i * 1.2566371f + 0.62831855f), (float)Math.sin((float)i * 1.2566371f + 0.62831855f), -0.5f);
            }
            this.vertices[11] = new Vector3f(0.0f, 0.0f, -halfRoot5);
            i = 12;
            while (--i >= 0) {
                this.vertices[i].normalize();
            }
            this.faceIndices = faceIndicesInitial;
            this.verticesTransformed = new Vector3f[12];
            i = 12;
            while (--i >= 0) {
                this.verticesTransformed[i] = new Vector3f();
            }
            this.screenCoordinates = new int[36];
        }

        void transform() {
            int i = this.vertices.length;
            while (--i >= 0) {
                Vector3f t = this.verticesTransformed[i];
                DotsRenderer.this.viewer.transformVector(this.vertices[i], t);
            }
        }

        void calcScreenPoints(int[] visibilityMap, float radius, int x, int y, int z) {
            int dotCount = 12;
            if (DotsRenderer.this.scalePixelsPerAngstrom > 5) {
                dotCount = 42;
                if (DotsRenderer.this.scalePixelsPerAngstrom > 10) {
                    dotCount = 162;
                    if (DotsRenderer.this.scalePixelsPerAngstrom > 20) {
                        dotCount = 642;
                    }
                }
            }
            float scaledRadius = DotsRenderer.this.viewer.scaleToPerspective(z, radius);
            int icoordinates = 0;
            int iDot = visibilityMap.length << 5;
            this.screenCoordinateCount = 0;
            if (iDot > dotCount) {
                iDot = dotCount;
            }
            while (--iDot >= 0) {
                if (!DotsRenderer.getBit(visibilityMap, iDot)) continue;
                Vector3f vertex = this.verticesTransformed[iDot];
                this.screenCoordinates[icoordinates++] = x + (int)((double)(scaledRadius * vertex.x) + (vertex.x < 0.0f ? -0.5 : 0.5));
                this.screenCoordinates[icoordinates++] = y + (int)((double)(scaledRadius * vertex.y) + (vertex.y < 0.0f ? -0.5 : 0.5));
                this.screenCoordinates[icoordinates++] = z + (int)((double)(scaledRadius * vertex.z) + (vertex.z < 0.0f ? -0.5 : 0.5));
                ++this.screenCoordinateCount;
            }
        }

        void quadruple() {
            this.htVertex = new Hashtable();
            int nVerticesOld = this.vertices.length;
            short[] faceIndicesOld = this.faceIndices;
            int nFaceIndicesOld = faceIndicesOld.length;
            int nEdgesOld = nVerticesOld + nFaceIndicesOld / 3 - 2;
            int nVerticesNew = nVerticesOld + nEdgesOld;
            Vector3f[] verticesNew = new Vector3f[nVerticesNew];
            System.arraycopy(this.vertices, 0, verticesNew, 0, nVerticesOld);
            this.vertices = verticesNew;
            this.verticesTransformed = new Vector3f[nVerticesNew];
            int i = nVerticesNew;
            while (--i >= 0) {
                this.verticesTransformed[i] = new Vector3f();
            }
            this.screenCoordinates = new int[3 * nVerticesNew];
            short[] faceIndicesNew = new short[4 * nFaceIndicesOld];
            this.faceIndices = faceIndicesNew;
            this.iVertexNew = (short)nVerticesOld;
            int iFaceNew = 0;
            int i2 = 0;
            while (i2 < nFaceIndicesOld) {
                short iA = faceIndicesOld[i2++];
                short iB = faceIndicesOld[i2++];
                short iC = faceIndicesOld[i2++];
                short iAB = this.getVertex(iA, iB);
                short iBC = this.getVertex(iB, iC);
                short iCA = this.getVertex(iC, iA);
                faceIndicesNew[iFaceNew++] = iA;
                faceIndicesNew[iFaceNew++] = iAB;
                faceIndicesNew[iFaceNew++] = iCA;
                faceIndicesNew[iFaceNew++] = iB;
                faceIndicesNew[iFaceNew++] = iBC;
                faceIndicesNew[iFaceNew++] = iAB;
                faceIndicesNew[iFaceNew++] = iC;
                faceIndicesNew[iFaceNew++] = iCA;
                faceIndicesNew[iFaceNew++] = iBC;
                faceIndicesNew[iFaceNew++] = iCA;
                faceIndicesNew[iFaceNew++] = iAB;
                faceIndicesNew[iFaceNew++] = iBC;
            }
            if (iFaceNew != faceIndicesNew.length) {
                System.out.println("que?");
                throw new NullPointerException();
            }
            if (this.iVertexNew != nVerticesNew) {
                System.out.println("huh?  iVertexNew=" + this.iVertexNew + "nVerticesNew=" + nVerticesNew);
                throw new NullPointerException();
            }
            this.htVertex = null;
        }

        private short getVertex(short i1, short i2) {
            Integer hashKey;
            Short iv;
            if (i1 > i2) {
                short t = i1;
                i1 = i2;
                i2 = t;
            }
            if ((iv = (Short)this.htVertex.get(hashKey = new Integer((i1 << 16) + i2))) != null) {
                return iv;
            }
            Vector3f vertexNew = new Vector3f(this.vertices[i1]);
            vertexNew.add(this.vertices[i2]);
            vertexNew.scale(0.5f);
            vertexNew.normalize();
            this.htVertex.put(hashKey, new Short(this.iVertexNew));
            this.vertices[this.iVertexNew] = vertexNew;
            short s = this.iVertexNew;
            this.iVertexNew = (short)(s + 1);
            return s;
        }
    }
}

