/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import org.jmol.g3d.Graphics3D;
import org.jmol.viewer.Atom;
import org.jmol.viewer.Polyhedra;
import org.jmol.viewer.ShapeRenderer;

class PolyhedraRenderer
extends ShapeRenderer {
    int drawEdges;

    PolyhedraRenderer() {
    }

    void render() {
        Polyhedra polyhedra = (Polyhedra)this.shape;
        Polyhedra.Polyhedron[] polyhedrons = polyhedra.polyhedrons;
        this.drawEdges = polyhedra.drawEdges;
        int i = polyhedra.polyhedronCount;
        while (--i >= 0) {
            this.render1(polyhedrons[i]);
        }
    }

    void render1(Polyhedra.Polyhedron p) {
        byte[] faces;
        if (!p.visible) {
            return;
        }
        short colix = Graphics3D.inheritColix(p.polyhedronColix, p.centralAtom.colixAtom);
        Atom[] vertices = p.vertices;
        switch (vertices.length) {
            case 6: {
                faces = Polyhedra.octahedronFaces;
                break;
            }
            case 4: {
                faces = Polyhedra.tetrahedronFaces;
                break;
            }
            default: {
                System.out.println("?Que? vertices.length=" + vertices.length);
                return;
            }
        }
        int i = 0;
        int j = 0;
        while (j < faces.length) {
            this.drawFace(colix, p.normixes[i++], vertices[faces[j++]], vertices[faces[j++]], vertices[faces[j++]]);
        }
        i = 0;
        j = 0;
        while (j < faces.length) {
            this.fillFace(colix, p.normixes[i++], vertices[faces[j++]], vertices[faces[j++]], vertices[faces[j++]]);
        }
    }

    void drawFace(short colix, short normix, Atom atomA, Atom atomB, Atom atomC) {
        if (this.drawEdges == 1 || this.drawEdges == 2 && this.g3d.isDirectedTowardsCamera(normix)) {
            this.g3d.drawTriangle(Graphics3D.getOpaqueColix(colix), atomA.xyzd, atomB.xyzd, atomC.xyzd);
        }
    }

    void fillFace(short colix, short normix, Atom atomA, Atom atomB, Atom atomC) {
        this.g3d.fillTriangle(colix, normix, atomA.xyzd, atomB.xyzd, atomC.xyzd);
    }
}

