/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix3f;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Vector3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.util.Bmp;
import org.jmol.viewer.Atom;
import org.jmol.viewer.SasCache;
import org.jmol.viewer.Sasurface;
import org.jmol.viewer.Sasurface1;
import org.jmol.viewer.ShapeRenderer;

class SasurfaceRenderer
extends ShapeRenderer {
    boolean perspectiveDepth;
    boolean hideSaddles;
    boolean hideCavities;
    boolean hideConvex;
    int scalePixelsPerAngstrom;
    boolean bondSelectionModeOr;
    int geodesicVertexCount;
    int geodesicFaceCount;
    short[] geodesicFaceVertexes;
    short[] geodesicFaceNormixes;
    SasCache sasCache;
    float radiusP;
    Vector3f[] transformedProbeVertexes;
    Point3i[] probeScreens;
    private static final boolean CONVEX_DOTS = false;
    private static final boolean CAVITY_DOTS = false;
    final AxisAngle4f aaT = new AxisAngle4f();
    final AxisAngle4f aaT1 = new AxisAngle4f();
    static final int INNER_TORUS_STEP_COUNT = 12;
    static final int OUTER_TORUS_STEP_COUNT = 11;
    static final float INNER_TORUS_STEP_ANGLE = 0.5235988f;
    static final int MAX_SEGMENT_COUNT = 6;
    final Matrix3f matrixT = new Matrix3f();
    final Matrix3f matrixT1 = new Matrix3f();
    final Point3f pointT = new Point3f();
    final Point3f pointT1 = new Point3f();
    final short[] torusEdgeIndexes = new short[12];
    final byte[] torusSegmentStarts = new byte[6];
    final Point3i screenCavityBottom = new Point3i();
    final short[] torusColixes = new short[11];

    SasurfaceRenderer() {
    }

    void initRenderer() {
        int maxVertexCount = this.g3d.getGeodesicVertexCount(2);
        this.sasCache = new SasCache(this.viewer, 6, maxVertexCount);
    }

    void render() {
        this.perspectiveDepth = this.viewer.getPerspectiveDepth();
        this.scalePixelsPerAngstrom = (int)this.viewer.getScalePixelsPerAngstrom();
        this.bondSelectionModeOr = this.viewer.getBondSelectionModeOr();
        Sasurface sasurface = (Sasurface)this.shape;
        if (sasurface == null) {
            return;
        }
        int surfaceCount = sasurface.surfaceCount;
        if (surfaceCount == 0) {
            return;
        }
        Sasurface1[] surfaces = sasurface.surfaces;
        this.hideSaddles = this.viewer.getTestFlag1();
        this.hideCavities = this.viewer.getTestFlag2();
        this.hideConvex = this.viewer.getTestFlag3();
        this.sasCache.clear();
        int i = surfaceCount;
        while (--i >= 0) {
            this.renderSasurface1(surfaces[i]);
        }
    }

    void renderSasurface1(Sasurface1 surface) {
        if (surface.hide) {
            return;
        }
        int renderingLevel = surface.geodesicRenderingLevel;
        this.radiusP = surface.radiusP;
        this.geodesicVertexCount = surface.geodesicVertexCount;
        this.geodesicFaceCount = this.g3d.getGeodesicFaceCount(renderingLevel);
        this.geodesicFaceVertexes = this.g3d.getGeodesicFaceVertexes(renderingLevel);
        this.geodesicFaceNormixes = this.g3d.getGeodesicFaceNormixes(renderingLevel);
        if (this.transformedProbeVertexes == null || this.transformedProbeVertexes.length < this.geodesicVertexCount) {
            this.allocTransformedProbeVertexes();
        }
        Atom[] atoms = this.frame.atoms;
        int[][] convexVertexMaps = surface.convexVertexMaps;
        int[][] convexFaceMaps = surface.convexFaceMaps;
        short[] colixesConvex = surface.colixesConvex;
        int displayModelIndex = this.displayModelIndex;
        int i = surface.surfaceConvexMax;
        while (--i >= 0) {
            int[] vertexMap = convexVertexMaps[i];
            if (vertexMap == null) continue;
            int[] faceMap = convexFaceMaps[i];
            Atom atom = atoms[i];
            if (displayModelIndex >= 0 && displayModelIndex != atom.modelIndex) continue;
            this.renderConvex(surface, atom, colixesConvex[i], vertexMap, faceMap);
        }
        Sasurface1.Torus[] toruses = surface.toruses;
        int i2 = surface.torusCount;
        while (--i2 >= 0) {
            Sasurface1.Torus torus = toruses[i2];
            this.renderTorus(torus, atoms, colixesConvex, convexVertexMaps);
        }
    }

    void allocTransformedProbeVertexes() {
        this.transformedProbeVertexes = new Vector3f[this.geodesicVertexCount];
        this.probeScreens = new Point3i[this.geodesicVertexCount];
        Vector3f[] transformedGeodesicVertexes = this.viewer.g3d.getTransformedVertexVectors();
        int i = this.geodesicVertexCount;
        while (--i >= 0) {
            this.transformedProbeVertexes[i] = new Vector3f();
            this.transformedProbeVertexes[i].scale(this.radiusP, transformedGeodesicVertexes[i]);
            this.probeScreens[i] = new Point3i();
        }
    }

    void renderConvex(Sasurface1 surface, Atom atom, short colix, int[] vertexMap, int[] faceMap) {
        if (this.hideConvex) {
            return;
        }
        Point3i[] screens = this.sasCache.lookupAtomScreens(atom, vertexMap);
        colix = Graphics3D.inheritColix(colix, atom.colixAtom);
        int i = Bmp.getMaxMappedBit(faceMap);
        int j = 3 * i - 1;
        while (--i >= 0) {
            if (Bmp.getBit(faceMap, i)) {
                short vA = this.geodesicFaceVertexes[j - 2];
                short vB = this.geodesicFaceVertexes[j - 1];
                short vC = this.geodesicFaceVertexes[j];
                this.g3d.fillTriangle(colix, screens[vA], vA, screens[vB], vB, screens[vC], vC);
            }
            j -= 3;
        }
    }

    void renderTorus(Sasurface1.Torus torus, Atom[] atoms, short[] convexColixes, int[][] convexVertexMaps) {
        this.prepareTorusColixes(torus, convexColixes, atoms);
        this.renderTorus(torus, this.torusColixes);
    }

    short getColix(short colix, short[] colixes, Atom[] atoms, int index) {
        return Graphics3D.inheritColix(colix, atoms[index].colixAtom);
    }

    int getTorusOuterDotCount() {
        return 32;
    }

    int getTorusIncrement() {
        return 1;
    }

    void renderTorus(Sasurface1.Torus torus, short[] colixes) {
        Point3i[] screens = this.sasCache.lookupTorusScreens(torus);
        short[] normixes = torus.normixes;
        int outerPointCount = torus.outerPointCount;
        Sasurface1.Torus.TorusCavity[] torusCavities = torus.torusCavities;
        int torusCavityIndex = 0;
        int ixP = 0;
        int torusSegmentCount = torus.torusSegmentCount;
        for (int i = 0; i < torusSegmentCount; ++i) {
            if (torusCavities != null) {
                this.renderTorusCavityTriangle(screens, normixes, ixP, outerPointCount, colixes, torusCavities[torusCavityIndex++]);
            }
            int stepCount = torus.torusSegments[i].stepCount;
            int ixQ = ixP + outerPointCount;
            int j = stepCount;
            while (--j > 0) {
                ++ixP;
                ++ixQ;
                for (int k = 1; k < outerPointCount; ++k) {
                    this.g3d.fillQuadrilateral(screens[ixP - 1], colixes[k - 1], normixes[ixP - 1], screens[ixP], colixes[k], normixes[ixP], screens[ixQ], colixes[k], normixes[ixQ], screens[ixQ - 1], colixes[k - 1], normixes[ixQ - 1]);
                    ++ixP;
                    ++ixQ;
                }
            }
            if (torusCavities != null) {
                this.renderTorusCavityTriangle(screens, normixes, ixP, outerPointCount, colixes, torusCavities[torusCavityIndex++]);
            }
            ixP = ixQ;
        }
    }

    void renderTorusCavityTriangle(Point3i[] torusScreens, short[] torusNormixes, int torusIndex, int torusPointCount, short[] colixes, Sasurface1.Torus.TorusCavity torusCavity) {
        Sasurface1.Cavity cavity = torusCavity.cavity;
        this.viewer.transformPoint(cavity.pointBottom, this.screenCavityBottom);
        short normixCavityBottom = cavity.normixBottom;
        Point3i torusScreenLast = torusScreens[torusIndex];
        short torusNormixLast = torusNormixes[torusIndex];
        short colixLast = colixes[0];
        ++torusIndex;
        for (int i = 1; i < torusPointCount; ++i) {
            short colix;
            Point3i torusScreen = torusScreens[torusIndex];
            short torusNormix = torusNormixes[torusIndex];
            ++torusIndex;
            short colixBottom = colix = colixes[i];
            if (colix != colixLast) {
                colixBottom = this.g3d.getColixMix(colix, colixLast);
            }
            this.g3d.fillTriangle(torusScreenLast, colixLast, torusNormixLast, torusScreen, colix, torusNormix, this.screenCavityBottom, colixBottom, normixCavityBottom);
            torusScreenLast = torusScreen;
            torusNormixLast = torusNormix;
            colixLast = colix;
        }
    }

    void prepareTorusColixes(Sasurface1.Torus torus, short[] convexColixes, Atom[] atoms) {
        int ixA = torus.ixA;
        int ixB = torus.ixB;
        int outerPointCount = torus.outerPointCount;
        short colixB = torus.colixB;
        short colixA = Graphics3D.inheritColix(torus.colixA, convexColixes[ixA], atoms[ixA].colixAtom);
        if (colixA == (colixB = Graphics3D.inheritColix(torus.colixB, convexColixes[ixB], atoms[ixB].colixAtom))) {
            int i = outerPointCount;
            while (--i >= 0) {
                this.torusColixes[i] = colixA;
            }
            return;
        }
        int halfRoundedUp = (outerPointCount + 1) / 2;
        this.torusColixes[outerPointCount / 2] = colixA;
        int i = outerPointCount / 2;
        while (--i >= 0) {
            this.torusColixes[i] = colixA;
            this.torusColixes[i + halfRoundedUp] = colixB;
        }
    }
}

