//  JmolShell - a platform for preparing Jmol presentations
//  
//  This file forms the basis for JmolShell. It is called by a WEB page that need
//  only include presentation-specific code. It uses the Jmol Java unit and the
//  Jmol.js library code that accompanies Jmol. 
//  
//  JmolShell is written by:
//	
//	Craig T. Martin
//	Dept of Chemistry and of Biochem & Mol Biol
//	University of Massachusetts
//	710 N Pleasant St
//	Amherst, MA 01003
//	(413) 545-3299
//	CTMartin@chem.umass.edu
//	http://www.chem.umass.edu/~cmartin
//  
//  
//  
var JmolShellUpdate = "September 8, 2005";

//Global variables
var TagLine = "",			authorG = "Bozo";
var CitationG = "J Irreprod Res 00, 123";
var PubMedIDG = "000",		LastUpdatedG = "1/01/1901";
var jHgt = 300, jWid = 300;
var sideBarFinalW = 500;
var ResetFileG = "Reset.spt";
var ScriptRecOn = "false";
var LastMsgSet = "";
var WaitingForO = "false";
var CaptureMsgs = "false";
var MsgStore = "";
var JmolDebugStatus = false;

// Constants for external links
//var JmolMainPage = "http:\/\/www.Jmol.org";
var JmolMainPage = "http:\/\/jmol.sourceforge.net";
var JmolJSPage = "http:\/\/jmol.sourceforge.net\/jslibrary";
var JmolHelp = "http:\/\/www.stolaf.edu\/people\/hansonr\/jmol\/docs\/";
var MouseHelp = "http://wiki.jmol.org/MouseManual";
var CHIMEHelp = "http:\/\/www.umass.edu\/microbio\/chime\/manual\/chimeman.htm#chcomref";
var RasmolHelp = "http:\/\/www.openrasmol.org\/doc\/#chcomref";
var PDB_Search = "http:\/\/pdbbeta.rcsb.org\/pdb\/explore.do?structureId=";


// A script to execute at startup
var StartUpScript = "set measurements angstroms;set ribbonedge on";

// Constants for "design"
var fontfam = "Arial, Verdana, Helvetica, Geneva, sans-serif";
var FontSzG = 12;
var fntstyl = " style=\"font-size: " + (FontSzG-2)+ "px;\"";
var fntstylTiny = " style=\"font-size: " + (FontSzG-3)+ "px;\"";
var fntstylSel = " WIDTH=\"60\" style=\"font-size: " + (FontSzG-2)+ "px; width: 60px\"";
var colWid = 38; colRows = 15;

// Constants for HTML formatting
var CrLf = "\r";
var HRSm = "\<HR size=\"2\" color=\"#446791\"\>";
var HRBg = "\<HR size=\"4\" color=\"#446791\"\>";
var Spc3 = "&nbsp;&nbsp;&nbsp;";
var Spc2 = "&nbsp;&nbsp;";
var br = "\<br\>";
var p = "\<P\>";

// Constants for Form Select elements
var ColorOptions = "Color\>"
		+ ",cpk,Red,Orange,Yellow,Green,Blue,Cyan,Violet,Brown"
		+ ",Magenta,Pink,LightGreen,LightBlue,LightYellow,Gray,Black,White,Purple";
		
var aaOptions = "aa\>"
		+ ",Asn,Gln,Asp,Glu,Arg,Lys,Gly,Ala,Val,Ile,Leu,Thr"
		+ ",Phe,Tyr,Trp,Pro,Met,Ser,Thr,Cys,His,Cystine,-----"
		+ ",Hydrophobic,Neutral,Polar,Charged,Acidic,Basic,Amino,Aromatic"
		+ ",Aliphatic,Hydrogen";
		
var aaWhatOptions = "where\>"
		+ ",Bonded,Ligand,Surface,Buried";
		
var typeOptions = "Type\>,Protein,Nucleic,Solvent,Water,Hetero,Ions"

var ScndryOptions = "2ndry\>,Helix,Sheet,Turn";
var BBOptions = "BB\>,Backbone,Sidechain";
var nucleicOptions = "DNA\>,AT,CG,A,C,G,T,U,Pyrimidine,Purine";

// Global variables that will change (but don't touch)
 var UserMenu = [];
 var UserDscr = [];
 var UserMenuHght = 30;
 var UsercmdHgt = 20;



//=================================

// Note that this set of scripts uses routines defined in Jmol.js

// ======== Define some static WEB "pages" for later loading =========

// A command line BOX for multiple commands
//  Future: make this of dynamic width & height, turn it into a function call
//  Future: include message box and command history box
var CmdLineHTML = "\<B\>Enter your "
	+ LinkTag(JmolHelp,"CHIMECommands","Jmol","Click here for help with commands") 
		+ " script here\<\/B\>"
	+"\<form name=\"area\"\>"
		+ ClearTag()
		+ "\<input type=\"button\" value=\"Execute\""
			+ "onclick=\"run(document.area.scriptBox.value)\"" + fntstyl + "\>"
		+ Spc3 + "\<input type=\"button\" value=\";\"" + fntstyl
			+ " onClick=\"ToggleCmdBx()\"\>"
		+ br
		+ "\<textarea name=\"scriptBox\"  value=\"Enter multiple jmol commands here\""
			+ "  cols=" + colWid + " rows=" + colRows + fntstyl + "\>\<\/textarea\>"
	+ "\<br\>\<\/form\>"
	
	+ "Command record".bold()
	+ "\<form name=\"history\"\>"
		+ ClearTag()
		+ "\<input name=\"ScriptRecordOn\" type=\"checkbox\" value=\"true\""
			+ " onClick=\"SetRecStatus()\"\> Record commands"+ Spc3
		+ "\<input type=\"button\" value=\";\"" + fntstyl + " onClick=\"ToggleHist()\"\>"
		+ br
		+ "\<textarea name=\"historyBox\"  value=\"\""
		+ "  cols=" + colWid + " rows=" + (colRows-5) + fntstyl + "\> \<\/textarea\>"
	+ "\<br\>\<\/form\>"
		
	+ "\<form name=\"Feedback\"\>"
	+ "Feedback".bold() + " (newest at top)"
		+ ClearTag()
		+ br
		+ "\<textarea name=\"Messages\"  value=\"\""
		+ "  cols=" + colWid + " rows=" + (colRows-5) + fntstyl + "\> \<\/textarea\>"
	+ "\<br\>\<\/form\>";

// ---------------------------------------------------------------------

// A help window
var HelpHTML = "This presentation made possible by "
	+ LinkTag(JmolMainPage,"JmolSrc","Jmol","Click here to learn more about Jmol") 
		+ ", an open-source project. "
	+ LinkTag(JmolHelp,"JmolHelp","Scripting commands","Click here for help with Jmol commands")
		+ " follow those of " 
	+ LinkTag(RasmolHelp,"RasmolHelp","Rasmol","Click here for Rasmol help") + "\/" 
	+ LinkTag(CHIMEHelp,"CHIMEHelp","CHIME.","Click here for CHIME help")
	+ "\<hr\> The Jmol "
	+ LinkTag(MouseHelp,"MouseHelp","mouse gestures","Click here to learn more about mouse gestures") 
	+ " are designed to function with single-button mice"
		+ "on the Mac. All references to 'left' get translated to 'only'"

	+ "\<table border=\"1\" cellspacing=\"2\" cellpadding=\"1\"\>"
		+ GetTblRw("rotate X & Y axes","left drag")
		+ GetTblRw("zoom + rotate Z axis","shift left drag\<br\> OR middle button drag")
		+ GetTblRw("rotate Z axis only","shift right drag")
		+ GetTblRw("translate X & Y axes","shift double left drag\<br\> OR double middle drag")
			+ GetTblRw("reset to center","shift double left click\<br\> OR double middle click")
		+ GetTblRw("wheel - zoom","a wheel is also a middle button if clicked/dragged")
		+ GetTblRw("popup menu","right click<br> OR ctrl left click")
	+ "\<\/table\>"

	+ "\<H3\>To measure distances and angles\<\/H3\>"
	+ "Double click, optionally single click 0, 1, or 2 times, Double click"

	+ "\<p\>After your first double-click the cursor will change and then you can"
		+ "\'hover\' over several different atoms to get different distances."

	+ "\<p\>Move outside the applet to cancel the measurement."

	+ "\<p\>For a distance measurment:"

	+ "\<p\>double click to drop an anchor"
	+ "\<br\>double click on the destination"

	+ "\<p\>For an angle measurement:"

	+ "\<p\>double click to drop an anchor"
	+ "\<br\>single click on an intermediate point"
	+ "\<br\>double click on the final point"

	+ "\<p\>For a torsion measurement:"

	+ "\<p\>double click to drop anchor"
	+ "\<br\>single click"
	+ "\<br\>single click"
	+ "\<br\>double click"
	
	+ "\<H3\>Selection examples\<\/H3\>"
	+ "Select:"
	+ "\<TABLE BORDER=\"0\" CELLSPACING=\"2\" CELLPADDING=\"1\"\>"
	+ "\<TR\>" + "\<TD width=70\>:G\<\/TD\>" + "\<TD\>Chain G\<\/TD\>" + "\<\/TR\>"
	+ "\<TR\>" + "\<TD\>145:G\<\/TD\>" + "\<TD\>Residue 145 of Chain G\<\/TD\>" + "\<\/TR\>"
	+ "\<TR\>" + "\<TD\>45-50:G\<\/TD\>" + "\<TD\>Residues 45 to 50 of Chain G\<\/TD\>" + "\<\/TR\>"
	+ "\<TR\>" + "\<TD\>*.CA\<\/TD\>" + "\<TD\>all c-alphas\<\/TD\>" + "\<\/TR\>"
	+ "\<TR\>" + "\<TD\>[Cys].CA\<\/TD\>" + "\<TD\>all Cys c-alphas\<\/TD\>" + "\<\/TR\>"
	+ "\<TR\>" + "\<TD\>[Cys]:A.CA\<\/TD\>" + "\<TD\>all Cys c-alphas in Chain A\<\/TD\>" + "\<\/TR\>"
	+ "\<\/TABLE\>"
	
	;

// ---------------------------------------------------------------------

// An "About" window - dynamic!
//	This takes information from the user, combined with info from this shell
//		and presents it all in a uniform format
function jAbout()
{
	return "Literature reference for the structure:\<br\>" +
		LinkTag("http://www.ncbi.nlm.nih.gov:80/entrez/query.fcgi?cmd=Retrieve" +
		"&db=PubMed&list_uids=" + PubMedIDG + "&dopt=Abstract",
		"PubMedW",CitationG,"Click here to go to PubMed entry")  +

	
	"\<hr\>Presentation by " + AuthorG + "<p>Last updated: " + LastUpdatedG +

	"\<hr\>This presentation made possible by " + 
		LinkTag(JmolMainPage,"JmolSrc","Jmol","Click here to go to Jmol main page")
			+ ", an open-source project, " +
		"using a set of JavaScript functions provided in the library " + 
		LinkTag(JmolJSPage,"JmolLib","Jmol.js",
			"Click here to go to Jmol javascript library page") + 

		p + "Developed using " + "JmolShell" + ", by " + 
		LinkTag("http:\/\/www.chem.umass.edu\/~cmartin","CTM","Craig Martin",
			"Click here to go to his home page at UMass") + " \<" + 
		EMailTag("cmartin","chem.umass.edu") + "\>, " +
		"Department of Chemistry, University of Massachusetts, Amherst, MA" +

 		p + "JmolShell last updated: " + JmolShellUpdate +

	"\<hr\>Description of menu items above: " + 
		p + "\<b\>Main\<\/b\> - The presentation content, including the complete" + 
			" story for the molecule at right" +
		p + "\<b\>About\<\/b\> - This page" + 
		p + "\<b\>Cmd\<\/b\> - provides a larger command line for executing " + 
		"multiple Jmol commands. Also allows recording of commands. Cut and paste " +
			"from and to here during development of your project" +
		p + "\<b\>Presets\<\/b\> - lets you construct Jmol commands using a simple " +
			"form. This is a good way to learn how to write scripts." + 
		p + "\<b\>Help\<\/b\> - Help on using JMol and JmolShell" + 
		p + "\<b\>Reset\<\/b\> - Redraws the molecule to its starting view and rendering" + 


	"\<FORM ID=\"HelpOut\" NAME=\"HelpOut\"\>" +	
	"\<INPUT TYPE=\"button\" VALUE=\"PDB Header\" onClick=\"DisplayHeaderInfo()\"\>" +
	"\<INPUT TYPE=\"button\" VALUE=\"Machine Info\" onClick=\"DisplayMachineInfo()\"\>" +	
	"\<BR\>\<textarea name=\"HelpOutBox\"  value=\"\"" +
		"  cols=" + (colWid+18) + " rows=" + colRows + fntstylTiny + "\> \<\/textarea\>" +
	"\<\/FORM\>";
}

function DisplayMachineInfo()
{	document.HelpOut.HelpOutBox.value =
		"AppCodeName: " + navigator.appCodeName +
		"\nAppName: " + navigator.appName +
		"\nAppVersion: " + navigator.appVersion +
		"\nUserAgent: " + navigator.userAgent +
		"\nPlatform: " + navigator.platform + 
//		"\nJava version " + java.lang.System.getProperty("java.version") + 
        "\nJava enabled: " + navigator.javaEnabled() + 
		"\nDocPath " + document.location.pathname + 
		"\nHostPath: " + document.location.host;
}

// Collect header info
function DisplayHeaderInfo()
{	document.HelpOut.HelpOutBox.value = "Reading...";
	MsgStore = "";
	CaptureMsgs = "true";
	run("show pdbheader");
}

function DisplayHeaderWrap()
{	CaptureMsgs = "false";
	document.HelpOut.HelpOutBox.value = MsgStore;
}

// ---------------------------------------------------------------------

// To Do: Include support for MoveTo
//   	Note:	show axisangle
//		yields:	axis-angle rotation = -0.37671968 0.7977311 -0.47085804 84.490776

var PresetsHTML = "Use the following to execute Jmol commands:".bold()
	+ p
	
	+ "\<form name=\"SelectForm\" \>" + ClearTag()
		+ "\<B\>Select\<\/B\>:" + Spc3
		+ SelectTag("aaList","DoSelectForm",aaOptions)
		+ SelectTag("aaWhatList","DoSelectForm",aaWhatOptions)
		+ SelectTag("Secondary","DoSelectForm",ScndryOptions)
		+ Spc3
		+ SelectTag("BBSide","DoSelectForm",BBOptions)
		+ SelectTag("AClass","DoSelectForm",typeOptions)
		+ SelectTag("Nucleic","DoSelectForm",nucleicOptions)
		+ br + Spc3	
		+ "Chain " + InputTextTag("Chain","DoSelectForm",fntstyl,1,1)
		+ Spc3 + "Res No " + InputTextTag("ResNo","DoSelectForm",fntstyl,4,7)
		+ Spc3 + "Atom No " + InputTextTag("AtomNo","DoSelectForm",fntstyl,6,10)
		+ br
		+ "\<input name=\"Send\" type=\"button\" value=\"\>\" "
		+		"onClick=\"DoSelectForm();run(document.SelectForm.selecttxt.value)\"\>"
		+ InputTextTag("selecttxt","",fntstyl,30,200)
		+ p + Spc2 + "Find within "
		+ InputTextTag("DstAng","DoWithinForm",fntstyl,3,7)
		+ " &#197; of the above selection"
		+ br + Spc2 + "\<input name=\"SendW\" type=\"button\" value=\"\>\" "
		+		"onClick=\"DoWithinForm();run(document.SelectForm.withintxt.value)\"\>"
		+ InputTextTag("withintxt","",fntstyl,30,200)
	+ "\<\/form\>"
		
	+ HRSm
	
	+ "\<form name=\"ApplyForm\" action=\"\"\>" + ClearTag()
		+ "\<B\>Apply\<\/B\>: " + Spc3 + Spc3
		+"Wireframe " + InputTextTag("wireframe","DoApplyForm",fntstyl,4,8) + br+Spc3
		+"Spacefill " + InputTextTag("spacefill","DoApplyForm",fntstyl,4,8) + Spc3
		
		+"Cartoon " + InputTextTag("cartoon","DoApplyForm",fntstyl,4,8) + Spc3 
		+ InputTextToggle("Transluc","DoApplyForm",fntstyl) + "Transluc" + br+Spc3
		+"Backbone " + InputTextTag("backbone","DoApplyForm",fntstyl,4,8) + Spc3
		+"Ribbon " + InputTextTag("ribbon","DoApplyForm",fntstyl,4,8) + br+Spc3
		+"Dots " + InputTextTag("dots","DoApplyForm",fntstyl,4,8) + Spc3
		+"Mesh " + InputTextTag("mesh","DoApplyForm",fntstyl,4,8) + Spc3 
		+SelectTag("Color","DoApplyForm",ColorOptions)
		+ "\<br\>\<input name=\"Send\" type=\"button\" value=\"\>\" "
		+		"onClick=\"DoApplyForm();run(document.ApplyForm.selecttxt.value)\"\>"
		+ InputTextTag("selecttxt","",fntstyl,30,200)
	+ "\<\/form\>"
	
	+ HRBg
	
	+ "\<form name=\"EnviroForm\" action=\"\"\>" + ClearTag()
		+ "\<B\>Global\<\/B\>:"

		+ br + Spc3 + "\<B\>Stereo\<\/B\>:\<br\>" + Spc3
			+ Spc2 + InputRadio("StereoView","","DoEnviroForm","Checked",fntstyl) + "None"
			+ Spc2 + InputRadio("StereoView","off","DoEnviroForm","",fntstyl) + "Off"
			+ Spc2 + InputRadio("StereoView","-5","DoEnviroForm","",fntstyl) + "cross-eyed"
			+ Spc2 + InputRadio("StereoView","5","DoEnviroForm","",fntstyl) + "wall-eyed"

		+ br + Spc3+"Bkgrnd "
		+ SelectTag("background","DoEnviroForm",ColorOptions)
		+ Spc3+"HBonds " + InputTextTag("hbonds","DoEnviroForm",fntstyl,4,8)
	
		+ br + "\<input name=\"ShowOr\" type=\"checkbox\" "
			+ " onClick=\"SetShowOr()\"\> Rotate to current view"
			//+ " in " + InputTextTag("Rtime","DoEnviroForm",fntstyl,3,4) + "sec"
		
		+ br + InputTextTag("CurrOr","DoEnviroForm",fntstyl,30,200) 

		+ "\<br\>\<input name=\"Send\" type=\"button\" value=\"\>\" "
		+		"onClick=\"DoEnviroForm();run(document.EnviroForm.selecttxt.value)\"\>"
		+ InputTextTag("selecttxt","",fntstyl,30,200)
	+ "\<\/form\>"
	;
	
// ========== Functions for the Cmd side-bar ===========

// Used by DoApplyForm (only)
function AddOpt(val,st,prop)
{ if (val != "") st += (st != "")  ?  ";"+prop+" "+val  :  prop+" "+val;
  return st
}

// Used by EnviroForm and perhaps others
//  Not currently used - it doesn't work!
function GetRadioValue(FormName,RadioName)
{
	alert(FormName + " == " + RadioName);
	with (EnviroForm) {
		alert("Radio value = " + StereoView[1].value);
		for (i=0;i<StereoView.length;i++)
			{ if (StereoView[i].checked) {rtnval = StereoView[i].value } }
	};
	return rtnval;
}

// Used by DoSelectForm (only)
function AddOptB(val,st,prefx)
{  if ((val.indexOf(">") == -1)&&(val!="")) st += (st != "")  ?  " and "+prefx+val  :  prefx+val;
  return st;
}

// Used by EnviroForm (only)
function SetShowOr()
{  with (document.EnviroForm) {
  if (ShowOr.checked)
	{ SetCurrOr() }
  else
	{ CurrOr.value = "" }
  }
  DoEnviroForm();
}

// Used by EnviroForm (only)
function SetCurrOr()
{  with (document.EnviroForm) {
	// issue a Jmol command and wait for the return
	CurrOr.value = "...thinking";
	WaitingForO = "true";
	run("show orientation");
	// This function is completed by the event handler showmsg
  }
}

// Process the Environment part of the form, filling in the text box with Jmol script
function DoEnviroForm()
{ var st = "";
  with (document.EnviroForm) {
  	with (background) {if (value != "") if (value.indexOf(">") == -1) st += (st != "") ? ";" + "background "+value : "background "+value};
 	with (hbonds) { st = AddOpt(value,st,"hbonds") };
	
	stereosetting = "";
	for (i=0;i<StereoView.length;i++)
		{ if (StereoView[i].checked) {stereosetting = StereoView[i].value } }
 	st = AddOpt(stereosetting,st,"stereo");

	if (ShowOr.checked) {
		if (st != "") st += ";";
		st += CurrOr.value;
		};
	selecttxt.value = st;
  };
}

// Process the Apply part of the form, filling in the text box with Jmol script
function DoApplyForm()
{
  var st = "";
  with (document.ApplyForm) {
  	st = AddOpt(wireframe.value,st,"wireframe");
  	st = AddOpt(spacefill.value,st,"spacefill");
  	st = AddOpt(dots.value,st,"dots");
  	st = AddOpt(backbone.value,st,"backbone");
	st = AddOpt(cartoon.value,st,"cartoon");
	if (Transluc.checked) 
		{ if (cartoon.value=="") { st = AddOpt("on",st,"cartoon") };
		  st = AddOpt("translucent",st,"color cartoons ");
		};
  	st = AddOpt(ribbon.value,st,"ribbon");  	
  	st = AddOpt(mesh.value,st,"mesh");
  	with (Color) {if (value != "") if (value.indexOf(">") == -1)
		st += (st != "") ? ";" + "color "+value : "color "+value};
	selecttxt.value = st;
  };
}

// Process the Select part of the form, filling in the text box with Jmol script
function DoSelectForm()
{
  var st = "";
  with (document.SelectForm) {
	st = AddOptB(aaList.value,st,"");
	st = AddOptB(aaWhatList.value,st,"");
	st = AddOptB(Secondary.value,st,"");
	st = AddOptB(BBSide.value,st,"");
	st = AddOptB(AClass.value,st,"");
	st = AddOptB(Nucleic.value,st,"");
	st = AddOptB(Chain.value,st,"*");
	st = AddOptB(ResNo.value,st,"");
	st = AddOptB(AtomNo.value,st,"atomno=");
  	selecttxt.value = (st != "") ? st = "Select " + st  :  "";
  };
  DoWithinForm();
}

// Process the Select part of the form, filling in the text box with Jmol script
function DoWithinForm()
{
  with (document.SelectForm) {
	if ((selecttxt.value=="") || (DstAng.value=="")) {
		st = ""
	} else {
		SelArg = selecttxt.value.substr(6,selecttxt.value.length-5);
  		st = "Select within(" + DstAng.value + "," + SelArg + ") and not (" + SelArg + ")";
	}
	withintxt.value = st;
  };
}

// In command history box, within Cmd, respond to checkbox
function SetRecStatus()
{ ScriptRecOn = document.history.ScriptRecordOn.checked; }

function ReplaceAll(st,stold,stnew)
{	var indx = st.indexOf(stold);
	while (indx != -1)
		{ st = st.replace(stold,stnew);
		  indx = st.indexOf(stold); };
	return st;
}

function ToggleHist()
{ with (document.history.historyBox) {
if (value.indexOf(";") != -1)
 {	value = ReplaceAll(value,";",CrLf)
   } else {
	value = ReplaceAll(value,CrLf,";");
	value = ReplaceAll(value,"\r",";");
	value = ReplaceAll(value,"\n",";");
}  }	}

function ToggleCmdBx()
{ with (document.area.scriptBox) {
if (value.indexOf(";") != -1)
 {	value = ReplaceAll(value,";",CrLf)
   } else {
	value = ReplaceAll(value,CrLf,";");
	value = ReplaceAll(value,"\r",";");
	value = ReplaceAll(value,"\n",";");
}  }	}

// ========== Functions for the Help side-bar ===========

// Used by HelpHTML definition (only)
function GetTblRw(txt1,txt2)
{
return "\<tr align=\"left\" valign=\"top\"\>"
	+ "\<td\>" + txt1 + "\<\/td\>"
	+ "\<td\>" + txt2 + "\<\/td\>"
	+ "\<\/tr\>";
}

// ========== Functions to toggle the side-bars ===========

 // Figure out which browser is running
 var nn4 = (document.layers) ? true : false 
 var ie = (document.all) ? true : false 
 var dom = (document.getElementById && !document.all) ? true : false  

// Used to reference dHTML elements browser-specifically 
function browser(id) {
  if (nn4)	{ path = document.layers[id] }
  else if (ie)	{ path = document.all[id] }
  else		{ path = document.getElementById(id) } ;
  return path
}

// Toggle content in the JmolShell side-bar
// The following assumes overlapping DIV's containing content
// on the left side. It allows toggling visibility so that only
// one is showing at a time 
function ShowDiv(id)
{ browser("Main").style.visibility="hidden";
  browser("About").style.visibility="hidden";
  browser("Cmd").style.visibility="hidden";
  browser("Presets").style.visibility="hidden";
  browser("Help").style.visibility="hidden";
  browser(id).style.visibility="visible";
  //alert("--"+browser("Main").style.visibility + "--" + browser("About").style.visibility + "--");
}

// ========== Functions that can be called within the HTML page ====

// This function simplifies the generation of toggle boxes with the explicit
//  function of turning monitor lines on/off
function ToggleMonitor(atom1,atom2,InTextLbl)
{
  t = "\<script\>jmolCheckbox(" + 
	"\"select atomno=" + atom1 + " or atomno=" + atom2 + ";spacefill 250;" +
	"monitor " + atom1 + " " + atom2 + "\"," + 
	"\"select atomno=" + atom1 + " or atomno=" + atom2 + ";spacefill off;" +
	"monitor " + atom1 + " " + atom2 + "\"," + 
	"\"" + InTextLbl + "\")\<\/script\>";
  document.write(t);
}

// Function to write a series of controls useful for animations
function AnimControls(nframes)
{
	RunScriptC = ";animation fps 1;animation on";
	RunRScript = "frame " + nframes + ";animation direction -1;animation mode once" + RunScriptC;
	RunFScript = "frame 1;animation direction +1;animation mode once" + RunScriptC;
	t = "Run: " +
		"\<script\>" +
		"jmolButton(\"" + RunRScript + "\", \"\\<\");" +
		"jmolButton(\"" + RunFScript + "\", \"\\>\");" +

		"\<\/script\>";

	t += p + "Step: " +
		"\<script\>" +
		"jmolButton(\"frame 1\", \"\\<\\<\");" +

		"jmolButton(\"animation frame prev\", \"\\<\");" +

		"jmolButton(\"animation frame next\", \"\\>\");" +

		"jmolButton(\"frame " + nframes  + "\", \"\\>\\>\")" +
		"\<\/script\>" +
		p +
		"\<form\>\<script\>" +
 		"jmolRadioGroup([";

	for (i=1; i<=nframes; i++)
		{ t += "[\"frame " + i + "\",\"\",\"\"],"  }
	
	t += " ], \" \", \"\") " +
		"\<\/script\>\<\/form\>";
		
	document.write(t);
}

// ========== General functions ===========

// Given a string with multiple lines, reverses the line order
//  (not currently used)
function ReverseLi(st)
{
    st = st.replace("\r\n","\n");
    st = st.replace("\r","\n");
	st_Arr = st.split("\n");
	st_New  = "";
	for (i=0; i<st_Arr.length; i++)
		{ st_New = st_Arr[i] + "\n" + st_New; }
	return st_New;
}

// Called by SetupPage. Draws the menu buttons that control
// visibility of the DIV panels
function NavLink(lnk,txt,Dscr)
{ st_D = (Dscr=="") ? "" : " title=\"" + Dscr + "\"";
  return "\<a href=\"javascript:ShowDiv(\'" + lnk + "\')\"" + st_D + "\>" + txt + "\<\/a\>"; }

// ---------------

// Appends 'px' units to a number, but not to a string
// Used by DivStartTag only
function AddU(x)
{ return (typeof(x) == "number") ? x+"px" : x }

// ---------------

// replace all occurences of x by y in st
function rplc(st, x, y) {

  if ((x == y) || (parseInt(y.indexOf(x)) > -1)) { return st }
    
  while (st.indexOf(x) != -1) {
    st = st.substring(0, st.indexOf(x)) + y
		+ st.substring(st.indexOf(x) + x.length, st.length);  }
  return st;
}

// ---------------

// Defines a "DIV" start tag, with full style information
function DivStartTag(divid, positn, brdr, brdrwid, brdrstyl, tp, lft, wdth, hght, scrllng, overflw, mrgn, pad,
						txtalgn, fontcolor, fontfam, fontsz, linehght, fontwgt, fontstyl,vsbl)
{
  var st = "\<div id=\"" + divid + "\" style=\"";
	if (positn != "")	st += " position: " + positn;
	if (brdr != "")		st += "; border: " + AddU(brdr);
	if (brdrwid != "")	st += "; border-width: " + AddU(brdrwid);
	if (brdrstyl != "")	st += "; border-style: " + brdrstyl;
	if (tp != "")		st += "; top: " + AddU(tp);
	if (lft != "")		st += "; left: " + AddU(lft);
	if (wdth != "")		st += "; width: " + AddU(wdth);
	if (hght != "")		st += "; height: " + AddU(hght);
//	if (scrllng != "")	st += "; scrolling: " + scrllng;
	if (overflw != "")	st += "; overflow: " + overflw;
	if (mrgn != "")		st += "; margin: " + AddU(mrgn);
	if (pad != "")		st += "; padding: " + AddU(pad);
	if (fontcolor != "") st += ";color : " + fontcolor;
	if (fontfam != "")	st += "; font-family: " + fontfam;
	if (txtalgn != "")	st += "; text-align: " + txtalgn;
	if (fontsz != "")	st += "; font-size: " + AddU(fontsz);
	if (linehght != "")	st += "; line-height: " + AddU(linehght);
	if (fontwgt != "")	st += "; font-weight: " + fontwgt;
	if (fontstyl != "")	st += "; font-style:  " + fontstyl;
	if (vsbl != "")		st += "; visibility:  " + vsbl;
	st += "\" \>";
	//alert(st);
 return st;
}

// ---------------

// returns a string defining a new DIV (used internally only)
function LeftDIV(id, tp, wd, vz, scrll)
{ scrl = (arguments.length<5) ? "yes" : scrll;
  return DivStartTag(id,"absolute", 1, 1, "solid", tp, 0, (wd-15), "90%", scrl, "auto", "", 2,
						"", "", fontfam, FontSzG, (FontSzG+2), "", "",vz); }

// Places a string right-adjusted (used internally only)
function floatRight(st)
  { return "\<span style=\"position: relative; float:right;\"\>" + st + "\<\/span\>"; }
// ---------------

// put Email tags for me and for the user
function EMailTagName(RealName, User, domain)
{ return "\<a href=\"mailto:" + User + "@" + domain + "\"\>" + RealName + "\<\/a\>" }

// ---------------

function EMailTag(User, domain)
{ return "\<a href=\"mailto:" + User + "@" + domain + "\"\>" + User + "@" + domain + "\<\/a\>" }

// ---------------

function SetTagLine(PDBid, Dscr,Citation) {
  DscrPlus = Dscr + "\<br\>\<SPAN STYLE=\"font-size: 70%; line-height: 8pt;\"\>" + Citation+ "\<\/SPAN\>"
  st = (PDBid == "" ) ? DscrPlus :
	LinkTag(PDB_Search + PDBid,
		"ProteinDataBank", PDBid,"Click here to go to entry at the PDB") + " - "+ DscrPlus;
  TagLineSpan.innerHTML = st;
}

// --------------

function FntSz(txt,sz) {
  st = "\<SPAN STYLE=\"font-size: " + sz + "%;\"\>" + txt + "\<\/SPAN\>";
  return st;
}

// ---------------

// Return an HTML link to go somewhere
function LinkTag(Dest,Targt,Txt,Dscr)
{ st_D = (Dscr=="") ? "" : " title=\"" + Dscr + "\"";
  return "\<a href=\"" + Dest + "\" target=\"" + Targt + "\"" + st_D + "\>" + Txt + "\<\/a\>" }

// ======== Routines for generating form elements (used by CmdLine code) =======

// return a complete Select element for a form. Generates a pop-up menu
function SelectTag(nam,onchng,optns)
{	if (onchng != "") onchng += "()";
	optns = "\<option\>" + optns.replace(/,/g,"\<option\>");
	var st = "\<select name=\"" + nam + "\" size=\"1\" onchange=\"" + onchng + "\"" 
		+ " WIDTH=\"59\" style=\"font-size: " + (FontSzG-2)+ "px; width: 59px\"" + "\>"
		+ optns + "\<\/select\>";
	return st;
}

// Return an "input" form element
function InputTextTag(nam,onchng,styl,sz,maxsz)
{	if (onchng != "") onchng = " onchange=\"" + onchng + "()\"";
	var st = "\<input name=\"" + nam + "\" type=\"text\" size=\"" + sz + "\" maxlength=\"" + maxsz + "\""
	+ onchng + "\>";
	return st;
}

// Return an "checkbox" form element
function InputTextToggle(nam,onchng,styl)
{	if (onchng != "") onchng = " onchange=\"" + onchng + "()\"";
	var st = "\<input name=\"" + nam + "\" type=\"checkbox\""
	+ onchng + "\>";
	return st;
}

// Return a "radio button" form element
function InputRadio(grpnam,rtnval,onchng,IsChecked,styl)
{	if (onchng != "") onchng = " onclick=\"" + onchng + "()\"";
	(IsChecked != "") ? IsChecked = " CHECKED" : IsChecked = "";
	var st = "\<input name=\"" + grpnam + "\" type=\"radio\" Value=\"" + rtnval + "\" "
	+ onchng + IsChecked + "\>";
	return st;
}


// Return a "Clear" form element
function ClearTag() {
  return "\<span style=\"position: relative; float:right;\"\>"
	+ "\<input type=\"reset\" value=\"Clear\"" + fntstyl + "\>"
	+ "\<\/span\>";
}

// =============== jShell specific stuff ==================

// Reset protein to default view, coloring, etc
function Reset()
  { run("script " + ResetFileG); }

// ---------------

// Draws an HTML link to execute script to load new molecule
function LinkToLoadNew(filename,lnktxt,PDB,dscr,citation) {
  q = "\'";
  stdsc = "Load coordinates for " + PDB + " - " + dscr;
  stjsscrpt = "LoadNewPDB("
		+ q + filename + q + ","
		+ q + "" + q + ","
		+ q + PDB + q + ","
		+ q + dscr + q + ","
		+ q + citation + q
		+ ")";
  st = "\<A HREF=\"javascript:" + stjsscrpt + "\" TITLE=\"" + stdsc + "\"\>" + lnktxt + "\<\/A\>";
  document.writeln(st);
}

// Shows frame i of a model and updates the info header appropriately
function ShowFrame(i,PDB,dscr,citation) {
	var st = "frame " + i;
	jmolScript(st);
	SetTagLine(PDB,dscr,citation);
}

// Executes script to load new molecule and updates the info header appropriately
function LoadNewPDB(filename,scrpt,PDB,dscr,citation) {
	if (scrpt=="")
		{ scrpt = "script " + ResetFileG + ""  };
	var st = "load " + filename + ";" + scrpt;
	jmolScript(st);
	//alert(st);
	SetTagLine(PDB,dscr,citation);
}

// Writes HTML code to generate a button set for loading new molecules
// Call with the following
//  [filename,dscr,script,PDB,citation], [filename,btntxt,PDB,dscr,citation], ...
// Include as many buttons as you like
function ButtonsToLoadNew() {
  var btns = ButtonsToLoadNew.arguments;
  var nbtns = btns.length;
  st = "\<form\>";
  for (var i = 0; i < nbtns; i++) {
	filename = btns[i][0];
	dscr = btns[i][1];
	scrp = btns[i][2];
	PDB = btns[i][3];
	citation = btns[i][4];
	chkd = btns[i][5];
	chkd = (chkd=="CHECKED") ? " CHECKED" : "";
	
	//btntxt = dscr + FntSz("(" + PDB + ")","80");
	btntxt = dscr + " \<SMALL\>(" + PDB + ")\<\/SMALL\>";
	sti = "\<input type=\"radio\" name=\"Bub\" onClick="
		+ "\"LoadNewPDB(\'" + filename  + "\',"
		+ "\'" +  scrp  + "\',"
		+ "\'" +  PDB  + "\',"
		+ "\'" +  dscr  + "\',"
		+ "\'" +  citation  + "\'"
		+ ")\"" + chkd + "\>" +  btntxt + "\<br\>";
	st += sti;
  }
  st += "\<\/form\>";
  document.writeln(st);
}

// Write a routine like that above, but that switches frames only
//
//  [ for future development ]


// Send command(s) to Jmol, saving in History if Record mode is ON
function run(script)
  { jmolScript(script);
	with (document.history) {
		if (ScriptRecordOn.checked) {
			if (historyBox.value != "") historyBox.value += CrLf;
			historyBox.value += ReplaceAll(script,";",CrLf);
		}
	}
  }

// ---------- Stuff for message call back ------------

// Feedback on the recently picked atom
//  place the result into boxes on main page
function showpick(a,b)
{	b = ""+b;
	with (document.cline.PickBox) {
		var st = value;
		value = b+"\n"+st;
	}
	with (document.cline) {
		Res.value = b.substring(b.indexOf("[")+1,b.indexOf("]"));
		ResNo.value = b.substring(b.indexOf("]")+1,b.indexOf(":"));
		Chain.value = b.substring(b.indexOf(":")+1,b.indexOf("."));
		Atom.value = b.substring(b.indexOf(".")+1,b.indexOf("#"));
		AtomNo.value = b.substring( b.indexOf("#")+1 );
	}
}

// Messages from Jmol (info about number of atoms selected, etc)
//  this is specified in the MessageCallBack argument below
function showmsg(a,b,c)
{	b = ""+b;
	with (document.cline.MsgBox) {
		var st = value;
		value = b+"\n"+st;
	}
	with (document.Feedback.Messages) {
		var st = value;
		value = b+"\n"+st;
	}
	
	// The following (optionally) records content to a global variable
	if (CaptureMsgs=="true")
		{ if ((b.indexOf("Jmol executing")==-1) && (b.indexOf("Script completed")==-1) )
			{ MsgStore += b + "\n"; } }

	// the following responds to a prior request from ShowOr
	if (WaitingForO=="true") {
		istart = b.indexOf("moveto ");
		if (istart>-1) {
			WaitingForO = "false";
			with (document.EnviroForm) {
				st = b.substring(istart,b.indexOf("OR")-2);
				CurrOr.value = st;
				DoEnviroForm();
			}
	 	 }
  	}

	// If the system was waiting for a completed message to be sent
	//   then do something
	if (b.indexOf("Script completed")>-1)
		{
		if (CaptureMsgs=="true")
			{
			CaptureMsgs="false";
			DisplayHeaderWrap();
			}
		}	

	LastMsgSet = b;
	
	//alert("showmsg: " + a + " !! " + b);
}

// Modification of routine in Jmol.js
// Taken from v10.0.35  9-8-05
//  Added two lines to allow for MessageCallback and PickCallback
function CM_jmolApplet(size, inlineModel, script, nameSuffix) {
  with (_jmol) {
    if (! nameSuffix)
      nameSuffix = appletCount;
    appletSuffixes.push(nameSuffix);
    ++appletCount;
    if (! script)
      script = "select *";
    var sz = _jmolGetAppletSize(size);
    var t;
    t = "<applet name='jmolApplet" + nameSuffix +
      "' id='jmolApplet" + nameSuffix +
      "' " + appletCssText +
      " code='JmolApplet'" +
      " archive='" + archivePath + "' codebase='" + codebase + "'\n" +
      " width='" + sz[0] + "' height='" + sz[1] +
      "' mayscript='true'>\n" +
        "  <param name=\"MessageCallback\" value=\"showmsg\" /\>\n " + // CM Added
        "  <param name=\"PickCallback\" value=\"showpick\" /\>\n " +   // CM Added
      "  <param name='progressbar' value='true' />\n" +
      "  <param name='progresscolor' value='" +
      progresscolor + "' />\n" +
      "  <param name='boxmessage' value='" +
      boxmessage + "' />\n" +
      "  <param name='boxbgcolor' value='" +
      boxbgcolor + "' />\n" +
      "  <param name='boxfgcolor' value='" +
      boxfgcolor + "' />\n" +
      "  <param name='ReadyCallback' value='_jmolReadyCallback' />\n";
    
    if (inlineModel)
      t += "  <param name='loadInline' value='" + inlineModel + "' />\n";
    if (script)
      t += "  <param name='script' value='" +
           _jmolSterilizeScript(script) + "' />\n";
    t += "</applet>";
    jmolSetTarget(nameSuffix);
    ready["jmolApplet" + nameSuffix] = false;
    if (_jmol.debugAlert)
      alert(t);
    document.write(t);
  }
}


//==================== Special section for User DIVs ============

// Only the first function should be called by the User

// Called by the User. It marks the beginning of a new user-defined DIV.
//  It writes the necessary code to start a new DIV (and finish the previous),
//    but also adds to the global arrays UserMenu and UserDscr
//  By default, the DIV defined first is visible. The rest are hidden.
function StartNewDiv(DivName,Dscr,LastUpDate) {
  Vsbl = (UserMenu.length==0) ? "visible" : "hidden";
  EndDivTag = "\" style=\"position:absolute;left:0px;top:"
	+ UserMenuHght + "px;height:" + UsercmdHgt + "px;"
	+ "width:" + sideBarFinalW + "px;overflow:auto;border:0px;padding:8px;visibility:"
	+ Vsbl + "\"\>";
  UserMenu[UserMenu.length] = DivName;
  UserDscr[UserDscr.length] = Dscr + " (last updated " + LastUpDate + ")";
  st = (UserMenu.length>1) ? "</DIV>" : "";
  st += "\<div id=\"" + DivName + EndDivTag;
  document.writeln(st);
}

// This is used when the user clicks on a menu item in the UserMenu
//  it hides all User Divs, and then enables the one passed
function ShowUserDiv(id)
{  for(var i=0; i< UserMenu.length; i++) {
		browser(UserMenu[i]).style.visibility="hidden";  }
  browser(id).style.visibility="Visible";
}

// Writes a menu, using the table construct
// Called as a part of WrapUp, so that it knows what to draw
//   Gets information from the passed arrays UserMenu and UserDscr
function WriteMenu(MenuItems,DescItems)
{
 // Define a DIV for this menu, at the top of the enclosing DIV
 st = "\<DIV id=\"UserMenu\" style=\"position:absolute;left:0px;top:0px;height:"
	+ UserMenuHght + "px;"
	+ "width:" + sideBarFinalW + "px;overflow:auto;border:0px;padding:0px\"\>";
 var n = MenuItems.length;
 var mWid = Math.round((sideBarFinalW)/n);
 FrntSt = "\<TD width=\"" + mWid + "\"\>\<A HREF=\"javascript:ShowUserDiv(\'";
 MidSt1 = "\')\" title=\'";
 MidSt2 = "\'\>";
 EndSt = "\<\/A\>\<\/TD\>";

 // Write a table containing the menu elements, then close this DIV
 st += "\<TABLE BORDER=\"0\" CELLSPACING=\"2\" CELLPADDING=\"1\" BGCOLOR=\"#FFFFCC\"\>";
 st += "\<TR ALIGN=\"center\" VALIGN=\"top\"\>";
 for(var i=0; i< n; i++) {
	st += FrntSt + MenuItems[i] + MidSt1 + DescItems[i] + MidSt2 + MenuItems[i] + EndSt;
 }
 st += "\<\/TABLE\>\<\/DIV\>";
 document.writeln(st);
 //alert(st);
}


//================================================================
//======== These draw the bulk of the page for the user ==========

// Define and write a Jmol Applet, sized dynamically
//
//	Arguments to the function JmolAppl are:
//
//	       pdbfile:  the name of the pdb coordinate file
//	     scrptfile:  the name of a default script file to run after loading
//          PDBid:  the PDB identifier for this structure
//         StDescr:  a description of the structure (eg, name of the protein)
//        Citation:  journal reference for the structure presented
//        PubMedID:  PubMed ID for the above journal reference
//          Author:  name of the author of this particular presentation
//     LastUpdated:  Date this particular presentation was last updated
//
//			== the following paramters are optional ==
//
//     SupportPath:  the path to the support folder (default: same folder)
//      sideBarWid: width, in pixels, of the sidebar (default: 290)

function JmolAppl(pdbfile,scrptfile,PDBid,StDescr,Citation,PubMedID,
                  Author,LastUpdated,SupportPath,sideBarWid) 
{
  var UseSignedAppl;
  if (! sideBarWid) sideBarWid = 290;
  if (sideBarWid<290) sideBarWid = 290;

  if (! SupportPath) SupportPath = "./";


  // vertical height for the single command line entry box
  var cmdHgt=50;

  // Figure out if being called locally or via the net
  jmolDebugAlert(JmolDebugStatus);
  if (JmolDebugStatus) alert("JmolDebugStatus on");
  UseSignedAppl = (document.location.host=="") ? ("1"=="1") : "";
  //alert("UseSignedAppl = <" + UseSignedAppl + ">");

  // First, call a setup routine in Jmol.js
  jmolInitialize(SupportPath,UseSignedAppl);
  jmolCheckBrowser("alert","This browser does not fully support Jmol. " + 
	"Some functions are limited.");

  //Figure out dimensions of the browser window
  if (parseInt(navigator.appVersion)>3) {
   if (navigator.appName=="Netscape") {
	jWid = window.innerWidth-sideBarWid-40;
	jHgt = window.innerHeight-cmdHgt-40;
   }
   if (navigator.appName.indexOf("Microsoft")!=-1) {
	jWid = document.body.offsetWidth-sideBarWid-40;
	jHgt = document.body.offsetHeight-cmdHgt-40;
	alert("Warning, this product does not play well with Microsoft!");
   }
  }
  
  // Update the SupportPath and other global variables from calling params
  //if (sideBarWid<200) sidebarwid = 200;
  AuthorG = Author;
  CitationG = Citation;
  PubMedIDG = PubMedID;
  ResetFileG = scrptfile;
  LastUpdatedG = LastUpdated;
  var DivEnd = "\<\/div\>";
  ((navigator.appVersion.indexOf("Mac") != -1)) ? FontSzG = 12 : FontSzG = 10;
  ((navigator.appVersion.indexOf("Mac") != -1)) ? CrLf = "\r" : CrLf = "\n";

  UsercmdHgt = jHgt - UserMenuHght-7;
  //alert("Params set. UsercmdHgt = "+UsercmdHgt);
  sideBarFinalW = sideBarWid-30;

  // change the title of the window to a description of the structure
  document.title = PDBid+" - "+StDescr;

//    Layout of "DIV" elements (Main, About, Cmd, Help overlap each other)
// +----------+-----------------------------------------+
// |			|									|
// |	MenuD	|									|
// |			|									|
// +---------+									|
// |			|			Appd					|
// |	Main	|									|
// |	About	|									|
// |	Cmd	|									|
// |	Help	|									|
// |			|									|
// +----------+-----------------------------------------+

// ----------- Then, draw the 'Appd' DIV with the applet containing the structure ---------------


// Write the DIV layer to contain the applet
  document.writeln(DivStartTag("Appd","absolute", "", "", "", "0", sideBarWid+1, "", "", "", "", "", "",
						"left", "", fontfam, FontSzG, (FontSzG+2), "", "",""));

  jmolSetAppletColor("white", "black", "white", "white");

  LoadScript = "load " + pdbfile;
  if (scrptfile) LoadScript += ";script " + scrptfile;
  // Write the JMol applet within this DIV
  CM_jmolApplet([jWid,jHgt], null, LoadScript);

  // Write a form containing a box for user-entered commands, then close the DIV
  cmdWid = Math.round(jWid/7) - 21;
  st = "\<form name=\"cline\" onSubmit="
  	+ "\"run(document.cline.jmscript.value);document.cline.jmscript.select();"
  	+ "document.cline.jmscript.value=''; return false\"\>"

  	+ "\<input name=\"jmscript\" type=\"text\" value=\"Enter single Jmol commands here\" "
  	+ "onfocus=\"if (this.value=='Enter single Jmol commands here') this.value=''\" size=\""+cmdWid+"\" "
	+ "maxlength=\"200\" " + fntstyl + "\>";

  // Write boxes for parsed picking stuff
  st +=  "\<input name=\"Res\" value=\"Res\" size=5 " + fntstyl + " \>"
	+ "\<input name=\"ResNo\" value=\"ResNo\" size=5 " + fntstyl + " \>"
	+ "\<input name=\"Chain\" value=\"Ch\" size=2 " + fntstyl + " \>"
	+ "\<input name=\"Atom\" value=\"Atom\" size=5 " + fntstyl + " \>"
	+ "\<input name=\"AtomNo\" value=\"AtomNo\" size=6 " + fntstyl + " \>";


  // Write a box for pickingcallback stuff
  st += "\<br\>\<textarea name=\"MsgBox\"  value=\"\""
	+ "  cols=\"" + (cmdWid-2) + "\" rows=4" + fntstyl + " \>"
	+ "\<\/textarea\>";

  // Write a box for messsagecallback stuff
  st += "\<textarea name=\"PickBox\"  value=\"\""
	+ "  cols=\"24\" rows=3" + fntstyl + "\>"
	+ "\<\/textarea\>"
  	+ "\<\/form\>";

  st += DivEnd;
  document.writeln(st);

// ------------ Next, draw the 'MenuD' DIV box to the top left --------------

// Draw the menu at the top
  var MenuHgt = 65;
  var st_Menu = DivStartTag("MenuD","absolute", 1, 1, "solid", "0", 0, (sideBarWid-15), MenuHgt-5, "", "hidden", "", 2,
						"center", "Green", fontfam, FontSzG, (FontSzG+2), "bold", "","")
 	+ NavLink("Main","Main","The descriptive content for this molecule")
		+ " | " 		
	+ NavLink("About","About","Information about this molecule and about JmolShell. Literature citation.")
		+ " | "
	+ NavLink("Cmd","Cmd","A box to enter multiple Jmol commands. Record and get feedback as well.")
		+ " | "		
	+ NavLink("Presets","Presets","Execute Jmol commands by example")
		+ " | "
	+ NavLink("Help","Help","Help on using Jmol. Links to documentation.")
		+ " || "
	+ "\<a href=\"javascript:Reset()\" title=\"Reset structure to starting point\"\>Reset\<\/a\>"
	+ "\<hr\>\<span id=\"TagLineSpan\"\>" + "loading..." + "\<\/span\>" + DivEnd;
  document.writeln(st_Menu);
  //alert(st_Menu);

// ------- Next, draw the 'Main,About,Help,&Cmd' DIV boxes to the left ----------

// Draw a the left-content, multiple times overlapping
// All but the main panel are set to invisible for now.
// Main must be last and is left open-ended, since user content in the calling page will follow

  var st_About = LeftDIV("About", MenuHgt, sideBarWid,"hidden") +jAbout() + DivEnd;
  var st_Cmd = LeftDIV("Cmd", MenuHgt, sideBarWid,"hidden","no") + CmdLineHTML + DivEnd;
  var st_Help = LeftDIV("Help", MenuHgt, sideBarWid,"hidden") + HelpHTML + DivEnd;
  var st_Presets = LeftDIV("Presets", MenuHgt, sideBarWid,"hidden") + PresetsHTML + DivEnd;
  var st_Main = LeftDIV("Main", MenuHgt, sideBarWid,"visible");
  document.writeln(st_About + st_Cmd + st_Help + st_Presets + st_Main);

// Update the Tag Line
	SetTagLine(PDBid, StDescr,Citation);

}

// =================================================================

// Call this after the User's HTML
function WrapUpPage()
{ 
  // If the user defined User (sub-) DIV's, wrap that up
  if (UserMenu.length>0) {
	document.writeln("\<\/DIV\>");
	WriteMenu(UserMenu,UserDscr);
  }

  // Close up the primary User HTML stuff
  document.writeln("\<\/div\>"); 
  run(StartUpScript);
}

