/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import java.util.BitSet;
import java.util.Hashtable;
import org.jmol.modelset.ModelSet;
import org.jmol.util.Logger;
import org.jmol.viewer.JmolConstants;

class Molecule {
    ModelSet modelSet;
    int moleculeIndex;
    int modelIndex;
    int indexInModel;
    int nAtoms;
    int nElements;
    int[] elementCounts = new int[JmolConstants.elementNumberMax];
    int[] altElementCounts = new int[JmolConstants.altElementMax];
    int elementNumberMax;
    int altElementMax;
    String mf;
    BitSet atomList;

    Molecule(ModelSet modelSet, int n, BitSet bitSet, int n2, int n3) {
        this.modelSet = modelSet;
        this.atomList = bitSet;
        this.moleculeIndex = n;
        this.modelIndex = n2;
        this.indexInModel = n3;
        this.getElementAndAtomCount(bitSet);
        this.mf = this.getMolecularFormula();
        if (Logger.isActiveLevel((int)0)) {
            Logger.debug((String)("new Molecule (" + this.mf + ") " + (n3 + 1) + "/" + (n2 + 1)));
        }
    }

    void getElementAndAtomCount(BitSet bitSet) {
        for (int i = 0; i < this.modelSet.atomCount; ++i) {
            if (!bitSet.get(i)) continue;
            ++this.nAtoms;
            int n = this.modelSet.atoms[i].getAtomicAndIsotopeNumber();
            if (n < 128) {
                int n2 = n;
                this.elementCounts[n2] = this.elementCounts[n2] + 1;
                if (this.elementCounts[n] == 1) {
                    ++this.nElements;
                }
                this.elementNumberMax = Math.max(this.elementNumberMax, n);
                continue;
            }
            int n3 = n = JmolConstants.altElementIndexFromNumber(n);
            this.altElementCounts[n3] = this.altElementCounts[n3] + 1;
            if (this.altElementCounts[n] == 1) {
                ++this.nElements;
            }
            this.altElementMax = Math.max(this.altElementMax, n);
        }
    }

    String getMolecularFormula() {
        int n;
        int n2;
        String string = "";
        String string2 = "";
        for (n2 = 1; n2 <= this.elementNumberMax; ++n2) {
            n = this.elementCounts[n2];
            if (n == 0) continue;
            string = string + string2 + JmolConstants.elementSymbolFromNumber(n2) + " " + n;
            string2 = " ";
        }
        for (n2 = 1; n2 <= this.altElementMax; ++n2) {
            n = this.altElementCounts[n2];
            if (n == 0) continue;
            string = string + string2 + JmolConstants.elementSymbolFromNumber(JmolConstants.altElementNumberFromIndex(n2)) + " " + n;
            string2 = " ";
        }
        return string;
    }

    Hashtable getInfo() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("number", new Integer(this.moleculeIndex + 1));
        hashtable.put("modelNumber", this.modelSet.getModelNumberDotted(this.modelIndex));
        hashtable.put("numberInModel", new Integer(this.indexInModel + 1));
        hashtable.put("nAtoms", new Integer(this.nAtoms));
        hashtable.put("nElements", new Integer(this.nElements));
        hashtable.put("mf", this.mf);
        return hashtable;
    }
}

