/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import org.jmol.g3d.Graphics3D;
import org.jmol.modelset.Atom;
import org.jmol.modelset.ModelSet;
import org.jmol.util.ArrayUtil;
import org.jmol.util.ColorEncoder;
import org.jmol.util.Logger;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.Viewer;

class ColorManager {
    private Viewer viewer;
    private Graphics3D g3d;
    private int[] argbsCpk;
    private int[] altArgbsCpk;
    private float colorHi;
    private float colorLo;
    private float[] colorData;
    private int palette = 0;
    private boolean isDefaultColorRasmol;
    short colixRubberband = (short)22;
    short colixBackgroundContrast;

    ColorManager(Viewer viewer, Graphics3D graphics3D) {
        this.viewer = viewer;
        this.g3d = graphics3D;
        this.argbsCpk = JmolConstants.argbsCpk;
        this.altArgbsCpk = ArrayUtil.arrayCopy((int[])JmolConstants.altArgbsCpk, (int)0, (int)-1, (boolean)false);
    }

    boolean getDefaultColorRasmol() {
        return this.isDefaultColorRasmol;
    }

    void resetElementColors() {
        this.setDefaultColors("Jmol");
    }

    void setDefaultColors(String string) {
        if (string.equalsIgnoreCase("Jmol")) {
            this.isDefaultColorRasmol = false;
            this.argbsCpk = JmolConstants.argbsCpk;
        } else if (string.equalsIgnoreCase("RasMol")) {
            this.isDefaultColorRasmol = true;
            this.argbsCpk = ColorEncoder.getRasmolScale((boolean)true);
        } else {
            Logger.error((String)"unrecognized color scheme");
            return;
        }
        this.altArgbsCpk = ArrayUtil.arrayCopy((int[])JmolConstants.altArgbsCpk, (int)0, (int)-1, (boolean)false);
        ColorEncoder.makeColorScheme((String)string, null, (boolean)true);
        int n = JmolConstants.argbsCpk.length;
        while (--n >= 0) {
            this.g3d.changeColixArgb((short)n, this.argbsCpk[n]);
        }
        n = JmolConstants.altArgbsCpk.length;
        while (--n >= 0) {
            this.g3d.changeColixArgb((short)(JmolConstants.elementNumberMax + n), this.altArgbsCpk[n]);
        }
    }

    void setRubberbandArgb(int n) {
        this.colixRubberband = n == 0 ? (short)0 : Graphics3D.getColix((int)n);
    }

    void setColixBackgroundContrast(int n) {
        this.colixBackgroundContrast = (short)((Graphics3D.calcGreyscaleRgbFromRgb((int)n) & 0xFF) < 128 ? 8 : 4);
    }

    short getColixAtomPalette(Atom atom, byte by) {
        int n = 0;
        switch (by) {
            case 83: {
                return this.getPropertyColix(atom.getAtomIndex());
            }
            case 0: 
            case 1: {
                short s = atom.getAtomicAndIsotopeNumber();
                if (s < 256) {
                    return this.g3d.getChangeableColix(s, this.argbsCpk[s]);
                }
                s = (short)JmolConstants.altElementIndexFromNumber(s);
                return this.g3d.getChangeableColix((short)(JmolConstants.elementNumberMax + s), this.altArgbsCpk[s]);
            }
            case 2: {
                int n2 = ColorEncoder.quantize((float)atom.getPartialCharge(), (float)-1.0f, (float)1.0f, (int)31);
                return this.g3d.getChangeableColix((short)(JmolConstants.PARTIAL_CHARGE_COLIX_RED + n2), JmolConstants.argbsRwbScale[n2]);
            }
            case 3: {
                int n3 = atom.getFormalCharge() - -4;
                return this.g3d.getChangeableColix((short)(JmolConstants.FORMAL_CHARGE_COLIX_RED + n3), JmolConstants.argbsFormalCharge[n3]);
            }
            case 5: 
            case 68: {
                float f;
                float f2;
                if (by == 68) {
                    ModelSet modelSet = this.viewer.getModelSet();
                    f2 = modelSet.getBfactor100Lo();
                    f = modelSet.getBfactor100Hi();
                } else {
                    f2 = 0.0f;
                    f = 10000.0f;
                }
                return ColorEncoder.getColorIndexFromPalette((float)atom.getBfactor100(), (float)f2, (float)f, (int)3);
            }
            case 70: {
                float f = this.viewer.getSurfaceDistanceMax();
                return ColorEncoder.getColorIndexFromPalette((float)atom.getSurfaceDistance100(), (float)0.0f, (float)f, (int)3);
            }
            case 8: {
                return ColorEncoder.getColorIndexFromPalette((float)atom.getGroupID(), (float)0.0f, (float)0.0f, (int)9);
            }
            case 9: {
                return ColorEncoder.getColorIndexFromPalette((float)atom.getGroupID(), (float)0.0f, (float)0.0f, (int)8);
            }
            case 75: {
                return ColorEncoder.getColorIndexFromPalette((float)atom.getSelectedGroupIndexWithinChain(), (float)0.0f, (float)(atom.getSelectedGroupCountWithinChain() - 1), (int)1);
            }
            case 76: {
                return ColorEncoder.getColorIndexFromPalette((float)atom.getSelectedMonomerIndexWithinPolymer(), (float)0.0f, (float)(atom.getSelectedMonomerCountWithinPolymer() - 1), (int)1);
            }
            case 77: {
                ModelSet modelSet = this.viewer.getModelSet();
                return ColorEncoder.getColorIndexFromPalette((float)modelSet.getMoleculeIndex(atom.getAtomIndex()), (float)0.0f, (float)(modelSet.getMoleculeCountInModel(atom.getModelIndex()) - 1), (int)0);
            }
            case 14: {
                ModelSet modelSet = this.viewer.getModelSet();
                int n4 = atom.getModelIndex();
                return ColorEncoder.getColorIndexFromPalette((float)modelSet.getAltLocIndexInModel(n4, (char)atom.getAlternateLocationID()), (float)0.0f, (float)modelSet.getAltLocCountInModel(n4), (int)0);
            }
            case 15: {
                ModelSet modelSet = this.viewer.getModelSet();
                int n5 = atom.getModelIndex();
                return ColorEncoder.getColorIndexFromPalette((float)modelSet.getInsertionCodeIndexInModel(n5, atom.getInsertionCode()), (float)0.0f, (float)modelSet.getInsertionCountInModel(n5), (int)0);
            }
            case 16: {
                short s = atom.getAtomicAndIsotopeNumber();
                n = ColorManager.getJmolOrRasmolArgb(s, 262190);
                break;
            }
            case 17: {
                short s = atom.getAtomicAndIsotopeNumber();
                n = ColorManager.getJmolOrRasmolArgb(s, 262149);
                break;
            }
            case 7: {
                n = JmolConstants.argbsStructure[atom.getProteinStructureType()];
                break;
            }
            case 10: {
                int n6 = atom.getChainID() & 0x1F;
                if (n6 < 0) {
                    n6 = 0;
                }
                if (n6 >= JmolConstants.argbsChainAtom.length) {
                    n6 %= JmolConstants.argbsChainAtom.length;
                }
                n = (atom.isHetero() ? JmolConstants.argbsChainHetero : JmolConstants.argbsChainAtom)[n6];
            }
        }
        return n == 0 ? (short)22 : (short)Graphics3D.getColix((int)n);
    }

    private short getPropertyColix(int n) {
        if (this.colorData == null || n >= this.colorData.length) {
            return 12;
        }
        return this.getColixForPropertyValue(this.colorData[n]);
    }

    private static int getJmolOrRasmolArgb(int n, int n2) {
        switch (n2) {
            case 262190: {
                if (n >= 256) break;
                return ColorEncoder.getArgbFromPalette((float)n, (float)0.0f, (float)0.0f, (int)6);
            }
            case 262149: {
                if (n >= 256) break;
                return ColorEncoder.getArgbFromPalette((float)n, (float)0.0f, (float)0.0f, (int)7);
            }
            default: {
                return n2;
            }
        }
        return JmolConstants.altArgbsCpk[JmolConstants.altElementIndexFromNumber(n)];
    }

    void setElementArgb(int n, int n2) {
        if (n2 == 262190 && this.argbsCpk == JmolConstants.argbsCpk) {
            return;
        }
        n2 = ColorManager.getJmolOrRasmolArgb(n, n2);
        if (this.argbsCpk == JmolConstants.argbsCpk) {
            this.argbsCpk = ArrayUtil.arrayCopy((int[])JmolConstants.argbsCpk, (int)0, (int)-1, (boolean)false);
            this.altArgbsCpk = ArrayUtil.arrayCopy((int[])JmolConstants.altArgbsCpk, (int)0, (int)-1, (boolean)false);
        }
        if (n < 256) {
            this.argbsCpk[n] = n2;
            this.g3d.changeColixArgb((short)n, n2);
            return;
        }
        n = JmolConstants.altElementIndexFromNumber(n);
        this.altArgbsCpk[n] = n2;
        this.g3d.changeColixArgb((short)(JmolConstants.elementNumberMax + n), n2);
    }

    int setColorScheme(String string, boolean bl) {
        this.palette = ColorEncoder.getColorScheme((String)string, (boolean)bl);
        Logger.info((String)("ColorManager: color scheme now \"" + ColorEncoder.getColorSchemeName((int)this.palette) + "\" color value range: " + this.colorLo + " to " + this.colorHi));
        return this.palette;
    }

    float[] getCurrentColorRange() {
        return new float[]{this.colorLo, this.colorHi};
    }

    void setCurrentColorRange(float[] fArray, BitSet bitSet, String string) {
        this.colorData = fArray;
        this.palette = ColorEncoder.getColorScheme((String)string, (boolean)false);
        this.colorHi = Float.MIN_VALUE;
        this.colorLo = Float.MAX_VALUE;
        if (fArray == null) {
            return;
        }
        int n = fArray.length;
        while (--n >= 0) {
            float f;
            if (bitSet != null && !bitSet.get(n) || Float.isNaN(f = fArray[n])) continue;
            this.colorHi = Math.max(this.colorHi, f);
            this.colorLo = Math.min(this.colorLo, f);
        }
        this.setCurrentColorRange(this.colorLo, this.colorHi);
    }

    void setCurrentColorRange(float f, float f2) {
        this.colorHi = f2;
        this.colorLo = f;
        Logger.info((String)("color \"" + ColorEncoder.getColorSchemeName((int)this.palette) + "\" range " + this.colorLo + " " + this.colorHi));
    }

    static String getState(StringBuffer stringBuffer) {
        return ColorEncoder.getState((StringBuffer)stringBuffer);
    }

    static void setUserScale(int[] nArray) {
        ColorEncoder.setUserScale((int[])nArray);
    }

    int[] getColorSchemeArray(String string) {
        return ColorEncoder.getColorSchemeArray((int)(string == null || string.length() == 0 ? this.palette : ColorEncoder.getColorScheme((String)string, (boolean)false)));
    }

    String getColorSchemeList(String string, boolean bl) {
        if (!bl && ColorEncoder.getColorScheme((String)string, (boolean)false) >= 0) {
            return "";
        }
        return ColorEncoder.getColorSchemeList((int[])this.getColorSchemeArray(string));
    }

    short getColixForPropertyValue(float f) {
        return this.colorLo < this.colorHi ? ColorEncoder.getColorIndexFromPalette((float)f, (float)this.colorLo, (float)this.colorHi, (int)this.palette) : ColorEncoder.getColorIndexFromPalette((float)(-f), (float)(-this.colorLo), (float)(-this.colorHi), (int)this.palette);
    }

    static short getColixHbondType(short s) {
        int n = (s & 0x7800) >> 11;
        return Graphics3D.getColix((int)JmolConstants.argbsHbondType[n]);
    }

    private static void flushCaches() {
        Graphics3D.flushShadesAndSphereCaches();
    }

    static void setSpecular(boolean bl) {
        if (Graphics3D.getSpecular() == bl) {
            return;
        }
        Graphics3D.setSpecular((boolean)bl);
        ColorManager.flushCaches();
    }

    static boolean getSpecular() {
        return Graphics3D.getSpecular();
    }

    static void setSpecularPercent(int n) {
        if (Graphics3D.getSpecularPercent() == n) {
            return;
        }
        Graphics3D.setSpecularPercent((int)n);
        ColorManager.flushCaches();
    }

    static int getSpecularPercent() {
        return Graphics3D.getSpecularPercent();
    }

    static void setSpecularPower(int n) {
        if (n < 0) {
            if (Graphics3D.getSpecularExponent() == -n) {
                return;
            }
            Graphics3D.setSpecularExponent((int)(-n));
        } else {
            if (Graphics3D.getSpecularPower() == n) {
                return;
            }
            Graphics3D.setSpecularPower((int)n);
        }
        ColorManager.flushCaches();
    }

    static void setDiffusePercent(int n) {
        if (Graphics3D.getDiffusePercent() == n) {
            return;
        }
        Graphics3D.setDiffusePercent((int)n);
        ColorManager.flushCaches();
    }

    static int getDiffusePercent() {
        return Graphics3D.getDiffusePercent();
    }

    static void setAmbientPercent(int n) {
        if (Graphics3D.getAmbientPercent() == n) {
            return;
        }
        Graphics3D.setAmbientPercent((int)n);
        ColorManager.flushCaches();
    }

    static int getAmbientPercent() {
        return Graphics3D.getAmbientPercent();
    }
}

