/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelsetbio;

import java.util.BitSet;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jmol.modelset.Atom;
import org.jmol.modelsetbio.AlphaPolymer;
import org.jmol.modelsetbio.AminoMonomer;
import org.jmol.modelsetbio.BioPolymer;
import org.jmol.modelsetbio.Monomer;
import org.jmol.util.Logger;
import org.jmol.util.Measure;

public class AminoPolymer
extends AlphaPolymer {
    short[] mainchainHbondOffsets;
    short[] min1Indexes;
    short[] min1Energies;
    short[] min2Indexes;
    short[] min2Energies;
    final Vector3f vectorPreviousOC = new Vector3f();
    final Point3f aminoHydrogenPoint = new Point3f();
    private static final float maxHbondAlphaDistance = 9.0f;
    private static final float maxHbondAlphaDistance2 = 81.0f;
    private static final float minimumHbondDistance2 = 0.5f;
    private static final double QConst = -27888.0;

    AminoPolymer(Monomer[] monomerArray) {
        super(monomerArray);
    }

    boolean hasWingPoints() {
        return true;
    }

    public void calcHydrogenBonds(BitSet bitSet, BitSet bitSet2) {
        this.initializeHbondDataStructures();
        this.calcProteinMainchainHydrogenBonds(bitSet, bitSet2);
    }

    void initializeHbondDataStructures() {
        int n;
        if (this.mainchainHbondOffsets == null) {
            this.mainchainHbondOffsets = new short[this.monomerCount];
            this.min1Indexes = new short[this.monomerCount];
            this.min1Energies = new short[this.monomerCount];
            this.min2Indexes = new short[this.monomerCount];
            this.min2Energies = new short[this.monomerCount];
        } else {
            n = this.monomerCount;
            while (--n >= 0) {
                this.min2Energies[n] = 0;
                this.min1Energies[n] = 0;
                this.mainchainHbondOffsets[n] = 0;
            }
        }
        n = this.monomerCount;
        while (--n >= 0) {
            this.min2Indexes[n] = -1;
            this.min1Indexes[n] = -1;
        }
    }

    void freeHbondDataStructures() {
        this.min2Energies = null;
        this.min2Indexes = null;
        this.min1Energies = null;
        this.min1Indexes = null;
        this.mainchainHbondOffsets = null;
    }

    void calcProteinMainchainHydrogenBonds(BitSet bitSet, BitSet bitSet2) {
        for (int i = 0; i < this.monomerCount; ++i) {
            AminoMonomer aminoMonomer = (AminoMonomer)this.monomers[i];
            this.mainchainHbondOffsets[i] = 0;
            if (i > 0 && aminoMonomer.getGroupID() != 15) {
                Point3f point3f = aminoMonomer.getNitrogenAtomPoint();
                this.aminoHydrogenPoint.add((Tuple3f)point3f, (Tuple3f)this.vectorPreviousOC);
                this.bondAminoHydrogen(i, this.aminoHydrogenPoint, bitSet, bitSet2);
            }
            Point3f point3f = aminoMonomer.getCarbonylCarbonAtomPoint();
            Point3f point3f2 = aminoMonomer.getCarbonylOxygenAtomPoint();
            this.vectorPreviousOC.sub((Tuple3f)point3f, (Tuple3f)point3f2);
            this.vectorPreviousOC.scale(1.0f / this.vectorPreviousOC.length());
        }
    }

    private void bondAminoHydrogen(int n, Point3f point3f, BitSet bitSet, BitSet bitSet2) {
        AminoMonomer aminoMonomer = (AminoMonomer)this.monomers[n];
        Point3f point3f2 = aminoMonomer.getLeadAtomPoint();
        Point3f point3f3 = aminoMonomer.getNitrogenAtomPoint();
        int n2 = 0;
        int n3 = 0;
        int n4 = -1;
        int n5 = -1;
        int n6 = this.monomerCount;
        while (--n6 >= 0) {
            AminoMonomer aminoMonomer2;
            Point3f point3f4;
            float f;
            if (n6 == n || n6 + 1 == n || n6 - 1 == n || (f = point3f2.distanceSquared(point3f4 = (aminoMonomer2 = (AminoMonomer)this.monomers[n6]).getLeadAtomPoint())) > 81.0f) continue;
            int n7 = this.calcHbondEnergy(aminoMonomer.getNitrogenAtom(), point3f3, point3f, aminoMonomer2);
            if (n7 < n2) {
                n3 = n2;
                n5 = n4;
                n2 = n7;
                n4 = n6;
                continue;
            }
            if (n7 >= n3) continue;
            n3 = n7;
            n5 = n6;
        }
        if (n4 >= 0) {
            this.mainchainHbondOffsets[n] = (short)(n - n4);
            this.min1Indexes[n] = (short)n4;
            this.min1Energies[n] = (short)n2;
            this.createResidueHydrogenBond(n, n4, bitSet, bitSet2);
            if (n5 >= 0) {
                this.createResidueHydrogenBond(n, n5, bitSet, bitSet2);
                this.min2Indexes[n] = (short)n5;
                this.min2Energies[n] = (short)n3;
            }
        }
    }

    private int calcHbondEnergy(Atom atom, Point3f point3f, Point3f point3f2, AminoMonomer aminoMonomer) {
        boolean bl;
        Point3f point3f3 = aminoMonomer.getCarbonylOxygenAtomPoint();
        float f = point3f3.distanceSquared(point3f);
        if (f < 0.5f) {
            return 0;
        }
        float f2 = point3f3.distanceSquared(point3f2);
        if (f2 < 0.5f) {
            return 0;
        }
        Point3f point3f4 = aminoMonomer.getCarbonylCarbonAtomPoint();
        float f3 = point3f4.distanceSquared(point3f2);
        if (f3 < 0.5f) {
            return 0;
        }
        float f4 = point3f4.distanceSquared(point3f);
        if (f4 < 0.5f) {
            return 0;
        }
        double d = Math.sqrt(f2);
        double d2 = Math.sqrt(f3);
        double d3 = Math.sqrt(f4);
        double d4 = Math.sqrt(f);
        int n = (int)(-27888.0 / d - -27888.0 / d2 + -27888.0 / d3 - -27888.0 / d4);
        boolean bl2 = bl = f4 > f3 && d <= 3.0 && n <= -500;
        return !bl ? 0 : (n < -9900 ? -9900 : n);
    }

    private void createResidueHydrogenBond(int n, int n2, BitSet bitSet, BitSet bitSet2) {
        short s;
        int n3 = n - n2;
        switch (n3) {
            case 2: {
                s = 4096;
                break;
            }
            case 3: {
                s = 6144;
                break;
            }
            case 4: {
                s = 8192;
                break;
            }
            case 5: {
                s = 10240;
                break;
            }
            case -3: {
                s = 12288;
                break;
            }
            case -4: {
                s = 14336;
                break;
            }
            default: {
                s = 2048;
            }
        }
        AminoMonomer aminoMonomer = (AminoMonomer)this.monomers[n];
        Atom atom = aminoMonomer.getNitrogenAtom();
        AminoMonomer aminoMonomer2 = (AminoMonomer)this.monomers[n2];
        Atom atom2 = aminoMonomer2.getCarbonylOxygenAtom();
        this.model.addHydrogenBond(atom, atom2, s, bitSet, bitSet2);
    }

    public void calculateStructures() {
        int n;
        char[] cArray = new char[this.monomerCount];
        this.calcPhiPsiAngles();
        for (n = 0; n < this.monomerCount - 1; ++n) {
            AminoMonomer aminoMonomer = (AminoMonomer)this.monomers[n];
            AminoMonomer aminoMonomer2 = (AminoMonomer)this.monomers[n + 1];
            float f = aminoMonomer2.getPhi();
            float f2 = aminoMonomer.getPsi();
            cArray[n] = AminoPolymer.isHelix(f2, f) ? (f < 0.0f && f2 < 25.0f ? 52 : 51) : (AminoPolymer.isSheet(f2, f) ? 115 : (AminoPolymer.isTurn(f2, f) ? 116 : 110));
            if (!Logger.isActiveLevel((int)0)) continue;
            Logger.debug((String)('\u0000' + this.monomers[0].getChainID() + " aminopolymer:" + n + " " + aminoMonomer2.getPhi() + "," + aminoMonomer.getPsi() + " " + cArray[n]));
        }
        for (n = 0; n < this.monomerCount; ++n) {
            int n2;
            if (cArray[n] != '4') continue;
            for (n2 = n + 1; n2 < this.monomerCount && cArray[n2] == '4'; ++n2) {
            }
            if (--n2 >= n + 3) {
                this.addSecondaryStructure((byte)3, n, n2);
            }
            n = n2;
        }
        for (n = 0; n < this.monomerCount; ++n) {
            int n3;
            if (cArray[n] != '3') continue;
            for (n3 = n + 1; n3 < this.monomerCount && cArray[n3] == '3'; ++n3) {
            }
            if (--n3 >= n + 3) {
                this.addSecondaryStructure((byte)3, n, n3);
            }
            n = n3;
        }
        for (n = 0; n < this.monomerCount; ++n) {
            int n4;
            if (cArray[n] != 's') continue;
            for (n4 = n + 1; n4 < this.monomerCount && cArray[n4] == 's'; ++n4) {
            }
            if (--n4 >= n + 2) {
                this.addSecondaryStructure((byte)2, n, n4);
            }
            n = n4;
        }
        for (n = 0; n < this.monomerCount; ++n) {
            int n5;
            if (cArray[n] != 't') continue;
            for (n5 = n + 1; n5 < this.monomerCount && cArray[n5] == 't'; ++n5) {
            }
            if (--n5 >= n + 2) {
                this.addSecondaryStructure((byte)1, n, n5);
            }
            n = n5;
        }
    }

    protected boolean calcPhiPsiAngles() {
        for (int i = 0; i < this.monomerCount - 1; ++i) {
            this.calcPhiPsiAngles((AminoMonomer)this.monomers[i], (AminoMonomer)this.monomers[i + 1]);
        }
        return true;
    }

    private void calcPhiPsiAngles(AminoMonomer aminoMonomer, AminoMonomer aminoMonomer2) {
        Point3f point3f = aminoMonomer.getNitrogenAtomPoint();
        Point3f point3f2 = aminoMonomer.getLeadAtomPoint();
        Point3f point3f3 = aminoMonomer.getCarbonylCarbonAtomPoint();
        Point3f point3f4 = aminoMonomer2.getNitrogenAtomPoint();
        Point3f point3f5 = aminoMonomer2.getLeadAtomPoint();
        Point3f point3f6 = aminoMonomer2.getCarbonylCarbonAtomPoint();
        aminoMonomer2.setPhi(Measure.computeTorsion((Point3f)point3f3, (Point3f)point3f4, (Point3f)point3f5, (Point3f)point3f6, (boolean)true));
        aminoMonomer.setPsi(Measure.computeTorsion((Point3f)point3f, (Point3f)point3f2, (Point3f)point3f3, (Point3f)point3f4, (boolean)true));
        aminoMonomer.setOmega(Measure.computeTorsion((Point3f)point3f2, (Point3f)point3f3, (Point3f)point3f4, (Point3f)point3f5, (boolean)true));
    }

    private static boolean isHelix(float f, float f2) {
        return f2 >= -160.0f && f2 <= 0.0f && f >= -100.0f && f <= 45.0f;
    }

    private static boolean isSheet(float f, float f2) {
        return f2 >= -180.0f && f2 <= -10.0f && f >= 70.0f && f <= 180.0f || f2 >= -180.0f && f2 <= -45.0f && f >= -180.0f && f <= -130.0f || f2 >= 140.0f && f2 <= 180.0f && f >= 90.0f && f <= 180.0f;
    }

    private static boolean isTurn(float f, float f2) {
        return f2 >= 30.0f && f2 <= 90.0f && f >= -15.0f && f <= 95.0f;
    }

    public void getPdbData(char c, boolean bl, BitSet bitSet, StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        BioPolymer.getPdbData(this, c, bl, bitSet, stringBuffer, stringBuffer2);
    }
}

