/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelsetbio;

import java.util.BitSet;
import org.jmol.api.JmolBioResolver;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Chain;
import org.jmol.modelset.Group;
import org.jmol.modelsetbio.AlphaMonomer;
import org.jmol.modelsetbio.AminoMonomer;
import org.jmol.modelsetbio.BioPolymer;
import org.jmol.modelsetbio.CarbohydrateMonomer;
import org.jmol.modelsetbio.Monomer;
import org.jmol.modelsetbio.NucleicMonomer;
import org.jmol.modelsetbio.PhosphorusMonomer;
import org.jmol.viewer.JmolConstants;

public final class Resolver
implements JmolBioResolver {
    public Group distinguishAndPropagateGroup(Chain chain, String string, int n, int n2, int n3, int n4, int n5, int[] nArray, byte[] byArray, Atom[] atomArray) {
        int n6 = n3 - 1;
        int n7 = 0;
        int n8 = JmolConstants.ATOMID_MAX;
        while (--n8 >= 0) {
            nArray[n8] = Integer.MIN_VALUE;
        }
        if (byArray != null) {
            n8 = n3;
            while (--n8 >= n2) {
                byte by = byArray[n8];
                if (by <= 0) continue;
                if (by < 14) {
                    n7 |= 1 << by;
                }
                nArray[by] = n8;
            }
        }
        if (n6 < n2) {
            throw new NullPointerException();
        }
        if ((n7 & 0xE) == 14) {
            return AminoMonomer.validateAndAllocate(chain, string, n, n2, n6, nArray, atomArray);
        }
        if (n7 == 4) {
            return AlphaMonomer.validateAndAllocate(chain, string, n, n2, n6, nArray, atomArray);
        }
        if ((n7 & 0x1FC0) == 8128) {
            return NucleicMonomer.validateAndAllocate(chain, string, n, n2, n6, nArray, atomArray);
        }
        if (n7 == 8192) {
            return PhosphorusMonomer.validateAndAllocate(chain, string, n, n2, n6, nArray, atomArray);
        }
        if (JmolConstants.checkCarbohydrate((String)string)) {
            return CarbohydrateMonomer.validateAndAllocate(chain, string, n, n2, n6, nArray, atomArray);
        }
        return null;
    }

    public void buildBioPolymer(Group group, Group[] groupArray, int n) {
        if (group instanceof Monomer && ((Monomer)group).getBioPolymer() == null) {
            BioPolymer.allocateBioPolymer(groupArray, n);
        }
    }

    public void clearBioPolymers(Group[] groupArray, int n, BitSet bitSet) {
        for (int i = 0; i < n; ++i) {
            Monomer monomer;
            Group group = groupArray[i];
            if (!(group instanceof Monomer) || (monomer = (Monomer)group).getBioPolymer() == null || bitSet != null && bitSet.get(monomer.getModelIndex())) continue;
            monomer.setBioPolymer(null, -1);
        }
    }
}

