/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapespecial;

import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Tuple3f;
import javax.vecmath.Tuple3i;
import javax.vecmath.Vector3f;
import org.jmol.modelset.Atom;
import org.jmol.shape.Shape;
import org.jmol.shape.ShapeRenderer;
import org.jmol.shapespecial.Vectors;

public class VectorsRenderer
extends ShapeRenderer {
    final Point3f pointVectorEnd = new Point3f();
    final Point3f pointArrowHead = new Point3f();
    final Point3i screenVectorEnd = new Point3i();
    final Point3i screenArrowHead = new Point3i();
    final Vector3f headOffsetVector = new Vector3f();
    int diameter;
    int headWidthPixels;
    float vectorScale;
    float headScale;
    boolean doShaft;
    static final float arrowHeadOffset = -0.2f;

    protected void render() {
        Vectors vectors = (Vectors)this.shape;
        if (!vectors.isActive) {
            return;
        }
        short[] sArray = vectors.mads;
        if (sArray == null) {
            return;
        }
        Atom[] atomArray = vectors.atoms;
        short[] sArray2 = vectors.colixes;
        int n = this.modelSet.getAtomCount();
        while (--n >= 0) {
            Vector3f vector3f;
            Atom atom = atomArray[n];
            if (!atom.isShapeVisible(this.myVisibilityFlag) || this.modelSet.isAtomHidden(n) || (vector3f = atom.getVibrationVector()) == null) continue;
            this.vectorScale = this.viewer.getVectorScale();
            if (!this.transform(sArray[n], atom, vector3f) || !this.g3d.setColix(Shape.getColix((short[])sArray2, (int)n, (Atom)atom))) continue;
            this.renderVector(atom);
        }
    }

    boolean transform(short s, Atom atom, Vector3f vector3f) {
        float f = vector3f.length();
        if ((double)Math.abs(f * this.vectorScale) < 0.01) {
            return false;
        }
        this.headScale = -0.2f;
        if (this.vectorScale < 0.0f) {
            this.headScale = -this.headScale;
        }
        this.doShaft = 0.1 + (double)Math.abs(this.headScale / f) < (double)Math.abs(this.vectorScale);
        this.headOffsetVector.set((Tuple3f)vector3f);
        this.headOffsetVector.scale(this.headScale / f);
        this.pointVectorEnd.scaleAdd(this.vectorScale, (Tuple3f)vector3f, (Tuple3f)atom);
        this.pointArrowHead.set((Tuple3f)this.pointVectorEnd);
        this.pointArrowHead.add((Tuple3f)this.headOffsetVector);
        this.screenArrowHead.set((Tuple3i)this.viewer.transformPoint(this.pointArrowHead, vector3f));
        this.screenVectorEnd.set((Tuple3i)this.viewer.transformPoint(this.pointVectorEnd, vector3f));
        this.diameter = s < 1 ? 1 : (s <= 20 ? (int)s : (int)this.viewer.scaleToScreen(this.screenVectorEnd.z, (int)s));
        this.headWidthPixels = (int)((float)this.diameter * 2.0f);
        if (this.headWidthPixels < this.diameter + 2) {
            this.headWidthPixels = this.diameter + 2;
        }
        if (this.isGenerator) {
            this.diameter = s < 1 ? (short)1 : s;
        }
        return true;
    }

    void renderVector(Atom atom) {
        if (this.doShaft) {
            this.g3d.fillCylinder((byte)1, this.diameter, atom.screenX, atom.screenY, atom.screenZ, this.screenArrowHead.x, this.screenArrowHead.y, this.screenArrowHead.z);
        }
        this.g3d.fillCone((byte)2, this.headWidthPixels, this.screenArrowHead, this.screenVectorEnd);
    }
}

