/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.more;

import java.io.BufferedReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.util.ArrayUtil;

public class ShelxReader
extends AtomSetCollectionReader {
    String[] sfacElementSymbols;
    boolean isCmdf = false;
    boolean iHaveAtomSet = false;
    static final String[] supportedRecordTypes = new String[]{"TITL", "CELL", "SPGR", "SFAC", "LATT", "SYMM"};
    static final String[] unsupportedRecordTypes = new String[]{"ZERR", "DISP", "UNIT", "LAUE", "REM", "MORE", "TIME", "HKLF", "OMIT", "SHEL", "BASF", "TWIN", "EXTI", "SWAT", "HOPE", "MERG", "SPEC", "RESI", "MOVE", "ANIS", "AFIX", "HFIX", "FRAG", "FEND", "EXYZ", "EXTI", "EADP", "EQIV", "CONN", "PART", "BIND", "FREE", "DFIX", "DANG", "BUMP", "SAME", "SADI", "CHIV", "FLAT", "DELU", "SIMU", "DEFS", "ISOR", "NCSY", "SUMP", "L.S.", "CGLS", "BLOC", "DAMP", "STIR", "WGHT", "FVAR", "BOND", "CONF", "MPLA", "RTAB", "HTAB", "LIST", "ACTA", "SIZE", "TEMP", "WPDB", "FMAP", "GRID", "PLAN", "MOLE"};

    public AtomSetCollection readAtomSetCollection(BufferedReader bufferedReader) {
        this.reader = bufferedReader;
        this.atomSetCollection = new AtomSetCollection("shelx");
        try {
            this.setFractionalCoordinates(true);
            boolean bl = false;
            while (!bl || this.desiredModelNumber <= 0) {
                boolean bl2;
                boolean bl3 = bl2 = ++this.modelNumber == this.desiredModelNumber || this.desiredModelNumber <= 0;
                if (bl2) {
                    bl = true;
                    this.sfacElementSymbols = null;
                    this.applySymmetry();
                    this.setFractionalCoordinates(true);
                    this.isCmdf = false;
                    this.iHaveAtomSet = false;
                }
                block3: while (this.readLine() != null) {
                    int n = this.line.trim().length();
                    while (n > 0 && this.line.charAt(n - 1) == '=') {
                        this.line = this.line.substring(0, n - 1) + this.readLine();
                    }
                    if (n < 3) continue;
                    String string = (this.line + " ").substring(0, 4).toUpperCase().trim();
                    if (string.equals("END")) break;
                    if (this.line.equals("NOTE")) {
                        this.isCmdf = true;
                        this.atomSetCollection.setFileTypeName("cmdf");
                        continue;
                    }
                    if (bl2 && this.isCmdf && this.line.equals("ATOM")) {
                        this.processCmdfAtoms();
                        break;
                    }
                    int n2 = unsupportedRecordTypes.length;
                    while (--n2 >= 0) {
                        if (!string.equals(unsupportedRecordTypes[n2])) continue;
                        continue block3;
                    }
                    n2 = supportedRecordTypes.length;
                    while (--n2 >= 0) {
                        if (!string.equals(supportedRecordTypes[n2])) continue;
                        if (!bl2) continue block3;
                        this.processSupportedRecord(n2);
                        continue block3;
                    }
                    if (!bl2 || this.isCmdf || !this.iHaveAtomSet) continue;
                    this.assumeAtomRecord();
                }
                if (this.readLine() != null) continue;
            }
            this.applySymmetry();
        }
        catch (Exception exception) {
            return this.setError(exception);
        }
        return this.atomSetCollection;
    }

    void processSupportedRecord(int n) throws Exception {
        if (!this.iHaveAtomSet) {
            this.atomSetCollection.newAtomSet();
        }
        this.iHaveAtomSet = true;
        switch (n) {
            case 0: {
                this.atomSetCollection.setAtomSetName(AtomSetCollectionReader.parseTrimmed(this.line, 4));
                break;
            }
            case 1: {
                this.cell();
                this.setSymmetryOperator("x,y,z");
                break;
            }
            case 2: {
                this.setSpaceGroupName(AtomSetCollectionReader.parseTrimmed(this.line, 4));
                break;
            }
            case 3: {
                this.parseSfacRecord();
                break;
            }
            case 4: {
                this.parseLattRecord();
                break;
            }
            case 5: {
                this.parseSymmRecord();
            }
        }
    }

    void parseLattRecord() throws Exception {
        this.parseToken(this.line);
        int n = this.parseInt();
        this.atomSetCollection.setLatticeParameter(n);
    }

    void parseSymmRecord() throws Exception {
        this.setSymmetryOperator(AtomSetCollectionReader.parseTrimmed(this.line, 4));
    }

    void cell() throws Exception {
        String[] stringArray = this.getTokens();
        int n = 1;
        if (this.isCmdf) {
            n = 0;
        } else {
            float f = this.parseFloat(stringArray[0]);
            this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("wavelength", new Float(f));
        }
        for (int i = 0; i < 6; ++i) {
            this.setUnitCellItem(i, this.parseFloat(stringArray[i + n + 1]));
        }
    }

    void parseSfacRecord() {
        String[] stringArray = AtomSetCollectionReader.getTokens(this.line, 4);
        boolean bl = true;
        int n = stringArray.length;
        while (bl && --n >= 0) {
            String string = stringArray[n];
            bl = Atom.isValidElementSymbolNoCaseSecondChar(string);
        }
        if (bl) {
            this.parseSfacElementSymbols(stringArray);
        } else {
            this.parseSfacCoefficients(stringArray);
        }
    }

    void parseSfacElementSymbols(String[] stringArray) {
        if (this.sfacElementSymbols == null) {
            this.sfacElementSymbols = stringArray;
        } else {
            int n = this.sfacElementSymbols.length;
            int n2 = stringArray.length;
            this.sfacElementSymbols = ArrayUtil.setLength(this.sfacElementSymbols, n + n2);
            int n3 = n2;
            while (--n3 >= 0) {
                this.sfacElementSymbols[n + n3] = stringArray[n3];
            }
        }
    }

    void parseSfacCoefficients(String[] stringArray) {
        float f = this.parseFloat(stringArray[1]);
        float f2 = this.parseFloat(stringArray[3]);
        float f3 = this.parseFloat(stringArray[5]);
        float f4 = this.parseFloat(stringArray[7]);
        float f5 = this.parseFloat(stringArray[9]);
        int n = (int)(f + f2 + f3 + f4 + f5 + 0.5f);
        String string = AtomSetCollectionReader.getElementSymbol(n);
        int n2 = 0;
        if (this.sfacElementSymbols == null) {
            this.sfacElementSymbols = new String[1];
        } else {
            n2 = this.sfacElementSymbols.length;
            this.sfacElementSymbols = ArrayUtil.setLength(this.sfacElementSymbols, n2 + 1);
            this.sfacElementSymbols[n2] = string;
        }
        this.sfacElementSymbols[n2] = string;
    }

    void assumeAtomRecord() throws Exception {
        int n;
        String string = this.parseToken(this.line);
        int n2 = this.parseInt();
        float f = this.parseFloat();
        float f2 = this.parseFloat();
        float f3 = this.parseFloat();
        Atom atom = this.atomSetCollection.addNewAtom();
        atom.atomName = string;
        if (this.sfacElementSymbols != null && (n = n2 - 1) >= 0 && n < this.sfacElementSymbols.length) {
            atom.elementSymbol = this.sfacElementSymbols[n];
        }
        this.setAtomCoord(atom, f, f2, f3);
    }

    void processCmdfAtoms() throws Exception {
        while (this.readLine() != null && this.line.length() > 10) {
            Atom atom = this.atomSetCollection.addNewAtom();
            String[] stringArray = this.getTokens();
            atom.elementSymbol = this.getSymbol(stringArray[0]);
            this.setAtomCoord(atom, this.parseFloat(stringArray[2]), this.parseFloat(stringArray[3]), this.parseFloat(stringArray[4]));
        }
    }

    String getSymbol(String string) {
        if (string == null) {
            return "Xx";
        }
        int n = string.length();
        if (n < 2) {
            return string;
        }
        char c = string.charAt(1);
        if (c >= 'a' && c <= 'z') {
            return string.substring(0, 2);
        }
        return "" + string.charAt(0);
    }
}

