/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.io.BufferedReader;
import java.util.Enumeration;
import java.util.Hashtable;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.symmetry.SpaceGroup;
import org.jmol.symmetry.UnitCell;
import org.jmol.util.Logger;
import org.jmol.util.Parser;
import org.jmol.viewer.JmolConstants;

public abstract class AtomSetCollectionReader {
    public AtomSetCollection atomSetCollection;
    public BufferedReader reader;
    public String line;
    public String prevline;
    protected long ptLine;
    public static final float ANGSTROMS_PER_BOHR = 0.5291772f;
    public int desiredModelNumber;
    public int modelNumber;
    public boolean iHaveDesiredModel;
    public String spaceGroup;
    public UnitCell unitcell;
    public float[] notionalUnitCell;
    public int[] latticeCells = new int[3];
    public int desiredSpaceGroupIndex;
    public int[] next = new int[1];
    protected boolean doApplySymmetry;
    boolean doConvertToFractional;
    boolean fileCoordinatesAreFractional;
    boolean ignoreFileUnitCell;
    protected boolean ignoreFileSymmetryOperators;
    boolean ignoreFileSpaceGroupName;
    boolean isTrajectory;
    protected boolean applySymmetryToBonds;
    float symmetryRange;
    public boolean iHaveUnitCell;
    private boolean iHaveFractionalCoordinates;
    private boolean iHaveSymmetryOperators;
    public boolean needToApplySymmetry;
    private int nMatrixElements = 0;

    protected String[] getTokens() {
        return Parser.getTokens(this.line);
    }

    protected static void getTokensFloat(String string, float[] fArray, int n) {
        Parser.parseFloatArray(AtomSetCollectionReader.getTokens(string), fArray, n);
    }

    protected static String[] getTokens(String string) {
        return Parser.getTokens(string);
    }

    protected static String[] getTokens(String string, int n) {
        return Parser.getTokens(string, n);
    }

    protected float parseFloat() {
        return Parser.parseFloat(this.line, this.next);
    }

    public float parseFloat(String string) {
        this.next[0] = 0;
        return Parser.parseFloat(string, this.next);
    }

    protected float parseFloat(String string, int n, int n2) {
        this.next[0] = n;
        return Parser.parseFloat(string, n2, this.next);
    }

    protected int parseInt() {
        return Parser.parseInt(this.line, this.next);
    }

    public int parseInt(String string) {
        this.next[0] = 0;
        return Parser.parseInt(string, this.next);
    }

    protected int parseInt(String string, int n) {
        this.next[0] = n;
        return Parser.parseInt(string, this.next);
    }

    protected int parseInt(String string, int n, int n2) {
        this.next[0] = n;
        return Parser.parseInt(string, n2, this.next);
    }

    protected String parseToken() {
        return Parser.parseToken(this.line, this.next);
    }

    protected String parseToken(String string) {
        this.next[0] = 0;
        return Parser.parseToken(string, this.next);
    }

    protected String parseTokenNext(String string) {
        return Parser.parseToken(string, this.next);
    }

    protected String parseToken(String string, int n, int n2) {
        this.next[0] = n;
        return Parser.parseToken(string, n2, this.next);
    }

    protected static String parseTrimmed(String string, int n) {
        return Parser.parseTrimmed(string, n);
    }

    protected static String parseTrimmed(String string, int n, int n2) {
        return Parser.parseTrimmed(string, n, n2);
    }

    public abstract AtomSetCollection readAtomSetCollection(BufferedReader var1);

    public AtomSetCollection readAtomSetCollectionFromDOM(Object object) {
        return null;
    }

    public AtomSetCollection setError(Exception exception) {
        exception.printStackTrace();
        this.atomSetCollection.errorMessage = this.line == null ? "Unexpected end of file after line " + --this.ptLine + ":\n" + this.prevline : "Error reading file at line " + this.ptLine + ":\n" + this.line + "\n" + exception.getMessage();
        return this.atomSetCollection;
    }

    public void initialize() {
        this.modelNumber = 0;
        this.desiredModelNumber = -1;
        this.iHaveDesiredModel = false;
        this.latticeCells[2] = 0;
        this.latticeCells[1] = 0;
        this.latticeCells[0] = 0;
        this.desiredSpaceGroupIndex = -1;
        this.isTrajectory = false;
        this.ignoreFileUnitCell = false;
        this.ignoreFileSpaceGroupName = false;
        this.ignoreFileSymmetryOperators = false;
        this.doConvertToFractional = false;
        this.doApplySymmetry = false;
        this.applySymmetryToBonds = false;
        this.fileCoordinatesAreFractional = false;
        this.iHaveUnitCell = false;
        this.iHaveFractionalCoordinates = false;
        this.iHaveSymmetryOperators = false;
        this.initializeSymmetry();
    }

    public void initialize(Hashtable hashtable) {
        this.initialize();
        int[] nArray = null;
        if (hashtable != null) {
            nArray = (int[])hashtable.get("params");
            this.applySymmetryToBonds = hashtable.containsKey("applySymmetryToBonds");
        }
        if (nArray == null) {
            return;
        }
        Float f = (Float)hashtable.get("symmetryRange");
        this.symmetryRange = f == null ? 0.0f : f.floatValue();
        boolean bl = this.isTrajectory = nArray[0] == -1;
        if (!this.isTrajectory) {
            this.desiredModelNumber = nArray[0];
        }
        this.latticeCells[0] = nArray[1];
        this.latticeCells[1] = nArray[2];
        this.latticeCells[2] = nArray[3];
        boolean bl2 = this.doApplySymmetry = this.latticeCells[0] > 0 && this.latticeCells[1] > 0 && this.latticeCells[2] > 0 || this.latticeCells[0] > 9 && this.latticeCells[1] > 9;
        if (!this.doApplySymmetry) {
            this.latticeCells[0] = 0;
            this.latticeCells[1] = 0;
            this.latticeCells[2] = 0;
        }
        if (nArray.length >= 5) {
            this.desiredSpaceGroupIndex = nArray[4];
            this.ignoreFileSpaceGroupName = this.desiredSpaceGroupIndex >= 0;
            boolean bl3 = this.ignoreFileSymmetryOperators = this.desiredSpaceGroupIndex != -1;
        }
        if (nArray.length >= 11) {
            this.setUnitCell((float)nArray[5] / 10000.0f, (float)nArray[6] / 10000.0f, (float)nArray[7] / 10000.0f, (float)nArray[8] / 10000.0f, (float)nArray[9] / 10000.0f, (float)nArray[10] / 10000.0f);
            this.ignoreFileUnitCell = this.iHaveUnitCell;
        }
    }

    private void initializeSymmetry() {
        this.iHaveUnitCell = this.ignoreFileUnitCell;
        if (!this.ignoreFileUnitCell) {
            this.notionalUnitCell = new float[22];
            int n = 22;
            while (--n >= 0) {
                this.notionalUnitCell[n] = Float.NaN;
            }
            this.unitcell = null;
        }
        if (!this.ignoreFileSpaceGroupName) {
            this.spaceGroup = "unspecified *";
        }
        this.needToApplySymmetry = false;
    }

    public void newAtomSet(String string) {
        if (this.atomSetCollection.currentAtomSetIndex >= 0) {
            this.atomSetCollection.newAtomSet();
            this.atomSetCollection.setCollectionName("<collection of " + (this.atomSetCollection.currentAtomSetIndex + 1) + " models>");
        } else {
            this.atomSetCollection.setCollectionName(string);
        }
        Logger.debug(string);
    }

    public void setSpaceGroupName(String string) {
        if (this.ignoreFileSpaceGroupName) {
            return;
        }
        this.spaceGroup = string.trim();
    }

    public void setSymmetryOperator(String string) {
        if (this.ignoreFileSymmetryOperators) {
            return;
        }
        this.atomSetCollection.setLatticeCells(this.latticeCells, this.applySymmetryToBonds);
        if (!this.atomSetCollection.addSymmetry(string)) {
            Logger.warn("Skipping symmetry operation " + string);
        }
        this.iHaveSymmetryOperators = true;
    }

    public void initializeCartesianToFractional() {
        int n;
        for (n = 0; n < 16; ++n) {
            if (Float.isNaN(this.notionalUnitCell[6 + n])) continue;
            return;
        }
        for (n = 0; n < 16; ++n) {
            this.notionalUnitCell[6 + n] = n % 5 == 0 ? 1 : 0;
        }
        this.nMatrixElements = 0;
    }

    public void setUnitCellItem(int n, float f) {
        if (this.ignoreFileUnitCell) {
            return;
        }
        if (n >= 6 && Float.isNaN(this.notionalUnitCell[6])) {
            this.initializeCartesianToFractional();
        }
        this.notionalUnitCell[n] = f;
        if (Logger.isActiveLevel(0)) {
            Logger.debug("setunitcellitem " + n + " " + f);
        }
        if (n < 6) {
            this.iHaveUnitCell = this.checkUnitCell(6);
        } else if (++this.nMatrixElements == 12) {
            this.checkUnitCell(22);
        }
    }

    public void setUnitCell(float f, float f2, float f3, float f4, float f5, float f6) {
        if (this.ignoreFileUnitCell) {
            return;
        }
        this.notionalUnitCell[0] = f;
        this.notionalUnitCell[1] = f2;
        this.notionalUnitCell[2] = f3;
        this.notionalUnitCell[3] = f4;
        this.notionalUnitCell[4] = f5;
        this.notionalUnitCell[5] = f6;
        this.iHaveUnitCell = this.checkUnitCell(6);
    }

    private boolean checkUnitCell(int n) {
        for (int i = 0; i < n; ++i) {
            if (!Float.isNaN(this.notionalUnitCell[i])) continue;
            return false;
        }
        this.unitcell = new UnitCell(this.notionalUnitCell);
        if (this.doApplySymmetry) {
            this.doConvertToFractional = !this.fileCoordinatesAreFractional;
        }
        return true;
    }

    public void setFractionalCoordinates(boolean bl) {
        this.iHaveFractionalCoordinates = this.fileCoordinatesAreFractional = bl;
    }

    public void setAtomCoord(Atom atom, float f, float f2, float f3) {
        atom.x = f;
        atom.y = f2;
        atom.z = f3;
        this.setAtomCoord(atom);
    }

    public void setAtomCoord(Atom atom) {
        if (this.doConvertToFractional && !this.fileCoordinatesAreFractional && this.unitcell != null) {
            this.unitcell.toFractional(atom);
            this.iHaveFractionalCoordinates = true;
        }
        this.needToApplySymmetry = true;
    }

    protected void addSites(Hashtable hashtable) {
        this.atomSetCollection.setAtomSetAuxiliaryInfo("pdbSites", hashtable);
        Enumeration enumeration = hashtable.keys();
        String string = "";
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            Hashtable hashtable2 = (Hashtable)hashtable.get(string2);
            int n = string2.length();
            while (--n >= 0) {
                char c = string2.charAt(n);
                if (Character.isLetterOrDigit(c) || c == '\'') continue;
                string2 = string2.substring(0, n) + "_" + string2.substring(n + 1);
            }
            String string3 = (String)hashtable2.get("seqNum");
            String string4 = (String)hashtable2.get("groups");
            this.addJmolScript("@site_" + string2 + " " + string4);
            this.addJmolScript("@" + string3 + " " + string4);
            this.addJmolScript("site_" + string2 + " = \"" + string4 + "\".split(\",\")");
            string = string + (string == "" ? "" : ",") + "site_" + string2;
        }
        this.addJmolScript("site_list = \"" + string + "\".split(\",\")");
    }

    public void applySymmetry() throws Exception {
        if (this.isTrajectory) {
            this.atomSetCollection.setTrajectory();
        }
        if (!this.needToApplySymmetry || !this.iHaveUnitCell) {
            this.initializeSymmetry();
            return;
        }
        this.atomSetCollection.setCoordinatesAreFractional(this.iHaveFractionalCoordinates);
        this.atomSetCollection.setNotionalUnitCell(this.notionalUnitCell);
        this.atomSetCollection.setAtomSetSpaceGroupName(this.spaceGroup);
        this.atomSetCollection.setSymmetryRange(this.symmetryRange);
        if (this.doConvertToFractional || this.fileCoordinatesAreFractional) {
            this.atomSetCollection.setLatticeCells(this.latticeCells, this.applySymmetryToBonds);
            if (this.ignoreFileSpaceGroupName || !this.iHaveSymmetryOperators) {
                SpaceGroup spaceGroup = SpaceGroup.createSpaceGroup(this.desiredSpaceGroupIndex, this.spaceGroup.indexOf("*") >= 0 ? "P1" : this.spaceGroup, this.notionalUnitCell, this.atomSetCollection.doNormalize);
                if (spaceGroup != null) {
                    if (Logger.isActiveLevel(0)) {
                        Logger.debug("using generated space group " + spaceGroup.dumpInfo());
                    }
                    this.atomSetCollection.setAtomSetSpaceGroupName(this.spaceGroup.indexOf("*") >= 0 ? this.spaceGroup : spaceGroup.getName());
                    this.atomSetCollection.applySymmetry(spaceGroup);
                }
            } else {
                this.atomSetCollection.applySymmetry();
            }
        }
        this.initializeSymmetry();
    }

    public static String getElementSymbol(int n) {
        return JmolConstants.elementSymbolFromNumber(n);
    }

    protected void fillDataBlock(String[][] stringArray) throws Exception {
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            stringArray[i] = AtomSetCollectionReader.getTokens(this.discardLinesUntilNonBlank());
        }
    }

    protected void discardLines(int n) throws Exception {
        int n2 = n;
        while (--n2 >= 0) {
            this.readLine();
        }
    }

    protected String discardLinesUntilStartsWith(String string) throws Exception {
        while (this.readLine() != null && !this.line.startsWith(string)) {
        }
        return this.line;
    }

    protected String discardLinesUntilContains(String string) throws Exception {
        while (this.readLine() != null && this.line.indexOf(string) < 0) {
        }
        return this.line;
    }

    protected void discardLinesUntilBlank() throws Exception {
        while (this.readLine() != null && this.line.trim().length() != 0) {
        }
    }

    protected String discardLinesUntilNonBlank() throws Exception {
        while (this.readLine() != null && this.line.trim().length() == 0) {
        }
        return this.line;
    }

    protected void checkLineForScript(String string) {
        this.line = string;
        this.checkLineForScript();
    }

    public void checkLineForScript() {
        int n;
        if (this.line.indexOf("Jmol PDB-encoded data") >= 0) {
            this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("jmolData", "" + this.line);
        }
        if (this.line.endsWith("#noautobond")) {
            this.line = this.line.substring(0, this.line.lastIndexOf(35)).trim();
            this.atomSetCollection.setAtomSetCollectionProperty("noautobond", "true");
        }
        if ((n = this.line.indexOf("jmolscript:")) >= 0) {
            String string = this.line.substring(n + 11, this.line.length());
            if (string.indexOf("#") >= 0) {
                string = string.substring(0, string.indexOf("#"));
            }
            this.addJmolScript(string);
            this.line = this.line.substring(0, n).trim();
        }
    }

    protected void addJmolScript(String string) {
        String string2 = this.atomSetCollection.getAtomSetCollectionProperty("jmolscript");
        string2 = string2 == null ? "" : string2 + ";";
        Logger.info("#jmolScript: " + string);
        this.atomSetCollection.setAtomSetCollectionProperty("jmolscript", string2 + string);
    }

    public String readLine() throws Exception {
        this.prevline = this.line;
        this.line = this.reader.readLine();
        ++this.ptLine;
        return this.line;
    }

    protected String readLineTrimmed() throws Exception {
        this.readLine();
        if (this.line == null) {
            this.line = "";
        }
        this.line = this.line.trim();
        return this.line;
    }

    protected static final String[] getStrings(String string, int n, int n2) {
        String[] stringArray = new String[n];
        int n3 = 0;
        int n4 = 0;
        while (n3 < n) {
            stringArray[n3] = string.substring(n4, n4 + n2);
            ++n3;
            n4 += n2;
        }
        return stringArray;
    }
}

