/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import java.util.Vector;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.jmol.modelset.ModelSet;
import org.jmol.util.Logger;
import org.jmol.util.Measure;
import org.jmol.util.TextFormat;
import org.jmol.viewer.Viewer;

public class Measurement {
    public ModelSet modelSet;
    Viewer viewer;
    protected int count;
    protected int[] countPlusIndices;
    private String strMeasurement;
    String strFormat;
    float value;
    private boolean isVisible = true;
    private boolean isHidden = false;
    private boolean isDynamic = false;
    private short colix;
    private int index;
    private AxisAngle4f aa;
    private Point3f pointArc;

    public int getCount() {
        return this.count;
    }

    public int[] getCountPlusIndices() {
        return this.countPlusIndices;
    }

    public int getIndex(int n) {
        return n > 0 && n <= this.count ? this.countPlusIndices[n] : -1;
    }

    public int getLastIndex() {
        return this.count > 0 ? this.countPlusIndices[this.count] : -1;
    }

    public int getPreviousIndex() {
        return this.count > 0 ? this.countPlusIndices[this.count - 1] : -1;
    }

    public String getString() {
        return this.strMeasurement;
    }

    public String getStrFormat() {
        return this.strFormat;
    }

    public float getValue() {
        return this.value;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public boolean isDynamic() {
        return this.isDynamic;
    }

    public void setVisible(boolean bl) {
        this.isVisible = bl;
    }

    public void setHidden(boolean bl) {
        this.isHidden = bl;
    }

    public void setDynamic(boolean bl) {
        this.isDynamic = bl;
    }

    public short getColix() {
        return this.colix;
    }

    public void setColix(short s) {
        this.colix = s;
    }

    public void setIndex(int n) {
        this.index = n;
    }

    public int getIndex() {
        return this.index;
    }

    public AxisAngle4f getAxisAngle() {
        return this.aa;
    }

    public Point3f getPointArc() {
        return this.pointArc;
    }

    public Measurement(ModelSet modelSet, int[] nArray, float f, short s, String string, int n) {
        this.modelSet = modelSet;
        this.viewer = modelSet.viewer;
        this.colix = s;
        this.strFormat = string;
        this.setInfo(modelSet, nArray, f, n);
    }

    public void refresh() {
        this.value = this.modelSet.getMeasurement(this.countPlusIndices);
        this.formatMeasurement();
    }

    public static String getMeasurementScript(int[] nArray) {
        String string = "measure";
        int n = nArray[0];
        for (int i = 0; i < n; ++i) {
            string = string + " (atomIndex=" + nArray[i + 1] + ")";
        }
        return string;
    }

    void setInfo(ModelSet modelSet, int[] nArray, float f, int n) {
        if (nArray == null) {
            this.count = 0;
        } else {
            this.count = nArray[0];
            this.countPlusIndices = new int[this.count + 1];
            System.arraycopy(nArray, 0, this.countPlusIndices, 0, this.count + 1);
        }
        if (this.countPlusIndices != null && Float.isNaN(f)) {
            f = modelSet.getMeasurement(this.countPlusIndices);
        }
        this.value = f;
        this.index = n;
        this.formatMeasurement();
    }

    void setFormat(String string) {
        this.strFormat = string;
    }

    public void formatMeasurement(String string, boolean bl) {
        if (string != null && string.length() == 0) {
            string = null;
        }
        if (!bl && string != null && string.indexOf(this.countPlusIndices[0] + ":") != 0) {
            return;
        }
        this.setFormat(string);
        this.formatMeasurement();
    }

    void formatMeasurement() {
        this.strMeasurement = null;
        if (Float.isNaN(this.value) || this.count == 0) {
            this.strMeasurement = null;
            return;
        }
        switch (this.count) {
            case 2: {
                this.strMeasurement = this.formatDistance(this.value);
                break;
            }
            case 3: {
                if (this.value == 180.0f) {
                    this.aa = null;
                    this.pointArc = null;
                } else {
                    Vector3f vector3f = new Vector3f();
                    Vector3f vector3f2 = new Vector3f();
                    float f = Measure.computeAngle(this.getAtomPoint3f(1), this.getAtomPoint3f(2), this.getAtomPoint3f(3), vector3f, vector3f2, false);
                    Vector3f vector3f3 = new Vector3f();
                    vector3f3.cross(vector3f, vector3f2);
                    this.aa = new AxisAngle4f(vector3f3.x, vector3f3.y, vector3f3.z, f);
                    vector3f.normalize();
                    vector3f.scale(0.5f);
                    this.pointArc = new Point3f(vector3f);
                }
            }
            case 4: {
                this.strMeasurement = this.formatAngle(this.value);
                break;
            }
            default: {
                Logger.error("Invalid count to measurement shape:" + this.count);
                throw new IndexOutOfBoundsException();
            }
        }
    }

    public void reformatDistanceIfSelected() {
        if (this.count != 2) {
            return;
        }
        if (this.viewer.isSelected(this.countPlusIndices[1]) && this.viewer.isSelected(this.countPlusIndices[2])) {
            this.formatMeasurement();
        }
    }

    Point3f getAtomPoint3f(int n) {
        return this.modelSet.getAtomAt(this.countPlusIndices[n]);
    }

    String formatDistance(float f) {
        int n = (int)(f * 100.0f + 0.5f);
        float f2 = n;
        String string = this.viewer.getMeasureDistanceUnits();
        if (string == "nanometers") {
            string = "nm";
            f2 = (float)n / 1000.0f;
        } else if (string == "picometers") {
            string = "pm";
            f2 = n;
        } else if (string == "au") {
            f2 = (float)((int)(f / 0.5291772f * 1000.0f + 0.5f)) / 1000.0f;
        } else {
            string = "\u00c5";
            f2 = (float)n / 100.0f;
        }
        return this.formatString(f2, string);
    }

    String formatAngle(float f) {
        f = (int)(f * 10.0f + (f >= 0.0f ? 0.5f : -0.5f));
        return this.formatString(f /= 10.0f, "\u00b0");
    }

    String formatString(float f, String string) {
        String string2;
        String string3 = this.countPlusIndices[0] + ":" + "";
        String string4 = string2 = this.strFormat != null && this.strFormat.indexOf(string3) == 0 ? this.strFormat : this.viewer.getDefaultMeasurementLabel(this.countPlusIndices[0]);
        if (string2.indexOf(string3) == 0) {
            string2 = string2.substring(2);
        }
        string2 = TextFormat.formatString(string2, "#", this.index + 1);
        string2 = TextFormat.formatString(string2, "UNITS", string);
        string2 = TextFormat.formatString(string2, "VALUE", f);
        for (int i = this.countPlusIndices[0]; i >= 1 && string2.indexOf("%") >= 0; --i) {
            string2 = this.modelSet.atoms[this.countPlusIndices[i]].formatLabel(string2, (char)(48 + i), null);
        }
        if (string2 == null) {
            return "";
        }
        return string2;
    }

    public boolean sameAs(int[] nArray) {
        if (this.count != nArray[0]) {
            return false;
        }
        if (this.count == 2) {
            return nArray[1] == this.countPlusIndices[1] && nArray[2] == this.countPlusIndices[2] || nArray[1] == this.countPlusIndices[2] && nArray[2] == this.countPlusIndices[1];
        }
        if (this.count == 3) {
            return nArray[2] == this.countPlusIndices[2] && (nArray[1] == this.countPlusIndices[1] && nArray[3] == this.countPlusIndices[3] || nArray[1] == this.countPlusIndices[3] && nArray[3] == this.countPlusIndices[1]);
        }
        return nArray[1] == this.countPlusIndices[1] && nArray[2] == this.countPlusIndices[2] && nArray[3] == this.countPlusIndices[3] && nArray[4] == this.countPlusIndices[4] || nArray[1] == this.countPlusIndices[4] && nArray[2] == this.countPlusIndices[3] && nArray[3] == this.countPlusIndices[2] && nArray[4] == this.countPlusIndices[1];
    }

    public Vector toVector() {
        Vector<Object> vector = new Vector<Object>();
        for (int i = 0; i < this.count + 1; ++i) {
            vector.addElement(new Integer(this.countPlusIndices[i]));
        }
        vector.addElement(this.strMeasurement);
        return vector;
    }
}

