/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import java.util.BitSet;
import java.util.Hashtable;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Chain;
import org.jmol.modelset.ModelSet;
import org.jmol.modelset.Polymer;
import org.jmol.util.ArrayUtil;

public final class Model {
    ModelSet modelSet;
    int modelIndex;
    int modelNumber;
    int fileIndex;
    int modelInFileIndex;
    int modelFileNumber;
    String modelNumberForAtomLabel = "1.1";
    String modelTag;
    String modelTitle;
    String modelFile;
    int firstMolecule;
    int firstAtomIndex;
    int moleculeCount;
    int nAltLocs;
    int nInsertions;
    BitSet bsAtoms;
    String frameTitle;
    boolean isPDB;
    Hashtable dataFrames;
    int dataSourceFrame = -1;
    String jmolData;
    String jmolFrameType;
    private int chainCount = 0;
    private Chain[] chains = new Chain[8];
    private int bioPolymerCount = 0;
    private Polymer[] bioPolymers = new Polymer[8];

    public ModelSet getModelSet() {
        return this.modelSet;
    }

    Model(ModelSet modelSet, int n, int n2, String string, String string2, String string3, String string4) {
        this.modelSet = modelSet;
        this.dataSourceFrame = this.modelIndex = n;
        this.modelNumber = n2;
        this.modelTag = string;
        this.modelTitle = string2;
        this.modelFile = string3;
        this.jmolData = string4;
        this.jmolFrameType = string4 == null ? "modelSet" : (string4.indexOf("ramachandran") >= 0 ? "ramachandran" : (string4.indexOf("quaternion") >= 0 ? "quaternion" : "data"));
    }

    void setNAltLocs(int n) {
        this.nAltLocs = n;
    }

    void setNInsertions(int n) {
        this.nInsertions = n;
    }

    void freeze() {
        this.chains = (Chain[])ArrayUtil.setLength(this.chains, this.chainCount);
        for (int i = 0; i < this.chainCount; ++i) {
            this.chains[i].freeze();
        }
        this.bioPolymers = (Polymer[])ArrayUtil.setLength(this.bioPolymers, this.bioPolymerCount);
    }

    void clearStructures() {
        this.chainCount = 0;
        this.chains = new Chain[8];
        this.bioPolymerCount = 0;
        this.bioPolymers = new Polymer[8];
    }

    void addSecondaryStructure(byte by, char c, int n, char c2, int n2) {
        int n3 = this.bioPolymerCount;
        while (--n3 >= 0) {
            Polymer polymer = this.bioPolymers[n3];
            polymer.addSecondaryStructure(by, c, n, c2, n2);
        }
    }

    void calculateStructures() {
        int n = this.bioPolymerCount;
        while (--n >= 0) {
            this.bioPolymers[n].calculateStructures();
        }
    }

    void setConformation(BitSet bitSet) {
        int n = this.bioPolymerCount;
        while (--n >= 0) {
            this.bioPolymers[n].setConformation(bitSet, this.nAltLocs);
        }
    }

    int getChainCount() {
        return this.chainCount;
    }

    public int getBioPolymerCount() {
        return this.bioPolymerCount;
    }

    void calcSelectedGroupsCount(BitSet bitSet) {
        int n = this.chainCount;
        while (--n >= 0) {
            this.chains[n].calcSelectedGroupsCount(bitSet);
        }
    }

    void calcSelectedMonomersCount(BitSet bitSet) {
        int n = this.bioPolymerCount;
        while (--n >= 0) {
            this.bioPolymers[n].calcSelectedMonomersCount(bitSet);
        }
    }

    void selectSeqcodeRange(int n, int n2, BitSet bitSet) {
        int n3 = this.chainCount;
        while (--n3 >= 0) {
            this.chains[n3].selectSeqcodeRange(n, n2, bitSet);
        }
    }

    int getGroupCount() {
        int n = 0;
        int n2 = this.chainCount;
        while (--n2 >= 0) {
            n += this.chains[n2].getGroupCount();
        }
        return n;
    }

    Chain getChain(char c) {
        int n = this.chainCount;
        while (--n >= 0) {
            Chain chain = this.chains[n];
            if (chain.getChainID() != c) continue;
            return chain;
        }
        return null;
    }

    Chain getChain(int n) {
        return n < this.chainCount ? this.chains[n] : null;
    }

    Chain getOrAllocateChain(char c) {
        Chain chain = this.getChain(c);
        if (chain != null) {
            return chain;
        }
        if (this.chainCount == this.chains.length) {
            this.chains = (Chain[])ArrayUtil.doubleLength(this.chains);
        }
        Chain chain2 = new Chain(this.modelSet, this, c);
        this.chains[this.chainCount++] = chain2;
        return chain2;
    }

    public void addBioPolymer(Polymer polymer) {
        if (this.bioPolymers.length == 0 || polymer == null) {
            this.bioPolymers = new Polymer[8];
        }
        if (polymer == null) {
            this.bioPolymerCount = 0;
            return;
        }
        if (this.bioPolymerCount == this.bioPolymers.length) {
            this.bioPolymers = (Polymer[])ArrayUtil.doubleLength(this.bioPolymers);
        }
        this.bioPolymers[this.bioPolymerCount++] = polymer;
    }

    public Polymer getBioPolymer(int n) {
        return this.bioPolymers[n];
    }

    void calcHydrogenBonds(BitSet bitSet, BitSet bitSet2) {
        int n = this.bioPolymerCount;
        while (--n >= 0) {
            this.bioPolymers[n].calcHydrogenBonds(bitSet, bitSet2);
        }
    }

    public boolean isAtomHidden(int n) {
        return this.modelSet.isAtomHidden(n);
    }

    public void addHydrogenBond(Atom atom, Atom atom2, short s, BitSet bitSet, BitSet bitSet2) {
        this.modelSet.addHydrogenBond(atom, atom2, s, bitSet, bitSet2);
    }

    public int getModelIndex() {
        return this.modelIndex;
    }

    public void getPdbData(char c, boolean bl, BitSet bitSet, StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        for (int i = 0; i < this.bioPolymerCount; ++i) {
            this.bioPolymers[i].getPdbData(c, bl, bitSet, stringBuffer, stringBuffer2);
        }
    }
}

