/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import java.util.BitSet;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.vecmath.Vector3f;
import org.jmol.api.JmolAdapter;
import org.jmol.api.JmolBioResolver;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.CellInfo;
import org.jmol.modelset.Chain;
import org.jmol.modelset.Group;
import org.jmol.modelset.Model;
import org.jmol.modelset.ModelSet;
import org.jmol.util.ArrayUtil;
import org.jmol.util.Logger;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.Viewer;

public final class ModelLoader
extends ModelSet {
    private ModelLoader mergeModelSet;
    private boolean merging;
    private boolean isMultiFile;
    private String jmolData;
    private boolean isTrajectory = false;
    private final int[] specialAtomIndexes = new int[JmolConstants.ATOMID_MAX];
    private String[] group3Lists;
    private int[][] group3Counts;
    private boolean someModelsHaveUnitcells;
    private boolean someModelsHaveFractionalCoordinates;
    private static final int ATOM_GROWTH_INCREMENT = 2000;
    private final Hashtable htAtomMap = new Hashtable();
    private static final int defaultGroupCount = 32;
    private Chain[] chainOf;
    private String[] group3Of;
    private int[] seqcodes;
    private int[] firstAtomIndexes;
    private int currentModelIndex;
    private Model currentModel;
    private char currentChainID;
    private Chain currentChain;
    private int currentGroupSequenceNumber;
    private char currentGroupInsertionCode;
    private String currentGroup3;
    Group nullGroup;
    private int baseModelIndex = 0;
    private int baseModelCount = 0;
    private int baseAtomIndex = 0;
    private int baseBondIndex = 0;
    private boolean appendNew;
    private int adapterModelCount = 0;

    public ModelLoader(Viewer viewer, String string) {
        this.viewer = viewer;
        this.initializeInfo(string, 1, null, null);
        this.initializeModelSet(null, null);
        this.modelSetName = "zapped";
    }

    public ModelLoader(Viewer viewer, JmolAdapter jmolAdapter, Object object, ModelLoader modelLoader, String string) {
        this.modelSetName = string;
        this.mergeModelSet = modelLoader;
        this.merging = modelLoader != null && modelLoader.atomCount > 0;
        this.viewer = viewer;
        this.initializeInfo(jmolAdapter.getFileTypeName(object).toLowerCase().intern(), jmolAdapter.getEstimatedAtomCount(object), jmolAdapter.getAtomSetCollectionProperties(object), jmolAdapter.getAtomSetCollectionAuxiliaryInfo(object));
        this.initializeModelSet(jmolAdapter, object);
        jmolAdapter.finish(object);
    }

    private void initializeInfo(String string, int n, Properties properties, Hashtable hashtable) {
        this.g3d = this.viewer.getGraphics3D();
        this.modelSetTypeName = string;
        this.isXYZ = this.modelSetTypeName == "xyz";
        this.setZeroBased();
        this.setModelSetProperties(properties);
        this.setModelSetAuxiliaryInfo(hashtable);
        this.isMultiFile = this.getModelSetAuxiliaryInfoBoolean("isMultiFile");
        this.isPDB = this.getModelSetAuxiliaryInfoBoolean("isPDB");
        this.jmolData = (String)this.getModelSetAuxiliaryInfo("jmolData");
        this.trajectories = (Vector)this.getModelSetAuxiliaryInfo("trajectories");
        this.isTrajectory = this.trajectories != null;
        this.someModelsHaveSymmetry = this.getModelSetAuxiliaryInfoBoolean("someModelsHaveSymmetry");
        this.someModelsHaveUnitcells = this.getModelSetAuxiliaryInfoBoolean("someModelsHaveUnitcells");
        this.someModelsHaveFractionalCoordinates = this.getModelSetAuxiliaryInfoBoolean("someModelsHaveFractionalCoordinates");
        if (this.merging) {
            this.someModelsHaveSymmetry |= this.mergeModelSet.getModelSetAuxiliaryInfoBoolean("someModelsHaveSymmetry");
            this.someModelsHaveUnitcells |= this.mergeModelSet.getModelSetAuxiliaryInfoBoolean("someModelsHaveUnitcells");
            this.someModelsHaveFractionalCoordinates |= this.mergeModelSet.getModelSetAuxiliaryInfoBoolean("someModelsHaveFractionalCoordinates");
            this.someModelsHaveAromaticBonds |= this.mergeModelSet.someModelsHaveAromaticBonds;
        }
        this.initializeBuild(n);
    }

    private void initializeBuild(int n) {
        if (n <= 0) {
            n = 2000;
        }
        if (this.merging) {
            this.atoms = this.mergeModelSet.atoms;
            this.bonds = this.mergeModelSet.bonds;
        } else {
            this.atoms = new Atom[n];
            this.bonds = new Bond[250 + n];
        }
        this.htAtomMap.clear();
        this.initializeGroupBuild();
    }

    private void initializeGroupBuild() {
        this.chainOf = new Chain[32];
        this.group3Of = new String[32];
        this.seqcodes = new int[32];
        this.firstAtomIndexes = new int[32];
        this.currentChainID = (char)65535;
        this.currentChain = null;
        this.currentGroupInsertionCode = (char)65535;
        this.currentGroup3 = "xxxxx";
        this.currentModelIndex = -1;
        this.currentModel = null;
    }

    private void initializeModelSet(JmolAdapter jmolAdapter, Object object) {
        this.adapterModelCount = jmolAdapter == null ? 1 : jmolAdapter.getAtomSetCount(object);
        this.appendNew = !this.merging || jmolAdapter == null || this.adapterModelCount > 1 || this.viewer.getAppendNew();
        this.initializeAtomBondModelCounts();
        if (jmolAdapter == null) {
            this.setModelNameNumberProperties(0, "", 1, null, null, false, null);
        } else {
            if (this.adapterModelCount > 0) {
                Logger.info("ModelSet: haveSymmetry:" + this.someModelsHaveSymmetry + " haveUnitcells:" + this.someModelsHaveUnitcells + " haveFractionalCoord:" + this.someModelsHaveFractionalCoordinates);
                Logger.info(this.adapterModelCount + " model" + (this.modelCount == 1 ? "" : "s") + (this.isTrajectory ? ", " + this.trajectories.size() + " trajectories" : "") + " in this collection. Use getProperty \"modelInfo\" or" + " getProperty \"auxiliaryInfo\" to inspect them.");
            }
            this.iterateOverAllNewModels(jmolAdapter, object);
            this.iterateOverAllNewAtoms(jmolAdapter, object);
            this.iterateOverAllNewBonds(jmolAdapter, object);
            this.iterateOverAllNewStructures(jmolAdapter, object);
            this.initializeUnitCellAndSymmetry();
            this.initializeBonding();
        }
        this.finalizeGroupBuild();
        this.calculatePolymers(null);
        this.freeze();
        this.calcBoundBoxDimensions(null);
        this.finalizeShapes();
        if (this.mergeModelSet != null) {
            this.mergeModelSet.releaseModelSet();
        }
        this.mergeModelSet = null;
    }

    protected void releaseModelSet() {
        this.group3Lists = null;
        this.group3Counts = null;
        this.groups = null;
        super.releaseModelSet();
    }

    private void initializeAtomBondModelCounts() {
        this.atomCount = 0;
        this.bondCount = 0;
        if (this.merging) {
            this.baseModelCount = this.mergeModelSet.modelCount;
            if (this.appendNew) {
                this.baseModelIndex = this.baseModelCount;
                this.modelCount = this.baseModelCount + this.adapterModelCount;
            } else {
                this.baseModelIndex = this.viewer.getCurrentModelIndex();
                if (this.baseModelIndex < 0) {
                    this.baseModelIndex = this.baseModelCount - 1;
                }
                this.modelCount = this.baseModelCount;
            }
            this.atomCount = this.baseAtomIndex = this.mergeModelSet.atomCount;
            this.bondCount = this.baseBondIndex = this.mergeModelSet.bondCount;
            this.groupCount = this.baseGroupIndex = this.mergeModelSet.groupCount;
        } else {
            this.modelCount = this.adapterModelCount;
        }
        this.setModelCount();
    }

    private void initializeMerge() {
        this.merge(this.mergeModelSet);
        this.bsSymmetry = this.mergeModelSet.bsSymmetry;
        Hashtable hashtable = this.mergeModelSet.getAuxiliaryInfo();
        String[] stringArray = (String[])hashtable.get("group3Lists");
        int[][] nArray = (int[][])hashtable.get("group3Counts");
        if (stringArray != null) {
            for (int i = 0; i < this.baseModelCount; ++i) {
                this.group3Lists[i] = stringArray[i];
                this.group3Counts[i] = nArray[i];
                this.structuresDefinedInFile.set(i);
            }
            this.group3Lists[this.modelCount] = stringArray[this.baseModelCount];
            this.group3Counts[this.modelCount] = nArray[this.baseModelCount];
        }
        if (!this.appendNew && this.isPDB) {
            this.structuresDefinedInFile.clear(this.baseModelIndex);
        }
        this.copyAtomData(this.mergeModelSet);
        this.surfaceDistance100s = null;
    }

    private void iterateOverAllNewModels(JmolAdapter jmolAdapter, Object object) {
        if (this.modelCount > 0) {
            this.nullGroup = new Group(new Chain(this, this.getModel(this.baseModelIndex), ' '), "", 0, -1, -1);
        }
        this.group3Lists = new String[this.modelCount + 1];
        this.group3Counts = new int[this.modelCount + 1][];
        this.structuresDefinedInFile = new BitSet();
        if (this.merging) {
            this.initializeMerge();
        }
        int n = this.baseModelIndex;
        int n2 = 0;
        while (n2 < this.adapterModelCount) {
            Hashtable hashtable;
            Properties properties;
            boolean bl;
            int n3 = this.appendNew ? jmolAdapter.getAtomSetNumber(object, n2) : Integer.MAX_VALUE;
            String string = jmolAdapter.getAtomSetName(object, n2);
            if (string == null) {
                String string2 = this.jmolData != null ? this.jmolData.substring(this.jmolData.indexOf(":") + 2, this.jmolData.indexOf("data(")) : (string = n3 == Integer.MAX_VALUE ? "" : "" + n3 % 1000000);
            }
            if (bl = this.setModelNameNumberProperties(n, string, n3, properties = jmolAdapter.getAtomSetProperties(object, n2), hashtable = jmolAdapter.getAtomSetAuxiliaryInfo(object, n2), this.isPDB, this.jmolData)) {
                this.group3Lists[n] = JmolConstants.group3List;
                this.group3Counts[n] = new int[JmolConstants.group3Count + 10];
                if (this.group3Lists[this.modelCount] == null) {
                    this.group3Lists[this.modelCount] = JmolConstants.group3List;
                    this.group3Counts[this.modelCount] = new int[JmolConstants.group3Count + 10];
                }
            }
            if (this.getModelAuxiliaryInfo(n, "periodicOriginXyz") != null) {
                this.someModelsHaveSymmetry = true;
            }
            ++n2;
            ++n;
        }
        this.finalizeModels(this.baseModelCount);
    }

    boolean setModelNameNumberProperties(int n, String string, int n2, Properties properties, Hashtable hashtable, boolean bl, String string2) {
        this.modelProperties[n] = properties;
        if (hashtable == null) {
            hashtable = new Hashtable<String, String>();
        }
        this.modelAuxiliaryInfo[n] = hashtable;
        String string3 = (String)this.getModelAuxiliaryInfo(n, "title");
        if (string2 != null) {
            hashtable.put("jmolData", string2);
            string3 = string2;
        }
        String string4 = (String)this.getModelAuxiliaryInfo(n, "fileName");
        if (n2 != Integer.MAX_VALUE) {
            this.models[n] = new Model(this, n, n2, string, string3, string4, string2);
        }
        String string5 = (String)this.getModelAuxiliaryInfo(n, "altLocs");
        this.models[n].setNAltLocs(string5 == null ? 0 : string5.length());
        string5 = (String)this.getModelAuxiliaryInfo(n, "insertionCodes");
        this.models[n].setNInsertions(string5 == null ? 0 : string5.length());
        this.models[n].isPDB = this.getModelAuxiliaryInfoBoolean(n, "isPDB");
        return this.models[n].isPDB;
    }

    private void finalizeModels(int n) {
        int n2;
        int n3;
        if (this.modelCount == n) {
            return;
        }
        int n4 = 0;
        int n5 = -1;
        if (n > 0) {
            if (this.models[0].modelNumber < 1000000) {
                for (n3 = 0; n3 < n; ++n3) {
                    if (this.models[n3].modelTag.length() == 0) {
                        this.models[n3].modelTag = "" + this.models[n3].modelNumber;
                    }
                    this.models[n3].modelNumber += 1000000;
                    this.models[n3].modelNumberForAtomLabel = "1." + (n3 + 1);
                }
            }
            n3 = this.models[n - 1].modelNumber;
            n3 -= n3 % 1000000;
            if (this.models[n].modelNumber < 1000000) {
                n3 += 1000000;
            }
            for (n2 = n; n2 < this.modelCount; ++n2) {
                this.models[n2].modelNumber += n3;
            }
        }
        for (n3 = n; n3 < this.modelCount; ++n3) {
            String string;
            n2 = this.models[n3].modelNumber / 1000000;
            if (n2 != n5) {
                n4 = 0;
                n5 = n2;
            }
            ++n4;
            if (n2 == 0) {
                string = "" + this.getModelNumber(n3);
                n2 = 1;
            } else {
                string = n2 + "." + n4;
            }
            this.models[n3].modelNumberForAtomLabel = string;
            this.models[n3].fileIndex = n2 - 1;
            this.models[n3].modelInFileIndex = n4 - 1;
            this.models[n3].modelFileNumber = n2 * 1000000 + n4;
            if (this.models[n3].modelTag.length() != 0) continue;
            this.models[n3].modelTag = string;
        }
        if (this.merging) {
            for (n3 = 0; n3 < n; ++n3) {
                this.models[n3].modelSet = this;
            }
        }
        for (n3 = 0; n3 < this.modelCount; ++n3) {
            this.setModelAuxiliaryInfo(n3, "modelName", this.models[n3].modelTag);
            this.setModelAuxiliaryInfo(n3, "modelNumber", new Integer(this.models[n3].modelNumber % 1000000));
            this.setModelAuxiliaryInfo(n3, "modelFileNumber", new Integer(this.models[n3].modelFileNumber));
            this.setModelAuxiliaryInfo(n3, "modelNumberDotted", this.getModelNumberDotted(n3));
        }
    }

    private void iterateOverAllNewAtoms(JmolAdapter jmolAdapter, Object object) {
        short s;
        short s2 = this.viewer.getMadAtom();
        JmolAdapter.AtomIterator atomIterator = jmolAdapter.getAtomIterator(object);
        while (atomIterator.hasNext()) {
            s = (short)atomIterator.getElementNumber();
            if (s <= 0) {
                s = JmolConstants.elementNumberFromSymbol(atomIterator.getElementSymbol());
            }
            char c = atomIterator.getAlternateLocationID();
            this.addAtom(atomIterator.getAtomSetIndex() + this.baseModelIndex, atomIterator.getAtomSymmetry(), atomIterator.getAtomSite(), atomIterator.getUniqueID(), s, atomIterator.getAtomName(), s2, atomIterator.getFormalCharge(), atomIterator.getPartialCharge(), atomIterator.getOccupancy(), atomIterator.getBfactor(), atomIterator.getX(), atomIterator.getY(), atomIterator.getZ(), atomIterator.getIsHetero(), atomIterator.getAtomSerial(), atomIterator.getChainID(), atomIterator.getGroup3(), atomIterator.getSequenceNumber(), atomIterator.getInsertionCode(), atomIterator.getVectorX(), atomIterator.getVectorY(), atomIterator.getVectorZ(), c, atomIterator.getClientAtomReference(), atomIterator.getRadius());
        }
        short s3 = -1;
        for (s = 0; s < this.atomCount; ++s) {
            if (this.atoms[s].modelIndex == s3) continue;
            s3 = this.atoms[s].modelIndex;
            this.setFirstAtomIndex(s3, s);
        }
    }

    private void addAtom(int n, BitSet bitSet, int n2, Object object, short s, String string, short s2, int n3, float f, int n4, float f2, float f3, float f4, float f5, boolean bl, int n5, char c, String string2, int n6, char c2, float f6, float f7, float f8, char c3, Object object2, float f9) {
        this.checkNewGroup(this.atomCount, n, c, string2, n6, c2);
        if (this.atomCount == this.atoms.length) {
            this.growAtomArrays(2000);
        }
        Atom atom = new Atom(this, this.currentModelIndex, this.atomCount, bitSet, n2, s, string, s2, n3, f, n4, f2, f3, f4, f5, bl, n5, c, string2, f6, f7, f8, c3, object2, f9);
        this.atoms[this.atomCount++] = atom;
        this.htAtomMap.put(object, atom);
    }

    private void checkNewGroup(int n, int n2, char c, String string, int n3, char c2) {
        String string2;
        String string3 = string2 = string == null ? null : string.intern();
        if (n2 != this.currentModelIndex) {
            this.currentModel = this.getModel(n2);
            this.currentModelIndex = n2;
            this.currentChainID = (char)65535;
        }
        if (c != this.currentChainID) {
            this.currentChainID = c;
            this.currentChain = this.currentModel.getOrAllocateChain(c);
            this.currentGroupInsertionCode = (char)65535;
            this.currentGroupSequenceNumber = -1;
            this.currentGroup3 = "xxxx";
        }
        if (n3 != this.currentGroupSequenceNumber || c2 != this.currentGroupInsertionCode || string2 != this.currentGroup3) {
            this.currentGroupSequenceNumber = n3;
            this.currentGroupInsertionCode = c2;
            this.currentGroup3 = string2;
            while (this.groupCount >= this.group3Of.length) {
                this.chainOf = (Chain[])ArrayUtil.doubleLength(this.chainOf);
                this.group3Of = ArrayUtil.doubleLength(this.group3Of);
                this.seqcodes = ArrayUtil.doubleLength(this.seqcodes);
                this.firstAtomIndexes = ArrayUtil.doubleLength(this.firstAtomIndexes);
            }
            this.firstAtomIndexes[this.groupCount] = n;
            this.chainOf[this.groupCount] = this.currentChain;
            this.group3Of[this.groupCount] = string;
            this.seqcodes[this.groupCount] = Group.getSeqcode(n3, c2);
            ++this.groupCount;
        }
    }

    private void growAtomArrays(int n) {
        int n2 = this.atomCount + n;
        this.atoms = (Atom[])ArrayUtil.setLength(this.atoms, n2);
        if (this.clientAtomReferences != null) {
            this.clientAtomReferences = (Object[])ArrayUtil.setLength(this.clientAtomReferences, n2);
        }
        if (this.vibrationVectors != null) {
            this.vibrationVectors = (Vector3f[])ArrayUtil.setLength(this.vibrationVectors, n2);
        }
        if (this.occupancies != null) {
            this.occupancies = ArrayUtil.setLength(this.occupancies, n2);
        }
        if (this.bfactor100s != null) {
            this.bfactor100s = ArrayUtil.setLength(this.bfactor100s, n2);
        }
        if (this.partialCharges != null) {
            this.partialCharges = ArrayUtil.setLength(this.partialCharges, n2);
        }
        if (this.atomNames != null) {
            this.atomNames = ArrayUtil.setLength(this.atomNames, n2);
        }
        if (this.atomSerials != null) {
            this.atomSerials = ArrayUtil.setLength(this.atomSerials, n2);
        }
        if (this.specialAtomIDs != null) {
            this.specialAtomIDs = ArrayUtil.setLength(this.specialAtomIDs, n2);
        }
    }

    private void iterateOverAllNewBonds(JmolAdapter jmolAdapter, Object object) {
        JmolAdapter.BondIterator bondIterator = jmolAdapter.getBondIterator(object);
        if (bondIterator == null) {
            return;
        }
        short s = this.viewer.getMadBond();
        short s2 = this.defaultCovalentMad = this.jmolData == null ? s : (short)0;
        while (bondIterator.hasNext()) {
            this.bondAtoms(bondIterator.getAtomUniqueID1(), bondIterator.getAtomUniqueID2(), (short)bondIterator.getEncodedOrder());
        }
        this.defaultCovalentMad = s;
    }

    private void bondAtoms(Object object, Object object2, short s) {
        Atom atom = (Atom)this.htAtomMap.get(object);
        if (atom == null) {
            Logger.error("bondAtoms cannot find atomUid1?:" + object);
            return;
        }
        Atom atom2 = (Atom)this.htAtomMap.get(object2);
        if (atom2 == null) {
            Logger.error("bondAtoms cannot find atomUid2?:" + object2);
            return;
        }
        if (atom.isBonded(atom2)) {
            return;
        }
        Bond bond = this.bondMutually(atom, atom2, s, this.getDefaultMadFromOrder(s));
        if (bond.isAromatic()) {
            this.someModelsHaveAromaticBonds = true;
        }
        if (this.bondCount == this.bonds.length) {
            this.bonds = (Bond[])ArrayUtil.setLength(this.bonds, this.bondCount + 4000);
        }
        this.setBond(this.bondCount++, bond);
    }

    private void iterateOverAllNewStructures(JmolAdapter jmolAdapter, Object object) {
        JmolAdapter.StructureIterator structureIterator = jmolAdapter.getStructureIterator(object);
        if (structureIterator != null) {
            while (structureIterator.hasNext()) {
                if (structureIterator.getStructureType().equals("turn")) continue;
                this.defineStructure(structureIterator.getModelIndex() + this.baseModelIndex, structureIterator.getStructureType(), structureIterator.getStartChainID(), structureIterator.getStartSequenceNumber(), structureIterator.getStartInsertionCode(), structureIterator.getEndChainID(), structureIterator.getEndSequenceNumber(), structureIterator.getEndInsertionCode());
            }
        }
        if ((structureIterator = jmolAdapter.getStructureIterator(object)) != null) {
            while (structureIterator.hasNext()) {
                if (!structureIterator.getStructureType().equals("turn")) continue;
                this.defineStructure(structureIterator.getModelIndex() + this.baseModelIndex, structureIterator.getStructureType(), structureIterator.getStartChainID(), structureIterator.getStartSequenceNumber(), structureIterator.getStartInsertionCode(), structureIterator.getEndChainID(), structureIterator.getEndSequenceNumber(), structureIterator.getEndInsertionCode());
            }
        }
    }

    protected void defineStructure(int n, String string, char c, int n2, char c2, char c3, int n3, char c4) {
        this.structuresDefinedInFile.set(n);
        super.defineStructure(n, string, c, n2, c2, c3, n3, c4);
    }

    private void initializeUnitCellAndSymmetry() {
        int n;
        int n2;
        if (this.someModelsHaveUnitcells) {
            n2 = this.adapterModelCount == 1 ? 1 : 0;
            this.cellInfos = new CellInfo[this.modelCount];
            for (n = 0; n < this.baseModelCount; ++n) {
                this.cellInfos[n] = this.mergeModelSet.cellInfos != null ? this.mergeModelSet.cellInfos[n] : new CellInfo(n, false, this.getModelAuxiliaryInfo(n));
            }
            for (n = this.baseModelCount; n < this.modelCount; ++n) {
                this.cellInfos[n] = new CellInfo(n, n2 != 0, this.getModelAuxiliaryInfo(n));
            }
        }
        if (this.someModelsHaveSymmetry) {
            this.getSymmetrySet();
            n = -1;
            int n3 = 0;
            for (n2 = this.baseAtomIndex; n2 < this.atomCount; ++n2) {
                if (this.atoms[n2].modelIndex != n) {
                    n = this.atoms[n2].modelIndex;
                    n3 = this.baseAtomIndex + this.getModelAuxiliaryInfoInt(n, "presymmetryAtomIndex") + this.getModelAuxiliaryInfoInt(n, "presymmetryAtomCount");
                }
                if (n2 < n3) continue;
                this.bsSymmetry.set(n2);
            }
        }
        if (this.someModelsHaveFractionalCoordinates) {
            for (n2 = this.baseAtomIndex; n2 < this.atomCount; ++n2) {
                n = this.atoms[n2].modelIndex;
                if (!this.cellInfos[n].coordinatesAreFractional) continue;
                this.cellInfos[n].toCartesian(this.atoms[n2]);
                if (!Logger.isActiveLevel(0)) continue;
                Logger.debug("atom " + n2 + ": " + this.atoms[n2]);
            }
        }
    }

    private void initializeBonding() {
        boolean bl;
        boolean bl2 = bl = this.bondCount == this.baseBondIndex || this.isMultiFile || this.isPDB && this.jmolData == null && this.bondCount - this.baseBondIndex < (this.atomCount - this.baseAtomIndex) / 2 || this.someModelsHaveSymmetry && !this.viewer.getApplySymmetryToBonds();
        if (this.viewer.getForceAutoBond() || bl && this.viewer.getAutoBond() && this.getModelSetProperty("noautobond") == null) {
            BitSet bitSet = null;
            if (this.merging) {
                bitSet = new BitSet(this.atomCount);
                for (int i = this.baseAtomIndex; i < this.atomCount; ++i) {
                    bitSet.set(i);
                }
            }
            Logger.info("ModelSet: autobonding; use  autobond=false  to not generate bonds automatically");
            this.autoBond(bitSet, bitSet, null);
        } else {
            Logger.info("ModelSet: not autobonding; use forceAutobond=true to force automatic bond creation");
        }
    }

    private void finalizeGroupBuild() {
        Hashtable hashtable;
        int n;
        this.groups = new Group[this.groupCount];
        if (this.merging) {
            for (n = 0; n < this.baseGroupIndex; ++n) {
                this.groups[n] = this.mergeModelSet.groups[n];
                this.groups[n].setModelSet(this);
            }
        }
        for (n = this.baseGroupIndex; n < this.groupCount; ++n) {
            this.distinguishAndPropagateGroup(n, this.chainOf[n], this.group3Of[n], this.seqcodes[n], this.firstAtomIndexes[n], n == this.groupCount - 1 ? this.atomCount : this.firstAtomIndexes[n + 1]);
            this.chainOf[n] = null;
            this.group3Of[n] = null;
        }
        this.chainOf = null;
        this.group3Of = null;
        if (this.group3Lists != null && (hashtable = this.getModelSetAuxiliaryInfo()) != null) {
            hashtable.put("group3Lists", this.group3Lists);
            hashtable.put("group3Counts", this.group3Counts);
        }
        this.group3Counts = null;
        this.group3Lists = null;
    }

    private void distinguishAndPropagateGroup(int n, Chain chain, String string, int n2, int n3, int n4) {
        Object object;
        int n5 = n4 - 1;
        if (n5 < n3) {
            throw new NullPointerException();
        }
        short s = this.atoms[n3].modelIndex;
        Group group = null;
        if (string != null && this.specialAtomIDs != null && this.haveBioClasses) {
            if (this.jbr == null && this.haveBioClasses) {
                try {
                    object = Class.forName("org.jmol.modelsetbio.Resolver");
                    this.jbr = (JmolBioResolver)((Class)object).newInstance();
                    this.haveBioClasses = true;
                }
                catch (Exception exception) {
                    Logger.error("developer error: org.jmol.modelsetbio.Resolver could not be found");
                    this.haveBioClasses = false;
                }
            }
            if (this.haveBioClasses) {
                group = this.jbr.distinguishAndPropagateGroup(chain, string, n2, n3, n4, s, this.modelCount, this.specialAtomIndexes, this.specialAtomIDs, this.atoms);
            }
        }
        if (group == null) {
            group = new Group(chain, string, n2, n3, n5);
            object = "o>";
        } else {
            Object object2 = group.isProtein() ? "p>" : (group.isNucleic() ? "n>" : (object = group.isCarbohydrate() ? "c>" : "o>"));
        }
        if (string != null) {
            this.countGroup(s, (String)object, string);
        }
        chain.addGroup(group);
        this.groups[n] = group;
        int n6 = n4;
        while (--n6 >= n3) {
            this.atoms[n6].setGroup(group);
        }
    }

    private void countGroup(int n, String string, String string2) {
        if (this.group3Lists == null || this.group3Lists[n] == null) {
            return;
        }
        String string3 = (string2 + "   ").substring(0, 3);
        int n2 = this.group3Lists[n].indexOf(string3);
        if (n2 < 0) {
            int n3 = n;
            this.group3Lists[n3] = this.group3Lists[n3] + ",[" + string3 + "]";
            n2 = this.group3Lists[n].indexOf(string3);
            this.group3Counts[n] = ArrayUtil.setLength(this.group3Counts[n], this.group3Counts[n].length + 10);
        }
        int[] nArray = this.group3Counts[n];
        int n4 = n2 / 6;
        nArray[n4] = nArray[n4] + 1;
        n2 = this.group3Lists[n].indexOf(",[" + string3);
        if (n2 >= 0) {
            this.group3Lists[n] = this.group3Lists[n].substring(0, n2) + string + this.group3Lists[n].substring(n2 + 2);
        }
        if (n < this.modelCount) {
            this.countGroup(this.modelCount, string, string2);
        }
    }

    private void freeze() {
        if (this.atomCount < this.atoms.length) {
            this.growAtomArrays(0);
        }
        if (this.bondCount < this.bonds.length) {
            this.bonds = (Bond[])ArrayUtil.setLength(this.bonds, this.bondCount);
        }
        int n = 5;
        while (--n > 0) {
            this.numCached[n] = 0;
            Bond[][] bondArray = this.freeBonds[n];
            int n2 = bondArray.length;
            while (--n2 >= 0) {
                bondArray[n2] = null;
            }
        }
        this.setAtomNamesAndNumbers();
        this.findElementsPresent();
        if (this.isPDB) {
            this.calculateStructuresAllExcept(this.structuresDefinedInFile);
        }
        this.molecules = null;
        this.moleculeCount = 0;
        this.currentModel = null;
        this.currentChain = null;
        this.htAtomMap.clear();
    }

    private void setAtomNamesAndNumbers() {
        Atom atom;
        int n;
        if (this.atomSerials == null) {
            this.atomSerials = new int[this.atomCount];
        }
        int s = Integer.MAX_VALUE;
        int n2 = 0;
        for (n = 0; n < this.atomCount; ++n) {
            short s2;
            atom = this.atoms[n];
            if (atom.modelIndex != s2) {
                s2 = atom.modelIndex;
                int n3 = n2 = this.isZeroBased ? 0 : 1;
            }
            if (this.atomSerials[n] != 0) continue;
            this.atomSerials[n] = n < this.baseAtomIndex ? this.mergeModelSet.atomSerials[n] : n2++;
        }
        if (this.atomNames == null) {
            this.atomNames = new String[this.atomCount];
        }
        for (n = 0; n < this.atomCount; ++n) {
            if (this.atomNames[n] != null) continue;
            atom = this.atoms[n];
            this.atomNames[n] = atom.getElementSymbol() + atom.getAtomNumber();
        }
    }

    private void findElementsPresent() {
        int n;
        this.elementsPresent = new BitSet[this.modelCount];
        for (n = 0; n < this.modelCount; ++n) {
            this.elementsPresent[n] = new BitSet();
        }
        n = this.atomCount;
        while (--n >= 0) {
            int n2 = this.atoms[n].getAtomicAndIsotopeNumber();
            if (n2 >= 128) {
                n2 = JmolConstants.elementNumberMax + JmolConstants.altElementIndexFromNumber(n2);
            }
            this.elementsPresent[this.atoms[n].modelIndex].set(n2);
        }
    }

    private void finalizeShapes() {
        if (this.someModelsHaveAromaticBonds && this.viewer.getSmartAromatic()) {
            this.assignAromaticBonds(false);
        }
        if (this.merging) {
            for (int i = 0; i < 31; ++i) {
                this.shapes[i] = this.mergeModelSet.shapes[i];
                if (this.shapes[i] == null) continue;
                this.shapes[i].setModelSet(this);
            }
            this.viewer.getFrameRenderer().clear();
            this.merging = false;
            return;
        }
        this.loadShape(0);
        this.loadShape(1);
        this.loadShape(5);
        this.loadShape(26);
        this.loadShape(27);
    }
}

