/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import java.awt.FontMetrics;
import javax.vecmath.Point3f;
import org.jmol.api.JmolRendererInterface;
import org.jmol.g3d.Font3D;
import org.jmol.g3d.Graphics3D;
import org.jmol.shape.Shape;
import org.jmol.util.Escape;
import org.jmol.util.TextFormat;
import org.jmol.viewer.Viewer;

public class Text {
    public static final int POINTER_NONE = 0;
    public static final int POINTER_ON = 1;
    public static final int POINTER_BACKGROUND = 2;
    private static final String[] hAlignNames = new String[]{"", "left", "center", "right", ""};
    static final int XY = 0;
    static final int LEFT = 1;
    static final int CENTER = 2;
    static final int RIGHT = 3;
    static final int XYZ = 4;
    static final String[] vAlignNames = new String[]{"xy", "top", "bottom", "middle"};
    static final int TOP = 1;
    static final int BOTTOM = 2;
    static final int MIDDLE = 3;
    boolean atomBased;
    Viewer viewer;
    JmolRendererInterface g3d;
    Point3f xyz;
    String target;
    String text;
    String textUnformatted;
    String script;
    boolean doFormatText;
    String[] lines;
    int align;
    int valign;
    int pointer;
    int movableX;
    int movableY;
    int movableXPercent = Integer.MAX_VALUE;
    int movableYPercent = Integer.MAX_VALUE;
    int offsetX;
    int offsetY;
    int z;
    int zSlab;
    int windowWidth;
    int windowHeight;
    boolean adjustForWindow;
    int boxX;
    int boxY;
    int boxWidth;
    int boxHeight;
    int modelIndex = -1;
    boolean visible = true;
    Font3D font;
    FontMetrics fm;
    byte fid;
    int ascent;
    int descent;
    int lineHeight;
    short colix;
    short bgcolix;
    int[] widths;
    int textWidth;
    int textHeight;

    Text(JmolRendererInterface jmolRendererInterface, Font3D font3D, String string, short s, short s2, int n, int n2, int n3, int n4, int n5) {
        this.viewer = null;
        this.g3d = jmolRendererInterface;
        this.atomBased = true;
        this.setText(string);
        this.colix = s;
        this.bgcolix = s2;
        this.setXYZs(n, n2, n3, n4);
        this.align = n5;
        this.setFont(font3D);
    }

    Text(Viewer viewer, Graphics3D graphics3D, Font3D font3D, String string, short s, int n, int n2) {
        this.viewer = viewer;
        this.g3d = graphics3D;
        this.atomBased = false;
        this.target = string;
        if (string.equals("error")) {
            n = 1;
        }
        this.align = n2;
        this.valign = n;
        this.font = font3D;
        this.colix = s;
        this.z = 2;
        this.zSlab = Integer.MIN_VALUE;
        this.getFontMetrics();
    }

    void getFontMetrics() {
        this.fm = this.font.fontMetrics;
        this.descent = this.fm.getDescent();
        this.ascent = this.fm.getAscent();
        this.lineHeight = this.ascent + this.descent;
    }

    void setFid(byte by) {
        if (this.fid == by) {
            return;
        }
        this.setFont(Font3D.getFont3D(by));
    }

    void setModel(int n) {
        this.modelIndex = n;
    }

    void setVisibility(boolean bl) {
        this.visible = bl;
    }

    void setXYZ(Point3f point3f) {
        this.valign = 4;
        this.xyz = point3f;
        this.setAdjustForWindow(false);
    }

    void setAdjustForWindow(boolean bl) {
        this.adjustForWindow = bl;
    }

    void setColix(short s) {
        this.colix = s;
    }

    void setColix(Object object) {
        this.colix = Graphics3D.getColix(object);
    }

    void setTranslucent(float f, boolean bl) {
        if (bl) {
            if (this.bgcolix != 0) {
                this.bgcolix = Graphics3D.getColixTranslucent(this.bgcolix, !Float.isNaN(f), f);
            }
        } else {
            this.colix = Graphics3D.getColixTranslucent(this.colix, !Float.isNaN(f), f);
        }
    }

    void setBgColix(short s) {
        this.bgcolix = s;
    }

    void setBgColix(Object object) {
        this.bgcolix = object == null ? (short)0 : Graphics3D.getColix(object);
    }

    void setMovableX(int n) {
        this.valign = this.valign == 4 ? 4 : 0;
        this.movableX = n;
        this.movableXPercent = Integer.MAX_VALUE;
    }

    void setMovableY(int n) {
        this.valign = this.valign == 4 ? 4 : 0;
        this.movableY = n;
        this.movableYPercent = Integer.MAX_VALUE;
    }

    void setMovableXPercent(int n) {
        this.valign = this.valign == 4 ? 4 : 0;
        this.movableX = Integer.MAX_VALUE;
        this.movableXPercent = n;
    }

    void setMovableYPercent(int n) {
        this.valign = this.valign == 4 ? 4 : 0;
        this.movableY = Integer.MAX_VALUE;
        this.movableYPercent = n;
    }

    void setXY(int n, int n2) {
        this.setMovableX(n);
        this.setMovableY(n2);
    }

    void setZs(int n, int n2) {
        this.z = n;
        this.zSlab = n2;
    }

    void setXYZs(int n, int n2, int n3, int n4) {
        this.setMovableX(n);
        this.setMovableY(n2);
        this.setZs(n3, n4);
    }

    void setScript(String string) {
        this.script = string == null || string.length() == 0 ? null : string;
    }

    String getScript() {
        return this.script;
    }

    void setOffset(int n) {
        this.offsetX = Text.getXOffset(n);
        this.offsetY = Text.getYOffset(n);
        this.valign = 0;
    }

    static final int getXOffset(int n) {
        switch (n) {
            case 0: {
                return 4;
            }
            case 32767: {
                return 0;
            }
        }
        return (byte)(n >> 8);
    }

    static final int getYOffset(int n) {
        switch (n) {
            case 0: {
                return -4;
            }
            case 32767: {
                return 0;
            }
        }
        return -((byte)(n & 0xFF));
    }

    void setText(String string) {
        string = this.fixText(string);
        if (this.text != null && this.text.equals(string)) {
            return;
        }
        this.text = string;
        this.textUnformatted = string;
        boolean bl = this.doFormatText = this.viewer != null && string != null && (string.indexOf("%{") >= 0 || string.indexOf("@{") >= 0);
        if (!this.doFormatText) {
            this.recalc();
        }
    }

    void setFont(Font3D font3D) {
        this.font = font3D;
        this.fid = this.font.fid;
        this.getFontMetrics();
        this.recalc();
    }

    boolean setAlignment(String string) {
        if ("left".equals(string)) {
            return this.setAlignment(1);
        }
        if ("center".equals(string)) {
            return this.setAlignment(2);
        }
        if ("right".equals(string)) {
            return this.setAlignment(3);
        }
        return false;
    }

    static String getAlignment(int n) {
        return hAlignNames[n & 3];
    }

    boolean setAlignment(int n) {
        this.align = n;
        this.recalc();
        return true;
    }

    void setPointer(int n) {
        this.pointer = n;
    }

    static String getPointer(int n) {
        return (n & 1) == 0 ? "" : ((n & 2) > 0 ? "background" : "on");
    }

    String fixText(String string) {
        int n;
        if (string == null || string.length() == 0) {
            return null;
        }
        while ((n = string.indexOf("\n")) >= 0) {
            string = string.substring(0, n) + "|" + string.substring(n + 1);
        }
        return string;
    }

    void recalc() {
        if (this.text == null) {
            this.text = null;
            this.lines = null;
            this.widths = null;
            return;
        }
        if (this.fm == null) {
            return;
        }
        this.lines = TextFormat.split(this.text, '|');
        this.textWidth = 0;
        this.widths = new int[this.lines.length];
        int n = this.lines.length;
        while (--n >= 0) {
            this.widths[n] = this.stringWidth(this.lines[n]);
            this.textWidth = Math.max(this.textWidth, this.widths[n]);
        }
        this.textHeight = this.lines.length * this.lineHeight;
        this.boxWidth = this.textWidth + 8;
        this.boxHeight = this.textHeight + 8;
    }

    private void formatText() {
        this.text = this.viewer == null ? this.textUnformatted : this.viewer.formatText(this.textUnformatted);
        this.recalc();
    }

    void render(JmolRendererInterface jmolRendererInterface, boolean bl) {
        if (this.text == null) {
            return;
        }
        this.windowWidth = jmolRendererInterface.getRenderWidth();
        this.windowHeight = jmolRendererInterface.getRenderHeight();
        if (this.doFormatText) {
            this.formatText();
        }
        this.setPositions(bl);
        this.setBoxOffsetsInWindow(bl);
        if (this.bgcolix != 0 && jmolRendererInterface.setColix(this.bgcolix)) {
            Text.showBox(jmolRendererInterface, this.colix, this.bgcolix, this.boxX, this.boxY, this.z + 2, this.zSlab, this.boxWidth + (bl ? this.boxWidth : 0), this.boxHeight + (bl ? this.boxHeight : 0), bl, this.atomBased);
        }
        if (jmolRendererInterface.setColix(this.colix)) {
            int n = bl ? this.boxWidth << 1 : this.boxWidth;
            int n2 = bl ? 8 : 4;
            int n3 = this.boxX;
            switch (this.align) {
                case 2: {
                    n3 += n / 2;
                    break;
                }
                case 3: {
                    n3 += n - n2;
                    break;
                }
                default: {
                    n3 += n2;
                }
            }
            int n4 = n3;
            int n5 = this.boxY + this.ascent + 4;
            n = this.lineHeight;
            int n6 = 1;
            if (bl) {
                n5 += this.ascent + 4;
                n <<= 1;
                n6 = 2;
            }
            for (int i = 0; i < this.lines.length; ++i) {
                switch (this.align) {
                    case 2: {
                        n4 = n3 - this.widths[i] * n6 / 2;
                        break;
                    }
                    case 3: {
                        n4 = n3 - this.widths[i] * n6;
                    }
                }
                jmolRendererInterface.drawString(this.lines[i], this.font, n4, n5, this.z, this.zSlab);
                n5 += n;
            }
        }
        if ((this.pointer & 1) != 0) {
            jmolRendererInterface.setColix((this.pointer & 2) != 0 && this.bgcolix != 0 ? this.bgcolix : this.colix);
            if (this.boxX > this.movableX) {
                jmolRendererInterface.drawLine(this.movableX, this.movableY, this.zSlab, this.boxX, this.boxY + this.boxHeight / 2, this.zSlab);
            } else if (this.boxX + this.boxWidth < this.movableX) {
                jmolRendererInterface.drawLine(this.movableX, this.movableY, this.zSlab, this.boxX + this.boxWidth, this.boxY + this.boxHeight / 2, this.zSlab);
            }
        }
    }

    private void setPositions(boolean bl) {
        int n;
        int n2;
        int n3;
        int n4;
        boolean bl2;
        boolean bl3 = bl2 = this.atomBased || this.xyz != null;
        if (this.valign == 0 || this.valign == 4) {
            n4 = this.movableXPercent != Integer.MAX_VALUE ? this.movableXPercent * this.windowWidth / 100 : (bl && !bl2 ? this.movableX << 1 : this.movableX);
            int n5 = this.offsetX;
            if (bl) {
                n5 <<= 1;
            }
            n2 = n3 = n4 + n5;
            n = n3;
        } else {
            n = bl ? 10 : 5;
            n3 = this.windowWidth / 2;
            n2 = this.windowWidth - n;
        }
        this.boxX = n;
        switch (this.align) {
            case 2: {
                this.boxX = n3 - (bl ? this.boxWidth : this.boxWidth / 2);
                break;
            }
            case 3: {
                this.boxX = n2 - (bl ? this.boxWidth * 2 : this.boxWidth);
            }
        }
        this.boxY = 0;
        switch (this.valign) {
            case 1: {
                break;
            }
            case 3: {
                this.boxY = this.windowHeight / 2;
                break;
            }
            case 2: {
                this.boxY = this.windowHeight;
                break;
            }
            default: {
                int n6 = this.movableXPercent != Integer.MAX_VALUE ? this.movableYPercent * this.windowHeight / 100 : (n4 = bl ? this.movableY << 1 : this.movableY);
                this.boxY = (bl2 ? (bl ? n4 >> 1 : n4) : this.windowHeight - n4) + this.offsetY;
                if (!bl) break;
                this.boxY += this.offsetY;
            }
        }
    }

    void setBoxOffsetsInWindow(boolean bl) {
        boolean bl2;
        int n = 0;
        int n2 = 0;
        boolean bl3 = bl2 = this.atomBased || this.xyz != null;
        if (!this.adjustForWindow) {
            n2 -= bl && !bl2 ? this.lineHeight * 2 : this.lineHeight;
        }
        if (this.atomBased && this.align == 0) {
            n += 4;
            n2 -= 8;
        }
        if (bl && this.atomBased) {
            n2 -= this.lineHeight / 2;
        }
        if (this.valign == 4) {
            n2 += this.ascent / 2;
        }
        if (bl) {
            n <<= 1;
            n2 <<= 1;
        }
        this.boxX += n;
        this.boxY += n2;
        if (this.adjustForWindow) {
            int n3;
            int n4;
            int n5;
            int n6 = this.boxX;
            int n7 = (bl ? this.boxWidth << 1 : this.boxWidth) + (n5 = bl ? 10 : 5);
            if (n6 + n7 > this.windowWidth) {
                n6 = this.windowWidth - n7;
            }
            if (n6 < n5) {
                n6 = n5;
            }
            this.boxX = n6;
            int n8 = this.boxY;
            int n9 = n4 = bl ? this.boxHeight << 1 : this.boxHeight;
            if ((n8 -= bl ? this.textHeight << 1 : this.textHeight) + n4 > this.windowHeight) {
                n8 = this.windowHeight - n4;
            }
            int n10 = this.atomBased ? (16 + this.lineHeight) * (bl ? 2 : 1) : (n3 = 0);
            if (n8 < n3) {
                n8 = n3;
            }
            this.boxY = n8;
        }
    }

    private static void showBox(JmolRendererInterface jmolRendererInterface, short s, short s2, int n, int n2, int n3, int n4, int n5, int n6, boolean bl, boolean bl2) {
        jmolRendererInterface.fillRect(n, n2, n3, n4, n5, n6);
        jmolRendererInterface.setColix(s);
        if (!bl2) {
            return;
        }
        if (bl) {
            jmolRendererInterface.drawRect(n + 3, n2 + 3, n3 - 1, n4, n5 - 6, n6 - 6);
            jmolRendererInterface.drawRect(n + 4, n2 + 4, n3 - 1, n4, n5 - 8, n6 - 8);
        } else {
            jmolRendererInterface.drawRect(n + 1, n2 + 1, n3 - 1, n4, n5 - 2, n6 - 2);
        }
    }

    static final void renderSimple(JmolRendererInterface jmolRendererInterface, Font3D font3D, String string, short s, short s2, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl, short s3, boolean bl2) {
        int n9;
        int n10 = n;
        int n11 = n2;
        int n12 = font3D.fontMetrics.stringWidth(string) + 8;
        int n13 = n7 + n8 + 8;
        if (n5 > 0) {
            n9 = n5;
        } else {
            n9 = -n12;
            n9 = n5 == 0 ? (n9 /= 2) : (n9 += n5);
        }
        int n14 = n6 > 0 ? n6 : (n6 == 0 ? -n13 / 2 - 2 : -n13 + n6);
        n += n9;
        n2 += n14;
        int n15 = 1;
        if (bl2) {
            n += n9;
            n2 += n14;
            n12 += n12;
            n13 += n13;
            n15 = 2;
        }
        if (s2 != 0 && jmolRendererInterface.setColix(s2)) {
            Text.showBox(jmolRendererInterface, s, s2, n, n2, n3, n4, n12, n13, bl2, true);
        }
        n15 <<= 2;
        if (bl2) {
            n7 <<= 1;
        }
        jmolRendererInterface.drawString(string, font3D, n + n15, n2 + n15 + n7, n3 - 1, n4);
        if (bl) {
            jmolRendererInterface.setColix(s3);
            if (n5 > 0) {
                jmolRendererInterface.drawLine(n10, n11, n4, n, n2 + n13 / 2, n4);
            } else if (n5 < 0) {
                jmolRendererInterface.drawLine(n10, n11, n4, n + n12, n2 + n13 / 2, n4);
            }
        }
    }

    public String getState(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.text == null || this.atomBased || this.target.equals("error")) {
            return "";
        }
        if (bl) {
            String string = null;
            switch (this.valign) {
                case 0: {
                    string = this.movableXPercent == Integer.MAX_VALUE ? this.movableX + " " : this.movableXPercent + "% ";
                    string = string + (this.movableYPercent == Integer.MAX_VALUE ? this.movableY + "" : this.movableYPercent + "%");
                }
                case 4: {
                    if (string == null) {
                        string = Escape.escape(this.xyz);
                    }
                    stringBuffer.append("  set echo ").append(this.target).append(" ").append(string);
                    if (this.align == 1) break;
                    stringBuffer.append("  set echo ").append(this.target).append(" ").append(hAlignNames[this.align]);
                    break;
                }
                default: {
                    stringBuffer.append("  set echo ").append(vAlignNames[this.valign]).append(" ").append(hAlignNames[this.align]);
                }
            }
            stringBuffer.append("; echo ").append(Escape.escape(this.textUnformatted)).append(";\n");
            if (this.script != null) {
                stringBuffer.append("  set echo ").append(this.target).append(" script ").append(Escape.escape(this.script)).append(";\n");
            }
            if (this.modelIndex >= 0) {
                stringBuffer.append("  set echo ").append(this.target).append(" model ").append(this.viewer.getModelNumberDotted(this.modelIndex)).append(";\n");
            }
        }
        if (bl != this.target.equals("top")) {
            return stringBuffer.toString();
        }
        stringBuffer.append("  " + Shape.getFontCommand("echo", this.font)).append(";\n");
        stringBuffer.append("  color echo");
        if (Graphics3D.isColixTranslucent(this.colix)) {
            stringBuffer.append(" translucent " + Graphics3D.getColixTranslucencyLevel(this.colix));
        }
        stringBuffer.append(" [x").append(this.g3d.getHexColorFromIndex(this.colix)).append("]");
        if (this.bgcolix != 0) {
            stringBuffer.append("; color echo background");
            if (Graphics3D.isColixTranslucent(this.bgcolix)) {
                stringBuffer.append(" translucent " + Graphics3D.getColixTranslucencyLevel(this.bgcolix));
            }
            stringBuffer.append(" [x").append(this.g3d.getHexColorFromIndex(this.bgcolix)).append("]");
        }
        stringBuffer.append(";\n");
        return stringBuffer.toString();
    }

    public boolean checkObjectClicked(int n, int n2) {
        return this.script != null && n >= this.boxX && n <= this.boxX + this.boxWidth && n2 >= this.boxY && n2 <= this.boxY + this.boxHeight;
    }

    private int stringWidth(String string) {
        int n = 0;
        int n2 = 1;
        int n3 = 1;
        if (string == null) {
            return 0;
        }
        if (string.indexOf("<su") < 0) {
            return this.fm.stringWidth(string);
        }
        int n4 = string.length();
        for (int i = 0; i < n4; ++i) {
            if (string.charAt(i) == '<') {
                String string2;
                if (i + 4 < n4 && ((string2 = string.substring(i, i + 5)).equals("<sub>") || string2.equals("<sup>"))) {
                    i += 4;
                    n2 = n3;
                    continue;
                }
                if (i + 5 < n4 && ((string2 = string.substring(i, i + 6)).equals("</sub>") || string2.equals("</sup>"))) {
                    i += 5;
                    n2 = 1;
                    continue;
                }
            }
            n += this.fm.stringWidth(string.substring(i, i + 1)) * n2;
        }
        return n;
    }
}

