/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.smiles;

import java.util.BitSet;
import org.jmol.api.SmilesMatcherInterface;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.ModelSet;
import org.jmol.smiles.SmilesAtom;
import org.jmol.smiles.SmilesBond;
import org.jmol.smiles.SmilesMolecule;
import org.jmol.smiles.SmilesParser;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.Viewer;

public class PatternMatcher
implements SmilesMatcherInterface {
    private int atomCount = 0;
    private ModelSet modelSet = null;

    public void setViewer(Viewer viewer) {
        this.modelSet = viewer.getModelSet();
        this.atomCount = viewer.getAtomCount();
    }

    public BitSet getSubstructureSet(String string) throws Exception {
        SmilesParser smilesParser = new SmilesParser();
        SmilesMolecule smilesMolecule = smilesParser.parseSmiles(string);
        return this.getSubstructureSet(smilesMolecule);
    }

    public BitSet getSubstructureSet(SmilesMolecule smilesMolecule) {
        BitSet bitSet = new BitSet();
        this.searchMatch(bitSet, smilesMolecule, 0);
        return bitSet;
    }

    private void searchMatch(BitSet bitSet, SmilesMolecule smilesMolecule, int n) {
        int n2;
        SmilesAtom smilesAtom = smilesMolecule.getAtom(n);
        for (n2 = 0; n2 < smilesAtom.getBondsCount(); ++n2) {
            SmilesBond smilesBond = smilesAtom.getBond(n2);
            if (smilesBond.getAtom2() != smilesAtom) continue;
            int n3 = smilesBond.getAtom1().getMatchingAtom();
            Atom atom = this.modelSet.getAtomAt(n3);
            Bond[] bondArray = atom.getBonds();
            if (bondArray != null) {
                for (int i = 0; i < bondArray.length; ++i) {
                    if (bondArray[i].getAtomIndex1() == n3) {
                        this.searchMatch(bitSet, smilesMolecule, smilesAtom, n, bondArray[i].getAtomIndex2());
                    }
                    if (bondArray[i].getAtomIndex2() != n3) continue;
                    this.searchMatch(bitSet, smilesMolecule, smilesAtom, n, bondArray[i].getAtomIndex1());
                }
            }
            return;
        }
        for (n2 = 0; n2 < this.atomCount; ++n2) {
            this.searchMatch(bitSet, smilesMolecule, smilesAtom, n, n2);
        }
    }

    private void searchMatch(BitSet bitSet, SmilesMolecule smilesMolecule, SmilesAtom smilesAtom, int n, int n2) {
        Object object;
        int n3;
        Object object2;
        for (int i = 0; i < n; ++i) {
            object2 = smilesMolecule.getAtom(i);
            if (((SmilesAtom)object2).getMatchingAtom() != n2) continue;
            return;
        }
        Atom atom = this.modelSet.getAtomAt(n2);
        object2 = smilesAtom.getSymbol();
        short s = atom.getElementNumber();
        if (object2 != "*" && object2 != JmolConstants.elementSymbolFromNumber(s)) {
            return;
        }
        int n4 = smilesAtom.getAtomicMass();
        if (n4 > 0 && (n3 = atom.getIsotopeNumber()) != n4) {
            return;
        }
        if (smilesAtom.getCharge() != atom.getFormalCharge()) {
            return;
        }
        for (n3 = 0; n3 < smilesAtom.getBondsCount(); ++n3) {
            object = smilesAtom.getBond(n3);
            if (((SmilesBond)object).getAtom2() != smilesAtom) continue;
            int n5 = ((SmilesBond)object).getAtom1().getMatchingAtom();
            Bond[] bondArray = atom.getBonds();
            boolean bl = false;
            block9: for (int i = 0; i < bondArray.length; ++i) {
                if (bondArray[i].getAtomIndex1() != n5 && bondArray[i].getAtomIndex2() != n5) continue;
                switch (((SmilesBond)object).getBondType()) {
                    case 4: {
                        if ((bondArray[i].getOrder() & 0x200) == 0) continue block9;
                        bl = true;
                        continue block9;
                    }
                    case 2: {
                        if ((bondArray[i].getOrder() & 2) == 0) continue block9;
                        bl = true;
                        continue block9;
                    }
                    case 1: 
                    case 5: 
                    case 6: {
                        if ((bondArray[i].getOrder() & 1) == 0) continue block9;
                        bl = true;
                        continue block9;
                    }
                    case 3: {
                        if ((bondArray[i].getOrder() & 3) == 0) continue block9;
                        bl = true;
                        continue block9;
                    }
                    case -1: {
                        bl = true;
                    }
                }
            }
            if (bl) continue;
            return;
        }
        smilesAtom.setMatchingAtom(n2);
        if (n + 1 < smilesMolecule.getAtomsCount()) {
            this.searchMatch(bitSet, smilesMolecule, n + 1);
        } else {
            for (n3 = 0; n3 < smilesMolecule.getAtomsCount(); ++n3) {
                object = smilesMolecule.getAtom(n3);
                bitSet.set(((SmilesAtom)object).getMatchingAtom());
            }
        }
        smilesAtom.setMatchingAtom(-1);
    }
}

