/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import java.io.DataInputStream;
import org.jmol.util.Logger;

class BinaryDocument {
    DataInputStream stream;
    boolean isRandom = false;
    boolean isBigEndian = true;

    BinaryDocument() {
    }

    byte readByte() throws Exception {
        return this.stream.readByte();
    }

    void readByteArray(byte[] byArray) throws Exception {
        this.stream.read(byArray);
    }

    void readByteArray(byte[] byArray, int n, int n2) throws Exception {
        this.stream.read(byArray, n, n2);
    }

    short readShort() throws Exception {
        if (this.isBigEndian) {
            return this.stream.readShort();
        }
        return (short)(this.stream.readByte() & 0xFF | (this.stream.readByte() & 0xFF) << 8);
    }

    int readInt() throws Exception {
        if (this.isBigEndian) {
            return this.stream.readInt();
        }
        return this.stream.readByte() & 0xFF | (this.stream.readByte() & 0xFF) << 8 | (this.stream.readByte() & 0xFF) << 16 | (this.stream.readByte() & 0xFF) << 24;
    }

    long readLong() throws Exception {
        if (this.isBigEndian) {
            return this.stream.readLong();
        }
        return (long)this.stream.readByte() & 0xFFL | ((long)this.stream.readByte() & 0xFFL) << 8 | ((long)this.stream.readByte() & 0xFFL) << 16 | ((long)this.stream.readByte() & 0xFFL) << 24 | ((long)this.stream.readByte() & 0xFFL) << 32 | ((long)this.stream.readByte() & 0xFFL) << 40 | ((long)this.stream.readByte() & 0xFFL) << 48 | ((long)this.stream.readByte() & 0xFFL) << 54;
    }

    void seek(long l) {
        try {
            this.stream.reset();
            this.stream.skipBytes((int)l);
        }
        catch (Exception exception) {
            Logger.error(null, exception);
        }
    }
}

