/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import java.util.BitSet;

public class Parser {
    private static final float[] decimalScale = new float[]{0.1f, 0.01f, 0.001f, 1.0E-4f, 1.0E-5f, 1.0E-6f, 1.0E-7f, 1.0E-8f};
    private static final float[] tensScale = new float[]{10.0f, 100.0f, 1000.0f, 10000.0f, 100000.0f, 1000000.0f};

    public static void parseFloatArray(String string, BitSet bitSet, float[] fArray) {
        Parser.parseFloatArray(Parser.getTokens(string), bitSet, fArray);
    }

    public static void parseFloatArray(String[] stringArray, BitSet bitSet, float[] fArray) {
        int n = fArray.length;
        int n2 = stringArray.length;
        int n3 = 0;
        for (int i = 0; i < n && n3 < n2; ++i) {
            float f;
            if (bitSet != null && !bitSet.get(i)) continue;
            while (Float.isNaN(f = Parser.parseFloat(stringArray[n3++])) && n3 < n2) {
            }
            fArray[i] = f;
        }
    }

    public static void parseFloatArrayFromMatchAndField(String string, BitSet bitSet, int n, int[] nArray, int n2, float[] fArray) {
        if (n2 == Integer.MIN_VALUE) {
            float f = Parser.parseFloat(string);
            for (int i = 0; i < fArray.length; ++i) {
                if (bitSet != null && !bitSet.get(i)) continue;
                fArray[i] = f;
            }
            return;
        }
        if (n2 <= 0) {
            Parser.parseFloatArray(string, bitSet, fArray);
            return;
        }
        int n3 = fArray.length;
        int n4 = -1;
        boolean bl = nArray != null;
        int[] nArray2 = Parser.markLines(string, '\n');
        int n5 = nArray2.length;
        int n6 = 0;
        for (int i = 0; i < n5; ++i) {
            int n7;
            float f;
            String[] stringArray = Parser.getTokens(string.substring(n6, nArray2[i]));
            n6 = nArray2[i];
            if (stringArray.length < n2 || stringArray.length < n || Float.isNaN(f = Parser.parseFloat(stringArray[n2 - 1]))) continue;
            if (bl) {
                n7 = Parser.parseInt(stringArray[n - 1]);
                if (n7 == Integer.MIN_VALUE || n7 < 0 || n7 >= n3 || (n7 = nArray[n7]) < 0) {
                    continue;
                }
            } else {
                while (++n4 < n3 && bitSet != null && !bitSet.get(n4)) {
                }
                if (n4 >= n3) {
                    return;
                }
                n7 = n4;
            }
            fArray[n7] = f;
        }
    }

    public static void parseFloatArray(String[] stringArray, float[] fArray) {
        Parser.parseFloatArray(stringArray, fArray, fArray.length);
    }

    public static void parseFloatArray(String[] stringArray, float[] fArray, int n) {
        int n2 = n;
        while (--n2 >= 0) {
            fArray[n2] = n2 >= stringArray.length ? Float.NaN : Parser.parseFloat(stringArray[n2]);
        }
    }

    public static float parseFloat(String string) {
        return Parser.parseFloat(string, new int[]{0});
    }

    public static int parseInt(String string) {
        return Parser.parseInt(string, new int[]{0});
    }

    public static String[] getTokens(String string) {
        return Parser.getTokens(string, 0);
    }

    public static String parseToken(String string) {
        return Parser.parseToken(string, new int[]{0});
    }

    public static String parseTrimmed(String string) {
        return Parser.parseTrimmed(string, 0, string.length());
    }

    public static String parseTrimmed(String string, int n) {
        return Parser.parseTrimmed(string, n, string.length());
    }

    public static String parseTrimmed(String string, int n, int n2) {
        int n3 = string.length();
        if (n2 < n3) {
            n3 = n2;
        }
        if (n3 < n) {
            return "";
        }
        return Parser.parseTrimmedChecked(string, n, n3);
    }

    public static int[] markLines(String string, char c) {
        int n = 0;
        int n2 = string.length();
        while (--n2 >= 0) {
            if (string.charAt(n2) != c) continue;
            ++n;
        }
        int[] nArray = new int[n + 1];
        nArray[n--] = string.length();
        int n3 = string.length();
        while (--n3 >= 0) {
            if (string.charAt(n3) != c) continue;
            nArray[n--] = n3 + 1;
        }
        return nArray;
    }

    public static float parseFloat(String string, int[] nArray) {
        int n = string.length();
        if (nArray[0] >= n) {
            return Float.NaN;
        }
        return Parser.parseFloatChecked(string, n, nArray);
    }

    public static float parseFloat(String string, int n, int[] nArray) {
        int n2 = string.length();
        if (n > n2) {
            n = n2;
        }
        if (nArray[0] >= n) {
            return Float.NaN;
        }
        return Parser.parseFloatChecked(string, n, nArray);
    }

    private static float parseFloatChecked(String string, int n, int[] nArray) {
        int n2;
        int n3;
        boolean bl = false;
        float f = 0.0f;
        for (n3 = nArray[0]; n3 < n && Parser.isWhiteSpace(string, n3); ++n3) {
        }
        boolean bl2 = false;
        if (n3 < n && string.charAt(n3) == '-') {
            ++n3;
            bl2 = true;
        }
        int n4 = 0;
        while (n3 < n) {
            char c = string.charAt(n3);
            n4 = c;
            if (c < '0' || n4 > 57) break;
            f = f * 10.0f + (float)(n4 - 48);
            ++n3;
            bl = true;
        }
        if (n4 == 46) {
            n2 = 0;
            while (++n3 < n) {
                char c = string.charAt(n3);
                n4 = c;
                if (c < '0' || n4 > 57) break;
                if (n2 < decimalScale.length) {
                    f += (float)(n4 - 48) * decimalScale[n2];
                }
                ++n2;
                bl = true;
            }
        }
        if (!bl) {
            f = Float.NaN;
        } else if (bl2) {
            f = -f;
        }
        if (n3 < n && (n4 == 69 || n4 == 101 || n4 == 68)) {
            if (++n3 >= n) {
                return Float.NaN;
            }
            n4 = string.charAt(n3);
            if (n4 == 43 && ++n3 >= n) {
                return Float.NaN;
            }
            nArray[0] = n3;
            n2 = Parser.parseIntChecked(string, n, nArray);
            if (n2 == Integer.MIN_VALUE) {
                return Float.NaN;
            }
            if (n2 > 0) {
                f = (float)((double)f * (n2 < tensScale.length ? (double)tensScale[n2 - 1] : Math.pow(10.0, n2)));
            } else if (n2 < 0) {
                f = (float)((double)f * (-n2 < decimalScale.length ? (double)decimalScale[-n2 - 1] : Math.pow(10.0, n2)));
            }
        } else {
            nArray[0] = n3;
        }
        return f;
    }

    public static int parseInt(String string, int[] nArray) {
        int n = string.length();
        if (nArray[0] >= n) {
            return Integer.MIN_VALUE;
        }
        return Parser.parseIntChecked(string, n, nArray);
    }

    public static int parseInt(String string, int n, int[] nArray) {
        int n2 = string.length();
        if (n > n2) {
            n = n2;
        }
        if (nArray[0] >= n) {
            return Integer.MIN_VALUE;
        }
        return Parser.parseIntChecked(string, n, nArray);
    }

    private static int parseIntChecked(String string, int n, int[] nArray) {
        char c;
        int n2;
        boolean bl = false;
        int n3 = 0;
        for (n2 = nArray[0]; n2 < n && Parser.isWhiteSpace(string, n2); ++n2) {
        }
        boolean bl2 = false;
        if (n2 < n && string.charAt(n2) == '-') {
            bl2 = true;
            ++n2;
        }
        while (n2 < n && (c = string.charAt(n2)) >= '0' && c <= '9') {
            n3 = n3 * 10 + (c - 48);
            bl = true;
            ++n2;
        }
        if (!bl) {
            n3 = Integer.MIN_VALUE;
        } else if (bl2) {
            n3 = -n3;
        }
        nArray[0] = n2;
        return n3;
    }

    public static String[] getTokens(String string, int n) {
        if (string == null) {
            return null;
        }
        int n2 = string.length();
        if (n > n2) {
            return null;
        }
        int n3 = Parser.countTokens(string, n);
        String[] stringArray = new String[n3];
        int[] nArray = new int[]{n};
        for (int i = 0; i < n3; ++i) {
            stringArray[i] = Parser.parseTokenChecked(string, n2, nArray);
        }
        return stringArray;
    }

    public static int countTokens(String string, int n) {
        int n2 = 0;
        if (string != null) {
            int n3 = string.length();
            while (true) {
                if (n < n3 && Parser.isWhiteSpace(string, n)) {
                    ++n;
                    continue;
                }
                if (n == n3) break;
                ++n2;
                while (++n < n3 && !Parser.isWhiteSpace(string, n)) {
                }
            }
        }
        return n2;
    }

    public static String parseToken(String string, int[] nArray) {
        int n = string.length();
        if (nArray[0] >= n) {
            return null;
        }
        return Parser.parseTokenChecked(string, n, nArray);
    }

    public static String parseToken(String string, int n, int[] nArray) {
        int n2 = string.length();
        if (n > n2) {
            n = n2;
        }
        if (nArray[0] >= n) {
            return null;
        }
        return Parser.parseTokenChecked(string, n, nArray);
    }

    private static String parseTokenChecked(String string, int n, int[] nArray) {
        int n2;
        for (n2 = nArray[0]; n2 < n && Parser.isWhiteSpace(string, n2); ++n2) {
        }
        int n3 = n2;
        while (n2 < n && !Parser.isWhiteSpace(string, n2)) {
            ++n2;
        }
        nArray[0] = n2;
        if (n3 == n2) {
            return null;
        }
        return string.substring(n3, n2);
    }

    private static String parseTrimmedChecked(String string, int n, int n2) {
        int n3;
        while (n < n2 && Parser.isWhiteSpace(string, n)) {
            ++n;
        }
        for (n3 = n2 - 1; n3 >= n && Parser.isWhiteSpace(string, n3); --n3) {
        }
        if (n3 < n) {
            return "";
        }
        return string.substring(n, n3 + 1);
    }

    public static String concatTokens(String[] stringArray, int n, int n2) {
        String string = "";
        String string2 = "";
        for (int i = n; i < n2; ++i) {
            if (i >= stringArray.length) continue;
            string = string + string2 + stringArray[i];
            string2 = " ";
        }
        return string;
    }

    public static String getString(String string, String string2) {
        int n = string.indexOf(string2);
        int n2 = string.lastIndexOf(string2);
        return n2 == n ? "" : string.substring(n + 1, n2);
    }

    private static boolean isWhiteSpace(String string, int n) {
        char c = string.charAt(n);
        return c == ' ' || c == '\t' || c == '\n';
    }

    public static boolean isOneOf(String string, String string2) {
        return (';' + string2 + ';').indexOf(';' + string + ';') >= 0;
    }
}

