/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import javax.vecmath.Matrix3f;
import javax.vecmath.Vector3f;

public class Quaternion {
    public float q0;
    public float q1;
    public float q2;
    public float q3;

    public Quaternion(float f, float f2, float f3, float f4) {
        this.q0 = f;
        this.q1 = f2;
        this.q2 = f3;
        this.q3 = f4;
    }

    public Quaternion(Matrix3f matrix3f) {
        float f;
        float f2;
        float f3;
        float f4;
        float f5 = matrix3f.m00 + matrix3f.m11 + matrix3f.m22;
        if (f5 > 0.0f) {
            float f6 = (float)Math.sqrt(f5 + 1.0f);
            f4 = 0.5f * f6;
            f6 = 0.5f / f6;
            f3 = (matrix3f.m12 - matrix3f.m21) * f6;
            f2 = (matrix3f.m20 - matrix3f.m02) * f6;
            f = (matrix3f.m01 - matrix3f.m10) * f6;
        } else {
            float f7 = matrix3f.m00;
            f7 = matrix3f.m11 > f7 ? matrix3f.m11 : f7;
            float f8 = f7 = matrix3f.m22 > f7 ? matrix3f.m22 : f7;
            if (matrix3f.m00 == f7) {
                float f9 = (float)Math.sqrt(matrix3f.m00 - matrix3f.m11 - matrix3f.m22 + 1.0f);
                f3 = 0.5f * f9;
                if (f9 != 0.0f) {
                    f9 = 0.5f / f9;
                }
                f4 = (matrix3f.m12 - matrix3f.m21) * f9;
                f2 = (matrix3f.m01 + matrix3f.m10) * f9;
                f = (matrix3f.m02 + matrix3f.m20) * f9;
            } else if (matrix3f.m11 == f7) {
                float f10 = (float)Math.sqrt(matrix3f.m11 - matrix3f.m00 - matrix3f.m22 + 1.0f);
                f2 = 0.5f * f10;
                if (f10 != 0.0f) {
                    f10 = 0.5f / f10;
                }
                f4 = (matrix3f.m20 - matrix3f.m02) * f10;
                f3 = (matrix3f.m01 + matrix3f.m10) * f10;
                f = (matrix3f.m12 + matrix3f.m21) * f10;
            } else {
                float f11 = (float)Math.sqrt(matrix3f.m22 - matrix3f.m00 - matrix3f.m11 + 1.0f);
                f = 0.5f * f11;
                if (f11 != 0.0f) {
                    f11 = 0.5f / f11;
                }
                f4 = (matrix3f.m01 - matrix3f.m10) * f11;
                f3 = (matrix3f.m02 + matrix3f.m20) * f11;
                f2 = (matrix3f.m12 + matrix3f.m21) * f11;
            }
        }
        this.q0 = f4;
        this.q1 = f3;
        this.q2 = f2;
        this.q3 = f;
    }

    public Quaternion mul(float f) {
        return new Quaternion(this.q0 * f, this.q1 * f, this.q2 * f, this.q3 * f);
    }

    public Quaternion mul(Quaternion quaternion) {
        return new Quaternion(quaternion.q0 * this.q0 - quaternion.q1 * this.q1 - quaternion.q2 * this.q2 - quaternion.q3 * this.q3, quaternion.q0 * this.q1 + quaternion.q1 * this.q0 + quaternion.q2 * this.q3 - quaternion.q3 * this.q2, quaternion.q0 * this.q2 + quaternion.q2 * this.q0 + quaternion.q3 * this.q1 - quaternion.q1 * this.q3, quaternion.q0 * this.q3 + quaternion.q3 * this.q0 + quaternion.q1 * this.q2 - quaternion.q2 * this.q1);
    }

    public float dot(Quaternion quaternion) {
        return this.q0 * quaternion.q0 + this.q1 * quaternion.q1 + this.q2 * quaternion.q2 + this.q3 * quaternion.q3;
    }

    public Quaternion inv() {
        return new Quaternion(this.q0, -this.q1, -this.q2, -this.q3);
    }

    public String toString() {
        return "{" + this.q0 + " " + this.q1 + " " + this.q2 + " " + this.q3 + "}";
    }

    public static final Quaternion getQuaternionFrame(Vector3f vector3f, Vector3f vector3f2) {
        Vector3f vector3f3 = new Vector3f();
        vector3f3.cross(vector3f, vector3f2);
        Vector3f vector3f4 = new Vector3f();
        vector3f4.cross(vector3f3, vector3f);
        vector3f.normalize();
        vector3f4.normalize();
        vector3f3.normalize();
        Matrix3f matrix3f = new Matrix3f();
        matrix3f.setColumn(0, vector3f);
        matrix3f.setColumn(1, vector3f4);
        matrix3f.setColumn(2, vector3f3);
        return new Quaternion(matrix3f);
    }
}

