/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.Properties;
import org.jmol.util.Logger;
import org.jmol.viewer.Compiler;

public final class JmolConstants {
    public static final int JMOL_DATA_RAMACHANDRAN = 0;
    public static final int JMOL_DATA_QUATERNION = 1;
    public static final int JMOL_DATA_OTHER = 2;
    public static final String EXPORT_DRIVER_LIST = "Maya;Vrml;Povray";
    public static final int DRAW_MULTIPLE = -1;
    public static final int DRAW_NONE = 0;
    public static final int DRAW_POINT = 1;
    public static final int DRAW_LINE = 2;
    public static final int DRAW_TRIANGLE = 3;
    public static final int DRAW_PLANE = 4;
    public static final int DRAW_ARROW = 15;
    public static final int DRAW_CIRCLE = 16;
    public static final int DRAW_CURVE = 17;
    public static final String CLASSBASE_OPTIONS = "org.jmol.";
    public static final String CLASSBASE_QUANTUM = "org.jmol.quantum.";
    public static final String copyright = "(C) 2007 Jmol Development";
    public static final String version;
    public static final String cvsDate = "$Date: 2007-11-09 13:27:49 +0100 (ven., 09 nov. 2007) $";
    public static final String date;
    public static final boolean officialRelease = false;
    public static final String DEFAULT_HELP_PATH = "http://www.stolaf.edu/academics/chemapps/jmol/docs/index.htm";
    public static final int DEFAULT_PERCENT_VDW_ATOM = 20;
    public static final float DEFAULT_BOND_RADIUS = 0.15f;
    public static final short DEFAULT_BOND_MILLIANGSTROM_RADIUS = 150;
    public static final float DEFAULT_BOND_TOLERANCE = 0.45f;
    public static final float DEFAULT_MIN_BOND_DISTANCE = 0.4f;
    public static final int CONNECT_DELETE_BONDS = 0;
    public static final int CONNECT_MODIFY_ONLY = 1;
    public static final int CONNECT_CREATE_ONLY = 2;
    public static final int CONNECT_MODIFY_OR_CREATE = 3;
    public static final int CONNECT_AUTO_BOND = 4;
    public static final int CONNECT_IDENTIFY_ONLY = 5;
    public static final float DEFAULT_MAX_CONNECT_DISTANCE = 1.0E8f;
    public static final float DEFAULT_MIN_CONNECT_DISTANCE = 0.1f;
    private static final String[] connectOperationStrings;
    public static final int MOUSE_NONE = -1;
    public static final int MOUSE_ROTATE = 0;
    public static final int MOUSE_ZOOM = 1;
    public static final int MOUSE_XLATE = 2;
    public static final int MOUSE_PICK = 3;
    public static final int MOUSE_DELETE = 4;
    public static final int MOUSE_MEASURE = 5;
    public static final int MOUSE_ROTATE_Z = 6;
    public static final int MOUSE_SLAB_PLANE = 7;
    public static final int MOUSE_POPUP_MENU = 8;
    public static final byte MULTIBOND_NEVER = 0;
    public static final byte MULTIBOND_WIREFRAME = 1;
    public static final byte MULTIBOND_NOTSMALL = 2;
    public static final byte MULTIBOND_ALWAYS = 3;
    public static final short madMultipleBondSmallMaximum = 500;
    public static final int AXES_MODE_BOUNDBOX = 0;
    public static final int AXES_MODE_MOLECULAR = 1;
    public static final int AXES_MODE_UNITCELL = 2;
    public static final int PICKING_OFF = 0;
    public static final int PICKING_IDENT = 1;
    public static final int PICKING_LABEL = 2;
    public static final int PICKING_CENTER = 3;
    public static final int PICKING_DRAW = 4;
    public static final int PICKING_SPIN = 5;
    public static final int PICKING_SELECT_ATOM = 8;
    public static final int PICKING_SELECT_GROUP = 9;
    public static final int PICKING_SELECT_CHAIN = 10;
    public static final int PICKING_SELECT_MOLECULE = 11;
    public static final int PICKING_SELECT_SITE = 12;
    public static final int PICKING_SELECT_ELEMENT = 13;
    public static final int PICKING_MEASURE = 14;
    public static final int PICKING_MEASURE_DISTANCE = 15;
    public static final int PICKING_MEASURE_ANGLE = 16;
    public static final int PICKING_MEASURE_TORSION = 17;
    public static final int PICKING_NAVIGATE = 18;
    private static final String[] pickingModeNames;
    public static final int PICKINGSTYLE_SELECT_JMOL = 0;
    public static final int PICKINGSTYLE_SELECT_CHIME = 0;
    public static final int PICKINGSTYLE_SELECT_RASMOL = 1;
    public static final int PICKINGSTYLE_SELECT_PFAAT = 2;
    public static final int PICKINGSTYLE_MEASURE_ON = 3;
    public static final int PICKINGSTYLE_MEASURE_OFF = 4;
    private static final String[] pickingStyleNames;
    public static final short BOND_ORDER_ANY = -2;
    public static final short BOND_ORDER_NULL = -1;
    public static final short BOND_HBOND_SHIFT = 11;
    public static final short BOND_HYDROGEN_MASK = 30720;
    public static final short BOND_H_REGULAR = 2048;
    public static final short BOND_H_PLUS_2 = 4096;
    public static final short BOND_H_PLUS_3 = 6144;
    public static final short BOND_H_PLUS_4 = 8192;
    public static final short BOND_H_PLUS_5 = 10240;
    public static final short BOND_H_MINUS_3 = 12288;
    public static final short BOND_H_MINUS_4 = 14336;
    public static final short BOND_H_NUCLEOTIDE = 16384;
    public static final short BOND_STEREO_MASK = 1024;
    public static final short BOND_STEREO_NEAR = 1025;
    public static final short BOND_STEREO_FAR = 1026;
    public static final short BOND_AROMATIC_MASK = 512;
    public static final short BOND_AROMATIC_SINGLE = 513;
    public static final short BOND_AROMATIC_DOUBLE = 514;
    public static final short BOND_AROMATIC = 515;
    public static final short BOND_SULFUR_MASK = 256;
    public static final short BOND_PARTIAL_MASK = 224;
    public static final short BOND_PARTIAL01 = 33;
    public static final short BOND_PARTIAL12 = 66;
    public static final short BOND_PARTIAL23 = 97;
    public static final short BOND_PARTIAL32 = 100;
    public static final short BOND_COVALENT_MASK = 1023;
    public static final short BOND_COVALENT_SINGLE = 1;
    public static final short BOND_COVALENT_DOUBLE = 2;
    public static final short BOND_COVALENT_TRIPLE = 3;
    public static final short BOND_COVALENT_QUADRUPLE = 4;
    public static final short BOND_ORDER_UNSPECIFIED = 7;
    private static final String[] bondOrderNames;
    private static final String[] bondOrderNumbers;
    private static final short[] bondOrderValues;
    public static final float ANGSTROMS_PER_BOHR = 0.5291772f;
    public static final int FRONTLIT = 0;
    public static final int BACKLIT = 1;
    public static final int FULLYLIT = 2;
    public static final int[] argbsHbondType;
    private static final String[] elementSymbols;
    public static final int elementNumberMax;
    private static Hashtable htElementMap;
    private static final String[] elementNames;
    private static final String naturalIsotopes = "1H,12C,14N,";
    private static final short[] altElementNumbers;
    private static final String[] altElementSymbols;
    private static final String[] altElementNames;
    public static final int[] altArgbsCpk;
    public static final int firstIsotope = 4;
    public static final int altElementMax;
    public static final short[] vanderwaalsMars;
    private static final short[] covalentMars;
    public static final int FORMAL_CHARGE_MIN = -4;
    public static final int FORMAL_CHARGE_MAX = 7;
    private static final short[] cationLookupTable;
    private static final short[] anionLookupTable;
    static BitSet bsCations;
    static BitSet bsAnions;
    public static final int MAXIMUM_AUTO_BOND_COUNT = 20;
    public static final byte PALETTE_VOLATILE = 64;
    public static final byte PALETTE_STATIC = 63;
    public static final byte PALETTE_UNKNOWN = -1;
    public static final byte PALETTE_NONE = 0;
    public static final byte PALETTE_CPK = 1;
    public static final byte PALETTE_PARTIAL_CHARGE = 2;
    public static final byte PALETTE_FORMAL_CHARGE = 3;
    public static final byte PALETTE_TEMP = 68;
    public static final byte PALETTE_FIXEDTEMP = 5;
    public static final byte PALETTE_SURFACE = 70;
    public static final byte PALETTE_STRUCTURE = 7;
    public static final byte PALETTE_AMINO = 8;
    public static final byte PALETTE_SHAPELY = 9;
    public static final byte PALETTE_CHAIN = 10;
    public static final byte PALETTE_GROUP = 75;
    public static final byte PALETTE_MONOMER = 76;
    public static final byte PALETTE_MOLECULE = 77;
    public static final byte PALETTE_ALTLOC = 14;
    public static final byte PALETTE_INSERTION = 15;
    public static final byte PALETTE_JMOL = 16;
    public static final byte PALETTE_RASMOL = 17;
    public static final byte PALETTE_TYPE = 18;
    public static final byte PALETTE_PROPERTY = 83;
    public static final byte PALETTE_VARIABLE = 84;
    private static final String[] paletteNames;
    private static final byte[] paletteIDs;
    private static final int paletteCount;
    public static final int[] argbsCpk;
    public static final int[] argbsCpkRasmol;
    public static final byte PROTEIN_STRUCTURE_NONE = 0;
    public static final byte PROTEIN_STRUCTURE_TURN = 1;
    public static final byte PROTEIN_STRUCTURE_SHEET = 2;
    public static final byte PROTEIN_STRUCTURE_HELIX = 3;
    public static final byte PROTEIN_STRUCTURE_DNA = 4;
    public static final byte PROTEIN_STRUCTURE_RNA = 5;
    public static final String[] proteinStructureNames;
    public static final int[] argbsStructure;
    public static final int[] argbsAmino;
    public static final int argbShapelyBackbone = -4671304;
    public static final int argbShapelySpecial = -10616738;
    public static final int argbShapelyDefault = -65281;
    public static final int[] argbsChainAtom;
    public static final int[] argbsChainHetero;
    public static final short FORMAL_CHARGE_COLIX_RED;
    public static final short FORMAL_CHARGE_COLIX_WHITE;
    public static final short FORMAL_CHARGE_COLIX_BLUE;
    public static final int FORMAL_CHARGE_RANGE_SIZE = 12;
    public static final int[] argbsFormalCharge;
    public static final int FORMAL_CHARGE_INDEX_WHITE = 4;
    public static final int FORMAL_CHARGE_INDEX_MAX;
    public static final short PARTIAL_CHARGE_COLIX_RED;
    public static final short PARTIAL_CHARGE_COLIX_WHITE;
    public static final short PARTIAL_CHARGE_COLIX_BLUE;
    public static final int PARTIAL_CHARGE_RANGE_SIZE = 31;
    public static final int[] argbsRwbScale;
    public static final int[] argbsRoygbScale;
    public static final int[] argbsIsosurfacePositive;
    public static final int[] argbsIsosurfaceNegative;
    public static final String[] specialAtomNames;
    public static final int ATOMID_MAX;
    public static final byte ATOMID_AMINO_NITROGEN = 1;
    public static final byte ATOMID_ALPHA_CARBON = 2;
    public static final byte ATOMID_CARBONYL_CARBON = 3;
    public static final byte ATOMID_CARBONYL_OXYGEN = 4;
    public static final byte ATOMID_O1 = 5;
    public static final int ATOMID_ALPHA_ONLY_MASK = 4;
    public static final int ATOMID_PROTEIN_MASK = 14;
    public static final byte ATOMID_O5_PRIME = 6;
    public static final byte ATOMID_C3_PRIME = 9;
    public static final byte ATOMID_O3_PRIME = 10;
    public static final int ATOMID_NUCLEIC_MASK = 8128;
    public static final byte ATOMID_NUCLEIC_PHOSPHORUS = 13;
    public static final int ATOMID_PHOSPHORUS_ONLY_MASK = 8192;
    public static final int ATOMID_DISTINGUISHING_ATOM_MAX = 14;
    public static final byte ATOMID_N1 = 32;
    public static final byte ATOMID_C2 = 33;
    public static final byte ATOMID_N3 = 34;
    public static final byte ATOMID_C4 = 35;
    public static final byte ATOMID_C5 = 36;
    public static final byte ATOMID_C6 = 37;
    public static final byte ATOMID_O2 = 38;
    public static final byte ATOMID_N7 = 39;
    public static final byte ATOMID_C8 = 40;
    public static final byte ATOMID_N9 = 41;
    public static final byte ATOMID_N4 = 42;
    public static final byte ATOMID_N2 = 43;
    public static final byte ATOMID_N6 = 44;
    public static final byte ATOMID_C5M = 45;
    public static final byte ATOMID_O6 = 46;
    public static final byte ATOMID_O4 = 47;
    public static final byte ATOMID_S4 = 48;
    public static final byte ATOMID_C7 = 49;
    private static final int ATOMID_BACKBONE_MIN = 64;
    public static final byte ATOMID_TERMINATING_OXT = 64;
    public static final byte ATOMID_H5T_TERMINUS = 72;
    public static final byte ATOMID_O5T_TERMINUS = 73;
    public static final byte ATOMID_O1P = 74;
    public static final byte ATOMID_OP1 = 75;
    public static final byte ATOMID_O2P = 76;
    public static final byte ATOMID_OP2 = 77;
    public static final byte ATOMID_O2_PRIME = 79;
    public static final byte ATOMID_H3T_TERMINUS = 88;
    public static final byte ATOMID_HO3_PRIME = 89;
    public static final byte ATOMID_HO5_PRIME = 90;
    public static final int GROUPID_PROLINE = 15;
    public static final int GROUPID_AMINO_MAX = 24;
    private static final int GROUPID_WATER = 42;
    private static final int GROUPID_SULPHATE = 46;
    public static final String[] predefinedGroup3Names;
    public static final int[] argbsShapely;
    private static final String allCarbohydrates = ",[AFL],[AGC],[AHR],[ARA],[ARB],[BDF],[BDR],[BGC],[BMA],[FCA],[FCB],[FRU],[FUC],[FUL],[GAL],[GLA],[GLB],[GLC],[GUP],[LXC],[MAN],[RAA],[RAM],[RIB],[RIP],[XYP],[XYS],[CBI],[CT3],[CTR],[CTT],[LAT],[MAB],[MAL],[MLR],[MTT],[SUC],[TRE],[ASF],[GCU],[MTL],[NAG],[NAM],[RHA],[SOR],[XYL]";
    public static final String group3List;
    public static final int group3Count;
    public static final char[] predefinedGroup1Names;
    public static String[] predefinedVariable;
    public static String[] predefinedStatic;
    public static final String DEFAULT_FONTFACE = "SansSerif";
    public static final String DEFAULT_FONTSTYLE = "Plain";
    public static final int LABEL_MINIMUM_FONTSIZE = 6;
    public static final int LABEL_MAXIMUM_FONTSIZE = 63;
    public static final int LABEL_DEFAULT_FONTSIZE = 13;
    public static final int LABEL_DEFAULT_X_OFFSET = 4;
    public static final int LABEL_DEFAULT_Y_OFFSET = 4;
    public static final int MEASURE_DEFAULT_FONTSIZE = 15;
    public static final int AXES_DEFAULT_FONTSIZE = 14;
    public static final int SHAPE_BALLS = 0;
    public static final int SHAPE_STICKS = 1;
    public static final int SHAPE_HSTICKS = 2;
    public static final int SHAPE_SSSTICKS = 3;
    public static final int SHAPE_LABELS = 4;
    public static final int SHAPE_MEASURES = 5;
    public static final int SHAPE_DOTS = 6;
    public static final int SHAPE_DIPOLES = 7;
    public static final int SHAPE_MIN_SECONDARY = 8;
    public static final int SHAPE_BACKBONE = 8;
    public static final int SHAPE_TRACE = 9;
    public static final int SHAPE_CARTOON = 10;
    public static final int SHAPE_STRANDS = 11;
    public static final int SHAPE_MESHRIBBON = 12;
    public static final int SHAPE_RIBBONS = 13;
    public static final int SHAPE_ROCKETS = 14;
    public static final int SHAPE_MAX_SECONDARY = 15;
    public static final int SHAPE_STARS = 15;
    public static final int SHAPE_HALOS = 16;
    public static final int SHAPE_MIN_SPECIAL = 17;
    public static final int SHAPE_VECTORS = 17;
    public static final int SHAPE_GEOSURFACE = 18;
    public static final int SHAPE_MAX_SIZE_ZERO_ON_RESTRICT = 19;
    public static final int SHAPE_POLYHEDRA = 19;
    public static final int SHAPE_MIN_MESH_COLLECTION = 20;
    public static final int SHAPE_DRAW = 20;
    public static final int SHAPE_ISOSURFACE = 21;
    public static final int SHAPE_LCAOCARTOON = 22;
    public static final int SHAPE_MO = 23;
    public static final int SHAPE_PMESH = 24;
    public static final int SHAPE_MAX_MESH_COLLECTION = 25;
    public static final int SHAPE_MAX_SPECIAL = 25;
    public static final int SHAPE_AXES = 25;
    public static final int SHAPE_BBCAGE = 26;
    public static final int SHAPE_UCCAGE = 27;
    public static final int SHAPE_ECHO = 28;
    public static final int SHAPE_HOVER = 29;
    public static final int SHAPE_FRANK = 30;
    public static final int SHAPE_MAX = 31;
    public static final int ATOM_IN_MODEL = 1;
    public static final int ATOM_SLABBED = 2;
    public static final String PREVIOUS_MESH_ID = "+PREVIOUS_MESH+";
    public static int CARTOON_VISIBILITY_FLAG;
    public static int ALPHA_CARBON_VISIBILITY_FLAG;
    public static final String[] shapeClassBases;
    public static final int CLASS_BASE_BIO = -1;
    public static final int CLASS_BASE_SPECIAL = -2;
    public static final int[] shapeToks;
    public static final int STEREO_NONE = 0;
    public static final int STEREO_DOUBLE = 1;
    public static final int STEREO_REDCYAN = 2;
    public static final int STEREO_REDBLUE = 3;
    public static final int STEREO_REDGREEN = 4;
    public static final int STEREO_CUSTOM = 5;
    static /* synthetic */ Class class$org$jmol$viewer$JmolConstants;

    public static int connectOperationFromString(String string) {
        int n = connectOperationStrings.length;
        while (--n >= 0 && !connectOperationStrings[n].equalsIgnoreCase(string)) {
        }
        return n;
    }

    public static String connectOperationName(int n) {
        return connectOperationStrings[n];
    }

    public static final String getPickingModeName(int n) {
        return n < 0 || n >= pickingModeNames.length ? "off" : pickingModeNames[n];
    }

    public static final int getPickingMode(String string) {
        int n = pickingModeNames.length;
        while (--n >= 0) {
            if (!string.equalsIgnoreCase(pickingModeNames[n])) continue;
            return n;
        }
        return -1;
    }

    public static final String getPickingStyleName(int n) {
        return n < 0 || n >= pickingStyleNames.length ? "toggle" : pickingModeNames[n];
    }

    public static final int getPickingStyle(String string) {
        int n = pickingStyleNames.length;
        while (--n >= 0) {
            if (!string.equalsIgnoreCase(pickingStyleNames[n])) continue;
            return n;
        }
        return -1;
    }

    static final short getBondOrderFromString(String string) {
        for (int i = 0; i < bondOrderNumbers.length; ++i) {
            if (!bondOrderNames[i].equalsIgnoreCase(string)) continue;
            return bondOrderValues[i];
        }
        if (string.toLowerCase().indexOf("partial ") == 0) {
            return JmolConstants.getPartialBondOrderFromInteger(Compiler.modelValue(string.substring(8).trim()));
        }
        return -1;
    }

    static final short getPartialBondOrderFromInteger(int n) {
        return (short)((n / 1000000 % 6 << 5) + (n % 1000000 & 0x1F));
    }

    public static final short getPartialBondOrder(int n) {
        return (short)(n >> 5);
    }

    public static final int getPartialBondDotted(int n) {
        return n & 0x1F;
    }

    static final short getBondOrderFromFloat(float f) {
        for (int i = 0; i < bondOrderNumbers.length; ++i) {
            if (Float.valueOf(bondOrderNumbers[i]).floatValue() != Math.abs(f)) continue;
            if (f > 0.0f) {
                return bondOrderValues[i];
            }
            f = -f;
        }
        return -1;
    }

    public static final String getBondOrderNameFromOrder(short s) {
        switch (s) {
            case -2: 
            case -1: {
                return "";
            }
            case 1: {
                return "single";
            }
            case 2: {
                return "double";
            }
        }
        if ((s & 0xE0) != 0) {
            return "partial " + JmolConstants.getBondOrderNumberFromOrder(s);
        }
        if ((s & 0x7800) != 0) {
            return "hbond";
        }
        if ((s & 0x100) != 0) {
            return "single";
        }
        int n = bondOrderValues.length;
        while (--n >= 0) {
            if (bondOrderValues[n] != s) continue;
            return bondOrderNames[n];
        }
        return "?";
    }

    public static final String getBondOrderNumberFromOrder(short s) {
        if (s == -1 || s == -2) {
            return "0";
        }
        if ((s & 0x7800) != 0) {
            return "1";
        }
        if ((s & 0x100) != 0) {
            return "1";
        }
        if ((s & 0xE0) != 0) {
            return (s >> 5) + "." + (s & 0x1F);
        }
        int n = bondOrderValues.length;
        while (--n >= 0) {
            if (bondOrderValues[n] != s) continue;
            return bondOrderNumbers[n];
        }
        return "?";
    }

    public static final short elementNumberFromSymbol(String string) {
        Serializable serializable;
        if (htElementMap == null) {
            Integer n;
            String string2;
            serializable = new Hashtable();
            int n2 = elementNumberMax;
            while (--n2 >= 0) {
                string2 = elementSymbols[n2];
                n = new Integer(n2);
                ((Hashtable)serializable).put(string2, n);
                if (string2.length() != 2) continue;
                ((Hashtable)serializable).put(string2.toUpperCase(), n);
            }
            n2 = altElementMax;
            while (--n2 >= 4) {
                string2 = altElementSymbols[n2];
                n = new Integer(altElementNumbers[n2]);
                ((Hashtable)serializable).put(string2, n);
                if (string2.length() != 2) continue;
                ((Hashtable)serializable).put(string2.toUpperCase(), n);
            }
            htElementMap = serializable;
        }
        if (string == null) {
            return 0;
        }
        serializable = (Integer)htElementMap.get(string);
        if (serializable != null) {
            return (short)((Integer)serializable).intValue();
        }
        Logger.error("" + string + "' is not a recognized symbol");
        return 0;
    }

    public static final String elementSymbolFromNumber(int n) {
        if (n >= elementNumberMax) {
            int n2 = altElementMax;
            while (--n2 >= 0) {
                if (n != altElementNumbers[n2]) continue;
                return altElementSymbols[n2];
            }
            n %= 128;
        }
        if (n < 0 || n >= elementNumberMax) {
            n = 0;
        }
        return elementSymbols[n];
    }

    public static final String elementNameFromNumber(int n) {
        if (n >= elementNumberMax) {
            int n2 = altElementMax;
            while (--n2 >= 0) {
                if (n != altElementNumbers[n2]) continue;
                return altElementNames[n2];
            }
            n %= 128;
        }
        if (n < 0 || n >= elementNumberMax) {
            n = 0;
        }
        return elementNames[n];
    }

    public static final String altElementNameFromIndex(int n) {
        return altElementNames[n];
    }

    public static final short altElementNumberFromIndex(int n) {
        return altElementNumbers[n];
    }

    public static final String altElementSymbolFromIndex(int n) {
        return altElementSymbols[n];
    }

    public static final String altIsotopeSymbolFromIndex(int n) {
        short s = altElementNumbers[n];
        return (s >> 7) + JmolConstants.elementSymbolFromNumber(s & 0x7F);
    }

    public static final int altElementIndexFromNumber(int n) {
        for (int i = 0; i < altElementMax; ++i) {
            if (altElementNumbers[i] != n) continue;
            return i;
        }
        return 0;
    }

    public static final boolean isNaturalIsotope(String string) {
        return naturalIsotopes.indexOf(string + ",") >= 0;
    }

    public static short getBondingMar(int n, int n2) {
        if (n2 > 0 && bsCations.get(n)) {
            return JmolConstants.getBondingMar(n, n2, cationLookupTable);
        }
        if (n2 < 0 && bsAnions.get(n)) {
            return JmolConstants.getBondingMar(n, n2, anionLookupTable);
        }
        return covalentMars[n];
    }

    public static short getBondingMar(int n, int n2, short[] sArray) {
        short s = (short)((n << 4) + (n2 + 4));
        short s2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = sArray.length / 2;
        while (n4 != n5) {
            n3 = (n4 + n5) / 2;
            s2 = sArray[n3 << 1];
            if (s2 > s) {
                n5 = n3;
                continue;
            }
            if (s2 < s) {
                n4 = n3 + 1;
                continue;
            }
            return sArray[(n3 << 1) + 1];
        }
        if (s2 > s) {
            --n3;
        }
        if (n != (s2 = sArray[n3 << 1]) >> 4) {
            ++n3;
        }
        return sArray[(n3 << 1) + 1];
    }

    public static byte pidOf(Object object) {
        return object instanceof Byte ? (Byte)object : (byte)-1;
    }

    public static boolean isPaletteVariable(byte by) {
        return (by & 0x40) != 0;
    }

    public static final byte getPaletteID(String string) {
        for (int i = 0; i < paletteCount; ++i) {
            if (!paletteNames[i].equals(string)) continue;
            return paletteIDs[i];
        }
        return string.indexOf("property_") == 0 ? (byte)83 : -1;
    }

    public static final String getPaletteName(byte by) {
        if (by == -1) {
            return null;
        }
        for (int i = 0; i < paletteCount; ++i) {
            if (paletteIDs[i] != by) continue;
            return paletteNames[i];
        }
        return null;
    }

    public static final String getProteinStructureName(int n) {
        return n >= 0 && n <= 5 ? proteinStructureNames[n] : "";
    }

    public static final boolean checkCarbohydrate(String string) {
        return string != null && allCarbohydrates.indexOf("[" + string.toUpperCase() + "]") >= 0;
    }

    private static final String getGroup3List() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 1; i < 42; ++i) {
            stringBuffer.append(",[").append((predefinedGroup3Names[i] + "   ").substring(0, 3) + "]");
        }
        stringBuffer.append(allCarbohydrates);
        return stringBuffer.toString();
    }

    public static final boolean isHetero(String string) {
        int n = group3List.indexOf("[" + (string + "   ").substring(0, 3) + "]");
        return n < 0 || n / 6 >= 42;
    }

    public static final boolean isShapeSecondary(int n) {
        return n < 15 && n >= 8;
    }

    public static final int getShapeVisibilityFlag(int n) {
        return 4 << n;
    }

    public static final String getShapeClassName(int n) {
        return (n < 0 ? shapeClassBases[~n] : (n == -1 || n >= 8 && n < 15 ? "org.jmol.shapebio." : (n == -2 || n >= 17 && n < 25 ? "org.jmol.shapespecial." : "org.jmol.shape."))) + (n >= 0 ? shapeClassBases[n] : "");
    }

    static final int shapeTokenIndex(int n) {
        int n2 = shapeToks.length;
        while (--n2 >= 0) {
            if (n != shapeToks[n2]) continue;
            return n2;
        }
        return -1;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        int n;
        String string = null;
        Properties properties = new Properties();
        if (string == null) {
            BufferedInputStream bufferedInputStream = null;
            InputStream inputStream = null;
            try {
                inputStream = (class$org$jmol$viewer$JmolConstants == null ? (class$org$jmol$viewer$JmolConstants = JmolConstants.class$("org.jmol.viewer.JmolConstants")) : class$org$jmol$viewer$JmolConstants).getClassLoader().getResourceAsStream("org/jmol/viewer/Jmol.properties");
                bufferedInputStream = new BufferedInputStream(inputStream);
                properties.load(bufferedInputStream);
                string = properties.getProperty("version", string);
            }
            catch (IOException iOException) {
            }
            finally {
                if (bufferedInputStream != null) {
                    try {
                        bufferedInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        version = string != null ? string : "(Unknown version)";
        date = cvsDate.substring(7, 23);
        connectOperationStrings = new String[]{"delete", "modify", "create", "modifyOrCreate", "auto", "adjust"};
        pickingModeNames = new String[]{"off", "ident", "label", "center", "draw", "spin", "coord NOT IMPLEMENTED", "bond NOT IMPLEMENTED", "atom", "group", "chain", "molecule", "site", "element", "measure", "distance", "angle", "torsion", "navigate"};
        pickingStyleNames = new String[]{"toggle", "selectOrToggle", "extendedSelect", "measure", "measureoff"};
        bondOrderNames = new String[]{"single", "double", "triple", "quadruple", "aromatic", "hbond", "partial", "partialDouble", "partialTriple", "partialTriple2", "aromaticSingle", "aromaticDouble", "unspecified"};
        bondOrderNumbers = new String[]{"1", "2", "3", "4", "1.5", "1", "0.5", "1.5", "2.5", "2.5", "1", "2", "1"};
        bondOrderValues = new short[]{1, 2, 3, 4, 515, 2048, 33, 66, 97, 100, 513, 514, 7};
        argbsHbondType = new int[]{-38476, -256, -1, -65281, -65536, -23296, -16711681, -16711936, -32640};
        elementSymbols = new String[]{"Xx", "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt"};
        elementNumberMax = elementSymbols.length;
        elementNames = new String[]{"unknown", "hydrogen", "helium", "lithium", "beryllium", "boron", "carbon", "nitrogen", "oxygen", "fluorine", "neon", "sodium", "magnesium", "aluminum", "silicon", "phosphorus", "sulfur", "chlorine", "argon", "potassium", "calcium", "scandium", "titanium", "vanadium", "chromium", "manganese", "iron", "cobalt", "nickel", "copper", "zinc", "gallium", "germanium", "arsenic", "selenium", "bromine", "krypton", "rubidium", "strontium", "yttrium", "zirconium", "niobium", "molybdenum", "technetium", "ruthenium", "rhodium", "palladium", "silver", "cadmium", "indium", "tin", "antimony", "tellurium", "iodine", "xenon", "cesium", "barium", "lanthanum", "cerium", "praseodymium", "neodymium", "promethium", "samarium", "europium", "gadolinium", "terbium", "dysprosium", "holmium", "erbium", "thulium", "ytterbium", "lutetium", "hafnium", "tantalum", "tungsten", "rhenium", "osmium", "iridium", "platinum", "gold", "mercury", "thallium", "lead", "bismuth", "polonium", "astatine", "radon", "francium", "radium", "actinium", "thorium", "protactinium", "uranium", "neptunium", "plutonium", "americium", "curium", "berkelium", "californium", "einsteinium", "fermium", "mendelevium", "nobelium", "lawrencium", "rutherfordium", "dubnium", "seaborgium", "bohrium", "hassium", "meitnerium"};
        altElementNumbers = new short[]{0, 13, 16, 55, 257, 385, 1670, 1798, 1927};
        altElementSymbols = new String[]{"Xx", "Al", "S", "Cs", "D", "T", "13C", "14C", "15N"};
        altElementNames = new String[]{"dummy", "aluminium", "sulphur", "caesium", "deuterium", "tritium", "", "", ""};
        altArgbsCpk = new int[]{-60269, -4217178, -208, -11069553, -64, -96, -11513776, -12566464, -15708080};
        altElementMax = altElementNumbers.length;
        vanderwaalsMars = new short[]{1000, 1200, 1400, 1820, 1700, 2080, 1950, 1850, 1700, 1730, 1540, 2270, 1730, 2050, 2100, 2080, 2000, 1970, 1880, 2750, 1973, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1630, 1400, 1390, 1870, 1700, 1850, 1900, 2100, 2020, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1630, 1720, 1580, 1930, 2170, 2200, 2060, 2150, 2160, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1720, 1660, 1550, 1960, 2020, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1860, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700};
        covalentMars = new short[]{0, 230, 930, 680, 350, 830, 680, 680, 680, 640, 1120, 970, 1100, 1350, 1200, 750, 1020, 990, 1570, 1330, 990, 1440, 1470, 1330, 1350, 1350, 1340, 1330, 1500, 1520, 1450, 1220, 1170, 1210, 1220, 1210, 1910, 1470, 1120, 1780, 1560, 1480, 1470, 1350, 1400, 1450, 1500, 1590, 1690, 1630, 1460, 1460, 1470, 1400, 1980, 1670, 1340, 1870, 1830, 1820, 1810, 1800, 1800, 1990, 1790, 1760, 1750, 1740, 1730, 1720, 1940, 1720, 1570, 1430, 1370, 1350, 1370, 1320, 1500, 1500, 1700, 1550, 1540, 1540, 1680, 1700, 2400, 2000, 1900, 1880, 1790, 1610, 1580, 1550, 1530, 1510, 1500, 1500, 1500, 1500, 1500, 1500, 1500, 1500, 1600, 1600, 1600, 1600, 1600, 1600};
        cationLookupTable = new short[]{53, 680, 69, 440, 70, 350, 85, 350, 87, 230, 104, 160, 117, 250, 119, 160, 121, 130, 133, 220, 138, 90, 155, 80, 165, 1120, 181, 970, 197, 820, 198, 660, 215, 510, 229, 650, 232, 420, 247, 440, 249, 350, 262, 2190, 264, 370, 266, 300, 281, 340, 283, 270, 293, 1540, 309, 1330, 325, 1180, 326, 990, 343, 732, 357, 960, 358, 940, 359, 760, 360, 680, 374, 880, 375, 740, 376, 630, 377, 590, 389, 810, 390, 890, 391, 630, 394, 520, 406, 800, 407, 660, 408, 600, 411, 460, 422, 740, 423, 640, 438, 720, 439, 630, 454, 690, 469, 960, 470, 720, 485, 880, 486, 740, 501, 810, 503, 620, 518, 730, 520, 530, 535, 580, 537, 460, 549, 660, 552, 500, 554, 420, 569, 470, 571, 390, 597, 1470, 614, 1120, 631, 893, 645, 1090, 648, 790, 661, 1000, 664, 740, 665, 690, 677, 930, 680, 700, 682, 620, 699, 979, 712, 670, 727, 680, 742, 800, 744, 650, 757, 1260, 758, 890, 773, 1140, 774, 970, 791, 810, 806, 930, 808, 710, 823, 760, 825, 620, 837, 820, 840, 700, 842, 560, 857, 620, 859, 500, 885, 1670, 901, 1530, 902, 1340, 917, 1390, 919, 1016, 933, 1270, 935, 1034, 936, 920, 951, 1013, 952, 900, 967, 995, 983, 979, 999, 964, 1014, 1090, 1015, 950, 1031, 938, 1047, 923, 1048, 840, 1063, 908, 1079, 894, 1095, 881, 1111, 870, 1126, 930, 1127, 858, 1143, 850, 1160, 780, 1177, 680, 1192, 700, 1194, 620, 1208, 720, 1211, 560, 1224, 880, 1226, 690, 1240, 680, 1254, 800, 1256, 650, 1269, 1370, 1271, 850, 1285, 1270, 1286, 1100, 1301, 1470, 1303, 950, 1318, 1200, 1320, 840, 1333, 980, 1335, 960, 1337, 740, 1354, 670, 1371, 620, 1397, 1800, 1414, 1430, 1431, 1180, 1448, 1020, 1463, 1130, 1464, 980, 1465, 890, 1480, 970, 1482, 800, 1495, 1100, 1496, 950, 1499, 710, 1511, 1080, 1512, 930, 1527, 1070, 1528, 920};
        anionLookupTable = new short[]{19, 1540, 96, 2600, 113, 1710, 130, 1320, 131, 1760, 147, 1330, 224, 2710, 227, 3840, 241, 2120, 258, 1840, 275, 1810, 512, 2720, 529, 2220, 546, 1910, 547, 2320, 563, 1960, 800, 2940, 803, 3700, 817, 2450, 834, 2110, 835, 2500, 851, 2200};
        bsCations = new BitSet();
        bsAnions = new BitSet();
        for (n = 0; n < anionLookupTable.length; n += 2) {
            bsAnions.set(anionLookupTable[n] >> 4);
        }
        for (n = 0; n < cationLookupTable.length; n += 2) {
            bsCations.set(cationLookupTable[n] >> 4);
        }
        paletteNames = new String[]{"none", "cpk", "partialcharge", "formalcharge", "temperature", "fixedtemperature", "surfacedistance", "structure", "amino", "shapely", "chain", "group", "monomer", "molecule", "altloc", "insertion", "jmol", "rasmol", "type", "property", "variable"};
        paletteIDs = new byte[]{0, 1, 2, 3, 68, 5, 70, 7, 8, 9, 10, 75, 76, 77, 14, 15, 16, 17, 18, 83, 84};
        paletteCount = paletteNames.length;
        argbsCpk = new int[]{-60269, -1, -2490369, -3374849, -3997952, -19019, -7303024, -13610760, -62195, -7282608, -4987915, -5546766, -7667968, -4217178, -997216, Short.MIN_VALUE, -208, -14684129, -8334877, -7388972, -12714240, -1644826, -4209977, -5855573, -7693881, -6522169, -2070989, -1011552, -11481008, -3637197, -8552272, -4026481, -10055793, -4357917, -24320, -5887703, -10700591, -9425232, -16711936, -7012353, -7020320, -9190711, -11225675, -12869986, -14381169, -16089716, -16750203, -4144960, -9841, -5868173, -10059648, -6397003, -2852352, -7077740, -12411216, -11069553, -16725760, -9382657, -57, -2490425, -3670073, -6029369, -7340089, -10354745, -12189753, -13566009, -14680121, -16711780, -16718219, -16722862, -16728264, -16733404, -11681025, -11688193, -14576426, -14254677, -14260586, -15248249, -3092256, -11997, -4671280, -5876659, -11052703, -6402123, -5547008, -9089211, -12418410, -12451738, -16745216, -9393158, -16729345, -16735745, -16740353, -16744193, -16749569, -11248398, -8889117, -7712797, -6211884, -5038124, -5038150, -5042778, -4387449, -3735450, -3407783, -3080113, -2555835, -2097096, -1703890, -1376218};
        argbsCpkRasmol = new int[]{16716947, 0x1FFFFFF, 50315467, 0x3B22222, 0x500FF00, 0x6C8C8C8, 0x78F8FFF, 0x8F00000, 165324064, 0xB0000FF, 203590434, 226525328, 249210144, 268412160, 285198386, 0x1100FF00, 343965840, 377520272, 411074704, 427851920, 452961536, 480586282, 497363498, 514140714, 598026794, 796950672, 899686640, 956278016, 1339729184};
        if (elementSymbols.length != elementNames.length || elementSymbols.length != vanderwaalsMars.length || elementSymbols.length != covalentMars.length || elementSymbols.length != argbsCpk.length) {
            Logger.error("ERROR!!! Element table length mismatch:\n elementSymbols.length=" + elementSymbols.length + "\n elementNames.length=" + elementNames.length + "\n vanderwaalsMars.length=" + vanderwaalsMars.length + "\n covalentMars.length=" + covalentMars.length + "\n argbsCpk.length=" + argbsCpk.length);
        }
        proteinStructureNames = new String[]{"none", "turn", "sheet", "helix", "dna", "rna"};
        argbsStructure = new int[]{-1, -10452737, -14336, -65408, -5373698, -196254};
        argbsAmino = new int[]{-4284306, -3618616, -15443201, -16720676, -1701366, -1645056, -16720676, -1701366, -1315861, -8224046, -15760881, -15760881, -15443201, -1645056, -13487446, -2320766, -354816, -354816, -4957516, -13487446, -15760881, -38476, -38476, -4284306};
        argbsChainAtom = new int[]{-1, -4140801, -5177424, -16184, -128, -16129, -5181200, -12176, -1015680, -663885, -16728065, -3318692, -10039894, -6632142, -1146130, -16724271, -16711809, -12799119, -16777077, -4343957, -16751616, -8388608, -8355840, -8388480, -16744320, -4684277, -5103070};
        argbsChainHetero = new int[]{-1, -7298865, -8335464, -3174224, -3158160, -3174193, -8339264, -3170208, -4173712, -3821949, -16734257, -4895668, -11094638, -7686870, -4296002, -16730463, -16724113, -13329567, -16777029, -5922981, -16739328, -5242880, -5197824, -5242704, -16731984, -1526253, -4050382};
        FORMAL_CHARGE_COLIX_RED = (short)elementSymbols.length;
        FORMAL_CHARGE_COLIX_WHITE = (short)(FORMAL_CHARGE_COLIX_RED + 4);
        FORMAL_CHARGE_COLIX_BLUE = (short)(FORMAL_CHARGE_COLIX_WHITE + 7);
        argbsFormalCharge = new int[]{-65536, -49088, -32640, -16192, -1, -2565889, -4934401, -7302913, -9671425, -12039937, -14408449, -16776961};
        FORMAL_CHARGE_INDEX_MAX = argbsFormalCharge.length;
        PARTIAL_CHARGE_COLIX_RED = (short)(FORMAL_CHARGE_COLIX_BLUE + 1);
        PARTIAL_CHARGE_COLIX_WHITE = (short)(PARTIAL_CHARGE_COLIX_RED + 15);
        PARTIAL_CHARGE_COLIX_BLUE = (short)(PARTIAL_CHARGE_COLIX_WHITE + 15);
        argbsRwbScale = new int[]{-65536, -61424, -57312, -53200, -49088, -44976, -40864, -36752, -32640, -28528, -24416, -20304, -16192, -12080, -7968, -1, -2039553, -3092225, -4144897, -5197569, -6250241, -7302913, -8355585, -9408257, -10460929, -11513601, -12566273, -13618945, -14671617, -15724289, -16776961};
        argbsRoygbScale = new int[]{-65536, -57344, -49152, -40960, Short.MIN_VALUE, -24576, -16384, -8192, -4096, -256, -987136, -2031872, -4129024, -6226176, -8323328, -10420480, -12517632, -14614784, -16711936, -16711904, -16711872, -16711840, -16711808, -16711776, -16711744, -16711712, -16711681, -16719617, -16727809, -16736001, -16744193, -16752385, -16760577, -16768769, -16776961};
        argbsIsosurfacePositive = new int[]{-11525984};
        argbsIsosurfaceNegative = new int[]{-6283184};
        specialAtomNames = new String[]{null, "N", "CA", "C", "O", "O1", "O5'", "C5'", "C4'", "C3'", "O3'", "C2'", "C1'", "P", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, "N1", "C2", "N3", "C4", "C5", "C6", "O2", "N7", "C8", "N9", "N4", "N2", "N6", "C5M", "O6", "O4", "S4", "C7", null, null, null, null, null, null, null, null, null, null, null, null, null, null, "OXT", "H", "1H", "2H", "3H", "HA", "1HA", "2HA", "H5T", "O5T", "O1P", "OP1", "O2P", "OP2", "O4'", "O2'", "1H5'", "2H5'", "H4'", "H3'", "1H2'", "2H2'", "2HO'", "H1'", "H3T", "HO3'", "HO5'", "HA2", "HA3", "HA2", "H1", "H2", "H3", "H5'", "H5''", "H2'", "H2''", "HO2'"};
        ATOMID_MAX = specialAtomNames.length;
        predefinedGroup3Names = new String[]{"", "ALA", "ARG", "ASN", "ASP", "CYS", "GLN", "GLU", "GLY", "HIS", "ILE", "LEU", "LYS", "MET", "PHE", "PRO", "SER", "THR", "TRP", "TYR", "VAL", "ASX", "GLX", "UNK", "G", "C", "A", "T", "U", "I", "DG", "DC", "DA", "DT", "DU", "DI", "+G", "+C", "+A", "+T", "+U", "+I", "HOH", "DOD", "WAT", "PO4", "SO4"};
        argbsShapely = new int[]{-65281, -7536756, -16777092, -33680, -6291390, -144, -46004, -10092544, -1, -9408257, -16757760, -12231099, -12105800, -4677566, -11318190, -11382190, -36798, -4699136, -11581952, -7573428, -29441, -65281, -65281, -65281, -36752, -29621, -6250241, -6226016, -32640, -8323073, -36752, -29621, -6250241, -6226016, -32640, -8323073, -36752, -29621, -6250241, -6226016, -32640, -8323073};
        group3List = JmolConstants.getGroup3List();
        group3Count = group3List.length() / 6;
        predefinedGroup1Names = new char[]{'\u0000', 'A', 'R', 'N', 'D', 'C', 'Q', 'E', 'G', 'H', 'I', 'L', 'K', 'M', 'F', 'P', 'S', 'T', 'W', 'Y', 'V', 'A', 'G', '?', 'G', 'C', 'A', 'T', 'U', 'I', 'G', 'C', 'A', 'T', 'U', 'I', 'G', 'C', 'A', 'T', 'U', 'I'};
        predefinedVariable = new String[]{"@water _g>=42 & _g<45, oxygen & connected(2, hydrogen or deuterium or tritium), (hydrogen or deuterium or tritium) & connected(oxygen & connected(2, hydrogen or deuterium or tritium))", "@turn structure=1", "@sheet structure=2", "@helix structure=3", "@bonded bondcount>0"};
        predefinedStatic = new String[]{"@_1H _H & !(_2H,_3H)", "@_12C _C & !(_13C,_14C)", "@_14N _N & !(_15N)", "@amino _g>0 & _g<=23", "@acidic asp,glu", "@basic arg,his,lys", "@charged acidic,basic", "@negative acidic", "@positive basic", "@neutral amino&!(acidic,basic)", "@polar amino&!hydrophobic", "@cyclic his,phe,pro,trp,tyr", "@acyclic amino&!cyclic", "@aliphatic ala,gly,ile,leu,val", "@aromatic his,phe,trp,tyr", "@buried ala,cys,ile,leu,met,phe,trp,val", "@surface amino&!buried", "@hydrophobic ala,gly,ile,leu,met,phe,pro,trp,tyr,val", "@ligand hetero & !solvent", "@mainchain backbone", "@small ala,gly,ser", "@medium asn,asp,cys,pro,thr,val", "@large arg,glu,gln,his,ile,leu,lys,met,phe,trp,tyr", "@c nucleic & within(group,_a=42)", "@g nucleic & within(group,_a=43)", "@cg c,g", "@a nucleic & within(group,_a=44)", "@t nucleic & within(group,_a=45 | _a=49)", "@at a,t", "@i nucleic & within(group,_a=46) & !g", "@u nucleic & within(group,_a=47) & !t", "@tu nucleic & within(group,_a=48)", "@solvent _g>=42 & _g<=46", "@hoh water", "@ions _g>=45,_g<=46", "@alpha _a=2", "@backbone (protein,nucleic) & _a>0 & (_a<32 || _a>=64)", "@sidechain (protein,nucleic) & !backbone", "@base nucleic & !backbone"};
        CARTOON_VISIBILITY_FLAG = JmolConstants.getShapeVisibilityFlag(10);
        ALPHA_CARBON_VISIBILITY_FLAG = CARTOON_VISIBILITY_FLAG | JmolConstants.getShapeVisibilityFlag(9) | JmolConstants.getShapeVisibilityFlag(11) | JmolConstants.getShapeVisibilityFlag(12) | JmolConstants.getShapeVisibilityFlag(13);
        shapeClassBases = new String[]{"Balls", "Sticks", "Hsticks", "Sssticks", "Labels", "Measures", "Dots", "Dipoles", "Backbone", "Trace", "Cartoon", "Strands", "MeshRibbon", "Ribbons", "Rockets", "Stars", "Halos", "Vectors", "GeoSurface", "Polyhedra", "Draw", "Isosurface", "LcaoCartoon", "MolecularOrbital", "Pmesh", "Axes", "Bbcage", "Uccage", "Echo", "Hover", "Frank"};
        if (shapeClassBases.length != 31) {
            Logger.error("the shapeClassBases array has the wrong length");
            throw new NullPointerException();
        }
        shapeToks = new int[]{6815745, 6881282, 590093, 65828, 23660815, 591122, 1290, 5473, 0x180100, 297, 259, 65831, 340, 282, 342, 307, 341, 4435, 1367, 132444, 136543, 136542, 136548, 135523, 347, 65901, 6886669, 1638767, 67851, 2385, 65904};
        if (shapeToks.length != 31) {
            Logger.error("the shapeToks array has the wrong length");
            throw new NullPointerException();
        }
        if (argbsFormalCharge.length != 12) {
            Logger.error("formal charge color table length");
            throw new NullPointerException();
        }
        if (shapeClassBases.length != 31) {
            Logger.error("shapeClassBases wrong length");
            throw new NullPointerException();
        }
        if (argbsAmino.length != 24) {
            Logger.error("argbsAmino wrong length");
            throw new NullPointerException();
        }
        if (argbsShapely.length != 42) {
            Logger.error("argbsShapely wrong length");
            throw new NullPointerException();
        }
        if (argbsChainHetero.length != argbsChainAtom.length) {
            Logger.error("argbsChainHetero wrong length");
            throw new NullPointerException();
        }
    }
}

