/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.more;

import java.io.BufferedReader;
import java.util.Hashtable;
import java.util.Vector;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.util.Logger;
import org.jmol.util.Parser;

public class JaguarReader
extends AtomSetCollectionReader {
    int atomCount = 0;
    int moCount = 0;
    int gaussianCount = 0;
    float lumoEnergy = Float.MAX_VALUE;
    Hashtable moData = new Hashtable();
    Vector orbitals = new Vector();

    public AtomSetCollection readAtomSetCollection(BufferedReader bufferedReader) {
        this.reader = bufferedReader;
        this.atomSetCollection = new AtomSetCollection("jaguar");
        try {
            while (this.readLine() != null) {
                if (this.line.startsWith(" Input geometry:")) {
                    this.readAtoms();
                    continue;
                }
                if (this.line.startsWith(" Symmetrized geometry:")) {
                    this.readAtoms();
                    continue;
                }
                if (this.line.startsWith("  final geometry:")) {
                    this.readAtoms();
                    continue;
                }
                if (this.line.startsWith("  Atomic charges from electrostatic potential:")) {
                    this.readCharges();
                    continue;
                }
                if (this.line.startsWith("  number of basis functions....")) {
                    this.moCount = this.parseInt(this.line.substring(32).trim());
                    continue;
                }
                if (this.line.startsWith("  basis set:")) {
                    this.moData.put("energyUnits", "");
                    this.moData.put("calculationType", this.line.substring(13).trim());
                    continue;
                }
                if (this.line.indexOf("Shell information") >= 0) {
                    this.readBasis();
                    continue;
                }
                if (this.line.indexOf("Normalized coefficients") >= 0) {
                    this.readBasisNormalized();
                    continue;
                }
                if (this.line.startsWith(" LUMO energy:")) {
                    this.lumoEnergy = this.parseFloat(this.line.substring(13));
                    continue;
                }
                if (this.line.indexOf("final wvfn") >= 0) {
                    this.readMolecularOrbitals();
                    if (!Logger.isActiveLevel((int)0)) continue;
                    Logger.debug((String)(this.orbitals.size() + " molecular orbitals read"));
                    continue;
                }
                if (!this.line.startsWith("  harmonic frequencies in")) continue;
                this.readFrequencies();
                break;
            }
            if (this.moCount > 0 && this.gaussianCount > 0) {
                this.atomSetCollection.setAtomSetAuxiliaryInfo("moData", (Object)this.moData);
            }
        }
        catch (Exception exception) {
            return this.setError(exception);
        }
        return this.atomSetCollection;
    }

    private void readAtoms() throws Exception {
        this.atomSetCollection.discardPreviousAtoms();
        this.discardLines(2);
        this.atomCount = 0;
        while (this.readLine() != null && this.line.length() >= 60 && this.line.charAt(2) != ' ') {
            String[] stringArray = this.getTokens();
            String string = stringArray[0];
            float f = this.parseFloat(stringArray[1]);
            float f2 = this.parseFloat(stringArray[2]);
            float f3 = this.parseFloat(stringArray[3]);
            if (Float.isNaN(f) || Float.isNaN(f2) || Float.isNaN(f3) || string.length() < 2) {
                return;
            }
            char c = string.charAt(1);
            String string2 = c >= 'a' && c <= 'z' ? string.substring(0, 2) : string.substring(0, 1);
            Atom atom = this.atomSetCollection.addNewAtom();
            atom.elementSymbol = string2;
            atom.atomName = string;
            atom.x = f;
            atom.y = f2;
            atom.z = f3;
            ++this.atomCount;
        }
    }

    private void readCharges() throws Exception {
        int n = 0;
        while (this.readLine() != null && this.line.indexOf("sum") < 0) {
            if (this.line.indexOf("Charge") < 0) continue;
            String[] stringArray = this.getTokens();
            for (int i = 1; i < stringArray.length; ++i) {
                this.atomSetCollection.getAtom((int)n++).partialCharge = this.parseFloat(stringArray[i]);
            }
        }
    }

    void readBasis() throws Exception {
        int n;
        int n2;
        String[] stringArray;
        String string = "";
        int n3 = -1;
        int[][] nArray = new int[this.moCount][4];
        Vector[] vectorArray = new Vector[this.moCount];
        this.gaussianCount = 0;
        this.discardLinesUntilContains("--------");
        while (this.readLine() != null && (stringArray = this.getTokens()).length == 9) {
            int n4 = this.parseInt(stringArray[2]);
            if (n4 <= 0) continue;
            if (!stringArray[0].equals(string)) {
                ++n3;
            }
            string = stringArray[0];
            int n5 = this.parseInt(stringArray[5]);
            n2 = this.parseInt(stringArray[4]);
            if (n2 <= 2) {
                --n2;
            }
            if (vectorArray[n5] == null) {
                nArray[n5][0] = n3;
                nArray[n5][1] = n2;
                nArray[n5][2] = 0;
                nArray[n5][3] = 0;
                vectorArray[n5] = new Vector();
            }
            float f = 1.0f;
            vectorArray[n5].addElement(new float[]{this.parseFloat(stringArray[6]), this.parseFloat(stringArray[8]) * f});
            this.gaussianCount += n4;
            n = n4 - 1;
            while (--n >= 0) {
                stringArray = AtomSetCollectionReader.getTokens((String)this.readLine());
                vectorArray[n5].addElement(new float[]{this.parseFloat(stringArray[6]), this.parseFloat(stringArray[8]) * f});
            }
        }
        float[][] fArrayArray = new float[this.gaussianCount][];
        Vector<int[]> vector = new Vector<int[]>();
        this.gaussianCount = 0;
        for (n2 = 0; n2 < this.moCount; ++n2) {
            if (vectorArray[n2] == null) continue;
            int n6 = vectorArray[n2].size();
            nArray[n2][2] = this.gaussianCount;
            nArray[n2][3] = n6;
            for (n = 0; n < n6; ++n) {
                fArrayArray[this.gaussianCount++] = (float[])vectorArray[n2].get(n);
            }
            vector.addElement(nArray[n2]);
        }
        this.moData.put("shells", vector);
        this.moData.put("gaussians", fArrayArray);
        if (Logger.isActiveLevel((int)0)) {
            Logger.debug((String)(vector.size() + " slater shells read"));
            Logger.debug((String)(this.gaussianCount + " gaussian primitives read"));
        }
    }

    void readBasisNormalized() throws Exception {
    }

    private void readMolecularOrbitals() throws Exception {
        String[][] stringArray = new String[this.moCount][];
        this.readLine();
        this.readLine();
        this.readLine();
        int n = 0;
        while (this.line != null) {
            this.readLine();
            this.readLine();
            this.readLine();
            if (this.line == null || this.line.indexOf("eigenvalues-") < 0) break;
            String[] stringArray2 = this.getTokens();
            int n2 = stringArray2.length - 1;
            this.fillDataBlock(stringArray);
            for (int i = 0; i < n2; ++i) {
                float[] fArray = new float[this.moCount];
                Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
                float f = this.parseFloat(stringArray2[i + 1]);
                hashtable.put("energy", new Float(f));
                if ((double)Math.abs(f - this.lumoEnergy) < 1.0E-4) {
                    this.moData.put("HOMO", new Integer(n));
                    this.lumoEnergy = Float.MAX_VALUE;
                }
                ++n;
                for (int j = 0; j < this.moCount; ++j) {
                    fArray[j] = this.parseFloat(stringArray[j][i + 3]);
                }
                hashtable.put("coefficients", fArray);
                this.orbitals.addElement(hashtable);
            }
        }
        this.moData.put("mos", this.orbitals);
    }

    private void readFrequencies() throws Exception {
        int n = 1;
        while (this.readLine() != null && !this.line.startsWith("  frequencies ")) {
        }
        if (this.line == null) {
            return;
        }
        do {
            int n2 = Parser.countTokens((String)this.line, (int)0) - 1;
            while (this.readLine() != null && !this.line.startsWith("  intensities ") && !this.line.startsWith("  force ")) {
            }
            for (int i = 0; i < this.atomCount; ++i) {
                String[] stringArray = AtomSetCollectionReader.getTokens((String)this.readLine());
                String[] stringArray2 = AtomSetCollectionReader.getTokens((String)this.readLine());
                String[] stringArray3 = AtomSetCollectionReader.getTokens((String)this.readLine());
                for (int j = 0; j < n2; ++j) {
                    this.recordAtomVector(n + j, i, this.parseFloat(stringArray[j + 2]), this.parseFloat(stringArray2[j + 2]), this.parseFloat(stringArray3[j + 2]));
                }
            }
            this.discardLines(1);
            n += n2;
        } while (this.readLine() != null && this.line.startsWith("  frequencies "));
    }

    private void recordAtomVector(int n, int n2, float f, float f2, float f3) throws Exception {
        if (Float.isNaN(f) || Float.isNaN(f2) || Float.isNaN(f3) || n2 <= 0 || n2 > this.atomCount) {
            return;
        }
        if (n2 == 1 && n > 1) {
            this.atomSetCollection.cloneFirstAtomSet();
        }
        Atom atom = this.atomSetCollection.getAtom((n - 1) * this.atomCount + n2 - 1);
        atom.vectorX = f;
        atom.vectorY = f2;
        atom.vectorZ = f3;
    }
}

