/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.bspt;

import javax.vecmath.Point3f;
import org.jmol.bspt.Bspt;
import org.jmol.bspt.CubeIterator;

public final class Bspf {
    int dimMax;
    Bspt[] bspts;
    CubeIterator[] cubeIterators;

    public Bspf(int n) {
        this.dimMax = n;
        this.bspts = new Bspt[0];
        this.cubeIterators = new CubeIterator[0];
    }

    public int getBsptCount() {
        return this.bspts.length;
    }

    public void addTuple(int n, Point3f point3f) {
        Object object;
        if (n >= this.bspts.length) {
            object = new Bspt[n + 1];
            System.arraycopy(this.bspts, 0, object, 0, this.bspts.length);
            this.bspts = object;
        }
        if ((object = this.bspts[n]) == null) {
            this.bspts[n] = new Bspt(this.dimMax);
            object = this.bspts[n];
        }
        ((Bspt)object).addTuple(point3f);
    }

    public void stats() {
        for (int i = 0; i < this.bspts.length; ++i) {
            if (this.bspts[i] == null) continue;
            this.bspts[i].stats();
        }
    }

    public CubeIterator getCubeIterator(int n) {
        if (n >= this.cubeIterators.length) {
            CubeIterator[] cubeIteratorArray = new CubeIterator[n + 1];
            System.arraycopy(this.cubeIterators, 0, cubeIteratorArray, 0, this.cubeIterators.length);
            this.cubeIterators = cubeIteratorArray;
        }
        if (this.cubeIterators[n] == null && this.bspts[n] != null) {
            this.cubeIterators[n] = this.bspts[n].allocateCubeIterator();
        }
        return this.cubeIterators[n];
    }
}

