/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.cifpdb;

import java.io.BufferedReader;
import java.util.Hashtable;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.Bond;
import org.jmol.adapter.smarter.Structure;
import org.jmol.util.Logger;
import org.jmol.viewer.JmolConstants;

public class CifReader
extends AtomSetCollectionReader {
    RidiculousFileFormatTokenizer tokenizer = new RidiculousFileFormatTokenizer();
    String thisDataSetName = "";
    String chemicalName = "";
    String thisStructuralFormula = "";
    String thisFormula = "";
    Hashtable htHetero;
    public static final String[] cellParamNames = new String[]{"_cell_length_a", "_cell_length_b", "_cell_length_c", "_cell_angle_alpha", "_cell_angle_beta", "_cell_angle_gamma", "_cell.length_a", "_cell.length_b", "_cell.length_c", "_cell.angle_alpha", "_cell.angle_beta", "_cell.angle_gamma"};
    static final String[] TransformFields = new String[]{"x[1][1]", "x[1][2]", "x[1][3]", "r[1]", "x[2][1]", "x[2][2]", "x[2][3]", "r[2]", "x[3][1]", "x[3][2]", "x[3][3]", "r[3]"};
    String key;
    String data;
    Hashtable atomTypes;
    static final byte ATOM_TYPE_SYMBOL = 0;
    static final byte ATOM_TYPE_OXIDATION_NUMBER = 1;
    static final String[] atomTypeFields = new String[]{"_atom_type_symbol", "_atom_type_oxidation_number"};
    static final byte NONE = -1;
    static final byte TYPE_SYMBOL = 0;
    static final byte LABEL = 1;
    static final byte AUTH_ATOM = 2;
    static final byte FRACT_X = 3;
    static final byte FRACT_Y = 4;
    static final byte FRACT_Z = 5;
    static final byte CARTN_X = 6;
    static final byte CARTN_Y = 7;
    static final byte CARTN_Z = 8;
    static final byte OCCUPANCY = 9;
    static final byte B_ISO = 10;
    static final byte COMP_ID = 11;
    static final byte ASYM_ID = 12;
    static final byte SEQ_ID = 13;
    static final byte INS_CODE = 14;
    static final byte ALT_ID = 15;
    static final byte GROUP_PDB = 16;
    static final byte MODEL_NO = 17;
    static final byte DUMMY_ATOM = 18;
    static final byte DISORDER_GROUP = 19;
    static final String[] atomFields = new String[]{"_atom_site_type_symbol", "_atom_site_label", "_atom_site_auth_atom_id", "_atom_site_fract_x", "_atom_site_fract_y", "_atom_site_fract_z", "_atom_site.Cartn_x", "_atom_site.Cartn_y", "_atom_site.Cartn_z", "_atom_site_occupancy", "_atom_site.b_iso_or_equiv", "_atom_site.auth_comp_id", "_atom_site.auth_asym_id", "_atom_site.auth_seq_id", "_atom_site.pdbx_PDB_ins_code", "_atom_site.label_alt_id", "_atom_site.group_PDB", "_atom_site.pdbx_PDB_model_num", "_atom_site_calc_flag", "_atom_site_disorder_group"};
    static final byte GEOM_BOND_ATOM_SITE_LABEL_1 = 0;
    static final byte GEOM_BOND_ATOM_SITE_LABEL_2 = 1;
    static final byte GEOM_BOND_SITE_SYMMETRY_2 = 2;
    static final String[] geomBondFields = new String[]{"_geom_bond_atom_site_label_1", "_geom_bond_atom_site_label_2"};
    static final byte NONPOLY_ENTITY_ID = 0;
    static final byte NONPOLY_NAME = 1;
    static final byte NONPOLY_COMP_ID = 2;
    static final String[] nonpolyFields = new String[]{"_pdbx_entity_nonpoly.entity_id", "_pdbx_entity_nonpoly.name", "_pdbx_entity_nonpoly.comp_id"};
    String[] hetatmData;
    static final byte CHEM_COMP_ID = 0;
    static final byte CHEM_COMP_NAME = 1;
    static final String[] chemCompFields = new String[]{"_chem_comp.id", "_chem_comp.name"};
    static final byte CONF_TYPE_ID = 0;
    static final byte BEG_ASYM_ID = 1;
    static final byte BEG_SEQ_ID = 2;
    static final byte BEG_INS_CODE = 3;
    static final byte END_ASYM_ID = 4;
    static final byte END_SEQ_ID = 5;
    static final byte END_INS_CODE = 6;
    static final String[] structConfFields = new String[]{"_struct_conf.conf_type_id", "_struct_conf.beg_auth_asym_id", "_struct_conf.beg_auth_seq_id", "_struct_conf.pdbx_beg_PDB_ins_code", "_struct_conf.end_auth_asym_id", "_struct_conf.end_auth_seq_id", "_struct_conf.pdbx_end_PDB_ins_code"};
    static final String[] structSheetRangeFields = new String[]{"_struct_sheet_range.sheet_id", "_struct_sheet_range.beg_auth_asym_id", "_struct_sheet_range.beg_auth_seq_id", "_struct_sheet_range.pdbx_beg_PDB_ins_code", "_struct_sheet_range.end_auth_asym_id", "_struct_sheet_range.end_auth_seq_id", "_struct_sheet_range.pdbx_end_PDB_ins_code"};
    static final byte SITE_ID = 0;
    static final byte SITE_COMP_ID = 1;
    static final byte SITE_ASYM_ID = 2;
    static final byte SITE_SEQ_ID = 3;
    static final byte SITE_INS_CODE = 4;
    static final String[] structSiteRangeFields = new String[]{"_struct_site_gen.site_id", "_struct_site_gen.auth_comp_id", "_struct_site_gen.auth_asym_id", "_struct_site_gen.auth_seq_id", "_struct_site_gen.label_alt_id"};
    int siteNum = 0;
    Hashtable htSites;
    static final byte SYMOP_XYZ = 0;
    static final byte SYM_EQUIV_XYZ = 1;
    static final String[] symmetryOperationsFields = new String[]{"_space_group_symop_operation_xyz", "_symmetry_equiv_pos_as_xyz"};
    String[] loopData;
    int[] fieldTypes = new int[100];
    boolean[] propertyReferenced = new boolean[50];
    int propertyCount;
    int fieldCount;

    public AtomSetCollection readAtomSetCollection(BufferedReader bufferedReader) {
        int n = 0;
        this.reader = bufferedReader;
        this.atomSetCollection = new AtomSetCollection("cif");
        this.line = "";
        boolean bl = false;
        try {
            while ((this.key = this.tokenizer.peekToken()) != null) {
                if (this.key.startsWith("data_")) {
                    if (this.iHaveDesiredModel) break;
                    boolean bl2 = bl = ++this.modelNumber != this.desiredModelNumber && this.desiredModelNumber > 0;
                    if (bl) {
                        this.tokenizer.getTokenPeeked();
                        continue;
                    }
                    this.chemicalName = "";
                    this.thisStructuralFormula = "";
                    this.thisFormula = "";
                    if (n == this.atomSetCollection.getAtomCount()) {
                        this.atomSetCollection.removeAtomSet();
                    } else {
                        this.applySymmetry();
                    }
                    this.processDataParameter();
                    this.iHaveDesiredModel = this.desiredModelNumber > 0;
                    n = this.atomSetCollection.getAtomCount();
                    continue;
                }
                if (this.key.startsWith("loop_")) {
                    if (bl) {
                        this.tokenizer.getTokenPeeked();
                        continue;
                    }
                    this.processLoopBlock();
                    continue;
                }
                if (this.key.indexOf("_") != 0) {
                    Logger.warn("CIF ERROR ? should be an underscore: " + this.key);
                    this.tokenizer.getTokenPeeked();
                } else if (!this.getData()) continue;
                if (bl) continue;
                if (this.key.startsWith("_chemical_name")) {
                    this.processChemicalInfo("name");
                    continue;
                }
                if (this.key.startsWith("_chemical_formula_structural")) {
                    this.processChemicalInfo("structuralFormula");
                    continue;
                }
                if (this.key.startsWith("_chemical_formula_sum")) {
                    this.processChemicalInfo("formula");
                    continue;
                }
                if (this.key.startsWith("_cell_") || this.key.startsWith("_cell.")) {
                    this.processCellParameter();
                    continue;
                }
                if (this.key.startsWith("_symmetry_space_group_name_H-M") || this.key.startsWith("_symmetry.space_group_name_H-M") || this.key.startsWith("_symmetry_space_group_name_Hall") || this.key.startsWith("_symmetry.space_group_name_Hall")) {
                    this.processSymmetrySpaceGroupName();
                    continue;
                }
                if (this.key.startsWith("_atom_sites.fract_tran") || this.key.startsWith("_atom_sites.fract_tran")) {
                    this.processUnitCellTransformMatrix();
                    continue;
                }
                if (!this.key.startsWith("_pdbx_entity_nonpoly")) continue;
                this.processNonpolyData();
            }
            if (this.atomSetCollection.getAtomCount() == n) {
                this.atomSetCollection.removeAtomSet();
            } else {
                this.applySymmetry();
            }
            if (this.htSites != null) {
                this.addSites(this.htSites);
            }
            this.atomSetCollection.setCollectionName("<collection of " + this.atomSetCollection.getAtomSetCount() + " models>");
        }
        catch (Exception exception) {
            return this.setError(exception);
        }
        return this.atomSetCollection;
    }

    void processDataParameter() {
        this.tokenizer.getTokenPeeked();
        String string = this.thisDataSetName = this.key.length() < 6 ? "" : this.key.substring(5);
        if (this.thisDataSetName.length() > 0) {
            if (this.atomSetCollection.getCurrentAtomSetIndex() >= 0) {
                this.atomSetCollection.newAtomSet();
            } else {
                this.atomSetCollection.setCollectionName(this.thisDataSetName);
            }
        }
        Logger.debug(this.key);
    }

    void processChemicalInfo(String string) throws Exception {
        if (string.equals("name")) {
            this.chemicalName = this.data = this.tokenizer.fullTrim(this.data);
        } else if (string.equals("structuralFormula")) {
            this.thisStructuralFormula = this.data = this.tokenizer.fullTrim(this.data);
        } else if (string.equals("formula")) {
            this.thisFormula = this.data = this.tokenizer.fullTrim(this.data);
        }
        if (Logger.isActiveLevel(0)) {
            Logger.debug(string + " = " + this.data);
        }
    }

    void processSymmetrySpaceGroupName() throws Exception {
        this.setSpaceGroupName(this.data);
    }

    void processCellParameter() throws Exception {
        int n = cellParamNames.length;
        while (--n >= 0) {
            if (!CifReader.isMatch(this.key, cellParamNames[n])) continue;
            this.setUnitCellItem(n % 6, this.parseFloat(this.data));
            return;
        }
    }

    void processUnitCellTransformMatrix() throws Exception {
        float f = this.parseFloat(this.data);
        if (Float.isNaN(f)) {
            return;
        }
        for (int i = 0; i < TransformFields.length; ++i) {
            if (this.key.indexOf(TransformFields[i]) < 0) continue;
            this.setUnitCellItem(6 + i, f);
            return;
        }
    }

    boolean getData() throws Exception {
        this.key = this.tokenizer.getTokenPeeked();
        this.data = this.tokenizer.getNextToken();
        if (this.data == null) {
            Logger.warn("CIF ERROR ? end of file; data missing: " + this.key);
            return false;
        }
        return this.data.length() == 0 || this.data.charAt(0) != '\u0000';
    }

    private void processLoopBlock() throws Exception {
        this.tokenizer.getTokenPeeked();
        String string = this.tokenizer.peekToken();
        if (string == null) {
            return;
        }
        if (string.startsWith("_atom_site_") || string.startsWith("_atom_site.")) {
            if (!this.processAtomSiteLoopBlock()) {
                return;
            }
            this.atomSetCollection.setAtomSetName(this.thisDataSetName);
            this.atomSetCollection.setAtomSetAuxiliaryInfo("chemicalName", this.chemicalName);
            this.atomSetCollection.setAtomSetAuxiliaryInfo("structuralFormula", this.thisStructuralFormula);
            this.atomSetCollection.setAtomSetAuxiliaryInfo("formula", this.thisFormula);
            return;
        }
        if (string.startsWith("_atom_type")) {
            this.processAtomTypeLoopBlock();
            return;
        }
        if (string.startsWith("_geom_bond")) {
            if (this.doApplySymmetry && !this.applySymmetryToBonds) {
                this.skipLoop();
            } else {
                this.processGeomBondLoopBlock();
            }
            return;
        }
        if (string.startsWith("_pdbx_entity_nonpoly")) {
            this.processNonpolyLoopBlock();
            return;
        }
        if (string.startsWith("_chem_comp")) {
            this.processChemCompLoopBlock();
            return;
        }
        if (string.startsWith("_struct_conf") && !string.startsWith("_struct_conf_type")) {
            this.processStructConfLoopBlock();
            return;
        }
        if (string.startsWith("_struct_sheet_range")) {
            this.processStructSheetRangeLoopBlock();
            return;
        }
        if (string.startsWith("_struct_sheet_range")) {
            this.processStructSheetRangeLoopBlock();
            return;
        }
        if (string.startsWith("_symmetry_equiv_pos") || string.startsWith("space_group_symop")) {
            if (this.ignoreFileSymmetryOperators) {
                Logger.warn("ignoring file-based symmetry operators");
                this.skipLoop();
            } else {
                this.processSymmetryOperationsLoopBlock();
            }
            return;
        }
        if (string.startsWith("_struct_site")) {
            this.processStructSiteBlock();
            return;
        }
        this.skipLoop();
    }

    void processAtomTypeLoopBlock() throws Exception {
        this.parseLoopParameters(atomTypeFields);
        int n = this.propertyCount;
        while (--n >= 0) {
            if (this.propertyReferenced[n]) continue;
            this.skipLoop();
            return;
        }
        while (this.tokenizer.getData()) {
            String string = null;
            float f = Float.NaN;
            block7: for (int i = 0; i < this.fieldCount; ++i) {
                char c;
                String string2 = this.loopData[i];
                if (string2.length() == 0 || (c = string2.charAt(0)) == '\u0000') continue;
                switch (this.fieldTypes[i]) {
                    case -1: {
                        continue block7;
                    }
                    case 0: {
                        string = string2;
                        continue block7;
                    }
                    case 1: {
                        f = this.parseFloat(string2);
                    }
                }
            }
            if (string == null || Float.isNaN(f)) continue;
            if (this.atomTypes == null) {
                this.atomTypes = new Hashtable();
            }
            this.atomTypes.put(string, new Float(f));
        }
    }

    boolean processAtomSiteLoopBlock() throws Exception {
        int c = -1;
        boolean bl = false;
        this.parseLoopParameters(atomFields);
        if (this.propertyReferenced[6]) {
            this.setFractionalCoordinates(false);
            for (int i = 3; i < 5; ++i) {
                this.disableField(i);
            }
        } else if (this.propertyReferenced[3]) {
            this.setFractionalCoordinates(true);
            for (int atom = 6; atom < 8; ++atom) {
                this.disableField(atom);
            }
        } else {
            this.skipLoop();
            return false;
        }
        while (this.tokenizer.getData()) {
            Atom atom = new Atom();
            block21: for (int i = 0; i < this.fieldCount; ++i) {
                char c2;
                String string = this.loopData[i];
                if (string.length() == 0 || (c2 = string.charAt(0)) == '\u0000') continue;
                switch (this.fieldTypes[i]) {
                    case -1: {
                        continue block21;
                    }
                    case 0: {
                        char c3;
                        char f;
                        String string2 = string.length() < 2 ? string : (Atom.isValidElementSymbol(f = string.charAt(0), c3 = (char)Character.toLowerCase(string.charAt(1))) ? "" + f + c3 : "" + f);
                        atom.elementSymbol = string2;
                        if (this.atomTypes == null || !this.atomTypes.containsKey(string)) continue block21;
                        float f2 = ((Float)this.atomTypes.get(string)).floatValue();
                        atom.formalCharge = (int)((double)f2 + (f2 < 0.0f ? -0.5 : 0.5));
                        if (!((double)Math.abs((float)atom.formalCharge - f2) > 0.1) || !Logger.isActiveLevel(0)) continue block21;
                        Logger.debug("CIF charge on " + string + " was " + f2 + "; rounded to " + atom.formalCharge);
                        continue block21;
                    }
                    case 1: 
                    case 2: {
                        atom.atomName = string;
                        continue block21;
                    }
                    case 3: 
                    case 6: {
                        atom.x = this.parseFloat(string);
                        continue block21;
                    }
                    case 4: 
                    case 7: {
                        atom.y = this.parseFloat(string);
                        continue block21;
                    }
                    case 5: 
                    case 8: {
                        atom.z = this.parseFloat(string);
                        continue block21;
                    }
                    case 9: {
                        float f = this.parseFloat(string);
                        if (Float.isNaN(f)) continue block21;
                        atom.occupancy = (int)(f * 100.0f);
                        continue block21;
                    }
                    case 10: {
                        atom.bfactor = this.parseFloat(string);
                        continue block21;
                    }
                    case 11: {
                        atom.group3 = string;
                        continue block21;
                    }
                    case 12: {
                        if (string.length() > 1) {
                            Logger.warn("Don't know how to deal with chains more than 1 char: " + string);
                        }
                        atom.chainID = c2;
                        continue block21;
                    }
                    case 13: {
                        atom.sequenceNumber = this.parseInt(string);
                        continue block21;
                    }
                    case 14: {
                        atom.chainID = c2;
                        continue block21;
                    }
                    case 15: 
                    case 19: {
                        atom.alternateLocationID = string.charAt(0);
                        continue block21;
                    }
                    case 16: {
                        bl = true;
                        if (!"HETATM".equals(string)) continue block21;
                        atom.isHetero = true;
                        continue block21;
                    }
                    case 17: {
                        char c4;
                        char c3 = this.parseInt(string);
                        if (c3 == c4) continue block21;
                        this.atomSetCollection.newAtomSet();
                        c4 = c3;
                        continue block21;
                    }
                    case 18: {
                        if (!"dum".equals(string)) continue block21;
                        atom.x = Float.NaN;
                        continue block21;
                    }
                }
            }
            if (Float.isNaN(atom.x) || Float.isNaN(atom.y) || Float.isNaN(atom.z)) {
                Logger.warn("atom " + atom.atomName + " has invalid/unknown coordinates");
                continue;
            }
            this.setAtomCoord(atom);
            this.atomSetCollection.addAtomWithMappedName(atom);
            if (!atom.isHetero || this.htHetero == null) continue;
            this.atomSetCollection.setAtomSetAuxiliaryInfo("hetNames", this.htHetero);
            this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("hetNames", this.htHetero);
            this.htHetero = null;
        }
        if (bl) {
            this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("isPDB", Boolean.TRUE);
            this.atomSetCollection.setAtomSetAuxiliaryInfo("isPDB", Boolean.TRUE);
        }
        return true;
    }

    void processGeomBondLoopBlock() throws Exception {
        this.parseLoopParameters(geomBondFields);
        int n = this.propertyCount;
        while (--n >= 0) {
            if (this.propertyReferenced[n]) continue;
            Logger.warn("?que? missing _geom_bond property:" + n);
            this.skipLoop();
            return;
        }
        while (this.tokenizer.getData()) {
            n = -1;
            int n2 = -1;
            block7: for (int i = 0; i < this.fieldCount; ++i) {
                char c;
                String string = this.loopData[i];
                if (string.length() == 0 || (c = string.charAt(0)) == '\u0000') continue;
                switch (this.fieldTypes[i]) {
                    case -1: {
                        continue block7;
                    }
                    case 0: {
                        n = this.atomSetCollection.getAtomNameIndex(string);
                        continue block7;
                    }
                    case 1: {
                        n2 = this.atomSetCollection.getAtomNameIndex(string);
                        continue block7;
                    }
                }
            }
            if (n < 0 || n2 < 0) continue;
            Bond bond = new Bond();
            bond.atomIndex1 = n;
            bond.atomIndex2 = n2;
            this.atomSetCollection.addBond(bond);
        }
    }

    void processNonpolyData() {
        if (this.hetatmData == null) {
            this.hetatmData = new String[3];
        }
        int n = nonpolyFields.length;
        while (--n >= 0) {
            if (!CifReader.isMatch(this.key, nonpolyFields[n])) continue;
            this.hetatmData[n] = this.data;
            break;
        }
        if (this.hetatmData[1] == null || this.hetatmData[2] == null) {
            return;
        }
        this.addHetero(this.hetatmData[2], this.hetatmData[1]);
        this.hetatmData = null;
    }

    void processChemCompLoopBlock() throws Exception {
        this.parseLoopParameters(chemCompFields);
        while (this.tokenizer.getData()) {
            String string = null;
            String string2 = null;
            block6: for (int i = 0; i < this.fieldCount; ++i) {
                char c;
                String string3 = this.loopData[i];
                if (string3.length() == 0 || (c = string3.charAt(0)) == '\u0000') continue;
                switch (this.fieldTypes[i]) {
                    case -1: {
                        continue block6;
                    }
                    case 0: {
                        string = string3;
                        continue block6;
                    }
                    case 1: {
                        string2 = string3;
                    }
                }
            }
            if (string == null || string2 == null) {
                return;
            }
            this.addHetero(string, string2);
        }
    }

    void processNonpolyLoopBlock() throws Exception {
        this.parseLoopParameters(nonpolyFields);
        while (this.tokenizer.getData()) {
            String string = null;
            String string2 = null;
            block6: for (int i = 0; i < this.fieldCount; ++i) {
                char c;
                String string3 = this.loopData[i];
                if (string3.length() == 0 || (c = string3.charAt(0)) == '\u0000') continue;
                switch (this.fieldTypes[i]) {
                    case -1: 
                    case 0: {
                        continue block6;
                    }
                    case 2: {
                        string = string3;
                        continue block6;
                    }
                    case 1: {
                        string2 = string3;
                    }
                }
            }
            if (string == null || string2 == null) {
                return;
            }
            this.addHetero(string, string2);
        }
    }

    void addHetero(String string, String string2) {
        if (!JmolConstants.isHetero(string)) {
            return;
        }
        if (this.htHetero == null) {
            this.htHetero = new Hashtable();
        }
        this.htHetero.put(string, string2);
        if (Logger.isActiveLevel(0)) {
            Logger.debug("hetero: " + string + " = " + string2);
        }
    }

    void processStructConfLoopBlock() throws Exception {
        this.parseLoopParameters(structConfFields);
        int n = this.propertyCount;
        while (--n >= 0) {
            if (this.propertyReferenced[n]) continue;
            Logger.warn("?que? missing _struct_conf property:" + n);
            this.skipLoop();
            return;
        }
        while (this.tokenizer.getData()) {
            Structure structure = new Structure();
            block12: for (int i = 0; i < this.fieldCount; ++i) {
                char c;
                String string = this.loopData[i];
                if (string.length() == 0 || (c = string.charAt(0)) == '\u0000') continue;
                switch (this.fieldTypes[i]) {
                    case -1: {
                        continue block12;
                    }
                    case 0: {
                        if (string.startsWith("HELX")) {
                            structure.structureType = "helix";
                            continue block12;
                        }
                        if (string.startsWith("TURN")) {
                            structure.structureType = "turn";
                            continue block12;
                        }
                        structure.structureType = "none";
                        continue block12;
                    }
                    case 1: {
                        structure.startChainID = c;
                        continue block12;
                    }
                    case 2: {
                        structure.startSequenceNumber = this.parseInt(string);
                        continue block12;
                    }
                    case 3: {
                        structure.startInsertionCode = c;
                        continue block12;
                    }
                    case 4: {
                        structure.endChainID = c;
                        continue block12;
                    }
                    case 5: {
                        structure.endSequenceNumber = this.parseInt(string);
                        continue block12;
                    }
                    case 6: {
                        structure.endInsertionCode = c;
                    }
                }
            }
            this.atomSetCollection.addStructure(structure);
        }
    }

    void processStructSheetRangeLoopBlock() throws Exception {
        this.parseLoopParameters(structSheetRangeFields);
        int n = this.propertyCount;
        while (--n >= 0) {
            if (this.propertyReferenced[n]) continue;
            Logger.warn("?que? missing _struct_conf property:" + n);
            this.skipLoop();
            return;
        }
        while (this.tokenizer.getData()) {
            Structure structure = new Structure();
            structure.structureType = "sheet";
            block10: for (int i = 0; i < this.fieldCount; ++i) {
                char c;
                String string = this.loopData[i];
                if (string.length() == 0 || (c = string.charAt(0)) == '\u0000') continue;
                switch (this.fieldTypes[i]) {
                    case 1: {
                        structure.startChainID = c;
                        continue block10;
                    }
                    case 2: {
                        structure.startSequenceNumber = this.parseInt(string);
                        continue block10;
                    }
                    case 3: {
                        structure.startInsertionCode = c;
                        continue block10;
                    }
                    case 4: {
                        structure.endChainID = c;
                        continue block10;
                    }
                    case 5: {
                        structure.endSequenceNumber = this.parseInt(string);
                        continue block10;
                    }
                    case 6: {
                        structure.endInsertionCode = c;
                    }
                }
            }
            this.atomSetCollection.addStructure(structure);
        }
    }

    void processStructSiteBlock() throws Exception {
        this.parseLoopParameters(structSiteRangeFields);
        int n = 3;
        while (--n >= 0) {
            if (this.propertyReferenced[n]) continue;
            Logger.warn("?que? missing _struct_site property:" + n);
            this.skipLoop();
            return;
        }
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        Hashtable<String, String> hashtable = null;
        this.htSites = new Hashtable();
        while (this.tokenizer.getData()) {
            for (int i = 0; i < this.fieldCount; ++i) {
                char c;
                String string7 = this.loopData[i];
                if (string7.length() == 0 || (c = string7.charAt(0)) == '\u0000') continue;
                switch (this.fieldTypes[i]) {
                    case 0: {
                        if (string6 != "") {
                            String string8 = (String)hashtable.get("groups");
                            string8 = string8 + (string8.length() == 0 ? "" : ",") + string6;
                            string6 = "";
                            hashtable.put("groups", string8);
                        }
                        if ((hashtable = (Hashtable)this.htSites.get(string = string7)) == null) {
                            hashtable = new Hashtable<String, String>();
                            hashtable.put("seqNum", "site_" + ++this.siteNum);
                            hashtable.put("groups", "");
                            this.htSites.put(string, hashtable);
                        }
                        string2 = "";
                        string3 = "";
                        string4 = "";
                        string5 = "";
                        break;
                    }
                    case 1: {
                        string5 = string7;
                        break;
                    }
                    case 2: {
                        string4 = string7;
                        break;
                    }
                    case 3: {
                        string2 = string7;
                        break;
                    }
                    case 4: {
                        string3 = string7;
                    }
                }
                if (string2 == "" || string5 == "") continue;
                string6 = "[" + string5 + "]" + string2 + (string3.length() > 0 ? "^" + string3 : "") + (string4.length() > 0 ? ":" + string4 : "");
            }
        }
        if (string6 != "") {
            String string9 = (String)hashtable.get("groups");
            string9 = string9 + (string9.length() == 0 ? "" : ",") + string6;
            string6 = "";
            hashtable.put("groups", string9);
        }
    }

    void processSymmetryOperationsLoopBlock() throws Exception {
        this.parseLoopParameters(symmetryOperationsFields);
        int n = 0;
        int n2 = this.propertyCount;
        while (--n2 >= 0) {
            if (!this.propertyReferenced[n2]) continue;
            ++n;
        }
        if (n != 1) {
            Logger.warn("?que? _symmetry_equiv or _space_group_symop property not found");
            this.skipLoop();
            return;
        }
        while (this.tokenizer.getData()) {
            for (n2 = 0; n2 < this.fieldCount; ++n2) {
                char c;
                String string = this.loopData[n2];
                if (string.length() == 0 || (c = string.charAt(0)) == '\u0000') continue;
                switch (this.fieldTypes[n2]) {
                    case 0: 
                    case 1: {
                        this.setSymmetryOperator(string);
                    }
                }
            }
        }
    }

    void parseLoopParameters(String[] stringArray) throws Exception {
        this.fieldCount = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            this.propertyReferenced[i] = false;
        }
        this.propertyCount = stringArray.length;
        while (true) {
            String string;
            if ((string = this.tokenizer.peekToken()) == null) {
                this.fieldCount = 0;
                break;
            }
            if (string.charAt(0) != '_') break;
            this.tokenizer.getTokenPeeked();
            this.fieldTypes[this.fieldCount] = -1;
            int n = stringArray.length;
            while (--n >= 0) {
                if (!CifReader.isMatch(string, stringArray[n])) continue;
                this.fieldTypes[this.fieldCount] = n;
                this.propertyReferenced[n] = true;
                break;
            }
            ++this.fieldCount;
        }
        if (this.fieldCount > 0) {
            this.loopData = new String[this.fieldCount];
        }
    }

    void disableField(int n) {
        int n2 = this.fieldCount;
        while (--n2 >= 0) {
            if (this.fieldTypes[n2] != n) continue;
            this.fieldTypes[n2] = -1;
        }
    }

    private void skipLoop() throws Exception {
        String string;
        while ((string = this.tokenizer.peekToken()) != null && string.charAt(0) == '_') {
            string = this.tokenizer.getTokenPeeked();
        }
        while (this.tokenizer.getNextDataToken() != null) {
        }
    }

    static final boolean isMatch(String string, String string2) {
        int n = string.length();
        if (string2.length() != n) {
            return false;
        }
        int n2 = n;
        while (--n2 >= 0) {
            char c;
            char c2 = string.charAt(n2);
            if (c2 == (c = string2.charAt(n2)) || (c2 == '_' || c2 == '.') && (c == '_' || c == '.')) continue;
            if (c2 <= 'Z' && c2 >= 'A') {
                c2 = (char)(c2 + 32);
            } else if (c <= 'Z' && c >= 'A') {
                c = (char)(c + 32);
            }
            if (c2 == c) continue;
            return false;
        }
        return true;
    }

    class RidiculousFileFormatTokenizer {
        String str;
        int ich;
        int cch;
        boolean wasUnQuoted;
        String strPeeked;
        int ichPeeked;

        RidiculousFileFormatTokenizer() {
        }

        void setString(String string) {
            this.str = string;
            this.cch = string == null ? 0 : string.length();
            this.ich = 0;
        }

        String setStringNextLine() throws Exception {
            this.setString(CifReader.this.readLine());
            if (CifReader.this.line == null || CifReader.this.line.length() == 0 || CifReader.this.line.charAt(0) != ';') {
                return CifReader.this.line;
            }
            this.ich = 1;
            String string = '\u0001' + CifReader.this.line.substring(1) + '\n';
            while (CifReader.this.readLine() != null) {
                if (CifReader.this.line.startsWith(";")) {
                    string = string.substring(0, string.length() - 1) + '\u0001' + CifReader.this.line.substring(1);
                    break;
                }
                string = string + CifReader.this.line + '\n';
            }
            this.setString(string);
            CifReader.this.line = string;
            return CifReader.this.line;
        }

        boolean hasMoreTokens() {
            if (this.str == null) {
                return false;
            }
            int n = 35;
            while (this.ich < this.cch) {
                char c = this.str.charAt(this.ich);
                n = c;
                if (c != ' ' && n != 9) break;
                ++this.ich;
            }
            if (this.str.indexOf("#jmolscript:") >= 0) {
                CifReader.this.checkLineForScript();
            }
            return this.ich < this.cch && n != 35;
        }

        String nextToken() {
            if (this.ich == this.cch) {
                return null;
            }
            int n = this.ich;
            char c = this.str.charAt(n);
            if (c != '\'' && c != '\"' && c != '\u0001') {
                this.wasUnQuoted = true;
                while (this.ich < this.cch && (c = this.str.charAt(this.ich)) != ' ' && c != '\t') {
                    ++this.ich;
                }
                if (this.ich == n + 1 && (this.str.charAt(n) == '.' || this.str.charAt(n) == '?')) {
                    return "\u0000";
                }
                return this.str.substring(n, this.ich);
            }
            this.wasUnQuoted = false;
            char c2 = c;
            boolean bl = false;
            while (++this.ich < this.cch) {
                c = this.str.charAt(this.ich);
                if (bl && (c == ' ' || c == '\t')) break;
                bl = c == c2;
            }
            if (this.ich == this.cch) {
                if (bl) {
                    return this.str.substring(n + 1, this.ich - 1);
                }
                return this.str.substring(n, this.ich);
            }
            ++this.ich;
            return this.str.substring(n + 1, this.ich - 2);
        }

        boolean wasUnQuoted() {
            return this.wasUnQuoted;
        }

        boolean getData() throws Exception {
            for (int i = 0; i < CifReader.this.fieldCount; ++i) {
                String string = this.getNextDataToken();
                if (string == null) {
                    return false;
                }
                CifReader.this.loopData[i] = string;
            }
            return true;
        }

        String getNextDataToken() throws Exception {
            String string = this.peekToken();
            if (string == null) {
                return null;
            }
            if (this.wasUnQuoted() && (string.charAt(0) == '_' || string.startsWith("loop_") || string.startsWith("data_") || string.startsWith("stop_") || string.startsWith("global_"))) {
                return null;
            }
            return CifReader.this.tokenizer.getTokenPeeked();
        }

        String getNextToken() throws Exception {
            while (!this.hasMoreTokens()) {
                if (this.setStringNextLine() != null) continue;
                return null;
            }
            return this.nextToken();
        }

        String peekToken() throws Exception {
            while (!this.hasMoreTokens()) {
                if (this.setStringNextLine() != null) continue;
                return null;
            }
            int n = this.ich;
            this.strPeeked = this.nextToken();
            this.ichPeeked = this.ich;
            this.ich = n;
            return this.strPeeked;
        }

        String getTokenPeeked() {
            this.ich = this.ichPeeked;
            return this.strPeeked;
        }

        String fullTrim(String string) {
            int n;
            int n2 = string.length();
            for (n = 0; n < n2 && "\n\t ".indexOf(string.charAt(n)) >= 0; ++n) {
            }
            while (n < n2 && "\n\t ".indexOf(string.charAt(n2 - 1)) >= 0) {
                --n2;
            }
            return string.substring(n, n2);
        }
    }
}

