/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import java.util.Hashtable;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

public class BoxInfo {
    private final Point3f bbCorner0 = new Point3f(-10.0f, -10.0f, -10.0f);
    private final Point3f bbCorner1 = new Point3f(10.0f, 10.0f, 10.0f);
    private final Point3f bbCenter = new Point3f();
    private final Vector3f bbVector = new Vector3f();
    private final Point3f[] bbVertices = new Point3f[8];
    private static final Point3f[] unitBboxPoints = new Point3f[]{new Point3f(1.0f, 1.0f, 1.0f), new Point3f(1.0f, 1.0f, -1.0f), new Point3f(1.0f, -1.0f, 1.0f), new Point3f(1.0f, -1.0f, -1.0f), new Point3f(-1.0f, 1.0f, 1.0f), new Point3f(-1.0f, 1.0f, -1.0f), new Point3f(-1.0f, -1.0f, 1.0f), new Point3f(-1.0f, -1.0f, -1.0f)};

    public BoxInfo() {
        int n = 8;
        while (--n >= 0) {
            this.bbVertices[n] = new Point3f();
        }
    }

    public Point3f getBoundBoxCenter() {
        return this.bbCenter;
    }

    public Vector3f getBoundBoxCornerVector() {
        return this.bbVector;
    }

    public Point3f[] getBoundBoxPoints() {
        return new Point3f[]{this.bbCenter, new Point3f(this.bbVector), this.bbCorner0, this.bbCorner1};
    }

    Point3f[] getBboxVertices() {
        return this.bbVertices;
    }

    Hashtable getBoundBoxInfo() {
        Hashtable<String, Tuple3f> hashtable = new Hashtable<String, Tuple3f>();
        hashtable.put("center", new Point3f(this.bbCenter));
        hashtable.put("vector", new Vector3f(this.bbVector));
        hashtable.put("corner0", new Point3f(this.bbCorner0));
        hashtable.put("corner1", new Point3f(this.bbCorner1));
        return hashtable;
    }

    void setBoundBox(Point3f point3f, Point3f point3f2, boolean bl) {
        if (point3f.distance(point3f2) == 0.0f) {
            return;
        }
        if (bl) {
            this.bbCorner0.set(Math.min(point3f.x, point3f2.x), Math.min(point3f.y, point3f2.y), Math.min(point3f.z, point3f2.z));
            this.bbCorner1.set(Math.max(point3f.x, point3f2.x), Math.max(point3f.y, point3f2.y), Math.max(point3f.z, point3f2.z));
        } else {
            this.bbCorner0.set(point3f.x - point3f2.x, point3f.y - point3f2.y, point3f.z - point3f2.z);
            this.bbCorner1.set(point3f.x + point3f2.x, point3f.y + point3f2.y, point3f.z + point3f2.z);
        }
        this.setBbcage();
    }

    void reset() {
        this.bbCorner0.set(Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE);
        this.bbCorner1.set(-3.4028235E38f, -3.4028235E38f, -3.4028235E38f);
    }

    void addBoundBoxPoint(Point3f point3f) {
        float f = point3f.x;
        if (f < this.bbCorner0.x) {
            this.bbCorner0.x = f;
        }
        if (f > this.bbCorner1.x) {
            this.bbCorner1.x = f;
        }
        if ((f = point3f.y) < this.bbCorner0.y) {
            this.bbCorner0.y = f;
        }
        if (f > this.bbCorner1.y) {
            this.bbCorner1.y = f;
        }
        if ((f = point3f.z) < this.bbCorner0.z) {
            this.bbCorner0.z = f;
        }
        if (f > this.bbCorner1.z) {
            this.bbCorner1.z = f;
        }
    }

    void setBbcage() {
        this.bbCenter.add(this.bbCorner0, this.bbCorner1);
        this.bbCenter.scale(0.5f);
        this.bbVector.sub(this.bbCorner1, this.bbCenter);
        int n = 8;
        while (--n >= 0) {
            Point3f point3f = this.bbVertices[n];
            point3f.set(unitBboxPoints[n]);
            point3f.x *= this.bbVector.x;
            point3f.y *= this.bbVector.y;
            point3f.z *= this.bbVector.z;
            point3f.add(this.bbCenter);
        }
    }
}

