/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import java.awt.FontMetrics;
import javax.vecmath.Point3i;
import org.jmol.g3d.Font3D;
import org.jmol.modelset.CellInfo;
import org.jmol.shape.Axes;
import org.jmol.shape.FontLineShapeRenderer;

public class AxesRenderer
extends FontLineShapeRenderer {
    String[] axisLabels = new String[]{"+X", "+Y", "+Z", null, null, null, "a", "b", "c"};
    final Point3i[] axisScreens = new Point3i[6];
    final Point3i originScreen;
    short[] colixes;

    public AxesRenderer() {
        int n = 6;
        while (--n >= 0) {
            this.axisScreens[n] = new Point3i();
        }
        this.originScreen = new Point3i();
        this.colixes = new short[3];
    }

    protected void render() {
        int n;
        this.antialias = this.g3d.isAntialiased();
        Axes axes = (Axes)this.shape;
        short s = this.viewer.getObjectMad(1);
        if (s == 0 || !this.g3d.checkTranslucent(false)) {
            return;
        }
        if (this.viewer.areAxesTainted()) {
            axes.initShape();
        }
        int n2 = 6;
        int n3 = 0;
        CellInfo[] cellInfoArray = this.modelSet.getCellInfos();
        if (this.viewer.getAxesMode() == 2 && cellInfoArray != null) {
            n = this.viewer.getDisplayModelIndex();
            if (n < 0 || cellInfoArray[n].getUnitCell() == null) {
                return;
            }
            n2 = 3;
            n3 = 6;
        }
        n = this.viewer.isJmolDataFrame();
        this.viewer.transformPoint(axes.getOriginPoint(n != 0), this.originScreen);
        int n4 = n2;
        while (--n4 >= 0) {
            this.viewer.transformPoint(axes.getAxisPoint(n4, n != 0), this.axisScreens[n4]);
        }
        n4 = s;
        if (s >= 20) {
            n4 = this.viewer.scaleToScreen(this.originScreen.z, s);
        }
        this.colixes[0] = this.viewer.getObjectColix(1);
        this.colixes[1] = this.viewer.getObjectColix(2);
        this.colixes[2] = this.viewer.getObjectColix(3);
        int n5 = n2;
        while (--n5 >= 0) {
            this.colix = this.colixes[n5 % 3];
            this.g3d.setColix(this.colix);
            String string = this.axisLabels[n5 + n3];
            if (string != null) {
                this.renderLabel(string, axes.font3d, this.axisScreens[n5].x, this.axisScreens[n5].y, this.axisScreens[n5].z);
            }
            if (s < 0) {
                this.g3d.drawDottedLine(this.originScreen, this.axisScreens[n5]);
                continue;
            }
            this.g3d.fillCylinder((byte)2, n4, this.originScreen, this.axisScreens[n5]);
        }
        if (n2 == 3) {
            this.colix = this.viewer.getColixBackgroundContrast();
            this.g3d.setColix(this.colix);
            this.renderLabel("0", axes.font3d, this.originScreen.x, this.originScreen.y, this.originScreen.z);
        }
    }

    private void renderLabel(String string, Font3D font3D, int n, int n2, int n3) {
        FontMetrics fontMetrics = font3D.fontMetrics;
        int n4 = fontMetrics.getAscent();
        int n5 = fontMetrics.stringWidth(string);
        int n6 = this.viewer.getBoundBoxCenterX();
        int n7 = this.viewer.getBoundBoxCenterY();
        if (this.antialias) {
            n5 <<= 1;
            n4 <<= 1;
            n6 <<= 1;
            n7 <<= 1;
        }
        int n8 = n - n6;
        int n9 = n2 - n7;
        if (n8 != 0 || n9 != 0) {
            float f = (float)Math.sqrt(n8 * n8 + n9 * n9);
            n8 = (int)((float)n5 * 0.75f * (float)n8 / f);
            n9 = (int)((float)n4 * 0.75f * (float)n9 / f);
            n += n8;
            n2 += n9;
        }
        int n10 = n - n5 / 2;
        int n11 = n2 + n4 / 2;
        this.g3d.drawString(string, font3D, n10, n11, n3, n3);
    }
}

