/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import java.util.BitSet;
import java.util.Hashtable;
import java.util.Vector;
import javax.vecmath.Point3f;
import org.jmol.g3d.Font3D;
import org.jmol.g3d.Graphics3D;
import org.jmol.modelset.Atom;
import org.jmol.modelset.ModelSet;
import org.jmol.shape.Closest;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.StateManager;
import org.jmol.viewer.Viewer;

public abstract class Shape {
    public Viewer viewer;
    public ModelSet modelSet;
    protected Graphics3D g3d;
    public int shapeID;
    public int myVisibilityFlag;
    protected float translucentLevel;
    protected boolean translucentAllowed = true;
    public boolean isBioShape;

    public Viewer getViewer() {
        return this.viewer;
    }

    public final void initializeShape(Viewer viewer, Graphics3D graphics3D, ModelSet modelSet, int n) {
        this.viewer = viewer;
        this.g3d = graphics3D;
        this.shapeID = n;
        this.myVisibilityFlag = JmolConstants.getShapeVisibilityFlag(n);
        this.setModelSet(modelSet);
        this.initShape();
    }

    public void setModelSet(ModelSet modelSet) {
        this.modelSet = modelSet;
        this.initModelSet();
    }

    protected void initModelSet() {
    }

    public void initShape() {
    }

    public void setSize(int n, BitSet bitSet) {
    }

    public void setProperty(String string, Object object, BitSet bitSet) {
        if (string == "translucentLevel") {
            this.translucentLevel = ((Float)object).floatValue();
            return;
        }
        Logger.warn("unassigned " + JmolConstants.shapeClassBases[this.shapeID] + " + shape setProperty:" + string + ":" + object);
    }

    public Object getProperty(String string, int n) {
        return null;
    }

    public boolean wasClicked(int n, int n2) {
        return false;
    }

    public void findNearestAtomIndex(int n, int n2, Closest closest) {
    }

    public void checkBoundsMinMax(Point3f point3f, Point3f point3f2) {
    }

    public void setModelClickability() {
    }

    public boolean checkObjectClicked(int n, int n2, int n3) {
        return false;
    }

    public boolean checkObjectHovered(int n, int n2) {
        return false;
    }

    public boolean checkObjectDragged(int n, int n2, int n3, int n4, int n5) {
        return false;
    }

    public short setColix(short s, byte by, int n) {
        return this.setColix(s, by, this.modelSet.getAtomAt(n));
    }

    protected short setColix(short s, byte by, Atom atom) {
        return s == 2 ? this.viewer.getColixAtomPalette(atom, by) : s;
    }

    protected void remapColors() {
    }

    public Vector getShapeDetail() {
        return null;
    }

    public String getShapeState() {
        return null;
    }

    public void setVisibilityFlags(BitSet bitSet) {
    }

    public static void setStateInfo(Hashtable hashtable, int n, String string) {
        Shape.setStateInfo(hashtable, n, n, string);
    }

    public static void setStateInfo(Hashtable hashtable, int n, int n2, String string) {
        StateManager.setStateInfo(hashtable, n, n2, string);
    }

    public static String getShapeCommands(Hashtable hashtable, Hashtable hashtable2, int n) {
        return StateManager.getCommands(hashtable, hashtable2, n);
    }

    public static String getShapeCommands(Hashtable hashtable, Hashtable hashtable2, int n, String string) {
        return StateManager.getCommands(hashtable, hashtable2, n, string);
    }

    public static void appendCmd(StringBuffer stringBuffer, String string) {
        StateManager.appendCmd(stringBuffer, string);
    }

    public static String getFontCommand(String string, Font3D font3D) {
        if (font3D == null) {
            return "";
        }
        return "font " + string + " " + font3D.fontSize + " " + font3D.fontFace + " " + font3D.fontStyle;
    }

    public String getColorCommand(String string, short s) {
        return this.getColorCommand(string, (byte)-1, s);
    }

    public String getColorCommand(String string, byte by, short s) {
        if (by == -1 && s == 0) {
            return "";
        }
        return "color " + string + " " + this.encodeTransColor(by, s, this.translucentAllowed);
    }

    private String encodeTransColor(byte by, short s, boolean bl) {
        if (by == -1 && s == 0) {
            return "";
        }
        return (bl ? Shape.getTranslucentLabel(s) + " " : "") + (by != -1 && !JmolConstants.isPaletteVariable(by) ? JmolConstants.getPaletteName(by) : this.encodeColor(s));
    }

    String encodeColor(short s) {
        return Graphics3D.isColixColorInherited(s) ? "none" : Escape.escapeColor(this.g3d.getColixArgb(s));
    }

    private static String getTranslucentLabel(short s) {
        return Graphics3D.isColixTranslucent(s) ? "translucent " + Graphics3D.getColixTranslucencyLevel(s) : "opaque";
    }

    public static short getColix(short[] sArray, int n, Atom atom) {
        return Graphics3D.getColixInherited(sArray == null || n >= sArray.length ? (short)0 : sArray[n], atom.getColix());
    }
}

