/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapebio;

import java.util.BitSet;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix3f;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Vector3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.modelset.Atom;
import org.jmol.modelsetbio.AlphaMonomer;
import org.jmol.modelsetbio.CarbohydratePolymer;
import org.jmol.modelsetbio.Monomer;
import org.jmol.modelsetbio.NucleicPolymer;
import org.jmol.modelsetbio.ProteinStructure;
import org.jmol.shape.Mesh;
import org.jmol.shape.MeshRenderer;
import org.jmol.shapebio.BioShape;
import org.jmol.shapebio.BioShapeCollection;
import org.jmol.shapebio.TraceRenderer;

abstract class BioShapeRenderer
extends MeshRenderer {
    int aspectRatio;
    int hermiteLevel;
    float sheetSmoothing;
    boolean isHighRes;
    boolean isTraceAlpha;
    boolean isNucleic;
    boolean isCarbohydrate;
    boolean ribbonBorder = false;
    BitSet bsVisible = new BitSet();
    Point3i[] ribbonTopScreens;
    Point3i[] ribbonBottomScreens;
    Mesh[] meshes;
    boolean[] meshReady;
    int monomerCount;
    Monomer[] monomers;
    Point3f[] controlPoints;
    Point3i[] controlPointScreens;
    boolean haveControlPointScreens;
    Vector3f[] wingVectors;
    short[] mads;
    short[] colixes;
    int[] leadAtomIndices;
    byte[] structureTypes;
    final Point3f pointT = new Point3f();
    int iPrev;
    int iNext;
    int iNext2;
    int iNext3;
    int diameterBeg;
    int diameterMid;
    int diameterEnd;
    boolean doCap0;
    boolean doCap1;
    final Point3i screenArrowTop = new Point3i();
    final Point3i screenArrowTopPrev = new Point3i();
    final Point3i screenArrowBot = new Point3i();
    final Point3i screenArrowBotPrev = new Point3i();
    static final int ABSOLUTE_MIN_MESH_SIZE = 3;
    static final int MIN_MESH_RENDER_SIZE = 8;
    Point3f[] controlHermites;
    Vector3f[] wingHermites;
    Point3f[] radiusHermites;
    final Vector3f Z = new Vector3f(0.1345f, 0.5426f, 0.3675f);
    Vector3f norm = new Vector3f();
    final Vector3f wing = new Vector3f();
    final Vector3f wing0 = new Vector3f();
    final Vector3f wing1 = new Vector3f();
    final Vector3f wingT = new Vector3f();
    final AxisAngle4f aa = new AxisAngle4f();
    final Point3f pt = new Point3f();
    final Point3f pt1 = new Point3f();
    final Point3f ptPrev = new Point3f();
    final Point3f ptNext = new Point3f();
    final Matrix3f mat = new Matrix3f();

    BioShapeRenderer() {
    }

    protected void render() {
        if (this.shape == null) {
            return;
        }
        BioShapeCollection bioShapeCollection = (BioShapeCollection)this.shape;
        int n = bioShapeCollection.bioShapes.length;
        while (--n >= 0) {
            BioShape bioShape = bioShapeCollection.getBioShape(n);
            if ((bioShape.modelVisibilityFlags & this.myVisibilityFlag) == 0 || bioShape.monomerCount < 2 || !this.initializePolymer(bioShape)) continue;
            this.renderBioShape(bioShape);
            this.freeTempArrays();
        }
    }

    private void freeTempArrays() {
        if (this.haveControlPointScreens) {
            this.viewer.freeTempScreens(this.controlPointScreens);
        }
        this.viewer.freeTempBytes(this.structureTypes);
    }

    protected abstract void renderBioShape(BioShape var1);

    private boolean initializePolymer(BioShape bioShape) {
        float f;
        boolean bl = false;
        boolean bl2 = this.viewer.getHighResolution();
        if (bl2 != this.isHighRes) {
            bl = true;
        }
        this.isHighRes = bl2;
        boolean bl3 = bl2 = this.viewer.isJmolDataFrame(bioShape.modelIndex) || this.viewer.getTraceAlpha();
        if (bl2 != this.isTraceAlpha) {
            bl = true;
        }
        this.isTraceAlpha = bl2;
        int n = this.viewer.getRibbonAspectRatio();
        if ((n = Math.min(Math.max(0, n), 20)) != this.aspectRatio && n != 0) {
            bl = true;
        }
        this.aspectRatio = n;
        n = this.viewer.getHermiteLevel();
        int n2 = n <= 0 ? -n : (n = this.viewer.getInMotion() ? 0 : n);
        if (n != this.hermiteLevel && n != 0) {
            bl = true;
        }
        this.hermiteLevel = Math.min(n, 8);
        if (this.hermiteLevel == 0) {
            this.aspectRatio = 0;
        }
        float f2 = f = this.viewer.isJmolDataFrame(bioShape.modelIndex) ? 0.0f : this.viewer.getSheetSmoothing();
        if (f != this.sheetSmoothing && this.isTraceAlpha) {
            this.sheetSmoothing = f;
            bl = true;
        }
        this.controlPoints = bioShape.bioPolymer.getControlPoints(this.isTraceAlpha, this.sheetSmoothing);
        this.monomerCount = bioShape.monomerCount;
        this.monomers = bioShape.monomers;
        this.leadAtomIndices = bioShape.bioPolymer.getLeadAtomIndices();
        this.bsVisible.clear();
        boolean bl4 = false;
        int n3 = this.monomerCount;
        while (--n3 >= 0) {
            if (bl) {
                bioShape.falsifyMesh(n3, false);
            }
            if ((this.monomers[n3].shapeVisibilityFlags & this.myVisibilityFlag) == 0 || this.modelSet.isAtomHidden(this.leadAtomIndices[n3])) continue;
            Atom atom = this.modelSet.atoms[this.leadAtomIndices[n3]];
            if (!this.g3d.isInDisplayRange(atom.screenX, atom.screenY)) continue;
            this.bsVisible.set(n3);
            bl4 = true;
        }
        if (!bl4) {
            return false;
        }
        this.ribbonBorder = this.viewer.getRibbonBorder();
        this.isNucleic = bioShape.bioPolymer instanceof NucleicPolymer;
        this.isCarbohydrate = bioShape.bioPolymer instanceof CarbohydratePolymer;
        this.haveControlPointScreens = false;
        this.wingVectors = bioShape.wingVectors;
        this.meshReady = bioShape.meshReady;
        this.meshes = bioShape.meshes;
        this.mads = bioShape.mads;
        this.colixes = bioShape.colixes;
        this.setStructureTypes();
        return true;
    }

    private void setStructureTypes() {
        this.structureTypes = this.viewer.allocTempBytes(this.monomerCount + 1);
        int n = this.monomerCount;
        while (--n >= 0) {
            this.structureTypes[n] = this.monomers[n].getProteinStructureType();
            if (this.structureTypes[n] != 1) continue;
            this.structureTypes[n] = 0;
        }
        this.structureTypes[this.monomerCount] = this.structureTypes[this.monomerCount - 1];
    }

    boolean isHelix(int n) {
        return this.structureTypes[n] == 3;
    }

    boolean isSheet(int n) {
        return this.structureTypes[n] == 2;
    }

    void calcScreenControlPoints() {
        this.calcScreenControlPoints(this.controlPoints);
    }

    void calcScreenControlPoints(Point3f[] point3fArray) {
        int n = this.monomerCount + 1;
        this.controlPointScreens = this.viewer.allocTempScreens(n);
        int n2 = n;
        while (--n2 >= 0) {
            this.viewer.transformPoint(point3fArray[n2], this.controlPointScreens[n2]);
        }
        this.haveControlPointScreens = true;
    }

    Point3i[] calcScreens(float f) {
        int n = this.controlPoints.length;
        Point3i[] point3iArray = this.viewer.allocTempScreens(n);
        if (f == 0.0f) {
            int n2 = n;
            while (--n2 >= 0) {
                this.viewer.transformPoint(this.controlPoints[n2], point3iArray[n2]);
            }
        } else {
            float f2 = f / 1000.0f;
            int n3 = n;
            while (--n3 >= 0) {
                this.calc1Screen(this.controlPoints[n3], this.wingVectors[n3], this.mads[n3] == 0 && n3 > 0 ? this.mads[n3 - 1] : this.mads[n3], f2, point3iArray[n3]);
            }
        }
        return point3iArray;
    }

    private void calc1Screen(Point3f point3f, Vector3f vector3f, short s, float f, Point3i point3i) {
        this.pointT.set(vector3f);
        float f2 = (float)s * f;
        this.pointT.scaleAdd(f2, point3f);
        this.viewer.transformPoint(this.pointT, point3i);
    }

    short getLeadColix(int n) {
        return Graphics3D.getColixInherited(this.colixes[n], this.monomers[n].getLeadAtom().getColix());
    }

    private void setNeighbors(int n) {
        this.iPrev = Math.max(n - 1, 0);
        this.iNext = Math.min(n + 1, this.monomerCount);
        this.iNext2 = Math.min(n + 2, this.monomerCount);
        this.iNext3 = Math.min(n + 3, this.monomerCount);
    }

    final void renderHermiteCylinder(Point3i[] point3iArray, int n) {
        this.colix = this.getLeadColix(n);
        if (!this.g3d.setColix(this.colix)) {
            return;
        }
        this.setNeighbors(n);
        this.g3d.drawHermite(this.isNucleic ? 4 : 7, point3iArray[this.iPrev], point3iArray[n], point3iArray[this.iNext], point3iArray[this.iNext2]);
    }

    private boolean setMads(int n, boolean bl) {
        this.madBeg = this.madEnd = this.mads[n];
        this.madMid = this.madEnd;
        if (this.isTraceAlpha) {
            if (!bl || this.structureTypes[n] == this.structureTypes[this.iNext]) {
                this.madEnd = this.mads[this.iNext];
                if (this.madEnd == 0) {
                    this.madEnd = this instanceof TraceRenderer ? this.madBeg : this.madBeg;
                }
                this.madMid = (short)(this.madBeg + this.madEnd >> 1);
            }
        } else {
            if (!bl || this.structureTypes[n] == this.structureTypes[this.iPrev]) {
                this.madBeg = (short)((this.mads[this.iPrev] == 0 ? this.madMid : this.mads[this.iPrev]) + this.madMid >> 1);
            }
            if (!bl || this.structureTypes[n] == this.structureTypes[this.iNext]) {
                this.madEnd = (short)((this.mads[this.iNext] == 0 ? this.madMid : this.mads[this.iNext]) + this.madMid >> 1);
            }
        }
        this.doCap0 = n == this.iPrev || bl && this.structureTypes[n] != this.structureTypes[this.iPrev];
        this.doCap1 = this.iNext == this.iNext2 || bl && this.structureTypes[n] != this.structureTypes[this.iNext];
        this.diameterBeg = this.viewer.scaleToScreen(this.controlPointScreens[n].z, this.madBeg);
        this.diameterMid = this.viewer.scaleToScreen(this.monomers[n].getLeadAtom().screenZ, this.madMid);
        this.diameterEnd = this.viewer.scaleToScreen(this.controlPointScreens[this.iNext].z, this.madEnd);
        return this.aspectRatio > 0 && (this.checkDiameter(this.diameterBeg) || this.checkDiameter(this.diameterMid) || this.checkDiameter(this.diameterEnd));
    }

    private boolean checkDiameter(int n) {
        return this.isHighRes & n > 3 || n >= 8;
    }

    final void renderHermiteConic(int n, boolean bl) {
        this.setNeighbors(n);
        this.colix = this.getLeadColix(n);
        if (!this.g3d.setColix(this.colix)) {
            return;
        }
        if (this.setMads(n, bl)) {
            try {
                if (!(this.meshes[n] != null && this.meshReady[n] || this.createMeshCylinder(n, this.madBeg, this.madMid, this.madEnd, 1))) {
                    return;
                }
                this.meshes[n].setColix(this.colix);
                this.render1(this.meshes[n]);
                return;
            }
            catch (Exception exception) {
                System.out.println("render mesh error hermiteConic: " + exception.toString());
            }
        }
        this.g3d.fillHermite(this.isNucleic ? 4 : 7, this.diameterBeg, this.diameterMid, this.diameterEnd, this.controlPointScreens[this.iPrev], this.controlPointScreens[n], this.controlPointScreens[this.iNext], this.controlPointScreens[this.iNext2]);
    }

    final void renderHermiteRibbon(boolean bl, int n, boolean bl2) {
        this.setNeighbors(n);
        this.colix = this.getLeadColix(n);
        if (!this.g3d.setColix(this.colix)) {
            return;
        }
        if (bl && this.aspectRatio != 0 && this.setMads(n, bl2)) {
            try {
                if (!(this.meshes[n] != null && this.meshReady[n] || this.createMeshCylinder(n, this.madBeg, this.madMid, this.madEnd, this.aspectRatio))) {
                    return;
                }
                this.meshes[n].setColix(this.colix);
                this.render1(this.meshes[n]);
                return;
            }
            catch (Exception exception) {
                System.out.println("render mesh error hermiteRibbon: " + exception.toString());
            }
        }
        this.g3d.drawHermite(bl, this.ribbonBorder, this.isNucleic ? 4 : 7, this.ribbonTopScreens[this.iPrev], this.ribbonTopScreens[n], this.ribbonTopScreens[this.iNext], this.ribbonTopScreens[this.iNext2], this.ribbonBottomScreens[this.iPrev], this.ribbonBottomScreens[n], this.ribbonBottomScreens[this.iNext], this.ribbonBottomScreens[this.iNext2], this.aspectRatio);
    }

    final void renderHermiteArrowHead(int n) {
        this.colix = this.getLeadColix(n);
        if (!this.g3d.setColix(this.colix)) {
            return;
        }
        this.setNeighbors(n);
        if (this.setMads(n, false)) {
            try {
                this.doCap0 = true;
                this.doCap1 = false;
                if (!(this.meshes[n] != null && this.meshReady[n] || this.createMeshCylinder(n, (int)((double)this.madBeg * 1.2), (int)((double)this.madBeg * 0.6), 0, this.aspectRatio >> 1))) {
                    return;
                }
                this.meshes[n].setColix(this.colix);
                this.render1(this.meshes[n]);
                return;
            }
            catch (Exception exception) {
                System.out.println("render mesh error hermiteArrowHead: " + exception.toString());
            }
        }
        this.calc1Screen(this.controlPoints[n], this.wingVectors[n], this.madBeg, 7.0E-4f, this.screenArrowTop);
        this.calc1Screen(this.controlPoints[n], this.wingVectors[n], this.madBeg, -7.0E-4f, this.screenArrowBot);
        this.calc1Screen(this.controlPoints[n], this.wingVectors[n], this.madBeg, 0.001f, this.screenArrowTopPrev);
        this.calc1Screen(this.controlPoints[n], this.wingVectors[n], this.madBeg, -0.001f, this.screenArrowBotPrev);
        this.g3d.drawHermite(true, this.ribbonBorder, this.isNucleic ? 4 : 7, this.screenArrowTopPrev, this.screenArrowTop, this.controlPointScreens[this.iNext], this.controlPointScreens[this.iNext2], this.screenArrowBotPrev, this.screenArrowBot, this.controlPointScreens[this.iNext], this.controlPointScreens[this.iNext2], this.aspectRatio);
        if (this.ribbonBorder && this.aspectRatio == 0) {
            this.g3d.fillCylinder(this.colix, this.colix, (byte)3, this.isGenerator ? 50 : 3, this.screenArrowTop.x, this.screenArrowTop.y, this.screenArrowTop.z, this.screenArrowBot.x, this.screenArrowBot.y, this.screenArrowBot.z);
        }
    }

    void renderCone(int n, Point3f point3f, Point3f point3f2, Point3f point3f3, Point3f point3f4) {
        int n2 = this.mad + (this.mad >> 2);
        n2 = this.viewer.scaleToScreen((int)Math.floor(point3f3.z), n2);
        this.g3d.fillCone((byte)2, n2, point3f3, point3f4);
    }

    private boolean createMeshCylinder(int n, int n2, int n3, int n4, int n5) {
        int n6;
        boolean bl;
        this.setNeighbors(n);
        if (this.controlPoints[n].distance(this.controlPoints[this.iNext]) == 0.0f) {
            return false;
        }
        if (this.isHelix(n)) {
            ProteinStructure proteinStructure = ((AlphaMonomer)this.monomers[n]).getProteinStructure();
            proteinStructure.calcAxis();
        }
        boolean bl2 = n5 != 1 && this.wingVectors != null;
        int n7 = (this.hermiteLevel + 1) * 2 + 1;
        int n8 = (n7 - 1) * 2 - 2;
        Mesh mesh = this.meshes[n] = new Mesh("mesh_" + this.shapeID + "_" + n, this.g3d, 0);
        boolean bl3 = bl = n2 != n3 || n3 != n4;
        if (this.controlHermites == null || this.controlHermites.length < n7 + 1) {
            this.controlHermites = new Point3f[n7 + 1];
        }
        Graphics3D.getHermiteList(this.isNucleic ? 4 : 7, this.controlPoints[this.iPrev], this.controlPoints[n], this.controlPoints[this.iNext], this.controlPoints[this.iNext2], this.controlPoints[this.iNext3], this.controlHermites, 0, n7);
        if (bl2) {
            if (this.wingHermites == null || this.wingHermites.length < n7 + 1) {
                this.wingHermites = new Vector3f[n7 + 1];
            }
            this.wing.set(this.wingVectors[this.iPrev]);
            if (n4 == 0) {
                this.wing.scale(2.0f);
            }
            Graphics3D.getHermiteList(this.isNucleic ? 4 : 7, this.wing, this.wingVectors[n], this.wingVectors[this.iNext], this.wingVectors[this.iNext2], this.wingVectors[this.iNext3], this.wingHermites, 0, n7);
        }
        float f = (float)n2 / 2000.0f;
        float f2 = (float)n3 / 2000.0f;
        float f3 = (float)n4 / 2000.0f;
        if (bl) {
            if (this.radiusHermites == null || this.radiusHermites.length < (n7 + 1 >> 1) + 1) {
                this.radiusHermites = new Point3f[(n7 + 1 >> 1) + 1];
            }
            this.ptPrev.set(f, f, 0.0f);
            this.pt.set(f, f2, 0.0f);
            this.pt1.set(f2, f3, 0.0f);
            this.ptNext.set(f3, f3, 0.0f);
            Graphics3D.getHermiteList(4, this.ptPrev, this.pt, this.pt1, this.ptNext, this.ptNext, this.radiusHermites, 0, n7 + 1 >> 1);
        }
        if (!bl2) {
            this.norm.sub(this.controlHermites[1], this.controlHermites[0]);
            this.wing0.cross(this.norm, this.Z);
            this.wing0.cross(this.norm, this.wing0);
        }
        int n9 = 0;
        int n10 = n7 >> 1;
        for (n6 = 0; n6 < n7; ++n6) {
            int n11;
            this.norm.sub(this.controlHermites[n6 + 1], this.controlHermites[n6]);
            if (bl2) {
                this.wing.set(this.wingHermites[n6]);
                this.wing1.set(this.wing);
                this.wing.scale(2.0f / (float)n5);
            } else {
                this.wing.cross(this.norm, this.wing0);
                this.wing.normalize();
            }
            float f4 = !bl ? f : (n6 < n10 ? this.radiusHermites[n6].x : this.radiusHermites[n6 - n10].y);
            this.wing.scale(f4);
            this.wing1.scale(f4);
            this.aa.set(this.norm, (float)(Math.PI * 2 / (double)n8));
            this.mat.set(this.aa);
            this.pt1.set(this.controlHermites[n6]);
            for (n11 = 0; n11 < n8; ++n11) {
                this.mat.transform(this.wing);
                this.wingT.set(this.wing);
                if (bl2) {
                    if (n11 == (n8 + 2) / 4 || n11 == (3 * n8 + 2) / 4) {
                        this.wing1.scale(-1.0f);
                    }
                    this.wingT.add(this.wing1);
                }
                this.pt.add(this.pt1, this.wingT);
                if (bl2) {
                    // empty if block
                }
                mesh.addVertexCopy(this.pt);
            }
            if (n6 > 0) {
                for (n11 = 0; n11 < n8; ++n11) {
                    mesh.addQuad(n9 - n8 + n11, n9 - n8 + (n11 + 1) % n8, n9 + (n11 + 1) % n8, n9 + n11);
                }
            }
            n9 += n8;
        }
        if (this.doCap0) {
            n6 = this.hermiteLevel * 2;
            while (--n6 >= 0) {
                mesh.addQuad(n6 + 2, n6 + 1, (n8 - n6) % n8, n8 - n6 - 1);
            }
        }
        if (this.doCap1) {
            n6 = this.hermiteLevel * 2;
            while (--n6 >= 0) {
                mesh.addQuad(n9 - n6 - 1, n9 - n8 + (n8 - n6) % n8, n9 - n8 + n6 + 1, n9 - n8 + n6 + 2);
            }
        }
        mesh.initialize(0);
        mesh.setVisibilityFlags(1);
        this.meshReady[n] = true;
        return true;
    }

    void createMeshCone(int n, Point3f point3f, Point3f point3f2, int n2) {
        int n3;
        int n4 = 5;
        int n5 = (n4 + 1) * 2 + 1;
        int n6 = (n5 - 1) * 2 - 2;
        this.norm.sub(point3f2, point3f);
        this.norm.normalize();
        this.norm.scale(0.19f);
        this.wing.cross(this.Z, this.norm);
        this.wing.normalize();
        this.wing.scale((float)n2 * 1.2f / 2000.0f);
        Mesh mesh = this.meshes[n] = new Mesh("mesh_" + this.shapeID + "_" + n, this.g3d, 0);
        this.aa.set(this.norm, (float)(Math.PI * 2 / (double)n6));
        this.mat.set(this.aa);
        this.pt1.set(point3f);
        this.pt1.sub(this.norm);
        for (n3 = 0; n3 < n6; ++n3) {
            this.mat.transform(this.wing);
            this.pt.add(this.pt1, this.wing);
            mesh.addVertexCopy(this.pt);
        }
        mesh.addVertexCopy(point3f2);
        for (n3 = 0; n3 < n6; ++n3) {
            mesh.addTriangle((n3 + 1) % n6, n6, n3);
        }
        n3 = n4 * 2;
        while (--n3 >= 0) {
            mesh.addQuad(n3 + 2, n3 + 1, (n6 - n3) % n6, n6 - n3 - 1);
        }
        mesh.initialize(0);
        this.meshReady[n] = true;
        mesh.setVisibilityFlags(1);
    }
}

