/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapespecial;

import java.text.NumberFormat;
import org.jmol.shapespecial.IsosurfaceMesh;
import org.jmol.shapespecial.IsosurfaceRenderer;
import org.jmol.shapespecial.MolecularOrbital;

public class MolecularOrbitalRenderer
extends IsosurfaceRenderer {
    private NumberFormat nf;
    private byte fid;

    protected void render() {
        this.antialias = this.g3d.isAntialiased();
        MolecularOrbital molecularOrbital = (MolecularOrbital)this.shape;
        int n = molecularOrbital.meshCount;
        while (--n >= 0) {
            this.imesh = (IsosurfaceMesh)molecularOrbital.meshes[n];
            if (!this.render1(this.imesh)) continue;
            this.renderInfo();
        }
    }

    private void renderInfo() {
        if (this.mesh.title == null || this.isGenerator || !this.g3d.setColix(this.viewer.getColixBackgroundContrast())) {
            return;
        }
        if (this.nf == null) {
            this.nf = NumberFormat.getInstance();
            this.fid = this.g3d.getFontFid("Monospaced", 14);
        }
        if (this.nf != null) {
            this.nf.setMaximumFractionDigits(3);
            this.nf.setMinimumFractionDigits(3);
        }
        this.g3d.setFont(this.fid);
        int n = 15;
        int n2 = 5;
        if (this.antialias) {
            n <<= 1;
            n2 <<= 1;
        }
        int n3 = n;
        for (int i = 0; i < this.mesh.title.length; ++i) {
            if (this.mesh.title[i].length() <= 0) continue;
            this.g3d.drawStringNoSlab(this.mesh.title[i], null, n2, n3, 0);
            n3 += n;
        }
    }
}

