/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.awt.Component;
import java.awt.Event;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import org.jmol.modelset.Measurement;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;

public abstract class MouseManager
implements KeyListener {
    Viewer viewer;
    Thread hoverWatcherThread;
    int previousDragX;
    int previousDragY;
    int xCurrent;
    int yCurrent;
    long timeCurrent;
    boolean measurementMode = false;
    boolean drawMode = false;
    boolean measuresEnabled = true;
    boolean hoverActive = false;
    boolean rubberbandSelectionMode = false;
    int xAnchor;
    int yAnchor;
    static final Rectangle rectRubber = new Rectangle();
    private static final boolean logMouseEvents = false;
    static final long MAX_DOUBLE_CLICK_MILLIS = 700L;
    static final int LEFT = 16;
    static final int MIDDLE = 8;
    static final int ALT = 8;
    static final int RIGHT = 4;
    static final int CTRL = 2;
    public static final int SHIFT = 1;
    static final int MIDDLE_RIGHT = 12;
    static final int LEFT_MIDDLE_RIGHT = 28;
    static final int CTRL_SHIFT = 3;
    static final int CTRL_LEFT = 18;
    static final int CTRL_RIGHT = 6;
    static final int CTRL_MIDDLE = 10;
    static final int CTRL_ALT_LEFT = 26;
    public static final int ALT_LEFT = 24;
    public static final int ALT_SHIFT_LEFT = 25;
    public static final int SHIFT_LEFT = 17;
    static final int CTRL_SHIFT_LEFT = 19;
    static final int CTRL_ALT_SHIFT_LEFT = 27;
    static final int SHIFT_MIDDLE = 9;
    static final int CTRL_SHIFT_MIDDLE = 11;
    static final int SHIFT_RIGHT = 5;
    static final int CTRL_SHIFT_RIGHT = 7;
    static final int CTRL_ALT_SHIFT_RIGHT = 15;
    public static final int BUTTON_MODIFIER_MASK = 31;
    int previousPressedX;
    int previousPressedY;
    int previousPressedModifiers;
    long previousPressedTime;
    int pressedCount;
    int previousClickX;
    int previousClickY;
    int previousClickModifiers;
    int previousClickCount;
    long previousClickTime;
    int mouseMovedX;
    int mouseMovedY;
    long mouseMovedTime;
    static final float wheelClickFractionUp = 1.25f;
    static final float wheelClickFractionDown = 0.8f;
    int measurementCount = 0;
    int[] measurementCountPlusIndices = new int[5];

    MouseManager(Viewer viewer) {
        this.viewer = viewer;
        Component component = viewer.getAwtComponent();
        if (component != null) {
            component.addKeyListener(this);
        }
    }

    void clear() {
        this.startHoverWatcher(false);
    }

    synchronized void startHoverWatcher(boolean bl) {
        if (bl) {
            if (this.hoverWatcherThread != null) {
                return;
            }
            this.hoverWatcherThread = new Thread(new HoverWatcher());
            this.hoverWatcherThread.start();
        } else {
            if (this.hoverWatcherThread == null) {
                return;
            }
            this.hoverWatcherThread.interrupt();
            this.hoverWatcherThread = null;
        }
    }

    void removeMouseListeners11() {
    }

    void removeMouseListeners14() {
    }

    void setModeMouse(int n) {
        if (n == -1) {
            this.startHoverWatcher(false);
            Component component = this.viewer.getAwtComponent();
            if (component == null) {
                return;
            }
            this.removeMouseListeners11();
            this.removeMouseListeners14();
            component.removeKeyListener(this);
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (!this.viewer.getNavigationMode()) {
            return;
        }
        int n = keyEvent.getKeyCode();
        int n2 = keyEvent.getModifiers();
        if (this.viewer.getBooleanProperty("showKeyStrokes", false)) {
            this.viewer.script("!set echo bottom left;!echo " + (n == 0 ? "" : n + " " + n2));
        }
        switch (n) {
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                this.viewer.navigate(n, n2);
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (!this.viewer.getNavigationMode()) {
            return;
        }
        if (this.viewer.getBooleanProperty("showKeyStrokes", false)) {
            this.viewer.script("!set echo bottom left;!echo;");
        }
        int n = keyEvent.getKeyCode();
        switch (n) {
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                this.viewer.navigate(0, 0);
            }
        }
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
    }

    Rectangle getRubberBand() {
        if (!this.rubberbandSelectionMode) {
            return null;
        }
        return rectRubber;
    }

    void calcRectRubberBand() {
        if (this.xCurrent < this.xAnchor) {
            MouseManager.rectRubber.x = this.xCurrent;
            MouseManager.rectRubber.width = this.xAnchor - this.xCurrent;
        } else {
            MouseManager.rectRubber.x = this.xAnchor;
            MouseManager.rectRubber.width = this.xCurrent - this.xAnchor;
        }
        if (this.yCurrent < this.yAnchor) {
            MouseManager.rectRubber.y = this.yCurrent;
            MouseManager.rectRubber.height = this.yAnchor - this.yCurrent;
        } else {
            MouseManager.rectRubber.y = this.yAnchor;
            MouseManager.rectRubber.height = this.yCurrent - this.yAnchor;
        }
    }

    void mousePressed(long l, int n, int n2, int n3, boolean bl) {
        this.pressedCount = this.previousPressedX == n && this.previousPressedY == n2 && this.previousPressedModifiers == n3 && l - this.previousPressedTime < 700L ? ++this.pressedCount : 1;
        this.hoverOff();
        this.previousDragX = this.xCurrent = n;
        this.previousPressedX = this.xCurrent;
        this.previousDragY = this.yCurrent = n2;
        this.previousPressedY = this.yCurrent;
        this.previousPressedModifiers = n3;
        this.previousPressedTime = this.timeCurrent = l;
        switch (n3 & 0x1F) {
            case 4: 
            case 18: {
                this.viewer.popupMenu(n, n2);
                return;
            }
        }
    }

    void mouseEntered(long l, int n, int n2) {
        this.hoverOff();
        this.timeCurrent = l;
        this.xCurrent = n;
        this.yCurrent = n2;
    }

    void mouseExited(long l, int n, int n2) {
        this.hoverOff();
        this.timeCurrent = l;
        this.xCurrent = n;
        this.yCurrent = n2;
        this.exitMeasurementMode();
    }

    void mouseReleased(long l, int n, int n2, int n3) {
        this.hoverOff();
        this.timeCurrent = l;
        this.xCurrent = n;
        this.yCurrent = n2;
        this.viewer.setInMotion(false);
        this.viewer.setCursor(0);
    }

    void clearClickCount() {
        this.previousClickX = -1;
    }

    void setMouseMode() {
        this.drawMode = false;
        this.measuresEnabled = true;
        switch (this.viewer.getPickingMode()) {
            case 4: {
                this.drawMode = true;
                this.measuresEnabled = false;
                break;
            }
            case 2: 
            case 15: 
            case 16: 
            case 17: {
                this.measuresEnabled = false;
                break;
            }
            default: {
                return;
            }
        }
        this.exitMeasurementMode();
    }

    void mouseClicked(long l, int n, int n2, int n3, int n4) {
        int n5;
        this.setMouseMode();
        n4 = 1;
        if (this.previousClickX == n && this.previousClickY == n2 && this.previousClickModifiers == n3 && l - this.previousClickTime < 700L) {
            n4 = this.previousClickCount + 1;
        }
        if (!this.viewer.getAwtComponent().hasFocus()) {
            this.viewer.getAwtComponent().requestFocusInWindow();
        }
        this.hoverOff();
        this.xCurrent = this.previousClickX = n;
        this.yCurrent = this.previousClickY = n2;
        this.previousClickModifiers = n3;
        this.previousClickCount = n4;
        this.timeCurrent = this.previousClickTime = l;
        if (!this.viewer.haveModelSet()) {
            return;
        }
        int n6 = n5 = this.drawMode ? -1 : this.viewer.findNearestAtomIndex(n, n2);
        if (n5 >= 0 && !this.viewer.isInSelectionSubset(n5)) {
            n5 = -1;
        }
        if (n4 == 1) {
            this.mouseSingleClick(n, n2, n3, n5);
        } else if (n4 == 2) {
            this.mouseDoubleClick(n, n2, n3, n5);
        }
    }

    void mouseSingleClick(int n, int n2, int n3, int n4) {
        this.setMouseMode();
        switch (n3 & 0x1F) {
            case 16: {
                if (this.viewer.frankClicked(n, n2)) {
                    this.viewer.popupMenu(-n, n2);
                    return;
                }
                if (this.viewer.getPickingMode() == 18) {
                    if (this.viewer.getNavigationMode()) {
                        this.viewer.navTranslatePercent(0.0f, (float)n * 100.0f / (float)this.viewer.getScreenWidth() - 50.0f, (float)n2 * 100.0f / (float)this.viewer.getScreenHeight() - 50.0f);
                    }
                    return;
                }
                if (!this.measurementMode) {
                    this.viewer.checkObjectClicked(n, n2, n3);
                }
                this.viewer.atomPicked(n4, n3);
                if (!this.measurementMode) break;
                this.addToMeasurement(n4, false);
                break;
            }
            case 17: 
            case 24: 
            case 25: {
                if (this.drawMode || this.viewer.checkObjectClicked(n, n2, n3)) break;
                this.viewer.atomPicked(n4, n3);
            }
        }
    }

    void mouseDoubleClick(int n, int n2, int n3, int n4) {
        this.setMouseMode();
        switch (n3 & 0x1F) {
            case 16: {
                if (this.measurementMode) {
                    this.addToMeasurement(n4, true);
                    this.toggleMeasurement();
                    break;
                }
                if (this.drawMode || !this.measuresEnabled) break;
                this.enterMeasurementMode();
                this.addToMeasurement(n4, true);
                break;
            }
            case 8: 
            case 17: 
            case 24: {
                if (n4 >= 0) break;
                this.viewer.script("!reset");
            }
        }
    }

    void mouseDragged(long l, int n, int n2, int n3) {
        this.setMouseMode();
        int n4 = n - this.previousDragX;
        int n5 = n2 - this.previousDragY;
        this.hoverOff();
        this.timeCurrent = l;
        this.xCurrent = this.previousDragX = n;
        this.yCurrent = this.previousDragY = n2;
        if (!this.viewer.getInMotion()) {
            this.viewer.setCursor(3);
        }
        this.viewer.setInMotion(true);
        if (this.pressedCount == 1) {
            this.mouseSinglePressDrag(n4, n5, n3);
        } else if (this.pressedCount == 2) {
            this.mouseDoublePressDrag(n4, n5, n3);
        }
    }

    void mouseSinglePressDrag(int n, int n2, int n3) {
        switch (n3 & 0x1F) {
            case 16: {
                this.viewer.rotateXYBy(n, n2);
                break;
            }
            case 24: {
                if (this.viewer.allowRotateSelected()) {
                    this.viewer.rotateMolecule(n, n2);
                    break;
                }
            }
            case 17: 
            case 25: {
                if (this.drawMode) {
                    this.viewer.checkObjectDragged(this.previousDragX, this.previousDragY, n, n2, n3);
                    break;
                }
            }
            case 8: {
                if (Math.abs(n2) > 5 * Math.abs(n)) {
                    this.viewer.zoomBy(n2);
                }
                if (Math.abs(n) <= 5 * Math.abs(n2)) break;
                this.viewer.rotateZBy(-n);
                break;
            }
            case 5: {
                this.viewer.rotateZBy((Math.abs(n2) > 5 * Math.abs(n) ? (this.xCurrent < this.viewer.getScreenWidth() / 2 ? n2 : -n2) : 0) + (this.yCurrent > this.viewer.getScreenHeight() / 2 ? n : -n));
                break;
            }
            case 6: 
            case 26: {
                this.viewer.translateXYBy(n, n2);
                break;
            }
            case 19: {
                if (!this.viewer.getSlabEnabled()) break;
                this.viewer.slabByPixels(n2);
                break;
            }
            case 27: {
                if (!this.viewer.getSlabEnabled()) break;
                this.viewer.slabDepthByPixels(n2);
            }
        }
    }

    void mouseDoublePressDrag(int n, int n2, int n3) {
        switch (n3 & 0x1F) {
            case 8: 
            case 17: 
            case 24: {
                this.viewer.translateXYBy(n, n2);
                break;
            }
            case 19: {
                if (!this.viewer.getSlabEnabled()) break;
                this.viewer.depthByPixels(n2);
            }
        }
    }

    void mouseMoved(long l, int n, int n2, int n3) {
        this.hoverOff();
        if (this.hoverWatcherThread == null) {
            this.startHoverWatcher(true);
        }
        this.timeCurrent = this.mouseMovedTime = l;
        this.mouseMovedX = this.xCurrent = n;
        this.mouseMovedY = this.yCurrent = n2;
        if (this.measurementMode || this.hoverActive) {
            int n4 = this.viewer.findNearestAtomIndex(n, n2);
            if (!this.measurementMode && n4 >= 0 && this.viewer.isInSelectionSubset(n4)) {
                n4 = -1;
            }
            this.setAttractiveMeasurementTarget(n4);
        }
    }

    void mouseWheel(long l, int n, int n2) {
        if (!this.viewer.getAwtComponent().hasFocus()) {
            return;
        }
        this.hoverOff();
        this.timeCurrent = l;
        if (n == 0) {
            return;
        }
        if ((n2 & 0x1F) == 0) {
            float f = this.viewer.getZoomPercentFloat() / 100.0f;
            if (n > 0) {
                while (--n >= 0) {
                    f *= 1.25f;
                }
            } else {
                while (++n <= 0) {
                    f *= 0.8f;
                }
            }
            this.viewer.zoomToPercent(f * 100.0f + 0.5f);
        }
    }

    abstract boolean handleOldJvm10Event(Event var1);

    void setAttractiveMeasurementTarget(int n) {
        int n2;
        if (this.measurementCountPlusIndices[0] == this.measurementCount + 1 && this.measurementCountPlusIndices[this.measurementCount + 1] == n) {
            this.viewer.refresh(0, "MouseManager:setAttractiveMeasurementTarget(" + n + ")");
            return;
        }
        for (n2 = this.measurementCount; n2 > 0; --n2) {
            if (this.measurementCountPlusIndices[n2] != n) continue;
            this.viewer.refresh(0, "MouseManager:setAttractiveMeasurementTarget(" + n + ")");
            return;
        }
        this.measurementCountPlusIndices[0] = n2 = this.measurementCount + 1;
        this.measurementCountPlusIndices[n2] = n;
        this.viewer.setPendingMeasurement(this.measurementCountPlusIndices);
    }

    void addToMeasurement(int n, boolean bl) {
        if (n == -1) {
            this.exitMeasurementMode();
            return;
        }
        int n2 = this.measurementCount;
        while (--n2 >= 0) {
            if (this.measurementCountPlusIndices[n2 + 1] != n) continue;
            return;
        }
        if (this.measurementCount == 3 && !bl) {
            return;
        }
        this.measurementCountPlusIndices[++this.measurementCount] = n;
        this.measurementCountPlusIndices[0] = this.measurementCount;
        if (this.measurementCount == 4) {
            this.toggleMeasurement();
        } else {
            this.viewer.setPendingMeasurement(this.measurementCountPlusIndices);
        }
    }

    void exitMeasurementMode() {
        if (!this.measurementMode) {
            return;
        }
        this.viewer.setPendingMeasurement(null);
        this.measurementMode = false;
        this.measurementCount = 0;
        this.viewer.setCursor(0);
    }

    void enterMeasurementMode() {
        this.viewer.setCursor(2);
        this.measurementCount = 0;
        this.measurementMode = true;
    }

    void toggleMeasurement() {
        if (this.measurementCount >= 2 && this.measurementCount <= 4) {
            this.measurementCountPlusIndices[0] = this.measurementCount;
            this.viewer.script("!" + Measurement.getMeasurementScript(this.measurementCountPlusIndices));
        }
        this.exitMeasurementMode();
    }

    void hoverOn(int n) {
        this.viewer.hoverOn(n);
    }

    void hoverOff() {
        this.viewer.hoverOff();
    }

    class HoverWatcher
    implements Runnable {
        HoverWatcher() {
        }

        public void run() {
            int n;
            Thread.currentThread().setPriority(1);
            while (MouseManager.this.hoverWatcherThread != null && (n = MouseManager.this.viewer.getHoverDelay()) > 0) {
                try {
                    int n2;
                    long l;
                    int n3;
                    Thread.sleep(n);
                    if (MouseManager.this.xCurrent != MouseManager.this.mouseMovedX || MouseManager.this.yCurrent != MouseManager.this.mouseMovedY || MouseManager.this.timeCurrent != MouseManager.this.mouseMovedTime || (n3 = (int)((l = System.currentTimeMillis()) - MouseManager.this.mouseMovedTime)) <= n || MouseManager.this.viewer.getInMotion() || MouseManager.this.viewer.getSpinOn() || MouseManager.this.viewer.checkObjectHovered(MouseManager.this.xCurrent, MouseManager.this.yCurrent) || (n2 = MouseManager.this.viewer.findNearestAtomIndex(MouseManager.this.xCurrent, MouseManager.this.yCurrent)) < 0) continue;
                    MouseManager.this.hoverOn(n2);
                }
                catch (InterruptedException interruptedException) {
                    Logger.debug("Hover InterruptedException!");
                    break;
                }
                catch (Exception exception) {
                    Logger.debug("Hover Exception: " + exception);
                    break;
                }
            }
            MouseManager.this.hoverWatcherThread = null;
        }
    }
}

