/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.applet;

import java.applet.Applet;
import java.applet.AppletContext;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import netscape.javascript.JSObject;
import org.jmol.api.JmolAppletInterface;
import org.jmol.appletwrapper.AppletWrapper;
import org.jmol.util.Logger;

public class JmolAppletRegistry {
    public static Hashtable htRegistry = new Hashtable();
    String name;
    boolean mayScript;
    Applet applet;
    AppletContext appletContext;

    public JmolAppletRegistry(String string, boolean bl, Applet applet) {
        if (string == null || string.length() == 0) {
            string = null;
        }
        this.name = string;
        this.mayScript = bl;
        this.applet = applet;
        this.appletContext = applet.getAppletContext();
        JmolAppletRegistry.checkIn(string, applet);
    }

    public synchronized Enumeration applets() {
        return htRegistry.elements();
    }

    static synchronized void checkIn(String string, Applet applet) {
        JmolAppletRegistry.cleanRegistry();
        Logger.info((String)("AppletRegistry.checkIn(" + string + ")"));
        if (string != null) {
            htRegistry.put(string, applet);
        }
    }

    static synchronized void cleanRegistry() {
        Enumeration enumeration = htRegistry.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            try {
                JmolAppletInterface jmolAppletInterface = (JmolAppletInterface)htRegistry.get(string);
                JSObject jSObject = JSObject.getWindow((Applet)((AppletWrapper)jmolAppletInterface));
                if (jSObject.hashCode() == 0) continue;
            }
            catch (Exception exception) {
                Logger.error((String)("Dereferencing registered applet " + string));
                htRegistry.remove(string);
            }
        }
    }

    JSObject getJsoWindow() {
        JSObject jSObject = null;
        if (this.mayScript) {
            try {
                jSObject = JSObject.getWindow((Applet)this.applet);
            }
            catch (Exception exception) {
                Logger.error((String)"exception trying to get jsoWindow");
            }
        } else {
            Logger.warn((String)("mayScript not specified for:" + this.name));
        }
        return jSObject;
    }

    JSObject getJsoTop() {
        JSObject jSObject = null;
        JSObject jSObject2 = this.getJsoWindow();
        if (jSObject2 != null) {
            try {
                jSObject = (JSObject)jSObject2.getMember("top");
            }
            catch (Exception exception) {
                Logger.error((String)"exception trying to get window.top");
            }
        }
        return jSObject;
    }

    public void script(String string, String string2) {
        this.scriptCallback(string, string2, null);
    }

    public void scriptCallback(String string, String string2, String string3) {
        if (string == null || string.length() == 0) {
            Logger.error((String)"no targetName specified");
            return;
        }
        if (this.tryDirect(string, string2, string3)) {
            return;
        }
        Logger.error((String)("unable to find target:" + string));
    }

    public static synchronized Vector findApplets(String string, String string2, String string3) {
        if (string != null && string.indexOf("[") < 0) {
            string = string + "[" + string2 + "]";
        }
        Vector<String> vector = new Vector<String>();
        if (string != null && htRegistry.containsKey(string)) {
            vector.addElement(string);
            return vector;
        }
        Enumeration enumeration = htRegistry.keys();
        while (enumeration.hasMoreElements()) {
            String string4 = (String)enumeration.nextElement();
            if (string3 != null && string4.equals(string3) || (string != null || string4.indexOf("[" + string2 + "]") <= 0) && !string4.equals(string)) continue;
            vector.addElement(string4);
        }
        return vector;
    }

    private synchronized boolean tryDirect(String string, String string2, String string3) {
        Vector vector;
        Logger.debug((String)"tryDirect trying appletContext");
        Applet applet = this.appletContext.getApplet(string);
        if (applet == null) {
            Logger.debug((String)"... trying registry");
            vector = JmolAppletRegistry.findApplets(string, null, null);
            if (vector.size() > 0) {
                applet = htRegistry.get(vector.elementAt(0));
            }
        }
        if (applet == null) {
            Logger.error((String)("tryDirect failed to find applet:" + string));
            return false;
        }
        if (!(applet instanceof JmolAppletInterface)) {
            Logger.error((String)("target " + string + " is not a JmolApplet"));
            return true;
        }
        vector = (JmolAppletInterface)applet;
        vector.scriptButton(string3 == null ? null : this.getJsoWindow(), this.name, string2, string3);
        return true;
    }
}

