/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapebio;

import java.util.BitSet;
import java.util.Hashtable;
import org.jmol.g3d.Graphics3D;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Model;
import org.jmol.modelsetbio.BioPolymer;
import org.jmol.shape.Closest;
import org.jmol.shape.Shape;
import org.jmol.shapebio.BioShape;
import org.jmol.viewer.JmolConstants;

public abstract class BioShapeCollection
extends Shape {
    Atom[] atoms;
    short madOn = (short)-2;
    short madHelixSheet = (short)3000;
    short madTurnRandom = (short)800;
    short madDnaRna = (short)5000;
    boolean isActive = false;
    BioShape[] bioShapes;

    public final void initModelSet() {
        this.isBioShape = true;
        this.atoms = this.modelSet.atoms;
        this.initialize();
    }

    public void setSize(int n, BitSet bitSet) {
        short s = (short)n;
        this.initialize();
        int n2 = this.bioShapes.length;
        while (--n2 >= 0) {
            BioShape bioShape = this.bioShapes[n2];
            if (bioShape.monomerCount <= 0) continue;
            bioShape.setMad(s, bitSet);
        }
    }

    public void setProperty(String string, Object object, BitSet bitSet) {
        this.initialize();
        if ("color" == string) {
            byte by = JmolConstants.pidOf((Object)object);
            short s = Graphics3D.getColix((Object)object);
            int n = this.bioShapes.length;
            while (--n >= 0) {
                BioShape bioShape = this.bioShapes[n];
                if (bioShape.monomerCount <= 0) continue;
                bioShape.setColix(s, by, bitSet);
            }
            return;
        }
        if ("translucency" == string) {
            boolean bl = "translucent".equals(object);
            int n = this.bioShapes.length;
            while (--n >= 0) {
                BioShape bioShape = this.bioShapes[n];
                if (bioShape.monomerCount <= 0) continue;
                bioShape.setTranslucent(bl, bitSet, this.translucentLevel);
            }
            return;
        }
        super.setProperty(string, object, bitSet);
    }

    public String getShapeState() {
        Hashtable hashtable = new Hashtable();
        Hashtable hashtable2 = new Hashtable();
        int n = this.bioShapes.length;
        while (--n >= 0) {
            BioShape bioShape = this.bioShapes[n];
            if (bioShape.monomerCount <= 0) continue;
            bioShape.setShapeState(hashtable, hashtable2);
        }
        return "\n" + Shape.getShapeCommands(hashtable, hashtable2, (int)this.modelSet.getAtomCount(), (String)(this.shapeID == 8 ? "Backbone" : "select"));
    }

    void initialize() {
        int n = this.modelSet.getModelCount();
        Model[] modelArray = this.modelSet.getModels();
        int n2 = this.modelSet.getBioPolymerCount();
        BioShape[] bioShapeArray = new BioShape[n2];
        int n3 = n2;
        int n4 = n;
        while (--n4 >= 0) {
            int n5 = modelArray[n4].getBioPolymerCount();
            while (--n5 >= 0) {
                if (this.bioShapes == null || this.bioShapes.length <= --n3 || this.bioShapes[n3] == null) {
                    bioShapeArray[n3] = new BioShape(this, n4, (BioPolymer)modelArray[n4].getBioPolymer(n5));
                    continue;
                }
                bioShapeArray[n3] = this.bioShapes[n3];
            }
        }
        this.bioShapes = bioShapeArray;
    }

    public void findNearestAtomIndex(int n, int n2, Closest closest) {
        int n3 = this.bioShapes.length;
        while (--n3 >= 0) {
            BioShape bioShape = this.bioShapes[n3];
            bioShape.bioPolymer.findNearestAtomIndex(n, n2, closest, this.bioShapes[n3].mads, this.myVisibilityFlag);
        }
    }

    public void setVisibilityFlags(BitSet bitSet) {
        if (this.bioShapes == null) {
            return;
        }
        int n = this.bioShapes.length;
        while (--n >= 0) {
            BioShape bioShape = this.bioShapes[n];
            bioShape.modelVisibilityFlags = bitSet.get(bioShape.modelIndex) ? this.myVisibilityFlag : 0;
        }
    }

    public void setModelClickability() {
        if (this.bioShapes == null) {
            return;
        }
        int n = this.bioShapes.length;
        while (--n >= 0) {
            this.bioShapes[n].setModelClickability();
        }
    }

    int getMpsShapeCount() {
        return this.bioShapes.length;
    }

    BioShape getBioShape(int n) {
        return this.bioShapes[n];
    }
}

