/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapebio;

import javax.vecmath.Point3i;
import org.jmol.shape.ShapeRenderer;
import org.jmol.shapebio.BioShape;
import org.jmol.shapebio.BioShapeRenderer;
import org.jmol.shapebio.Strands;

public class StrandsRenderer
extends BioShapeRenderer {
    protected int strandCount;
    protected float strandSeparation;
    protected float baseOffset;

    protected void renderBioShape(BioShape bioShape) {
        if (!this.setStrandCount()) {
            return;
        }
        this.render1();
    }

    protected boolean setStrandCount() {
        if (this.wingVectors == null) {
            return false;
        }
        this.strandCount = ((Strands)((ShapeRenderer)this).shape).strandCount;
        this.strandSeparation = this.strandCount <= 1 ? 0.0f : 1.0f / (float)(this.strandCount - 1);
        this.baseOffset = (this.strandCount & 1) == 0 ? this.strandSeparation / 2.0f : this.strandSeparation;
        return true;
    }

    protected void render1() {
        Point3i[] point3iArray;
        int n = this.strandCount >> 1;
        while (--n >= 0) {
            float f = (float)n * this.strandSeparation + this.baseOffset;
            point3iArray = this.calcScreens(f);
            this.render1Strand(point3iArray);
            ((ShapeRenderer)this).viewer.freeTempScreens(point3iArray);
            point3iArray = this.calcScreens(-f);
            this.render1Strand(point3iArray);
            ((ShapeRenderer)this).viewer.freeTempScreens(point3iArray);
        }
        if (this.strandCount % 2 == 1) {
            point3iArray = this.calcScreens(0.0f);
            this.render1Strand(point3iArray);
            ((ShapeRenderer)this).viewer.freeTempScreens(point3iArray);
        }
    }

    private void render1Strand(Point3i[] point3iArray) {
        int n = this.monomerCount;
        while (--n >= 0) {
            if (!this.bsVisible.get(n)) continue;
            this.renderHermiteCylinder(point3iArray, n);
        }
    }
}

