/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import java.util.BitSet;
import java.util.Hashtable;
import java.util.Vector;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import org.jmol.atomdata.AtomData;
import org.jmol.modelset.ModelCollection;
import org.jmol.shape.Closest;
import org.jmol.shape.Dipoles;
import org.jmol.shape.MeshCollection;
import org.jmol.shape.Shape;
import org.jmol.util.BitSetUtil;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.viewer.JmolConstants;

public abstract class ModelSet
extends ModelCollection {
    private boolean selectionHaloEnabled = false;
    private boolean echoShapeActive = false;
    protected String modelSetTypeName;
    protected Vector trajectories;
    protected boolean isZeroBased;
    protected final Shape[] shapes = new Shape[31];
    protected final Closest closest = new Closest();
    private static final boolean useRasMolHbondsCalculation = true;

    protected void releaseModelSet() {
        for (int i = 0; i < 31; ++i) {
            this.shapes[i] = null;
        }
        this.models = null;
        this.closest.atom = null;
        super.releaseModelSet();
    }

    public void setSelectionHaloEnabled(boolean bl) {
        if (this.selectionHaloEnabled != bl) {
            this.selectionHaloEnabled = bl;
        }
    }

    public boolean getSelectionHaloEnabled() {
        return this.selectionHaloEnabled;
    }

    public boolean getEchoStateActive() {
        return this.echoShapeActive;
    }

    public void setEchoStateActive(boolean bl) {
        this.echoShapeActive = bl;
    }

    public String getModelSetTypeName() {
        return this.modelSetTypeName;
    }

    public int getTrajectoryCount() {
        return this.trajectories == null ? 1 : this.trajectories.size();
    }

    public void setTrajectory(int n) {
        if (this.trajectories == null || n < 0 || n >= this.trajectories.size()) {
            return;
        }
        Point3f[] point3fArray = (Point3f[])this.trajectories.get(n);
        int n2 = this.atomCount;
        while (--n2 >= 0) {
            this.atoms[n2].set((Tuple3f)point3fArray[n2]);
        }
    }

    public void setZeroBased() {
        this.isZeroBased = this.isXYZ && this.viewer.getZeroBasedXyzRasmol();
    }

    private Shape allocateShape(int n) {
        if (n == 2 || n == 3) {
            return null;
        }
        String string = JmolConstants.getShapeClassName(n);
        try {
            Class<?> clazz = Class.forName(string);
            Shape shape = (Shape)clazz.newInstance();
            shape.initializeShape(this.viewer, this.g3d, this, n);
            return shape;
        }
        catch (Exception exception) {
            Logger.error((String)("Could not instantiate shape:" + string), (Throwable)exception);
            return null;
        }
    }

    public Shape getShape(int n) {
        return this.shapes[n];
    }

    public int findNearestAtomIndex(int n, int n2) {
        int n3;
        if (this.atomCount == 0) {
            return -1;
        }
        this.closest.atom = null;
        if (this.g3d.isAntialiased()) {
            n <<= 1;
            n2 <<= 1;
        }
        this.findNearestAtomIndex(n, n2, this.closest);
        for (n3 = 0; n3 < this.shapes.length && this.closest.atom == null; ++n3) {
            if (this.shapes[n3] == null) continue;
            this.shapes[n3].findNearestAtomIndex(n, n2, this.closest);
        }
        n3 = this.closest.atom == null ? -1 : this.closest.atom.atomIndex;
        this.closest.atom = null;
        return n3;
    }

    public void setShapeSize(int n, int n2, BitSet bitSet) {
        if (n2 != 0) {
            this.loadShape(n);
        }
        if (this.shapes[n] != null) {
            this.shapes[n].setSize(n2, bitSet);
        }
    }

    public Shape loadShape(int n) {
        if (this.shapes[n] == null) {
            this.shapes[n] = this.allocateShape(n);
        }
        return this.shapes[n];
    }

    public void setShapeProperty(int n, String string, Object object, BitSet bitSet) {
        if (this.shapes[n] != null) {
            this.shapes[n].setProperty(string.intern(), object, bitSet);
        }
    }

    public Object getShapeProperty(int n, String string, int n2) {
        return this.shapes[n] == null ? null : this.shapes[n].getProperty(string, n2);
    }

    public int getShapeIdFromObjectName(String string) {
        for (int i = 20; i < 25; ++i) {
            MeshCollection meshCollection = (MeshCollection)this.shapes[i];
            if (meshCollection == null || meshCollection.getIndexFromName(string) < 0) continue;
            return i;
        }
        Dipoles dipoles = (Dipoles)this.shapes[7];
        if (dipoles != null && dipoles.getIndexFromName(string) >= 0) {
            return 7;
        }
        return -1;
    }

    public void getBondDipoles() {
        if (this.partialCharges == null) {
            return;
        }
        this.getBondDipoles((Dipoles)this.loadShape(7));
    }

    public void setModelVisibility() {
        int n;
        BitSet bitSet = this.viewer.getVisibleFramesBitSet();
        for (n = 1; n < 31; ++n) {
            if (this.shapes[n] == null) continue;
            this.shapes[n].setVisibilityFlags(bitSet);
        }
        this.shapes[0].setVisibilityFlags(bitSet);
        for (n = 0; n < 31; ++n) {
            Shape shape = this.shapes[n];
            if (shape == null) continue;
            shape.setModelClickability();
        }
    }

    public void fillAtomData(AtomData atomData, int n) {
        if (n == 3) {
            int[] nArray = new int[1];
            atomData.hAtomRadius = (float)JmolConstants.vanderwaalsMars[1] / 1000.0f;
            atomData.hAtoms = this.getAdditionalHydrogens(atomData.bsSelected, nArray);
            atomData.hydrogenAtomCount = nArray[0];
            return;
        }
        atomData.firstAtomIndex = atomData.modelIndex < 0 ? Math.max(0, BitSetUtil.firstSetBit((BitSet)atomData.bsSelected)) : this.getFirstAtomIndexInModel(atomData.modelIndex);
        atomData.firstModelIndex = this.atomCount == 0 ? 0 : (int)this.atoms[atomData.firstAtomIndex].modelIndex;
        atomData.lastModelIndex = atomData.firstModelIndex;
        atomData.modelName = this.getModelNumberDotted(atomData.firstModelIndex);
        super.fillAtomData(atomData, n);
    }

    public boolean frankClicked(int n, int n2) {
        Shape shape = this.shapes[30];
        return shape != null && shape.wasClicked(n, n2);
    }

    public boolean checkObjectHovered(int n, int n2) {
        Shape shape = this.shapes[28];
        if (shape != null && shape.checkObjectHovered(n, n2)) {
            return true;
        }
        shape = this.shapes[20];
        if (shape == null || !this.viewer.getDrawHover()) {
            return false;
        }
        return shape.checkObjectHovered(n, n2);
    }

    public boolean checkObjectClicked(int n, int n2, int n3) {
        Shape shape = this.shapes[28];
        if (shape != null && shape.checkObjectClicked(n, n2, n3)) {
            return true;
        }
        shape = this.shapes[20];
        return shape != null && shape.checkObjectClicked(n, n2, n3);
    }

    public void checkObjectDragged(int n, int n2, int n3, int n4, int n5) {
        Shape shape;
        for (int i = 0; !(i >= 31 || (shape = this.shapes[i]) != null && shape.checkObjectDragged(n, n2, n3, n4, n5)); ++i) {
        }
    }

    public Hashtable getShapeInfo() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < 31; ++i) {
            Shape shape = this.shapes[i];
            if (shape == null) continue;
            String string = JmolConstants.shapeClassBases[i];
            Vector vector = shape.getShapeDetail();
            if (vector == null) continue;
            Hashtable<String, Vector> hashtable2 = new Hashtable<String, Vector>();
            hashtable2.put("obj", vector);
            hashtable.put(string, hashtable2);
        }
        if (stringBuffer.length() > 0) {
            hashtable.put("shapeCommands", stringBuffer.toString());
        }
        return hashtable;
    }

    public void calculatePolymers(int n) {
        super.calculatePolymers(n);
        for (int i = 0; i < this.shapes.length; ++i) {
            if (this.shapes[i] == null || !this.shapes[i].isBioShape) continue;
            this.shapes[i] = null;
        }
        this.viewer.getFrameRenderer().clear();
    }

    public int autoHbond(BitSet bitSet, BitSet bitSet2, BitSet bitSet3) {
        this.bsPseudoHBonds = new BitSet();
        if (this.bondCount > 0) {
            this.calcHydrogenBonds(bitSet, bitSet2);
            bitSet3 = this.bsPseudoHBonds;
            return BitSetUtil.cardinalityOf((BitSet)bitSet3);
        }
        return super.autoHbond(bitSet, bitSet2, bitSet3);
    }

    protected void assignAromaticBonds(boolean bl) {
        super.assignAromaticBonds(bl, null);
        if (bl) {
            this.setShapeSize(1, Integer.MIN_VALUE, this.bsAromatic);
        }
    }

    public int[] makeConnections(float f, float f2, short s, int n, BitSet bitSet, BitSet bitSet2, BitSet bitSet3, boolean bl) {
        if (n != 5) {
            String string = "connect ";
            if (f != 0.1f) {
                string = string + f + " ";
            }
            if (f2 != 1.0E8f) {
                string = string + f2 + " ";
            }
            string = bl ? string + Escape.escape((BitSet)bitSet, (boolean)false) + " " : string + Escape.escape((BitSet)bitSet) + " " + Escape.escape((BitSet)bitSet2) + " ";
            if (n != 0) {
                string = string + JmolConstants.getBondOrderNameFromOrder(s) + " ";
            }
            string = string + JmolConstants.connectOperationName(n);
            string = string + ";";
            this.stateScripts.addElement(string);
        }
        return super.makeConnections(f, f2, s, n, bitSet, bitSet2, bitSet3, bl);
    }

    public void rebond() {
        this.stateScripts.addElement("connect;");
        this.deleteAllBonds();
        this.autoBond(null, null, null);
    }

    public void deleteAllBonds() {
        int n = 0;
        while (n < this.stateScripts.size()) {
            if (((String)this.stateScripts.get(n)).indexOf("connect") == 0) {
                this.stateScripts.removeElementAt(n);
                continue;
            }
            ++n;
        }
        super.deleteAllBonds();
    }

    public String getState(StringBuffer stringBuffer, boolean bl) {
        int n;
        StringBuffer stringBuffer2 = new StringBuffer();
        if (bl && stringBuffer != null) {
            stringBuffer.append("  _setModelState;\n");
            stringBuffer2.append("function _setModelState();\n");
        }
        if (bl) {
            for (n = 0; n < 7; n = (byte)(n + 1)) {
                if (this.getTaintedAtoms((byte)n) == null) continue;
                this.getTaintedState(stringBuffer2, (byte)n);
            }
        }
        if (bl) {
            Vector vector = this.stateScripts;
            int n2 = vector.size();
            if (n2 > 0) {
                stringBuffer2.append("\n");
                for (int i = 0; i < n2; ++i) {
                    stringBuffer2.append("  ").append(vector.get(i)).append("\n");
                }
            }
            stringBuffer2.append("\n");
        }
        this.setModelVisibility();
        stringBuffer2.append(this.getProteinStructureState(null, false));
        for (n = 0; n < 31; ++n) {
            String string;
            Shape shape = this.shapes[n];
            if (shape == null || !bl && !JmolConstants.isShapeSecondary(n) || (string = shape.getShapeState()) == null || string.length() <= 1) continue;
            stringBuffer2.append(string);
        }
        for (n = 0; n < this.modelCount; ++n) {
            String string = this.models[n].frameTitle;
            if (string == null || string.length() <= 0) continue;
            stringBuffer2.append("  frame " + this.getModelNumberDotted(n) + "; frame title " + Escape.escape((String)string) + "\n;");
        }
        if (stringBuffer != null) {
            stringBuffer2.append("\nend function;\n\n");
        }
        return stringBuffer2.toString();
    }
}

