/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import java.util.BitSet;
import java.util.Hashtable;
import org.jmol.g3d.Graphics3D;
import org.jmol.modelset.Atom;
import org.jmol.shape.AtomShape;
import org.jmol.shape.Shape;
import org.jmol.viewer.JmolConstants;

public class Balls
extends AtomShape {
    public void setSize(int n, BitSet bitSet) {
        int n2;
        short s = (short)n;
        this.isActive = true;
        if (this.bsSizeSet == null) {
            this.bsSizeSet = new BitSet();
        }
        int n3 = n2 = bitSet.length();
        while (--n3 >= 0) {
            if (!bitSet.get(n3)) continue;
            Atom atom = this.atoms[n3];
            atom.setMadAtom(s);
            this.bsSizeSet.set(n3);
        }
    }

    public void setProperty(String string, Object object, BitSet bitSet) {
        if ("color" == string) {
            short s = Graphics3D.getColix((Object)object);
            if (s == 0) {
                s = 2;
            }
            if (this.bsColixSet == null) {
                this.bsColixSet = new BitSet();
            }
            byte by = JmolConstants.pidOf(object);
            int n = this.atomCount;
            while (--n >= 0) {
                if (!bitSet.get(n)) continue;
                Atom atom = this.atoms[n];
                atom.setColixAtom(this.setColix(s, by, atom));
                this.bsColixSet.set(n, s != 2 || by != 0);
                atom.setPaletteID(by);
            }
            return;
        }
        if ("colorValues" == string) {
            int[] nArray = (int[])object;
            if (nArray.length == 0) {
                return;
            }
            if (this.bsColixSet == null) {
                this.bsColixSet = new BitSet();
            }
            int n = 0;
            Integer n2 = null;
            for (int i = 0; i < this.atomCount; ++i) {
                short s;
                if (!bitSet.get(i)) continue;
                if (n >= nArray.length) {
                    return;
                }
                if ((s = Graphics3D.getColix((Object)(n2 = new Integer(nArray[n++])))) == 0) {
                    s = 2;
                }
                byte by = JmolConstants.pidOf(n2);
                Atom atom = this.atoms[i];
                atom.setColixAtom(this.setColix(s, by, atom));
                this.bsColixSet.set(i, s != 2 || by != 0);
                atom.setPaletteID(by);
            }
            return;
        }
        if ("translucency" == string) {
            boolean bl = ((String)object).equals("translucent");
            if (this.bsColixSet == null) {
                this.bsColixSet = new BitSet();
            }
            int n = this.atomCount;
            while (--n >= 0) {
                if (!bitSet.get(n)) continue;
                this.atoms[n].setTranslucent(bl, this.translucentLevel);
                if (!bl) continue;
                this.bsColixSet.set(n);
            }
            return;
        }
        super.setProperty(string, object, bitSet);
    }

    public void setModelClickability() {
        int n = this.atomCount;
        while (--n >= 0) {
            Atom atom = this.atoms[n];
            atom.setClickable(0);
            if ((atom.getShapeVisibilityFlags() & this.myVisibilityFlag) == 0 || this.modelSet.isAtomHidden(n)) continue;
            atom.setClickable(this.myVisibilityFlag);
        }
    }

    public void setVisibilityFlags(BitSet bitSet) {
        int n = this.viewer.getDisplayModelIndex();
        boolean bl = n >= 0;
        boolean bl2 = this.viewer.getShowHydrogens();
        int n2 = this.atomCount;
        while (--n2 >= 0) {
            Atom atom = this.atoms[n2];
            int n3 = atom.getShapeVisibilityFlags();
            atom.setShapeVisibilityFlags(n3 &= 0xFFFFFFFE & ~this.myVisibilityFlag);
            if (!bl2 && atom.getElementNumber() == 1) continue;
            int n4 = atom.getModelIndex();
            if ((bl || !bitSet.get(n4)) && n4 != n) continue;
            atom.setShapeVisibility(1, true);
            if (atom.getMadAtom() == 0 || this.modelSet.isAtomHidden(n2)) continue;
            atom.setShapeVisibility(this.myVisibilityFlag, true);
        }
    }

    public String getShapeState() {
        Hashtable hashtable = new Hashtable();
        float f = 0.0f;
        for (int i = 0; i < this.atomCount; ++i) {
            byte by;
            if (this.bsSizeSet != null && this.bsSizeSet.get(i)) {
                float f2;
                f = this.atoms[i].getMadAtom();
                if (f2 < 0.0f) {
                    Shape.setStateInfo(hashtable, i, "Spacefill on");
                } else {
                    Shape.setStateInfo(hashtable, i, "Spacefill " + f / 2000.0f);
                }
            }
            if (this.bsColixSet == null || !this.bsColixSet.get(i) || (by = this.atoms[i].getPaletteID()) == 1 && !this.atoms[i].isTranslucent()) continue;
            Shape.setStateInfo(hashtable, i, this.getColorCommand("atoms", by, this.atoms[i].getColix()));
        }
        return Shape.getShapeCommands(hashtable, null, this.atomCount);
    }
}

