/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import java.util.BitSet;
import java.util.Hashtable;
import javax.vecmath.Point3i;
import org.jmol.api.JmolRendererInterface;
import org.jmol.g3d.Font3D;
import org.jmol.g3d.Graphics3D;
import org.jmol.shape.Shape;
import org.jmol.shape.Text;
import org.jmol.shape.TextShape;
import org.jmol.util.Escape;
import org.jmol.util.Logger;

public class Hover
extends TextShape {
    private static final String FONTFACE = "SansSerif";
    private static final String FONTSTYLE = "Plain";
    private static final int FONTSIZE = 12;
    Text hoverText;
    int atomIndex = -1;
    Point3i xy;
    String text;
    String labelFormat = "%U";
    String[] atomFormats;

    public void initShape() {
        super.initShape();
        Font3D font3D = this.g3d.getFont3D(FONTFACE, FONTSTYLE, 12);
        short s = Graphics3D.getColix((String)"#FFFFC3");
        short s2 = 4;
        this.currentText = this.hoverText = new Text((JmolRendererInterface)this.g3d, font3D, null, s2, s, 0, 0, 1, Integer.MIN_VALUE, 1);
        this.hoverText.setAdjustForWindow(true);
    }

    public void setProperty(String string, Object object, BitSet bitSet) {
        if (Logger.isActiveLevel((int)0)) {
            Logger.debug((String)("Hover.setProperty(" + string + "," + object + ")"));
        }
        if ("target" == string) {
            if (object == null) {
                this.atomIndex = -1;
            } else {
                this.atomIndex = (Integer)object;
                this.viewer.setStatusAtomHovered(this.atomIndex, this.viewer.getAtomInfoXYZ(this.atomIndex));
            }
            return;
        }
        if ("text" == string) {
            this.text = (String)object;
            if (this.text != null && this.text.length() == 0) {
                this.text = null;
            }
            return;
        }
        if ("atomLabel" == string) {
            String string2 = (String)object;
            if (string2 != null && string2.length() == 0) {
                string2 = null;
            }
            int n = this.viewer.getAtomCount();
            if (this.atomFormats == null) {
                this.atomFormats = new String[n];
            }
            int n2 = n;
            while (--n2 >= 0) {
                if (!bitSet.get(n2)) continue;
                this.atomFormats[n2] = string2;
            }
            return;
        }
        if ("xy" == string) {
            this.xy = (Point3i)object;
            return;
        }
        if ("label" == string) {
            this.labelFormat = (String)object;
            if (this.labelFormat != null && this.labelFormat.length() == 0) {
                this.labelFormat = null;
            }
            return;
        }
        super.setProperty(string, object, null);
    }

    public String getShapeState() {
        Hashtable hashtable = new Hashtable();
        int n = this.viewer.getAtomCount();
        if (this.atomFormats != null) {
            int n2 = n;
            while (--n2 >= 0) {
                if (this.atomFormats[n2] == null) continue;
                Shape.setStateInfo(hashtable, n2, "set hoverLabel " + Escape.escape((String)this.atomFormats[n2]));
            }
        }
        return "\n  hover " + Escape.escape((String)(this.labelFormat == null ? "" : this.labelFormat)) + ";\n" + Shape.getShapeCommands(hashtable, null, n);
    }
}

