/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import java.util.Hashtable;
import org.jmol.api.JmolSelectionListener;
import org.jmol.i18n.GT;
import org.jmol.modelset.ModelSet;
import org.jmol.util.ArrayUtil;
import org.jmol.util.BitSetUtil;
import org.jmol.viewer.StateManager;
import org.jmol.viewer.Viewer;

class SelectionManager {
    private Viewer viewer;
    private JmolSelectionListener[] listeners = new JmolSelectionListener[4];
    final BitSet bsSelection = new BitSet();
    private BitSet bsSubset;
    private static final int TRUE = 1;
    private static final int FALSE = 0;
    private static final int UNKNOWN = -1;
    private int empty = 1;
    private boolean hideNotSelected;
    private final BitSet bsHidden = new BitSet();

    SelectionManager(Viewer viewer) {
        this.viewer = viewer;
    }

    void clear() {
        this.clearSelection(true);
        this.hide(null, true);
        this.setSelectionSubset(null);
    }

    void hide(BitSet bitSet, boolean bl) {
        ModelSet modelSet;
        BitSetUtil.clear((BitSet)this.bsHidden);
        if (bitSet != null) {
            this.bsHidden.or(bitSet);
        }
        if ((modelSet = this.viewer.getModelSet()) != null) {
            modelSet.setBsHidden(this.bsHidden);
        }
        if (!bl) {
            this.viewer.reportSelection(GT._((String)"{0} atoms hidden", (String)("" + BitSetUtil.cardinalityOf((BitSet)this.bsHidden))));
        }
    }

    void display(BitSet bitSet, BitSet bitSet2, boolean bl) {
        if (bitSet2 == null) {
            BitSetUtil.clear((BitSet)this.bsHidden);
        } else {
            this.bsHidden.or(bitSet);
            BitSetUtil.andNot((BitSet)this.bsHidden, (BitSet)bitSet2);
        }
        ModelSet modelSet = this.viewer.getModelSet();
        if (modelSet != null) {
            modelSet.setBsHidden(this.bsHidden);
        }
        if (!bl) {
            this.viewer.reportSelection(GT._((String)"{0} atoms hidden", (String)("" + BitSetUtil.cardinalityOf((BitSet)this.bsHidden))));
        }
    }

    BitSet getHiddenSet() {
        return this.bsHidden;
    }

    boolean getHideNotSelected() {
        return this.hideNotSelected;
    }

    void setHideNotSelected(boolean bl) {
        this.hideNotSelected = bl;
        if (bl) {
            this.selectionChanged(false);
        }
    }

    boolean isSelected(int n) {
        return this.bsSelection.get(n);
    }

    void select(BitSet bitSet, boolean bl) {
        if (bitSet == null) {
            this.selectAll(true);
            if (!this.viewer.getRasmolHydrogenSetting()) {
                this.excludeSelectionSet(this.viewer.getAtomBits(1638402));
            }
            if (!this.viewer.getRasmolHeteroSetting()) {
                this.excludeSelectionSet(this.viewer.getAtomBits(0x190001));
            }
            this.selectionChanged(false);
        } else {
            this.setSelectionSet(bitSet);
        }
        if (!bl) {
            this.viewer.reportSelection(GT._((String)"{0} atoms selected", (String)("" + this.getSelectionCount())));
        }
    }

    void selectAll(boolean bl) {
        int n = this.viewer.getAtomCount();
        this.empty = n == 0 ? 1 : 0;
        int n2 = n;
        while (--n2 >= 0) {
            this.bsSelection.set(n2);
        }
        this.selectionChanged(bl);
    }

    void clearSelection(boolean bl) {
        this.hideNotSelected = false;
        BitSetUtil.clear((BitSet)this.bsSelection);
        this.empty = 1;
        this.selectionChanged(bl);
    }

    void setSelectionSet(BitSet bitSet) {
        BitSetUtil.clear((BitSet)this.bsSelection);
        if (bitSet != null) {
            this.bsSelection.or(bitSet);
        }
        this.empty = -1;
        this.selectionChanged(false);
    }

    void setSelectionSubset(BitSet bitSet) {
        this.bsSubset = bitSet;
    }

    boolean isInSelectionSubset(int n) {
        return n < 0 || this.bsSubset == null || this.bsSubset.get(n);
    }

    void invertSelection() {
        this.empty = 1;
        int n = this.viewer.getAtomCount();
        while (--n >= 0) {
            if (this.bsSelection.get(n)) {
                this.bsSelection.clear(n);
                continue;
            }
            this.bsSelection.set(n);
            this.empty = 0;
        }
        this.selectionChanged(false);
    }

    private void excludeSelectionSet(BitSet bitSet) {
        if (bitSet == null || this.empty == 1) {
            return;
        }
        int n = this.viewer.getAtomCount();
        while (--n >= 0) {
            if (!bitSet.get(n)) continue;
            this.bsSelection.clear(n);
        }
        this.empty = -1;
    }

    int getSelectionCount() {
        if (this.empty == 1) {
            return 0;
        }
        int n = 0;
        this.empty = 1;
        int n2 = this.viewer.getAtomCount();
        while (--n2 >= 0) {
            if (!this.bsSelection.get(n2) || this.bsSubset != null && !this.bsSubset.get(n2)) continue;
            ++n;
        }
        if (n > 0) {
            this.empty = 0;
        }
        return n;
    }

    void addListener(JmolSelectionListener jmolSelectionListener) {
        int n = this.listeners.length;
        while (--n >= 0) {
            if (this.listeners[n] != jmolSelectionListener) continue;
            this.listeners[n] = null;
            break;
        }
        int n2 = n = this.listeners.length;
        while (--n2 >= 0) {
            if (this.listeners[n2] != null) continue;
            this.listeners[n2] = jmolSelectionListener;
            return;
        }
        this.listeners = (JmolSelectionListener[])ArrayUtil.doubleLength((Object)this.listeners);
        this.listeners[n] = jmolSelectionListener;
    }

    private void selectionChanged(boolean bl) {
        if (this.hideNotSelected) {
            this.hide(BitSetUtil.copyInvert((BitSet)this.bsSelection, (int)this.viewer.getAtomCount()), false);
        }
        if (bl) {
            return;
        }
        int n = this.listeners.length;
        while (--n >= 0) {
            JmolSelectionListener jmolSelectionListener = this.listeners[n];
            if (jmolSelectionListener == null) continue;
            this.listeners[n].selectionChanged(this.bsSelection);
        }
    }

    String getState(StringBuffer stringBuffer) {
        StringBuffer stringBuffer2 = new StringBuffer();
        if (stringBuffer != null) {
            stringBuffer.append("  _setSelectionState;\n");
            stringBuffer2.append("function _setSelectionState();\n");
        }
        String string = null;
        Hashtable<String, BitSet> hashtable = new Hashtable<String, BitSet>();
        if (BitSetUtil.firstSetBit((BitSet)this.bsHidden) >= 0) {
            hashtable.put("hide selected", this.bsHidden);
        }
        if (BitSetUtil.firstSetBit((BitSet)this.bsSubset) >= 0) {
            hashtable.put("subset selected", this.bsSubset);
        }
        if ((string = StateManager.getCommands(hashtable)) != null) {
            stringBuffer2.append(string);
        }
        hashtable = new Hashtable();
        hashtable.put("-", this.bsSelection);
        string = StateManager.getCommands(hashtable, null, this.viewer.getAtomCount());
        if (string == null) {
            StateManager.appendCmd(stringBuffer2, "select none");
        } else {
            stringBuffer2.append(string);
        }
        stringBuffer2.append(this.viewer.getShapeProperty(1, "selectionState"));
        if (stringBuffer != null) {
            stringBuffer2.append("end function\n\n");
        }
        return stringBuffer2.toString();
    }
}

